/**
 * @file			AXMIspChSettings.hpp
 * @brief			AXMIspChSettingsクラスヘッダ
 *
 * @par			言語
 * 					C++
 */
#ifndef AXMISPCHSETTINGS_HPP_
#define AXMISPCHSETTINGS_HPP_
#include "AXMIspAssistType.hpp"

/**
 * 低輝度クロマサプレスセンサーゲイン最大値
 */
const BYTE				CH_MAX_SENSOR_GAIN = 0x30;
/**
 * 低輝度クロマサプレスゲイン出力最大値
 */
const BYTE				CH_MAX_OUTPUT_GAIN = 0x80;

/**
 * @class     AXMIspChSettings
 * @brief     低輝度クロマサプレス設定パラメータクラス
 *
 * @n         低輝度クロマサプレスの計算パラメータと、計算結果を格納する
 */
class AXMIspChSettings {
public:
	/**
	 * @brief  オブジェクトを初期化する
	 *
	 * @n
	 */
	AXMIspChSettings();
	/**
	 * @brief  オブジェクトを開放する
	 *
	 * @n
	 */
	virtual ~AXMIspChSettings();
public:
	BYTE				lowStartGain;							//!< 低輝度クロマサプレス開始ゲイン
	BYTE				lowInc;								//!< 低輝度クロマサプレス傾き
};

#endif /* AXMISPCHSETTINGS_HPP_ */
