/*
 * AXMIspCorrect.cpp
 */

#include "../AXMCommon/AXMCommonConfig.hpp"
#include "AXMIspCorrect.hpp"
#include "AXMIspCorrectParam.hpp"

AXMIspCorrect::AXMIspCorrect(AXFObjectName& name)
    : AXModelActor(name),
      m_log(name),
      m_name(name) {
  m_log.write(AXFLOG_DEBUG, "Correct Constractor");

  p_spec = NULL;

  cnt = Shade_CorrectData_Num;
  Shade_Grid_Hor_Pitch = 0;
  Shade_Grid_Height = 0;
  for(UINT i = 0; i < AXH_Shade_Grid_Height_Max; i++) {
    for(UINT j = 0; j < AXH_Shade_Grid_Width; j++) {
      IntData[i][j].R = 0x00000000ul;
      IntData[i][j].G = 0x00000000ul;
      IntData[i][j].B = 0x00000000ul;
    }
  }

  DefectPixcel = NULL;

  state = STATE_WAITING;
#ifdef USE_AXFTEST_COMMAND
  m_loopbackCount = 0;
#endif /* USE_AXFTEST_COMMAND */
}

AXMIspCorrect::~AXMIspCorrect() {
  m_log.write(AXFLOG_DEBUG, "Correct Destractor");
}

ax::actorFuncStatus AXMIspCorrect::onCreate() {
  m_log.write(AXFLOG_DEBUG, "Correct onCreate()");

  // StateMachine に必要な情報を登録する
  //      自オブジェクト,
  //      初期状態,
  //      状態の最大数
#ifndef PARASOFT_CPPTEST
  if (0 > setStateInfo(this, STATE_WAITING, STATE_MAX)) {   //  起動時 待機中
    m_log.write(AXFLOG_ERR, "fail registHandle");
    return ax::AXFACTOR_ERROR;
  }

  // STATE_0状態の状態テーブルを登録する
  //      状態テーブルで登録する状態,
  //      状態テーブルのポインタ,
  setStateTable(STATE_WAITING, state_waiting);              //  待機中:調整モード(WB調整以外)
  setStateTable(STATE_RUNNING, state_running);
  setStateTable(STATE_KIZU_RUNNING, state_kizu_running);
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspCorrect::onStart() {
  m_log.write(AXFLOG_DEBUG, "Correct onStart()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspCorrect::onStop() {
  m_log.write(AXFLOG_DEBUG, "Correct onStop()");
  return ax::AXFACTOR_SUCCESS;
}

#if 0
ax::actorFuncStatus AXMIspCorrect::onPause() {
  m_log.write(AXFLOG_DEBUG, "Correct onPause()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspAwb::onResume() {
  m_log.write(AXFLOG_DEBUG, "Correct onResume()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMIspCorrect::onRestart() {
  m_log.write(AXFLOG_DEBUG, "Correct onRestart()");
  return ax::AXFACTOR_SUCCESS;
}
#endif
