#ifndef _PROC_DEF_CMOS_H_
#define _PROC_DEF_CMOS_H_

#include "DSPCommon.h"

#define REG_CMOS_CID0                       0x02 // write = 0x02, read = 0x82
#define REG_CMOS_CID1                       0x03 // write = 0x03, read = 0x83
#define REG_CMOS_CID2                       0x04 // write = 0x04, read = 0x84

// CID0
#define REG_CMOS_CID0_STANDBY               ((REG_CMOS_CID0 << 8) | 0x00)
#define REG_CMOS_CID0_REGHOLD               ((REG_CMOS_CID0 << 8) | 0x01)
#define REG_CMOS_CID0_XMSTA                 ((REG_CMOS_CID0 << 8) | 0x02)
#define REG_CMOS_CID0_SW_RESET              ((REG_CMOS_CID0 << 8) | 0x03)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x04)
#define REG_CMOS_CID0_STD12EN_ADBIT         ((REG_CMOS_CID0 << 8) | 0x05)
#define REG_CMOS_CID0_MODE                  ((REG_CMOS_CID0 << 8) | 0x06)
#define REG_CMOS_CID0_V_H_RESERVE_WINMODE   ((REG_CMOS_CID0 << 8) | 0x07)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x08)
#define REG_CMOS_CID0_FRSEL                 ((REG_CMOS_CID0 << 8) | 0x09)
#define REG_CMOS_CID0_BLKLEVEL0             ((REG_CMOS_CID0 << 8) | 0x0a)
#define REG_CMOS_CID0_BLKLEVEL1             ((REG_CMOS_CID0 << 8) | 0x0b)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x0c)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x0d)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x0e)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x0f)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x10)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x11)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x12)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x13)
#define REG_CMOS_CID0_GAIN0                 ((REG_CMOS_CID0 << 8) | 0x14)
#define REG_CMOS_CID0_GAIN1                 ((REG_CMOS_CID0 << 8) | 0x15)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x16)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x17)
#define REG_CMOS_CID0_VMAX0                 ((REG_CMOS_CID0 << 8) | 0x18)
#define REG_CMOS_CID0_VMAX1                 ((REG_CMOS_CID0 << 8) | 0x19)
#define REG_CMOS_CID0_VMAX2                 ((REG_CMOS_CID0 << 8) | 0x1a)
#define REG_CMOS_CID0_HMAX0                 ((REG_CMOS_CID0 << 8) | 0x1b)
#define REG_CMOS_CID0_HMAX1                 ((REG_CMOS_CID0 << 8) | 0x1c)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x1d)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x1e)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x1f)
#define REG_CMOS_CID0_SHS10                 ((REG_CMOS_CID0 << 8) | 0x20)
#define REG_CMOS_CID0_SHS11                 ((REG_CMOS_CID0 << 8) | 0x21)
#define REG_CMOS_CID0_SHS12                 ((REG_CMOS_CID0 << 8) | 0x22)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x23)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x24)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x25)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x26)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x27)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x28)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x29)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x2a)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x2b)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x2c)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x2d)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x2e)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x2f)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x30)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x31)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x32)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x33)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x34)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x35)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x36)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x37)
#define REG_CMOS_CID0_WINPV0                ((REG_CMOS_CID0 << 8) | 0x38)
#define REG_CMOS_CID0_WINPV1                ((REG_CMOS_CID0 << 8) | 0x39)
#define REG_CMOS_CID0_WINWV0                ((REG_CMOS_CID0 << 8) | 0x3a)
#define REG_CMOS_CID0_WINWV1                ((REG_CMOS_CID0 << 8) | 0x3b)
#define REG_CMOS_CID0_WINPH0                ((REG_CMOS_CID0 << 8) | 0x3c)
#define REG_CMOS_CID0_WINPH1                ((REG_CMOS_CID0 << 8) | 0x3d)
#define REG_CMOS_CID0_WINWH0                ((REG_CMOS_CID0 << 8) | 0x3e)
#define REG_CMOS_CID0_WINWH1                ((REG_CMOS_CID0 << 8) | 0x3f)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x40)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x41)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x42)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x43)
#define REG_CMOS_CID0_ODBIT_OPORTSEL        ((REG_CMOS_CID0 << 8) | 0x44)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x45)
#define REG_CMOS_CID0_XVSLNG                ((REG_CMOS_CID0 << 8) | 0x46)
#define REG_CMOS_CID0_XHSLNG                ((REG_CMOS_CID0 << 8) | 0x47)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x48)
#define REG_CMOS_CID0_XVSOUTSEL_XHSOUTSEL   ((REG_CMOS_CID0 << 8) | 0x49)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x4a)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x4b)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x4c)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x4d)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x4e)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x4f)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x50)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x51)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x52)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x53)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x54)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x55)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x56)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x57)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x58)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x59)
//#define REG_CMOS_CID0_dummy               ((REG_CMOS_CID0 << 8) | 0x5a)
#define REG_CMOS_CID0_INCKSEL0              ((REG_CMOS_CID0 << 8) | 0x5b)
#define REG_CMOS_CID0_INCKSEL1              ((REG_CMOS_CID0 << 8) | 0x5c)
#define REG_CMOS_CID0_INCKSEL2              ((REG_CMOS_CID0 << 8) | 0x5d)
#define REG_CMOS_CID0_INCKSEL3              ((REG_CMOS_CID0 << 8) | 0x5e)
#define REG_CMOS_CID0_INCKSEL4              ((REG_CMOS_CID0 << 8) | 0x5f)


#define CMOS_MODE_2x2_960x600               0x00
#define CMOS_MODE_2x2_960x600_LVDS          0x01
#define LVDS_MODE_1920x1080                 0x02
#define LVDS_MODE_1920x1080_30              0x03
#define LVDS_MODE_1920x1080_PARA            0x04

/*
#define REG_GPIO_00                     0x30220000
#define REG_GPIO_1_GPIODATA         (0x1000 + REG_GPIO_BASE)
#define REG_GPIO_1_GPIODATA_F       (0x13FC + REG_GPIO_BASE)
#define REG_GPIO_1_GPIODIR          (0x1400 + REG_GPIO_BASE)
*/

#ifdef  __cplusplus
extern "C"
{
#endif

extern void init_cmos_sony_imx136(UInt8 mode);
extern void reset_cmos(void);
extern void wakeup_cmos(void);
extern void standby_cmos(void);
extern void start_cmos(void);
extern void stop_cmos(void);
extern void cmos_power_off(void);
extern void cmos_power_on(void);

#ifdef  __cplusplus
}
#endif

#endif // _PROC_DEF_CMOS_H_
