/*
 * AXMPixcessor.cpp
 */

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
#include "AXMCommon/AXMCommonParam.hpp"
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
#include "AXMPixcessor.hpp"
#include "AXFEvent.hpp"
#include "AXFStage.hpp"
#include "AXMIsp/AXMIsp.hpp"
#include "AXMIspAwb/AXMIspAwb.hpp"
#include "AXMIspAdjust/AXMIspAdjust.hpp"
#include "../../project/refkit/AXMIspConfig.hpp"
#include "AXMIspAe/AXMIspAe.hpp"
//#include "AXMIspAf/AXMIspAf.hpp"
#include "AXMImageSensor/AXMImageSensor.hpp"

#include "AXHSpec.hpp"

AXMPixcessor::AXMPixcessor(AXFObjectName& name)
    : AXModelActor(name),
      m_log(name),
      m_name(name),
      m_timerID(NULL)
{
  m_log.write(AXFLOG_DEBUG, "Pixcessor Constractor");

  //  設定値参照用
  //  AXMPixcessorで設定値保存先アドレスを取得し、そのアドレスを他のオブジェクトに通知する
  //  アドレスの通知は、onStartで行う
#ifndef DISABLE_SET_DEFAULT_ISP_PARAM
  AXHSpec spec(AXH_Spec_Mode_Default);
#else   //  DISABLE_SET_DEFAULT_ISP_PARAM
  AXHSpec spec(AXH_Spec_Mode_Normal);
#endif  //  DISABLE_SET_DEFAULT_ISP_PARAM
  p_spec = (ST_SPEC*)spec.getSpecAddr();

  Width = p_spec->Scaler.scaling.InImgSize.Width;
  Height = p_spec->Scaler.scaling.InImgSize.Height;

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
  isWdrMode = AXM_wdrMode_Init;
  //  SPU出力画像データフォーマット設定
  opdConfigAE.setImageSize(Width, Height, false);
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

}

AXMPixcessor::~AXMPixcessor() {
  m_log.write(AXFLOG_DEBUG, "Pixcessor Destractor");
}

ax::actorFuncStatus AXMPixcessor::onCreate() {
  m_log.write(AXFLOG_DEBUG, "Pixcessor onCreate()");

  // StateMachine に必要な情報を登録する
  //      自オブジェクト,
  //      初期状態,
  //      状態の最大数
#ifndef PARASOFT_CPPTEST
  if (0 > setStateInfo(this, STATUS_RUNNING, STATSU_MAX)) {
    m_log.write(AXFLOG_ERR, "fail registHandle");
    return ax::AXFACTOR_ERROR;
  }

  // STATE_0状態の状態テーブルを登録する
  //      状態テーブルで登録する状態,
  //      状態テーブルのポインタ,
  setStateTable(STATUS_RUNNING, state_running);
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::onStart() {
  m_log.write(AXFLOG_DEBUG, "Pixcessor onStart()");

  //  設定値保存先アドレスを各オブジェクトへ通知
  static ST_MSG msg;
  msg.data = p_spec;
  //  AXMIspへ設定値保存先アドレスを通知
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIsp, AXMIsp::EVENT_SPEC_ADDR, &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send AXMIsp::EVENT_SPEC_ADDR");
  }
#endif  //  PARASOFT_CPPTEST
  //  AXMIspAwbへ設定値保存先アドレスを通知
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIspAwb, AXMIspAwb::EVENT_SPEC_ADDR, &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send AXMIspAwb::EVENT_SPEC_ADDR");
  }
#endif  //  PARASOFT_CPPTEST
  //  AXMIspAdjustへ設定値保存先アドレスを通知
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIspAdjust, AXMIspAdjust::EVENT_SPEC_ADDR, &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send AXMIspAdjust::EVENT_SPEC_ADDR");
  }
#endif  //  PARASOFT_CPPTEST
  //  AXMIspAeへ設定値保存先アドレスを通知
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIspAe, AXMIspAe::EVENT_SPEC_ADDR, &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send AXMIspAe::EVENT_SPEC_ADDR");
  }
#endif  //  PARASOFT_CPPTEST
//  //  AXMIspAfへ設定値保存先アドレスを通知
//#ifndef PARASOFT_CPPTEST
//  if (0 > send(nameIspAf, AXMIspAf::EVENT_SPEC_ADDR, &msg, sizeof(ST_MSG))) {
//    m_log.write(AXFLOG_ERR, "fail send AXMIspAf::EVENT_SPEC_ADDR");
//  }
//#endif  //  PARASOFT_CPPTEST
  //  AXMImageSensorへ設定値保存先アドレスを通知
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameImageSensor, AXMImageSensor::EVENT_SPEC_ADDR, &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send AXMImageSensor::EVENT_SPEC_ADDR");
  }
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::onStop() {
  m_log.write(AXFLOG_DEBUG, "Pixcessor onStop()");

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::onDestroy() {
  m_log.write(AXFLOG_DEBUG, "Pixcessor onDestroy()");

  return ax::AXFACTOR_SUCCESS;
}

#if 0
ax::actorFuncStatus AXMPixcessor::onPause() {
  m_log.write(AXFLOG_DEBUG, "Pixcessor onPause()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::onResume() {
  m_log.write(AXFLOG_DEBUG, "Pixcessor onResume()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::onRestart() {
  m_log.write(AXFLOG_DEBUG, "Pixcessor onRestart()");
  return ax::AXFACTOR_SUCCESS;
}
#endif
