/**
 * @file   AXMPixcessor.hpp
 * @brief  AXMPixcessorクラスヘッダ
 *
 * @n      Pixcessor IFクラス
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMPIXCESSOR_HPP_
#define AXMPIXCESSOR_HPP_

#include "../AXMCommon/AXMCommonConfig.hpp"
#include "../AXM/AXModelActor.hpp"

#include "AXMCommon/AXMCommonSetParam.hpp"
#include "AXMCommon/AXMCommonStruct.hpp"

//#include "AXHDefect.hpp"

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
#include "AXHOpdConfigAWB.hpp"
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
#if !defined(ENABLE_OPD_CONFIG_ISP_TO_AXH) || !defined(ENABLE_IMAGE_ADDR_ISP_TO_AXH)
#include "AXHOpdConfigAE.hpp"
#include "AXHOpdCommon.hpp"
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

#ifndef ENABLE_OPD_DATA_ISP_TO_AXH
#include "AXHOpdDataAWB.hpp"
#include "AXHOpdDataAE.hpp"
#include "AXHOpdCommon.hpp"
#endif  //  ENABLE_OPD_DATA_ISP_TO_AXH

/**
 * @class AXMPixcessor
 * @brief Pixcessor IFクラス
 *
 * @n
 */
class AXMPixcessor : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
  AXFActor::TimerId_t m_timerID;  // タイマーID

 public:
  AXMPixcessor(AXFObjectName& name);
  virtual ~AXMPixcessor();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
  ax::actorFuncStatus onDestroy();
#if 0
  ax::actorFuncStatus onPause();
  ax::actorFuncStatus onResume();
  ax::actorFuncStatus onRestart();
#endif

// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMPixcessorState.hpp"

private:
  //  設定値格納先(設定値参照用)
  ST_SPEC *p_spec;

  unsigned short Width;                                     //  入力画像サイズ
  unsigned short Height;                                    //  出力画像サイズ
#ifdef PARASOFT_CPPTEST
  int CPPTest_WORK[50];
#endif

#ifndef  ENABLE_OPD_CONFIG_ISP_TO_AXH
  AXHOpdConfigAWB opdConfigAWB;
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
#if !defined(ENABLE_OPD_CONFIG_ISP_TO_AXH) || !defined(ENABLE_IMAGE_ADDR_ISP_TO_AXH)
  AXHOpdConfigAE  opdConfigAE;
  bool            isWdrMode;
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

#ifndef  ENABLE_OPD_DATA_ISP_TO_AXH
  AXHOpdDataAWB opdDataAWB;
  AXHOpdDataAE  opdDataAE;
#endif  //  ENABLE_OPD_DATA_ISP_TO_AXH

};
#endif /* AXMPIXCESSOR_HPP_ */
