/**
 * @file   AXMPixcessorInt.hpp
 * @brief  AXMPixcessorIntクラスヘッダ
 *
 * @n      PixcessorInt IFクラス
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMPIXCESSORINT_HPP_
#define AXMPIXCESSORINT_HPP_

#include "../../AXMCommon/AXMCommonConfig.hpp"
#include "../../AXM/AXModelActor.hpp"
#include "AXMCommon/AXMCommonBridgeParam.hpp"
#include "../../AXMCommon/AXMCommonStruct.hpp"
#include "AXMIspTest/DSPCommon.h"
#include "AXMIspTest/adrs_base.h"
#include "AXMIspTest/reg_imageif.h"
#include "AXHPixcessorInt.hpp"
#include "AXHScaler.hpp"


class AXFIrqSignal;

#define AXM_GENPARAM_MAX (20)

/*
 * @class AXMPixcessorInt
 * @brief PixcessorInt IFクラス
 *
 * @n
 */
class AXMPixcessorInt : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
  AXFActor::TimerId_t m_timerID;  // タイマーID
  AXFIrqSignal* m_irqSignal;
	//　ホストCPUへの通知なしのため不要
  //AXFIrqSignal* m_irqFrameGen;

  bool m_isUseTimer;

  int m_genWCount;
  int m_genRCount;
  IspToNvrParam_FrameGen_Control_t m_genParam[AXM_GENPARAM_MAX];
  AXHPixcessorInt m_pixInt;
  AXHScaler       m_scl;

public:
  ImageSensorParam imageSensorParam;
  long afEval[19];	// AF評価値Hf[9]、Lf[9], count
	bool          creFlg;	// 生成フラグ

 public:
  AXMPixcessorInt(AXFObjectName& name);
  virtual ~AXMPixcessorInt();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
  ax::actorFuncStatus onDestroy();
#if 0
  ax::actorFuncStatus onPause();
  ax::actorFuncStatus onResume();
  ax::actorFuncStatus onRestart();
#endif

  //フレーム割り込みハンドラ
  void frameIsrHandler();

	//　ホストCPUへの通知なしのため不要
  ////フレーム生成完了通知(DSP->ARM)ハンドラ
  //void frameGenHandler(int cmd, int bankno=0, int complex=0);

  //フレーム生成用パラメータ設定
  void setGenParam(int cmd, int bankno, int complex);

  //フレーム生成用パラメータ取得
  void* getGenParam();

  //AF評価値取得
  void getAfEval();

  /**
   * @brief	isi割り込み時isp開始
   */
  void                 startIsp();

  /**
   * @brief	GDU開始
   */
  void                 startGdu();

  /**
   * @brief	isi2割り込み時GDUバンク番号切り替え
   */
  void                 switchGduBankNo();

  /**
   * @brief	ImageIF 動作モード取得
   * @n       動作モード取得時に、動作モード変更通知をクリアする
   *
   * @retval 	0                              Linear動作モード以外(30fps)
   * @retval	1                              Linear動作モード(60fps)
   */
  unsigned char        getImageIFOpeMode();
  /**
   * @brief	ImageIF 動作モード変更通知取得
   *
   * @retval	0                              変更なし
   * @retval	1                              変更あり
   */
  unsigned char        getImageIFOpeModeUpd();
  /**
   * @brief	画像複雑度取得
   *
   * @return	画像複雑度
   */
  unsigned int         getScalerSatd();
  // static関数定義
  /**
   * @brief	GDUバンク番号取得
   *
   * @return	GDUへ送るバンク番号
   */
  static int           getGduBankno();
  /**
   * @brief	GDUバンク番号設定
   *
   * @param	[in]   bankno                      gduバンク番号
   */
  static void          setGduBankno(int bankno);
  /**
   * @brief	ImageIF 動作モード設定
   *
   * @param	[in]   opemode                     ImageIF動作モード
   * @n                                          0:Linearモード以外(30fps)
   * @n                                          1:Linearモード(60fps)
   * @return	設定したImageIF動作モード
   */
  static unsigned char setImageIFOpeMode(unsigned char opemode);
  /**
   * @brief	スケーリング機能enabled設定
   *
   * @param	[in]  ch0_enabled                  ch0スケーリング機能のenabled状態
   * @param	[in]  ch1_enabled                  ch1スケーリング機能のenabled状態
   * @param	[in]  ch2_enabled                  ch2スケーリング機能のenabled状態
   */
  static void          setScalerEnabled(unsigned char ch0_enabled, unsigned char ch1_enabled, unsigned char ch2_enabled);

  void PixcessorInit();

// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMPixcessorIntState.hpp"
};
#endif /* AXMPIXCESSORINT_HPP_ */
