/*
 * AXMPixcessorState.cpp
 */

#include "AXMCommon/AXMCommonConfig.hpp"
#include "AXMCommon/AXMCommonParam.hpp"
#include "AXMCommon/AXMCommonSetParam.hpp"
#include "AXMCommon/AXMCommonStruct.hpp"

#include "AXMPixcessor.hpp"
#include "AXMIsp/AXMIsp.hpp"
#include "../../project/refkit/AXMIspConfig.hpp"

#include "AXMIspAe/AXMIspAe.hpp"
#include "AXMIspAwb/AXMIspAwb.hpp"
#ifdef AXM_ISP_CT_AWB
#include "AXMIspCT/AXMIspCTAwb.hpp"
#endif
#include "AXMIspAssist/AXMIspAssist.hpp"
//#include <iostream>
#include "AXMIspAdjust/AXMIspAdjust.hpp"

#include "AXMIspTest/DSPCommon.h"
#include "AXMIspTest/adrs_base.h"
#include "AXMIspTest/reg_imageif.h"
#include "AXMIspTest/spad_map.h"

#include "AXHOb.hpp"
#include "AXHGamma.hpp"
#include "AXHAperture.hpp"
#include "AXHChromaSuppress.hpp"
#include "AXHScaler.hpp"

#include "AXHCommonParam.hpp"
#include "AXHLensShade.hpp"
#include "AXHIridix.hpp"
#include "AXHNR.hpp"
#include "AXHDefect.hpp"
#include "AXHMatrixGain.hpp"
#include "AXHRegDefine.hpp"


// 3rdリリースから、「モデルイベント」と「デバイスイベント」の
// 登録が可能となる。
//
// 状態テーブルは、状態ごとに定義し、イベントIDとメンバ関数の紐付けを行う。
// ※状態テーブルの最後は、必ず{0,NULL}で終了する必要がある。

// STATUS_RUNNING状態の状態テーブル定義
//      {イベントID, メンバ関数ポインタ}
//      ...
//     {0,NULL}
const AXMPixcessor::StateTable AXMPixcessor::state_running[] = {
    { AXMPixcessor::PIXCESSOR_EVENT_FAKE_ISR,
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcFrameIsr     },
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
    { AXMPixcessor::ISP_EVENT_AWB_OPD_SET,                  //  AWB OPD設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcAWBOpdSet    },
    { AXMPixcessor::ISP_EVENT_AE_OPD_SET,                   //  AE OPD設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcAEOpdSet     },
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
#ifndef ENABLE_OPD_DATA_ISP_TO_AXH
    { AXMPixcessor::ISP_EVENT_AWB_IMAGE,                    //  AWB 画像データ取得要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcAWBImage     },
    { AXMPixcessor::ISP_EVENT_AE_IMAGE,                     //  AE 画像データ取得要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcAEImage      },
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
#ifndef ENABLE_IMAGE_ADDR_ISP_TO_AXH
    { AXMPixcessor::ISP_EVENT_SHADE_IMAGE,                  //  Correct(シェーディング補正) 画像データ取得要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcCorrectImage   },
#endif  //  ENABLE_IMAGE_ADDR_ISP_TO_AXH
    { AXMPixcessor::ISP_EVENT_OB_AREA_SET,                  // OB OB領域設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcOBAreaSet           },
    { AXMPixcessor::ISP_EVENT_OB_DARKLEVEL_SET,             // OB 黒レベル設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcOBDarkLevelSet      },
    { AXMPixcessor::ISP_EVENT_OB_ACCUM_GET,                 // OB OB積算データ取得要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcOBAccumGet          },
    { AXMPixcessor::ISP_EVENT_OB_SENSOR_ARRAY_PTN_SET,      // OB センサ配列パターン選択領域設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcOBSensorArrayPtnSet },
    { AXMPixcessor::ISP_EVENT_OB_ARRAY_PTN_INDEX_SET,       // OB 配列パターンへのインデックス設定値設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcOBArrayPtnIndexSet  },
    { AXMPixcessor::ISP_EVENT_OB_FIX_DARKLEVEL_SET,         // OB 固定黒レベル値設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcOBFixDarkLevelSet   },
    { AXMPixcessor::ISP_EVENT_GAMMA_TABLE_SET,              // Gamma Gammaテーブル設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcGammaTblSet  },
    { AXMPixcessor::ISP_EVENT_APERTURE_TOTAL_GAIN_SET,      // Aperture トータルゲイン設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcApertureTotalGainSet   },
    { AXMPixcessor::ISP_EVENT_APERTURE_LIMIT_SET,           // Aperture リミット設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcAperturePlusMinusLimitSet        },
    { AXMPixcessor::ISP_EVENT_APERTURE_OVERMIDRANGE_GAINRATIO_SET, // Aperture 高域・中域ゲイン比率設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcApertureOverMidRangeGainRatioSet },
    { AXMPixcessor::ISP_EVENT_APERTURE_LUT_TABLE_SET,       // Aperture LUTテーブル設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcApertureLutTblSet      },
    { AXMPixcessor::ISP_EVENT_APERTURE_CORING_SET,          // Aperture コアリング設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcApertureCoringSet      },
    { AXMPixcessor::PIXCESSOR_EVENT_LENS_SHADE_SET,         // レンズシェーディング補正関連レジスタ設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcLensShadeSet           },
    { AXMPixcessor::PIXCESSOR_EVENT_IRIDIX_SET,             // IRIDIX関連レジスタ設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcIridixSet              },
    { AXMPixcessor::PIXCESSOR_EVENT_NR_SET,                 // NR関連レジスタ一括設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNRSet                  },
    { AXMPixcessor::PIXCESSOR_EVENT_NR_SIZE_SET,            // NR関連レジスタ画像サイズ設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNRSizeSet              },
    { AXMPixcessor::PIXCESSOR_EVENT_NR_MODE_SET,            // NR関連レジスタ動作モード設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNRModeSet              },
    { AXMPixcessor::PIXCESSOR_EVENT_NR_MAINY_SET,           // NR関連レジスタMAIN-Y信号設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNRMainYSet             },
    { AXMPixcessor::PIXCESSOR_EVENT_NR_MAINC_SET,           // NR関連レジスタMAIN-C信号設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNRMainCSet             },
    { AXMPixcessor::PIXCESSOR_EVENT_NR_SUBY_SET,            // NR関連レジスタSUB-Y信号設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNRSubYSet              },
    { AXMPixcessor::PIXCESSOR_EVENT_NR_SUBC_SET,            // NR関連レジスタSUB-C信号設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNRSubCSet              },
    { AXMPixcessor::PIXCESSOR_EVENT_DEFECT_SET,             // 画素欠陥補正関連レジスタ一括設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcDefectSet              },
    { AXMPixcessor::PIXCESSOR_EVENT_DEFECT_MODE_SET,        // 画素欠陥補正関連レジスタモード設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcDefectModeSet          },
    { AXMPixcessor::PIXCESSOR_EVENT_DEFECT_ADDRESS_SET,     // 画素欠陥補正関連レジスタアドレス設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcDefectAutoSet          },
    { AXMPixcessor::PIXCESSOR_EVENT_DEFECT_AUTO_SET,        // 画素欠陥補正関連レジスタ自動補正設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcDefectAutoSet          },
    { AXMPixcessor::PIXCESSOR_EVENT_DEFECT_LEVEL_SET,       // 画素欠陥補正関連レジスタ輝度信号レベル設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcDefectLevelSet         },
    { AXMPixcessor::PIXCESSOR_EVENT_RGB_MATRIX_SET,         // RGBマトリックス 設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcRGBMatrixSet           },
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
    { AXMPixcessor::PIXCESSOR_EVENT_NOTIFY_WDR_MODE,        // WDRモード変更通知
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNotifyWdrMode          },
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
    { AXMPixcessor::PIXCESSOR_EVENT_NOTIFY_LINEAR_MODE,     // Linear動作モード変更通知
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcNotifyLinearMode       },
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

    { AXMPixcessor::ISP_EVENT_CHROMA_LUT_TABLE_SET,         // Chroma LUTテーブル設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcChromaLutTblSet           },
    { AXMPixcessor::ISP_EVENT_CHROMA_LOW_LUMINANCE_GAIN_SET,// Chroma 低輝度クロマサプレスゲイン設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcChromaLowLuminanceGainSet },
    { AXMPixcessor::ISP_EVENT_CHROMA_EDGE_LUT_TABLE_SET,    // Chroma エッジクロマサプレスLUTテーブル設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcChromaEdgeLutTblSet       },
    { AXMPixcessor::ISP_EVENT_SCALER_IMAGE_SIZE_SET,        // Scaler スケーラー機能画像サイズ設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcScalerImageSizeSet },
    { AXMPixcessor::ISP_EVENT_SCALER_NEG_FLIP_SET,          // Scaler スケーラー機能ネガポジ・反転設定要求
      (AXMPixcessor::StateFuncPtr) &AXMPixcessor::funcScalerNegFlipSet   },
    {0,NULL}
};


ax::actorFuncStatus AXMPixcessor::funcFrameIsr(const void* pParam, int size) {
  return ax::AXFACTOR_SUCCESS;
}

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
ax::actorFuncStatus AXMPixcessor::funcAWBOpdSet(const void* pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    //  AWB用OPD設定要求
    ST_MSG *rcvMsg = (ST_MSG *)pParam;
    static ST_MSG msg = *rcvMsg;
    unsigned char *frameID = (unsigned char *)msg.data;
    imageif_enc_pic_start_awb(*frameID);
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcAEOpdSet(const void* pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    //  AE用OPD設定要求
    ST_MSG *rcvMsg = (ST_MSG *)pParam;
    static ST_MSG msg = *rcvMsg;
    unsigned char *frameID = (unsigned char *)msg.data;
    imageif_enc_pic_start_ae(*frameID);
  }

  return ax::AXFACTOR_SUCCESS;
}
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

#ifndef ENABLE_OPD_DATA_ISP_TO_AXH
ax::actorFuncStatus AXMPixcessor::funcAWBImage(const void* pParam, int size) {
  static ST_MSG msg;
  msg.sid = SID_AXMPixcessor;
  msg.rid = RID_AXMIspAwb;
  //  AWB用データ取得要求受信
  if((pParam != 0x00000000ul) && (0 < size))
  {
    ST_MSG *p_msg = (ST_MSG*)pParam;
    msg.cmd = p_msg->cmd;                                   //  受信したコマンドはそのまま返す
  }
#ifndef AXM_ISP_CT_AWB
  switch(msg.cmd & Cmd_Get_OPD_Mask) {
    case Cmd_Get_OPD_AWB:
      msg.data = (void *)opdDataAWB.getOpdData(AXH_Cmd_Get_Opd_AWB_0);
      break;
    case Cmd_Get_OPD_AWB_L:
    default:
      msg.data = (void *)opdDataAWB.getOpdData(AXH_Cmd_Get_Opd_AWB_1);
      break;
  }
#else   //  AXM_ISP_CT_AWB
  msg.data = AXMIspCTAwb::GetImagePtr();
#endif  //  AXM_ISP_CT_AWB
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIspAwb, AXMIspAwb::EVENT_COLOR_DATA, &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send AXMIspAwb::EVENT_COLOR_DATA");
  }
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcAEImage(const void* pParam, int size) {
  static ST_MSG msg;
  msg.sid = SID_AXMPixcessor;
  msg.rid = RID_AXMIspAwb;
  //  AE用データ取得要求受信
  if((pParam != 0x00000000ul) && (0 < size))
  {
    ST_MSG *p_msg = (ST_MSG*)pParam;
    msg.cmd = p_msg->cmd;                                   //  受信したコマンドはそのまま返す
  }
  //  3A画像データ 先頭アドレス設定
  switch(msg.cmd & Cmd_Get_OPD_Mask) {
    case Cmd_Get_OPD_AE_0:
      msg.data = (void *)opdDataAE.getOpdData(AXH_Cmd_Get_Opd_AE0_0);
      break;
    case Cmd_Get_OPD_AE_1:
      msg.data = (void *)opdDataAE.getOpdData(AXH_Cmd_Get_Opd_AE0_1);
      break;
    case Cmd_Get_OPD_AE_L_0:
      msg.data = (void *)opdDataAE.getOpdData(AXH_Cmd_Get_Opd_AE1_0);
      break;
    case Cmd_Get_OPD_AE_L_1:
    default:
      msg.data = (void *)opdDataAE.getOpdData(AXH_Cmd_Get_Opd_AE1_1);
      break;
  }
#ifndef PARASOFT_CPPTEST
  if (0 > send(nameIspAe, AXMIspAe::EVENT_START, &msg, sizeof(ST_MSG))) {
    m_log.write(AXFLOG_ERR, "fail send AXMIspAe::EVENT_START");
  }
#endif  //  PARASOFT_CPPTEST

  return ax::AXFACTOR_SUCCESS;
}
#endif  //  ENABLE_OPD_DATA_ISP_TO_AXH

#ifndef ENABLE_IMAGE_ADDR_ISP_TO_AXH
ax::actorFuncStatus AXMPixcessor::funcCorrectImage(const void* pParam, int size) {
  static ST_MSG msg;
  msg.sid = SID_AXMPixcessor;
  //  AWB用データ取得要求受信
  msg.data = (void *)opdConfigAE.getImageAddr();

  return ax::AXFACTOR_SUCCESS;
}
#endif //  ENABLE_IMAGE_ADDR_ISP_TO_AXH

ax::actorFuncStatus AXMPixcessor::funcOBAreaSet(const void* pParam, int size) {
	// OB領域設定要求(設定後は何もしない)
	if ((pParam != 0x00000000ul) && (0 < size)) {
		ST_MSG* msg = (ST_MSG*)pParam;

		if (msg->data != NULL) {
//			OBSamplingRange* range = (OBSamplingRange*)msg->data;
//			char str[100];
//			snprintf(str, sizeof(str), "funcOBAreaSet OB SamplingRange %d, %d, %d, %d\n", range->hStart, range->hEnd, range->vStart, range->vEnd);
//			m_log.write(AXFLOG_DEBUG, str);
			OBSamplingRange* range = (OBSamplingRange*)msg->data;
			AXHOb ob;
			ob.set_ob_area(range->hStart, range->hEnd, range->vStart, range->vEnd);
		}
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcOBDarkLevelSet(const void* pParam, int size) {
  // 黒レベル設定要求(設定後は何もしない)
	if ((pParam != 0x00000000ul) && (0 < size)) {
		//  暫定的にAXMIspからモード番号が送られてくるので、それを引数に指定する
		//  最終バージョンまでに修正すること
		ST_MSG* msg = (ST_MSG*)pParam;
		if (msg->data != NULL) {
//			unsigned int* darkLevel = &((unsigned int*)msg->data)[0];
//			char str[100];
//			snprintf(str, sizeof(str), "funcOBDarkLevelSet OB darkLevel %d, %d, %d, %d\n", darkLevel[0], darkLevel[1], darkLevel[2], darkLevel[3]);
//			m_log.write(AXFLOG_DEBUG, str);
			unsigned int* darkLevel = &((unsigned int*)msg->data)[0];
			AXHOb ob;
			ob.set_ob_dark_level(darkLevel[0], darkLevel[1], darkLevel[2], darkLevel[3]);
		}
		// 今回Assistは使用しないため不要
		/*
#ifndef PARASOFT_CPPTEST
		if (0 > send(nameIspAssist, AXMIspAssist::EVENT_PROC_SET_DARK_LEVEL, 0, 0)) {
			m_log.write(AXFLOG_ERR, "fail send AXMIspAssist::EVENT_PROC_SET_DARK_LEVEL");
		}
#endif  //  PARASOFT_CPPTEST
		*/
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcOBAccumGet(const void* pParam, int size) {
	ST_MSG* msg = (ST_MSG*)pParam;
	if (0 < size && msg != NULL) {
		unsigned long* accum = &((unsigned long*)msg->data)[0];
		AXHOb ob;
		ob.get_ob_accumlator(&accum[0], &accum[1], &accum[2], &accum[3]);

#ifdef PARASOFT_CPPTEST
		for (int i = 0; i < 4; i++) {
			accum[i] = (i + 1) * 100;
		}
		CPPTest_WORK[0] = 1;
#endif
	}

	// 今回Assistは使用しないため不要
	/*
#ifndef PARASOFT_CPPTEST
	if (0 > send(nameIspAssist, AXMIspAssist::EVENT_PROC_CALC_DARK_LEVEL, msg, sizeof(ST_MSG))) {
		m_log.write(AXFLOG_ERR, "fail send AXMIspAssist::EVENT_PROC_CALC_DARK_LEVEL");
	}
#endif  //  PARASOFT_CPPTEST
	*/

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcOBSensorArrayPtnSet(const void* pParam, int size) {
#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = -1;
#endif
	ST_MSG* msg = (ST_MSG*)pParam;
	if (0 < size && msg != NULL) {
//		unsigned char arrayPtn = (unsigned char)msg->data;
//		char str[100];
//		snprintf(str, sizeof(str), "funcOBSensorArrayPtnSet OB arrayPtn %d\n", (int)arrayPtn);
//		m_log.write(AXFLOG_DEBUG, str);
		unsigned char arrayPtn = *((unsigned char*)msg->data);
		AXHOb ob;
		ob.set_ob_sensor_array_ptn(arrayPtn);

#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = arrayPtn;
#endif
	}

	return ax::AXFACTOR_SUCCESS;

}
ax::actorFuncStatus AXMPixcessor::funcOBArrayPtnIndexSet(const void* pParam, int size) {
#ifdef PARASOFT_CPPTEST
	for (int i = 0; i < 16; i++) {
		CPPTest_WORK[i] = -1;
	}
#endif
	ST_MSG* msg = (ST_MSG*)pParam;
	if (0 < size && msg != NULL) {
//		unsigned char* ptnIndexes = &((unsigned char*)msg->data)[0];
//		char str[100];
//		snprintf(str, sizeof(str), "funcOBArrayPtnIndexSet OB ptnIndexes %d, %d, %d, ... %d\n", (int)ptnIndexes[0], (int)ptnIndexes[1], (int)ptnIndexes[2], (int)ptnIndexes[15]);
//		m_log.write(AXFLOG_DEBUG, str);
		unsigned char* ptnIndexes = &((unsigned char*)msg->data)[0];
		AXHOb ob;
		ob.set_ob_array_ptn_index(&ptnIndexes[0]);

#ifdef PARASOFT_CPPTEST
		for (int i = 0; i < 16; i++) {
			CPPTest_WORK[i] = ptnIndexes[i];
		}
#endif
	}
	
	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcOBFixDarkLevelSet(const void* pParam, int size) {
#ifdef PARASOFT_CPPTEST
	for (int i = 0; i < 8; i++) {
		CPPTest_WORK[i] = -1;
	}
#endif
	ST_MSG* msg = (ST_MSG*)pParam;
	if (0 < size && msg != NULL) {
//		unsigned int* dl = &((unsigned int*)msg->data)[0];
//		char str[100];
//		snprintf(str, sizeof(str), "funcOBFixDarkLevelSet OB dl %d, %d, %d, ... %d\n", dl[0], dl[1], dl[2], dl[7]);
//		m_log.write(AXFLOG_DEBUG, str);
		unsigned int* darklevel = &((unsigned int*)msg->data)[0];

		AXHOb ob;
		ob.set_ob_fix_dark_level(&darklevel[0]);

#ifdef PARASOFT_CPPTEST
		for (int i = 0; i < 8; i++) {
			CPPTest_WORK[i] = (int)darklevel[i];
		}
#endif
		// 今回Assistは使用しないため不要
		/*
#ifndef PARASOFT_CPPTEST
		if (0 > send(nameIspAssist, AXMIspAssist::EVENT_PROC_SET_DARK_LEVEL, 0, 0)) {
			m_log.write(AXFLOG_ERR, "fail send AXMIspAssist::EVENT_PROC_SET_DARK_LEVEL");
		}
#endif  //  PARASOFT_CPPTEST
		*/
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcGammaTblSet(const void* pParam, int size) {
	ST_MSG* msg = (ST_MSG*)pParam;
	if (0 < size && msg != NULL) {
		unsigned short* gamma = &((unsigned short*)msg->data)[0];

//		char str[100];
//		snprintf(str, sizeof(str), "funcGammaTblSet Gamma %d, %d, %d, %d, -> , %d, %d\n", gamma[0], gamma[1], gamma[2], gamma[3], gamma[63], gamma[64]);
//		m_log.write(AXFLOG_DEBUG, str);

		AXHGamma gm;
		gm.set_gamma_table(&gamma[0], CURVE_POI_CNT);

#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = 1;
#endif
	}

//#ifndef PARASOFT_CPPTEST
//	if (0 > send(nameIspAdjust, AXMIspAdjust::EVENT_PROC_GAMMA_END, 0, 0)) {
//		m_log.write(AXFLOG_ERR, "fail send AXMIspAdjust::EVENT_PROC_GAMMA_END");
//	}
//#endif  //  PARASOFT_CPPTEST

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcApertureTotalGainSet(const void *pParam, int size) {
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_APERTURE_PROC
		unsigned char totalGain = *((unsigned char*)pParam);

//		char str[100];
//		snprintf(str, sizeof(str), "*Debug*funcApertureTotalGainSet totalGain %d\n", totalGain);
//		m_log.write(AXFLOG_DEBUG, str);

		AXHAperture ap;
		ap.set_aperture_totalgain(totalGain);
#endif  // DISABLE_APERTURE_PROC
#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = 1;
#endif
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcAperturePlusMinusLimitSet(const void *pParam, int size) {
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_APERTURE_PROC
		short* limit = &((short*)pParam)[0];

//		char str[100];
//		snprintf(str, sizeof(str), "*Debug*funcAperturePlusMinusLimitSet limitPositive %d limitNegative %d\n", limit[0], limit[1]);
//		m_log.write(AXFLOG_DEBUG, str);

		AXHAperture ap;
		ap.set_aperture_plus_minus_limit(static_cast<unsigned short>(limit[0]), static_cast<unsigned short>(limit[1]));
#endif  // DISABLE_APERTURE_PROC
#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = 1;
#endif
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcApertureOverMidRangeGainRatioSet(const void *pParam, int size) {
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_APERTURE_PROC
		unsigned char* ratio = &((unsigned char*)pParam)[0];

//		char str[100];
//		snprintf(str, sizeof(str), "*Debug*funcApertureOverMidRangeGainRatioSet highRangeRatio %d midRangeRatio %d\n", ratio[0], ratio[1]);
//		m_log.write(AXFLOG_DEBUG, str);

		AXHAperture ap;
		ap.set_aperture_overmidrange_gainratio(ratio[0], ratio[1]);
#endif  // DISABLE_APERTURE_PROC
#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = 1;
#endif
	}

	return ax::AXFACTOR_SUCCESS;

}

ax::actorFuncStatus AXMPixcessor::funcApertureLutTblSet(const void *pParam, int size) {
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_APERTURE_PROC
		ST_MSG* msg = (ST_MSG*)pParam;
		unsigned char* lut = (unsigned char*)msg->data;
		int datasize = AP_LUT_DATA_CNT;

//		char str[100];
//		snprintf(str, sizeof(str), "*Debug*funcApertureLutTblSet lut %d, %d, %d, %d,... %d, %d size %d\n", lut[0], lut[1], lut[2], lut[3], lut[126], lut[127], datasize);
//		m_log.write(AXFLOG_DEBUG, str);

		AXHAperture ap;
		ap.set_aperture_lut(&lut[0], datasize);
#endif  // DISABLE_APERTURE_PROC
#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = 1;
#endif
	}

	return ax::AXFACTOR_SUCCESS;
}
ax::actorFuncStatus AXMPixcessor::funcApertureCoringSet(const void *pParam, int size) {
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_APERTURE_PROC
		BYTE coringTh = *((BYTE*)pParam);

//		char str[100];
//		snprintf(str, sizeof(str), "*Debug*funcApertureCoringSet coringTh %d\n", coringTh);
//		m_log.write(AXFLOG_DEBUG, str);

		AXHAperture ap;
		ap.set_aperture_coring(coringTh);
#endif  // DISABLE_APERTURE_PROC
#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = 1;
#endif
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcLensShadeSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    //  レンズシェーディング補正設定
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_LENS_SHADE *p_LensShade = (ST_LENS_SHADE *)(p_msg->data);
    int cmd = p_msg->cmd;
    if(cmd == Cmd_Adjust_LensShade_Init) {
      //  c++testでAXHLensShadeオブジェクトの内容を確認するために、次のような条件コンパイルとする
      AXHLensShade LensShade(AXH_LensShade_Mode_Init);
      LensShade.setEnabled(p_LensShade->Enabled);
      LensShade.setPitch(p_LensShade->Pitch);
      LensShade.setShift(p_LensShade->Shift);
      LensShade.Execute();
    }
    else {
      AXHLensShade LensShade;
      if((cmd & Cmd_Adjust_LensShade_Enabled) == Cmd_Adjust_LensShade_Enabled) {
        LensShade.setEnabled(p_LensShade->Enabled);
      }
      if((cmd & Cmd_Adjust_LensShade_Pitch) == Cmd_Adjust_LensShade_Pitch) {
        LensShade.setPitch(p_LensShade->Pitch);
      }
      if((cmd & Cmd_Adjust_LensShade_Shift) == Cmd_Adjust_LensShade_Shift) {
        LensShade.setShift(p_LensShade->Shift);
      }
      LensShade.Execute();
    }
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcIridixSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_IRIDIX *p_Iridix = (ST_IRIDIX *)(p_msg->data);
    int cmd = p_msg->cmd;
    AXHIridix iridix;
    iridix.setStrength(p_Iridix->Strength);
    iridix.setMinSlope(p_Iridix->MinSlope);
    iridix.setMaxSlope(p_Iridix->MaxSlope);
    Width = p_spec->Scaler.scaling.InImgSize.Width;
    Height = p_spec->Scaler.scaling.InImgSize.Height;
    if(cmd == Cmd_Adjust_Iridix_Init) {
      iridix.Execute(AXH_Iridix_Mode_Init, Width, Height);
    }
    else {
      iridix.Execute(AXH_Iridix_Mode_Run, Width, Height);
    }
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcNRSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_NR *p_NR = (ST_NR *)(p_msg->data);
    AXHNR nr;
    nr.setMode(p_NR->Mode);
    //  3DNR
    for(UINT i = 0; i < AXH_NR_Main_Max; i++) {
      nr.setMainYTH(i, p_NR->Main.YTH[i]);
      nr.setMainYIN(i, p_NR->Main.YIN[i]);
      nr.setMainYLV(i, p_NR->Main.YLV[i]);
      nr.setMainCTH(i, p_NR->Main.CTH[i]);
      nr.setMainCIN(i, p_NR->Main.CIN[i]);
      nr.setMainCLV(i, p_NR->Main.CLV[i]);
    }
    //  2DNR
    for(UINT i = 0; i < AXH_NR_Sub_Max; i++) {
      nr.setSubYTH(i, p_NR->Sub.YTH[i]);
      nr.setSubYIN(i, p_NR->Sub.YIN[i]);
      nr.setSubYLV(i, p_NR->Sub.YLV[i]);
      nr.setSubCTH(i, p_NR->Sub.CTH[i]);
      nr.setSubCIN(i, p_NR->Sub.CIN[i]);
      nr.setSubCLV(i, p_NR->Sub.CLV[i]);
    }
    nr.Execute(Width, Height);
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcNRSizeSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
//    ST_MSG *p_msg = (ST_MSG *)pParam;
//    ST_NR *p_NR = (ST_NR *)(p_msg->data);
    AXHNR nr;
    nr.ExecuteSize(Width, Height);
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcNRModeSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_NR *p_NR = (ST_NR *)(p_msg->data);
    AXHNR nr;
    nr.ExecuteMode(p_NR->Mode);
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcNRMainYSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_NR *p_NR = (ST_NR *)(p_msg->data);
    AXHNR nr;
		
    for(UINT i = 0; i < AXH_NR_Main_Max; i++) {
      nr.setMainYTH(i, p_NR->Main.YTH[i]);
      nr.setMainYIN(i, p_NR->Main.YIN[i]);
      nr.setMainYLV(i, p_NR->Main.YLV[i]);
    }
    nr.ExecuteMainY();
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcNRMainCSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_NR *p_NR = (ST_NR *)(p_msg->data);
    AXHNR nr;
		
    for(UINT i = 0; i < AXH_NR_Main_Max; i++) {
      nr.setMainCTH(i, p_NR->Main.CTH[i]);
      nr.setMainCIN(i, p_NR->Main.CIN[i]);
      nr.setMainCLV(i, p_NR->Main.CLV[i]);
    }
    nr.ExecuteMainC();
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcNRSubYSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_NR *p_NR = (ST_NR *)(p_msg->data);
    AXHNR nr;
		
    for(UINT i = 0; i < AXH_NR_Sub_Max; i++) {
      nr.setSubYTH(i, p_NR->Sub.YTH[i]);
      nr.setSubYIN(i, p_NR->Sub.YIN[i]);
      nr.setSubYLV(i, p_NR->Sub.YLV[i]);
    }
    nr.ExecuteSubY();
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcNRSubCSet(const void *pParam, int size) {
  if((pParam != 0x00000000ul) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_NR *p_NR = (ST_NR *)(p_msg->data);
    AXHNR nr;
		
    for(UINT i = 0; i < AXH_NR_Sub_Max; i++) {
      nr.setSubCTH(i, p_NR->Sub.CTH[i]);
      nr.setSubCIN(i, p_NR->Sub.CIN[i]);
      nr.setSubCLV(i, p_NR->Sub.CLV[i]);
    }
    nr.ExecuteSubC();
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcDefectSet(const void *pParam, int size) {
  if((pParam != NULL) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_DEFECT *p_Defect = (ST_DEFECT *)(p_msg->data);
    funcSetDefectMode(p_Defect);                            //  モード設定
    funcSetDefectAddress(p_Defect);                         //  アドレス設定
    funcSetDefectAuto(p_Defect);                            //  自動補正設定
    funcSetDefectLevel(p_Defect);                           //  輝度信号レベル設定
  }

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcDefectModeSet(const void *pParam, int size) {
  if((pParam != NULL) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_DEFECT *p_Defect = (ST_DEFECT *)(p_msg->data);
    funcSetDefectMode(p_Defect);
  }

  return ax::AXFACTOR_SUCCESS;
}

void AXMPixcessor::funcSetDefectMode(ST_DEFECT *p_Defect) {
  AXHDefect Defect;
	
  Defect.setDMAmode(p_Defect->Mode.External);
  Defect.setAutoEnable(p_Defect->Mode.AutoCorrect);
}

ax::actorFuncStatus AXMPixcessor::funcDefectAddressSet(const void *pParam, int size) {
  if((pParam != NULL) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_DEFECT *p_Defect = (ST_DEFECT *)(p_msg->data);
    funcSetDefectAddress(p_Defect);
  }

  return ax::AXFACTOR_SUCCESS;
}

void AXMPixcessor::funcSetDefectAddress(ST_DEFECT *p_Defect) {
  AXHDefect Defect;
	
  for(UINT i = 0; i < AXH_Defect_IntAddr_Max; i++) {
    Defect.setPixcelAddr(i, p_Defect->Address[i]);
  }
}

ax::actorFuncStatus AXMPixcessor::funcDefectAutoSet(const void *pParam, int size) {
  if((pParam != NULL) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_DEFECT *p_Defect = (ST_DEFECT *)(p_msg->data);
    funcSetDefectAuto(p_Defect);
  }

  return ax::AXFACTOR_SUCCESS;
}

void AXMPixcessor::funcSetDefectAuto(ST_DEFECT *p_Defect) {
  AXHDefect Defect;
	
  Defect.setAutoCorrect(p_Defect->AutoCorrect.CLS);
  Defect.setAutoSel(p_Defect->AutoCorrect.Ave);
  Defect.setWhiteDefectTH(p_Defect->AutoCorrect.TH_H);
  Defect.setBlackDefectTH(p_Defect->AutoCorrect.TH_L);
}

ax::actorFuncStatus AXMPixcessor::funcDefectLevelSet(const void *pParam, int size) {
  if((pParam != NULL) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_DEFECT *p_Defect = (ST_DEFECT *)(p_msg->data);
    funcSetDefectLevel(p_Defect);
  }

  return ax::AXFACTOR_SUCCESS;
}

void AXMPixcessor::funcSetDefectLevel(ST_DEFECT *p_Defect) {
  AXHDefect Defect;
	
  for(UINT i = 0; i < AXH_Defect_ADFOFS_Max; i++) {
    Defect.setLevelModulate(i, p_Defect->AutoCorrect.OFST[i]);
  }
}

ax::actorFuncStatus AXMPixcessor::funcRGBMatrixSet(const void *pParam, int size) {
  if((pParam != NULL) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG *)pParam;
    ST_RGB_MATRIX *p_RGBMatrix = (ST_RGB_MATRIX *)(p_msg->data);
    //  設定処理を追加
    AXHRGBMatrixCoef RGBMatrix;
    for(unsigned int i = 0; i < AXH_RGBMatrixSetOut_Max; i++) {
      for(unsigned int j = 0; j < AXH_RGBMatrixSetIn_Max; j++) {
        RGBMatrix.setCoef(i, j, p_RGBMatrix->Coef[i][j]);
      }
      RGBMatrix.setOffset(i, p_RGBMatrix->Offset[i]);
    }
    RGBMatrix.setRegCtrl(AXH_LMBC_Init);
  }

  return ax::AXFACTOR_SUCCESS;
}

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
ax::actorFuncStatus AXMPixcessor::funcNotifyWdrMode(const void* pParam, int size) {
  if((pParam != NULL) && (0 < size)) {
    ST_MSG *p_msg = (ST_MSG*)pParam;
	isWdrMode = *(bool *)p_msg->data;
  }
  return ax::AXFACTOR_SUCCESS;
}
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
ax::actorFuncStatus AXMPixcessor::funcNotifyLinearMode(const void* pParam, int size) {
	if ((pParam != NULL) && (0 < size)) {
		ST_MSG *p_msg = (ST_MSG*)pParam;
		bool isLinearMode = *(bool *)p_msg->data;
		opdConfigAE.setLinearMode (isLinearMode);
		opdConfigAWB.setLinearMode(isLinearMode);
	}

	return ax::AXFACTOR_SUCCESS;
}
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

ax::actorFuncStatus AXMPixcessor::funcChromaLutTblSet(const void *pParam, int size) {
	static bool luminanceModEnabled = false;

#ifdef PARASOFT_CPPTEST
	CPPTest_WORK[10] = -1;
#endif
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_CHROMA_PROC
		ST_MSG* msg = (ST_MSG*)pParam;
		unsigned char* lut = (unsigned char*)msg->data;
		int datasize = CH_MAX_LUT_SIZE;

		//char str[100];
		//snprintf(str, sizeof(str), "*Debug*funcChromaLutTblSet lut %d, %d, %d, %d,... %d, %d size %d\n", lut[0], lut[1], lut[2], lut[3], lut[254], lut[255], datasize);
		//m_log.write(AXFLOG_DEBUG, str);

		AXHChromaSuppress ch;
		// 初回呼び出し時、輝度変調を有効にする
		if (luminanceModEnabled == false) {
			ch.set_chroma_luminanceModulation_signal_flow();
			luminanceModEnabled = true;
#ifdef PARASOFT_CPPTEST
			CPPTest_WORK[10] = 1;
#endif
		}
		// 輝度変調テーブルを設定
		ch.set_chroma_lut(&lut[0], datasize);

#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = lut[0];
		CPPTest_WORK[1] = lut[1];
		CPPTest_WORK[2] = lut[2];
		CPPTest_WORK[3] = lut[3];
		CPPTest_WORK[4] = lut[4];
		CPPTest_WORK[5] = lut[5];
		CPPTest_WORK[6] = lut[6];
		CPPTest_WORK[7] = lut[253];
		CPPTest_WORK[8] = lut[254];
		CPPTest_WORK[9] = lut[255];
#endif
#endif  // DISABLE_CHROMA_PROC
	}

	return ax::AXFACTOR_SUCCESS;
}
ax::actorFuncStatus AXMPixcessor::funcChromaLowLuminanceGainSet(const void *pParam, int size) {
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_CHROMA_PROC
		BYTE gain = *((BYTE*)pParam);

		//char str[100];
		//snprintf(str, sizeof(str), "*Debug*funcChromaLowLuminanceGainSet gain %d\n", gain);
		//m_log.write(AXFLOG_DEBUG, str);

		AXHChromaSuppress ch;
		ch.set_chroma_lowLuminance_gain_signal_flow(gain);

#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = gain;
#endif
#endif  // DISABLE_CHROMA_PROC
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcChromaEdgeLutTblSet(const void *pParam, int size) {
	static bool edgeChromaEnabled = false;

#ifdef PARASOFT_CPPTEST
	CPPTest_WORK[10] = -1;
#endif
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_CHROMA_PROC
		ST_MSG* msg = (ST_MSG*)pParam;
		unsigned char* lut = (unsigned char*)msg->data;

//		char str[100];
//		snprintf(str, sizeof(str), "*Debug*funcChromaEdgeLutTblSet lut %d, %d, %d, %d,... %d, %d\n", lut[0], lut[1], lut[2], lut[3], lut[126], lut[127]);
//		m_log.write(AXFLOG_DEBUG, str);

		AXHChromaSuppress ch;
		// 初回呼び出し時、エッジクロマサプレスを有効にする
		if (edgeChromaEnabled == false) {
			ch.set_chroma_edge_signal_flow();
			edgeChromaEnabled = true;
#ifdef PARASOFT_CPPTEST
			CPPTest_WORK[10] = 1;
#endif
		}
		// エッジクロマサプレスLUTテーブルを設定
		ch.set_chroma_edge_lut(&lut[0]);

#ifdef PARASOFT_CPPTEST
		CPPTest_WORK[0] = lut[0];
		CPPTest_WORK[1] = lut[1];
		CPPTest_WORK[2] = lut[2];
		CPPTest_WORK[3] = lut[3];
		CPPTest_WORK[4] = lut[4];
		CPPTest_WORK[5] = lut[5];
		CPPTest_WORK[6] = lut[6];
		CPPTest_WORK[7] = lut[125];
		CPPTest_WORK[8] = lut[126];
		CPPTest_WORK[9] = lut[127];
#endif
#endif  // DISABLE_CHROMA_PROC
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcScalerImageSizeSet(const void *pParam, int size) {
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_SCALER_PROC
		AXHScaler scl;

		ST_SCALER scaler = *((ST_SCALER*)((ST_MSG*)pParam)->data);

		// スケーラー機能有効・無効/入出力画像サイズ設定
		for (int ch = 0; ch < SCL_SCALING_CH_CNT; ch++) {
			scl.set_scaler_src_img_size(ch, scaler.scaling.InImgSize.Width , scaler.scaling.InImgSize.Height );
			scl.set_scaler_dst_img_size(ch, scaler.scaling.OutImgSize[ch].Width, scaler.scaling.OutImgSize[ch].Height);
//			std::cout << "ch:" << ch << "/InImgSizeWidth:" << (int)scaler.scaling[ch].InImgSize.Width << "/InImgSizeHeight:" << (int)scaler.scaling[ch].InImgSize.Height << std::endl;
//			std::cout << "ch:" << ch << "/OutImgSizeWidth:" << (int)scaler.scaling[ch].OutImgSize.Width << "/OutImgSizeHeight:" << (int)scaler.scaling[ch].OutImgSize.Height << std::endl;
#ifdef PARASOFT_CPPTEST
			CPPTest_WORK[ch * 4 + 0] = scaler.scaling.InImgSize.Width;
			CPPTest_WORK[ch * 4 + 1] = scaler.scaling.InImgSize.Height;
			CPPTest_WORK[ch * 4 + 2] = scaler.scaling.OutImgSize[ch].Width;
			CPPTest_WORK[ch * 4 + 3] = scaler.scaling.OutImgSize[ch].Height;
#endif
		}
#endif  // DISABLE_SCALER_PROC
	}

	return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMPixcessor::funcScalerNegFlipSet(const void *pParam, int size) {
	if (0 < size && pParam != NULL) {
#ifndef DISABLE_SCALER_PROC
		AXHScaler scl;

		ST_SCALER scaler = *((ST_SCALER*)((ST_MSG*)pParam)->data);

		// ネガポジ/上下左右反転設定
		for (int ch = 0; ch < SCL_NEG_FLIP_CH_CNT; ch++) {
			scl.set_scaler_neg_flip(ch, scaler.flip[ch].vFlip, scaler.flip[ch].hFlip, scaler.neg[ch]);
//			std::cout << "ch:" << ch << "/vFlip:" << (int)scaler.flip[ch].vFlip << "/hFlip:" << (int)scaler.flip[ch].hFlip << std::endl;
//			std::cout << "ch:" << ch << "/nega :" << (int)scaler.neg[ch] << std::endl;
#ifdef PARASOFT_CPPTEST
			CPPTest_WORK[ch * 3 + 0] = scaler.flip[ch].vFlip;
			CPPTest_WORK[ch * 3 + 1] = scaler.flip[ch].hFlip;
			CPPTest_WORK[ch * 3 + 2] = scaler.neg [ch];
#endif
		}
#endif  // DISABLE_SCALER_PROC
	}

	return ax::AXFACTOR_SUCCESS;
}


#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
void AXMPixcessor::imageif_enc_pic_start_awb(unsigned char frameID)
{
  opdConfigAWB.setOpdMode(g_opd_mode_raw);
  opdConfigAWB.setVerDiv(g_opd_v_div_awb);
  opdConfigAWB.setHorDiv(g_opd_h_div_awb);
  opdConfigAWB.setVerWSize(g_avever_w_size_v_awb);
  opdConfigAWB.setHorWSize(g_avever_w_size_h_awb);
  switch(frameID) {
    case AXMIsp::ISP_FRAME_AWB_3A:      //  AWB 短時間画像設定
      opdConfigAWB.setOpdConfig(AXH_Cmd_Get_Opd_AWB_0, isWdrMode);
      break;
    case AXMIsp::ISP_FRAME_AWB_3A_L:    //  AWB 長時間画像設定
    default:
      opdConfigAWB.setOpdConfig(AXH_Cmd_Get_Opd_AWB_1, isWdrMode);
      break;
  }
}

void AXMPixcessor::imageif_enc_pic_start_ae(unsigned char frameID)
{
  opdConfigAE.setOpdMode(g_opd_mode_yrgb);
  opdConfigAE.setVerDiv(g_opd_v_div_ae);
  opdConfigAE.setHorDiv(g_opd_h_div_ae);
  opdConfigAE.setVerWSize(g_avever_w_size_v_ae);
  opdConfigAE.setHorWSize(g_avever_w_size_h_ae);

  switch(frameID) {
    case AXMIsp::ISP_FRAME_AE_3A_0:     //  AE 短時間0画像設定
      opdConfigAE.setOpdConfig(AXH_Cmd_Get_Opd_AE0_0, isWdrMode);
      break;
    case AXMIsp::ISP_FRAME_AE_3A_1:     //  AE 短時間1画像設定
      opdConfigAE.setOpdConfig(AXH_Cmd_Get_Opd_AE0_1, isWdrMode);
      break;
    case AXMIsp::ISP_FRAME_AE_3A_L_0:   //  AE 長時間0画像設定
      opdConfigAE.setOpdConfig(AXH_Cmd_Get_Opd_AE1_0, isWdrMode);
      break;
    case AXMIsp::ISP_FRAME_AE_3A_L_1:   //  AE 長時間1画像設定
    default:
      opdConfigAE.setOpdConfig(AXH_Cmd_Get_Opd_AE1_1, isWdrMode);
      break;
  }
}
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH

