/*
 * AXMTest.cpp
 */

#include "AXMTest.hpp"
#ifndef BB_TMP_PASS	/* 一旦コンパイルを通す用 */
#include "../../project/refkit/AXMAxConfig.hpp"
#endif

AXMTest::AXMTest(AXFObjectName& name)
    : AXModelActor(name),
      m_log(name),
      m_name(name),
      m_loopbackCount(0),
      m_isLoopback(false),
      m_timerId(0),
#ifndef	UNUSE_CHRONO	// baba Chrono非対応
      m_chronoStart(),
#endif
      m_isTimerTest(false),
      m_watchdogLoop(true) {
  m_log.write(AXFLOG_DEBUG, "AXMTest Constractor");
}

AXMTest::~AXMTest() {
  m_log.write(AXFLOG_DEBUG, "AXMTest Destractor");
}

ax::actorFuncStatus AXMTest::onCreate() {
  m_log.write(AXFLOG_DEBUG, "AXMTest onCreate()");

  // StateMachine に必要な情報を登録する
  //      自オブジェクト,
  //      初期状態,
  //      状態の最大数
  if (0 > setStateInfo(this, STATE_RUNNING, STATE_MAX)) {
    m_log.write(AXFLOG_ERR, "fail registHandle");
    return ax::AXFACTOR_ERROR;
  }

  // STATE_RUNNING状態の状態テーブルを登録する
  //      状態テーブルで登録する状態,
  //      状態テーブルのポインタ,
  setStateTable(STATE_RUNNING, state_running);

  createTimer();

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMTest::onDestroy() {
  m_log.write(AXFLOG_DEBUG, "AXMTest onDestroy()");

  deleteTimer();

  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMTest::onStart() {
  m_log.write(AXFLOG_DEBUG, "AXMTest onStart()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMTest::onStop() {
  m_log.write(AXFLOG_DEBUG, "AXMTest onStop()");
  return ax::AXFACTOR_SUCCESS;
}

#if 0
ax::actorFuncStatus AXMTest::onPause() {
  m_log.write(AXFLOG_DEBUG, "AXMTest onPause()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMTest::onResume() {
  m_log.write(AXFLOG_DEBUG, "AXMTest onResume()");
  return ax::AXFACTOR_SUCCESS;
}

ax::actorFuncStatus AXMTest::onRestart() {
  m_log.write(AXFLOG_DEBUG, "AXMTest onRestart()");
  return ax::AXFACTOR_SUCCESS;
}
#endif
