/*
 * @file   AXMTest.hpp
 * @brief  AXMTestクラスヘッダ
 *
 * @n      AXテスト用クラス
 *         Across ISP
 * @par    Programming Language
 *         C++
 */

#ifndef AXMTEST_HPP_
#define AXMTEST_HPP_

#include "../AXM/AXModelActor.hpp"
#include <vector>

/*
 * @class AXMTest
 * @brief AXテスト用クラス
 */
class AXMTest : public AXModelActor {
  AXFLog m_log;
  AXFObjectName& m_name;
  int m_loopbackCount;
  bool m_isLoopback;
  TimerId_t m_timerId;
  std::vector<int> m_vec;
#ifndef	UNUSE_CHRONO	// baba Chrono非対応
  AXFChrono m_chronoStart;
#endif
  bool m_isTimerTest;
  bool m_watchdogLoop;

 public:
  AXMTest(AXFObjectName& name);
  virtual ~AXMTest();
  ax::actorFuncStatus onCreate();
  ax::actorFuncStatus onDestroy();
  ax::actorFuncStatus onStart();
  ax::actorFuncStatus onStop();
#if 0
  ax::actorFuncStatus onPause();
  ax::actorFuncStatus onResume();
  ax::actorFuncStatus onRestart();
#endif

// StateMachineオブジェクト用ヘッダファイル挿入
#include "./AXMTestState.hpp"
};
#endif /* AXMTEST_HPP_ */
