/*!
    \file    datapath.h
    \brief   the header file of datapath

*/

#ifndef DATAPATH_H
#define DATAPATH_H

//#define UHD
//#define RAW10
//#define YUV422_10
//#define LISR_THRU
//#define IMX415
// 下記切り替えは設定側のコンパイルスイッチで行う
//#define IMX412
//#define IMX662
//#define FPS60

#ifdef IMX415
#ifdef UHD
  #ifdef RAW10
    #ifdef YUV422_10
    #include "datapath_uhd30_r10_yuv422_10.h"
    #else
      #ifdef FPS60
      #include "datapath_uhd60_r10_yuv422_8.h"
      //#include "datapath_uhd60_r10_yuv420_8.h"
      #else
      #include "datapath_uhd30_r10_yuv422_8.h"
      #endif
    #endif
  #else
    #ifdef YUV422_10
    #include "datapath_uhd30_r12_yuv422_10.h"
    #else
      #ifdef LISR_THRU
      #include "datapath_uhd30_r12_yuv422_8_thru_wo_ddr.h"
      #else
      #include "datapath_uhd30_r12_yuv422_8.h"
      #endif
    #endif
  #endif
#else
  #ifdef YUV422_10
  #include "datapath_fhd60_r12_yuv422_10.h"
  #else
    #ifdef LISR_THRU
    #include "datapath_fhd60_r12_yuv422_8_thru_wo_ddr.h"
    #else
    #include "datapath_fhd60_r12_yuv422_8.h"
    #endif
  #endif
#endif
#endif

#ifdef IMX412
	#ifdef UHD
		#ifdef LISR_THRU
			#include "imx412_datapath_uhd30_r12_yuv422_8_thru_wo_ddr.h"
		#else
			#include "imx412_datapath_uhd30_r12_yuv422_8.h"
		#endif
	#else
		#include "imx412_datapath_fhd53_r10_yuv422_8.h"
	#endif
#endif
#ifdef IMX662
	#ifdef FPS60
		#include "imx662_datapath_fhd60_r12_yuv422_8.h"
	#else
	  #include "imx662_datapath_fhd30_r12_yuv422_8.h"
	#endif
#endif

void datapath_init(void);

#endif  /* DATAPATH_H */
