
#include "lisoc_test.h"
#include "ddr4.h"
#include "ddr.h"

#define DDR_CTRL_BASE_ADDR1 0x40040000
#define DDR_CTRL_BASE_ADDR0 0x40030000
#define DDR_PHY_BASE_ADDR1 0x40020000
#define DDR_PHY_BASE_ADDR0 0x40010000
#define phy_init_complete_to_reg  0x2c4, 0, 0
#define sdram_init_done_to_reg    0x2c4, 1, 1


volatile uint32_t ddr_ctrl_base_addr = DDR_CTRL_BASE_ADDR0;
volatile uint32_t ddr_phy_base_addr = DDR_PHY_BASE_ADDR0;

void apb_ctrl_wr_cmd( uint32_t addr, uint8_t stop, uint8_t start, uint32_t wdata ){
  unsigned int tmp0 =0 ;
  unsigned int tmp1 =0 ;
  tmp0 =(*(volatile uint32_t *)((addr)  | ddr_ctrl_base_addr));
  tmp1 =(((0xffffffff <<(31-stop))>>(31-stop+start))<<start);
  tmp0 = tmp0 &(~tmp1);
  tmp0 =((wdata <<start) & tmp1)|tmp0;
  (*(volatile uint32_t *)((addr)  | ddr_ctrl_base_addr)) = tmp0;
  //printf("[PHY_WR]addr[%d:%d] = 0x%08x;   wdata = 0x%08x\n",stop,start,addr,wdata);
}

void apb_ctrl_rd_cmd( uint32_t addr, uint8_t stop, uint8_t start, uint32_t *rdata ){
  unsigned int tmp =0  ;
  tmp =(*(volatile uint32_t *)((addr) | ddr_ctrl_base_addr));
  tmp =((tmp <<(31-stop))>>(31-stop+start));
  //printf("[PHY_WR]addr[%d:%d] = 0x%08x;   rdata = 0x%08x\n",stop,start,addr,tmp);        
  *rdata = tmp;
}

void apb_wr_cmd( uint32_t addr, uint8_t stop, uint8_t start, uint32_t wdata ){
  unsigned int tmp0 =0 ;
  unsigned int tmp1 =0 ;
  tmp0 =(*(volatile uint32_t *)((addr)  | ddr_phy_base_addr));
  tmp1 =(((0xffffffff <<(31-stop))>>(31-stop+start))<<start);
  tmp0 = tmp0 &(~tmp1);
  tmp0 =((wdata <<start) & tmp1)|tmp0;
  (*(volatile uint32_t *)((addr)  | ddr_phy_base_addr)) = tmp0;   
  //printf("[PHY_WR]addr[%d:%d] = 0x%08x;   wdata = 0x%08x\n",stop,start,addr,wdata);
}


void apb_rd_cmd( uint32_t addr, uint8_t stop, uint8_t start, uint32_t *rdata ){
  unsigned int tmp =0  ;
  tmp =(*(volatile uint32_t *)((addr)| ddr_phy_base_addr));
  tmp =((tmp <<(31-stop))>>(31-stop+start));
  //printf("[PHY_WR]addr[%d:%d] = 0x%08x;   rdata = 0x%08x\n",stop,start,addr,tmp);        
  *rdata = tmp;
}

void init_ddr(uint32_t ctl_base_addr, uint32_t phy_base_addr) {
  uint32_t read_data;
  ddr_ctrl_base_addr = ctl_base_addr;
  ddr_phy_base_addr = phy_base_addr;

  //phy_analog_config();

  if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR0) {
    LISOC_RCC->RCC_DPBLKRSTR.DDR0CORERST = 0x1;
    LISOC_RCC->RCC_DPBLKRSTR.DDR0PHYRST = 0x1;
  }
  if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR1) {
    LISOC_RCC->RCC_DPBLKRSTR.DDR1CORERST = 0x1;
    LISOC_RCC->RCC_DPBLKRSTR.DDR1PHYRST = 0x1;
  }

  //apb_ctrl_wr_cmd(0x0d8,0,0,0x1);
  //apb_ctrl_wr_cmd(0x0d8,21,16,0x4);
  //apb_ctrl_wr_cmd(0x0d8,12,8,0x10);


  apb_ctrl_wr_cmd(0x208, 31, 0, 0x5);
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7f804480);
  apb_ctrl_wr_cmd(0x20c, 31, 0, 0x1);
  apb_ctrl_wr_cmd(0x20c, 31, 0, 0x1);
  apb_ctrl_wr_cmd(0xa0, 31, 0, 0x0);
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7f804480);
  apb_ctrl_wr_cmd(0xdc, 31, 0, 0x80700);
  apb_ctrl_wr_cmd(0xdc, 31, 0, 0xb0700);
  apb_ctrl_wr_cmd(0xdc, 31, 0, 0xb0c00);
  apb_ctrl_wr_cmd(0xdc, 31, 0, 0xb0c00);
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7f804480);
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7f804480);
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804480);
  apb_ctrl_wr_cmd(0x1d8, 31, 0, 0x8fa);
  apb_ctrl_wr_cmd(0x1d8, 31, 0, 0x8fa);
  apb_ctrl_wr_cmd(0x1d8, 31, 0, 0x90a);
  apb_ctrl_wr_cmd(0x1d8, 31, 0, 0x90a);
  apb_ctrl_wr_cmd(0x1dc, 31, 0, 0x3020100);
  apb_ctrl_wr_cmd(0x1dc, 31, 0, 0x3020100);
  apb_ctrl_wr_cmd(0x1dc, 31, 0, 0x3020100);
  apb_ctrl_wr_cmd(0x1dc, 31, 0, 0x4020100);
  apb_ctrl_wr_cmd(0x1e0, 31, 0, 0x7060505);
  apb_ctrl_wr_cmd(0x1e0, 31, 0, 0x7060605);
  apb_ctrl_wr_cmd(0x1e0, 31, 0, 0x7070605);
  apb_ctrl_wr_cmd(0x1e0, 31, 0, 0x8070605);
  apb_ctrl_wr_cmd(0x1e4, 31, 0, 0x909);
  apb_ctrl_wr_cmd(0x1e4, 31, 0, 0xa09);
  apb_ctrl_wr_cmd(0x1e4, 31, 0, 0xa09);
  apb_ctrl_wr_cmd(0x1e4, 31, 0, 0xa09);
  apb_ctrl_wr_cmd(0x1e8, 31, 0, 0xd0c0b0c);
  apb_ctrl_wr_cmd(0x1e8, 31, 0, 0xd0c0d0c);
  apb_ctrl_wr_cmd(0x1e8, 31, 0, 0xd0e0d0c);
  apb_ctrl_wr_cmd(0x1e8, 31, 0, 0xf0e0d0c);
  apb_ctrl_wr_cmd(0x1ec, 31, 0, 0x11100f10);
  apb_ctrl_wr_cmd(0x1ec, 31, 0, 0x11101110);
  apb_ctrl_wr_cmd(0x1ec, 31, 0, 0x11121110);
  apb_ctrl_wr_cmd(0x1ec, 31, 0, 0x13121110);
  apb_ctrl_wr_cmd(0x1f0, 31, 0, 0x15141314);
  apb_ctrl_wr_cmd(0x1f0, 31, 0, 0x15141514);
  apb_ctrl_wr_cmd(0x1f0, 31, 0, 0x15161514);
  apb_ctrl_wr_cmd(0x1f0, 31, 0, 0x17161514);
  apb_ctrl_wr_cmd(0x1f4, 31, 0, 0x19181718);
  apb_ctrl_wr_cmd(0x1f4, 31, 0, 0x19181918);
  apb_ctrl_wr_cmd(0x1f4, 31, 0, 0x191a1918);
  apb_ctrl_wr_cmd(0x1f4, 31, 0, 0x1b1a1918);
  apb_ctrl_wr_cmd(0x1f8, 31, 0, 0x0);
  apb_ctrl_wr_cmd(0x1f8, 31, 0, 0x0);
  apb_ctrl_wr_cmd(0x1fc, 31, 0, 0x1c1b0b);
  apb_ctrl_wr_cmd(0x1fc, 31, 0, 0x1c1c0b);
  apb_ctrl_wr_cmd(0x1fc, 31, 0, 0x31c0b);
  apb_ctrl_wr_cmd(0x1fc, 31, 0, 0x1d031c0b);
  apb_ctrl_wr_cmd(0x200, 31, 0, 0x1e1e);
  apb_ctrl_wr_cmd(0x200, 31, 0, 0x1e);
  apb_ctrl_wr_cmd(0xd0, 31, 0, 0x2);
  apb_ctrl_wr_cmd(0xd0, 31, 0, 0x0);
  apb_ctrl_wr_cmd(0x18, 31, 0, 0xf0f0f);
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804484);
  apb_ctrl_wr_cmd(0x20c, 31, 0, 0x1);
  apb_ctrl_wr_cmd(0x20c, 31, 0, 0x601);
  apb_ctrl_wr_cmd(0xb0, 31, 0, 0x12321232);
  apb_ctrl_wr_cmd(0xb4, 31, 0, 0x12321232);
  apb_ctrl_wr_cmd(0xb8, 31, 0, 0x12321232);
  apb_ctrl_wr_cmd(0xbc, 31, 0, 0x12321232);
  apb_ctrl_wr_cmd(0xb0, 31, 0, 0x12321232);
  apb_ctrl_wr_cmd(0xb4, 31, 0, 0x12321232);
  apb_ctrl_wr_cmd(0xb8, 31, 0, 0x12321232);
  apb_ctrl_wr_cmd(0xbc, 31, 0, 0x12321232);
  apb_ctrl_wr_cmd(0x58, 31, 0, 0xff050007);
  apb_ctrl_wr_cmd(0x58, 31, 0, 0xff050003);
  apb_ctrl_wr_cmd(0x214, 31, 0, 0x40f);
  apb_ctrl_wr_cmd(0x218, 31, 0, 0x4000000);
  apb_ctrl_wr_cmd(0x218, 31, 0, 0x4000000);
  apb_ctrl_wr_cmd(0x21c, 31, 0, 0x900000);
  apb_ctrl_wr_cmd(0x21c, 31, 0, 0x900501);
  apb_ctrl_wr_cmd(0x220, 31, 0, 0x31c0000);
  apb_ctrl_wr_cmd(0x214, 31, 0, 0x40f);
  apb_ctrl_wr_cmd(0x34, 31, 0, 0x6830000f);
  apb_ctrl_wr_cmd(0x34, 31, 0, 0x6830edf5);
  apb_ctrl_wr_cmd(0x38, 31, 0, 0xf6d43);
  apb_ctrl_wr_cmd(0x38, 31, 0, 0x1a696d43);
  apb_ctrl_wr_cmd(0x3c, 31, 0, 0xf384a);
  apb_ctrl_wr_cmd(0x3c, 31, 0, 0xf3d7384a);
  apb_ctrl_wr_cmd(0x4, 31, 0, 0xd000f);
  apb_ctrl_wr_cmd(0x4, 31, 0, 0xd000c);
  apb_ctrl_wr_cmd(0x8, 31, 0, 0x29c2);
  apb_ctrl_wr_cmd(0xc, 31, 0, 0xf001c);
  apb_ctrl_wr_cmd(0xc, 31, 0, 0x26001c);
  apb_ctrl_wr_cmd(0x10, 31, 0, 0xf0006);
  apb_ctrl_wr_cmd(0x10, 31, 0, 0x60006);
  apb_ctrl_wr_cmd(0x14, 31, 0, 0xf0d0f0f);
  apb_ctrl_wr_cmd(0x14, 31, 0, 0xf0d020f);
  apb_ctrl_wr_cmd(0x14, 31, 0, 0xf0d0206);
  apb_ctrl_wr_cmd(0x18, 31, 0, 0x60f0f);
  apb_ctrl_wr_cmd(0x18, 31, 0, 0x6040f);
  apb_ctrl_wr_cmd(0x18, 31, 0, 0x60406);
  apb_ctrl_wr_cmd(0x14, 31, 0, 0x120d0206);
  apb_ctrl_wr_cmd(0x24, 31, 0, 0x7050000);
  apb_ctrl_wr_cmd(0x2c, 31, 0, 0x5000005);
  apb_ctrl_wr_cmd(0x30, 31, 0, 0x2570200);
  apb_ctrl_wr_cmd(0x30, 31, 0, 0x2570200);
  apb_ctrl_wr_cmd(0x20, 31, 0, 0x37407f);
  apb_ctrl_wr_cmd(0x20, 31, 0, 0x374060);
  apb_ctrl_wr_cmd(0x2c, 31, 0, 0xd000005);
  apb_ctrl_wr_cmd(0x24, 31, 0, 0x7000000);
  apb_ctrl_wr_cmd(0x2c, 31, 0, 0xd000005);
  apb_ctrl_wr_cmd(0x44, 31, 0, 0xe800);
  apb_ctrl_wr_cmd(0x40, 31, 0, 0xff000000);
  apb_ctrl_wr_cmd(0x40, 31, 0, 0xff062000);
  apb_ctrl_wr_cmd(0x40, 31, 0, 0xff062200);
  apb_ctrl_wr_cmd(0x44, 31, 0, 0xc00e800);
  apb_ctrl_wr_cmd(0x44, 31, 0, 0xc00e80c);
  apb_ctrl_wr_cmd(0x28, 31, 0, 0x20040c01);
  apb_ctrl_wr_cmd(0x1c, 31, 0, 0x8000000);
  apb_ctrl_wr_cmd(0x1c, 31, 0, 0x8000c00);
  apb_ctrl_wr_cmd(0x1c, 31, 0, 0x81e0c00);
  apb_ctrl_wr_cmd(0x1c, 31, 0, 0x81e0c04);
  apb_ctrl_wr_cmd(0x20, 31, 0, 0x1f374060);
  apb_ctrl_wr_cmd(0x2c, 31, 0, 0xd000c05);
  apb_ctrl_wr_cmd(0x28, 31, 0, 0x20040c0c);
  apb_ctrl_wr_cmd(0x20, 31, 0, 0x1f374060);
  apb_ctrl_wr_cmd(0x24, 31, 0, 0x70000e0);
  apb_ctrl_wr_cmd(0x210, 31, 0, 0x31f02);
  apb_ctrl_wr_cmd(0x210, 31, 0, 0x21f02);
  
  if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR0) {
    LISOC_RCC->RCC_DPBLKRSTR.DDR0CORERST = 0x0;
    LISOC_RCC->RCC_DPBLKRSTR.DDR0PHYRST = 0x0;
  }
  if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR1) {
    LISOC_RCC->RCC_DPBLKRSTR.DDR1CORERST = 0x0;
    LISOC_RCC->RCC_DPBLKRSTR.DDR1PHYRST = 0x0;
  }

  apb_wr_cmd(0x84, 31, 0, 0x3596f);
  
  //------------------------PHY INITIAL START------------------------------.
  
  //---------------------PHY BASIC CONFIG START----------------------------.
  //Configure the DQ WIDTH, DQ32 para3[3:0] = 4'b1111, DQ16 para3[3:0] = 4'b0011
  apb_wr_cmd(0x0, 31, 0, 0xf87);
  
  //-----------------SET CWL OF PHY------------------
  //para3[7:0], Configure the CWL = 8h'0b at frequency point0
  apb_wr_cmd(0x10, 31, 0, 0xb000000);
  //---------------SET CWL OF PHY END----------------
  
  //-----------------SET CL OF PHY-------------------
  //para3[7:0], Configure the CL = 8h'0c at frequency point0
  apb_wr_cmd(0xc, 31, 0, 0xc060606);
  
  //-----------------SET AL OF PHY-------------------
  //para3[7:0], Configure the AL = 8h'00 at frequency point0
  apb_wr_cmd(0x8, 31, 0, 0x0);
  apb_wr_cmd(0xa8, 31, 0, 0x2581ba80);
  apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
  
  //CHOOSE MEM TYPE, para3[2:0], DDR2 = 3'b000, LPDDR2 = 3'b001, DDR3=3'b010, LPDDR3=3'b011, DDR4=3'b100, LPDDR4=3'b101
  apb_wr_cmd(0x0, 31, 0, 0xfc7);
  
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804494);


  //Wait the phy initial complete
  read_data = 0;
  while(read_data == 0){
    apb_ctrl_rd_cmd(phy_init_complete_to_reg,&read_data);
    //printf("phy_init:read_data %x\n",read_data);
  }
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804484);
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x780448c);

  read_data = 0;
  while(read_data == 0){
    apb_ctrl_rd_cmd(sdram_init_done_to_reg,&read_data);
    //printf("sdram_init:read_data %x\n",read_data);
  }
  //the sdram initial complete
  apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804484);

  //++++++++++++++++++Write Leveling Start+++++++++++++++++++++++++++.
  //The related registers hold default value
  apb_wr_cmd(0xa0, 31, 0, 0x400100);
  apb_wr_cmd(0x4, 31, 0, 0x88);
  apb_wr_cmd(0x4, 31, 0, 0x41010088);
  apb_wr_cmd(0x4, 31, 0, 0x41010098);
  read_data=0;
  while(read_data != 0xf) {
    apb_rd_cmd(wl_done_byte,&read_data);
    //printf("wl_done_byte:read_data %x\n",read_data);
    delay_us(10);
  }

  apb_wr_cmd(0x4, 31, 0, 0x41010088);
  apb_wr_cmd(0x4, 31, 0, 0x41010008);
  
  //++++++++++++++++++Write Leveling End+++++++++++++++++++++++++++++.

  //++++++++++++++++++RX DQS Gating Start+++++++++++++++++++++++++++.
#if 1
  //The related registers hold default value
  apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
  apb_wr_cmd(0x44, 31, 0, 0x1300120); //MPR mode
  //apb_wr_cmd(0x300, 31, 0, 0x800800a0);
  //apb_wr_cmd(0x480, 31, 0, 0x800800a0);
  //apb_wr_cmd(0x600, 31, 0, 0x800800a0);
  //apb_wr_cmd(0x780, 31, 0, 0x800800a0);
  apb_wr_cmd(0x4, 31, 0, 0x41010008);
  apb_wr_cmd(0x4, 31, 0, 0x41010009);

  read_data=0;
  while (read_data != 1){
    apb_rd_cmd(calib_end, &read_data);
    //printf("calib_end:read_data %x\n",read_data);
  }
  read_data=0;
  while (read_data != 0xf) {
    apb_rd_cmd(calib_done_byte, &read_data);
    //printf("calib_done:read_data %x\n",read_data);
  }

  apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
  apb_wr_cmd(0x4, 31, 0, 0x41010008);
  apb_wr_cmd(0x4, 31, 0, 0x41010000);

#endif
  
  //++++++++++++++++++RX DQS Gating End++++++++++++++++++++++++++++++.
#if 1
  //++++++++++++++++++Read Training Start++++++++++++++++++++++++++++++.
  //The related registers hold default value

  //////dq0 dq1 dq2 dq3 dq4 dq5 dq6 dq7 dq8 dq9 dq10 dq11 dq12 dq13 dq14 dq15 
  //wrap  0  1   2   3   0   1   2   3    0   1  2    3     0    1   2     3
  if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR0) {
    
    apb_wr_cmd(reg_a_l_rdtrain_check_wrap0,0x7d);// 0b0111 1101) ;//dq5 dq7 dq3 dq1
    apb_wr_cmd(reg_a_l_rdtrain_check_wrap1,0x22);// 0b0010 0010) ;// 2 0 6 4 
    apb_wr_cmd(reg_a_h_rdtrain_check_wrap0,0xd7);// 0b1101 0111) ;// 7 1 5 3
    apb_wr_cmd(reg_a_h_rdtrain_check_wrap1,0x22);// 0b0010 0010) ;// 6 0 2 4
    
    apb_wr_cmd(reg_b_l_rdtrain_check_wrap0,0x7d);// 0b01111101) ;//5 7 3 1
    apb_wr_cmd(reg_b_l_rdtrain_check_wrap1,0x22);// 0b00100010) ;//2 0 6 4
    apb_wr_cmd(reg_b_h_rdtrain_check_wrap0,0xd7);// 0b11010111) ;//7 1 5 3
    apb_wr_cmd(reg_b_h_rdtrain_check_wrap1,0x22);// 0b00100010) ;//6 0 2 4
    
    apb_wr_cmd(reg_rd_train_check_value_en,0x01);
  }else if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR1) {
    apb_wr_cmd(reg_a_l_rdtrain_check_wrap0,0x22);// 6 0 2 4  0010 0010
    apb_wr_cmd(reg_a_l_rdtrain_check_wrap1,0xDD);// 1 3 5 7  1101 1101
    apb_wr_cmd(reg_a_h_rdtrain_check_wrap0,0xA0);// 0 4 6 2  1010 0000
    apb_wr_cmd(reg_a_h_rdtrain_check_wrap1,0xD7);// 3 1 5 7  1101 0111
    
    apb_wr_cmd(reg_b_l_rdtrain_check_wrap0,0x22);// 6 0 2 4
    apb_wr_cmd(reg_b_l_rdtrain_check_wrap1,0xDD);// 1 3 5 7
    apb_wr_cmd(reg_b_h_rdtrain_check_wrap0,0xA0);// 0 4 6 2
    apb_wr_cmd(reg_b_h_rdtrain_check_wrap1,0xD7);// 3 1 5 7
    
    apb_wr_cmd(reg_rd_train_check_value_en,0x01);
  }
  apb_wr_cmd(0xa8, 31, 0, 0x3081ba81);

  apb_wr_cmd(0x94, 31, 0, 0x3fc200|0x8);//add by tancc 
  apb_wr_cmd(0x3a0, 31, 0, 0x1f073f00);
  apb_wr_cmd(0x520, 31, 0, 0x1f073f00);
  apb_wr_cmd(0x6a0, 31, 0, 0x1f073f00);
  apb_wr_cmd(0x820, 31, 0, 0x1f073f00);
  apb_wr_cmd(0x94, 31, 0, 0x3fc201|0x8);//add by tancc 
  //For read training, the phy will wait for the controller send at least one auto-refresh command.;
  read_data=0;
  while (read_data != 0x1) {
    apb_rd_cmd(train_true_done, &read_data);
    //printf("train_true_done:read_data %x\n",read_data);
    delay_us(10);
  }
  apb_wr_cmd(0x94, 31, 0, 0x3fc200|0x8);//add by tancc 
  apb_wr_cmd(0x94, 31, 0, 0x3fc200|0x8);//add by tancc 
  apb_wr_cmd(0x94, 31, 0, 0x3fc000|0x8);//add by tancc 
  apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);

  //++++++++++++++++++Read Training End+++++++++++++++++++++++++++++++.

  //++++++++++++++++++Write Training Start++++++++++++++++++++++++++++++.
  //The related registers hold default value
  apb_wr_cmd(0xa0, 31, 0, 0x400100);
  apb_wr_cmd(0xa0, 31, 0, 0x400180);

  apb_wr_cmd(0xa8, 31, 0, 0x3081ba81);

  apb_wr_cmd(0xa0, 31, 0, 0x400180);
  apb_wr_cmd(0xa0, 31, 0, 0x400181);
  apb_wr_cmd(0xa0, 31, 0, 0x400183);
  //For Write Training that the Controller needs to send the auto-refresh at least one time.
  read_data=0;
  while (read_data != 0x1) {
    apb_rd_cmd(train_step1_delay_done, &read_data);
    //printf("train_step1_delay_done:read_data %x\n",read_data);
    delay_us(10);
  }
  read_data=0;
  while (read_data != 0x1) {
    apb_rd_cmd(train_all_step_done, &read_data);
    //printf("train_all_step_done:read_data %x\n",read_data);
    delay_us(10);
  }
  delay_us(10);

  apb_wr_cmd(0xa0, 31, 0, 0x400181);
  apb_wr_cmd(0xa0, 31, 0, 0x400181);
  apb_wr_cmd(0xa0, 31, 0, 0x400101);
  apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
  
  //++++++++++++++++++Write Training End+++++++++++++++++++++++++++++++.
#endif

  //tr_test(ddr_ctrl_base_addr,ddr_phy_base_addr);

}

void init_ddr_sim(uint32_t ctl_base_addr, uint32_t phy_base_addr) {
    volatile uint32_t read_data;
    ddr_ctrl_base_addr = ctl_base_addr;
    ddr_phy_base_addr = phy_base_addr;
    if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR0) {
      LISOC_RCC->RCC_DPBLKRSTR.DDR0CORERST = 0x1;
      LISOC_RCC->RCC_DPBLKRSTR.DDR0PHYRST = 0x1;
    }
    if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR1) {
      LISOC_RCC->RCC_DPBLKRSTR.DDR1CORERST = 0x1;
      LISOC_RCC->RCC_DPBLKRSTR.DDR1PHYRST = 0x1;
    }

    apb_ctrl_wr_cmd(0x208, 31, 0, 0xf);
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7f804480);
    apb_ctrl_wr_cmd(0x20c, 31, 0, 0x1);
    apb_ctrl_wr_cmd(0x20c, 31, 0, 0x1);
    apb_ctrl_wr_cmd(0xa0, 31, 0, 0x0);
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7f804480);
    apb_ctrl_wr_cmd(0xdc, 31, 0, 0x80700);
    apb_ctrl_wr_cmd(0xdc, 31, 0, 0x90700);
    apb_ctrl_wr_cmd(0xdc, 31, 0, 0x90b00);
    apb_ctrl_wr_cmd(0xdc, 31, 0, 0x9090b00);
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7f804480);
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7f804480);
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804480);
    apb_ctrl_wr_cmd(0x1d8, 31, 0, 0x48fa);
    apb_ctrl_wr_cmd(0x1d8, 31, 0, 0x48fa);
    apb_ctrl_wr_cmd(0x1d8, 31, 0, 0x490a);
    apb_ctrl_wr_cmd(0x1d8, 31, 0, 0x490a);
    apb_ctrl_wr_cmd(0x1dc, 31, 0, 0x3020100);
    apb_ctrl_wr_cmd(0x1dc, 31, 0, 0x3020100);
    apb_ctrl_wr_cmd(0x1dc, 31, 0, 0x3020100);
    apb_ctrl_wr_cmd(0x1dc, 31, 0, 0x4020100);
    apb_ctrl_wr_cmd(0x1e0, 31, 0, 0x7060505);
    apb_ctrl_wr_cmd(0x1e0, 31, 0, 0x7060605);
    apb_ctrl_wr_cmd(0x1e0, 31, 0, 0x7070605);
    apb_ctrl_wr_cmd(0x1e0, 31, 0, 0x8070605);
    apb_ctrl_wr_cmd(0x1e4, 31, 0, 0x909);
    apb_ctrl_wr_cmd(0x1e4, 31, 0, 0xa09);
    apb_ctrl_wr_cmd(0x1e4, 31, 0, 0xa09);
    apb_ctrl_wr_cmd(0x1e4, 31, 0, 0xa09);
    apb_ctrl_wr_cmd(0x1e8, 31, 0, 0xd0c0b0c);
    apb_ctrl_wr_cmd(0x1e8, 31, 0, 0xd0c0d0c);
    apb_ctrl_wr_cmd(0x1e8, 31, 0, 0xd0e0d0c);
    apb_ctrl_wr_cmd(0x1e8, 31, 0, 0xf0e0d0c);
    apb_ctrl_wr_cmd(0x1ec, 31, 0, 0x11100f10);
    apb_ctrl_wr_cmd(0x1ec, 31, 0, 0x11101110);
    apb_ctrl_wr_cmd(0x1ec, 31, 0, 0x11121110);
    apb_ctrl_wr_cmd(0x1ec, 31, 0, 0x13121110);
    apb_ctrl_wr_cmd(0x1f0, 31, 0, 0x15141314);
    apb_ctrl_wr_cmd(0x1f0, 31, 0, 0x15141514);
    apb_ctrl_wr_cmd(0x1f0, 31, 0, 0x15161514);
    apb_ctrl_wr_cmd(0x1f0, 31, 0, 0x17161514);
    apb_ctrl_wr_cmd(0x1f4, 31, 0, 0x19181718);
    apb_ctrl_wr_cmd(0x1f4, 31, 0, 0x19181918);
    apb_ctrl_wr_cmd(0x1f4, 31, 0, 0x191a1918);
    apb_ctrl_wr_cmd(0x1f4, 31, 0, 0x1b1a1918);
    apb_ctrl_wr_cmd(0x1f8, 31, 0, 0x0);
    apb_ctrl_wr_cmd(0x1f8, 31, 0, 0x0);
    apb_ctrl_wr_cmd(0x1fc, 31, 0, 0x1c1b0b);
    apb_ctrl_wr_cmd(0x1fc, 31, 0, 0x1c1c0b);
    apb_ctrl_wr_cmd(0x1fc, 31, 0, 0x31c0b);
    apb_ctrl_wr_cmd(0x1fc, 31, 0, 0x1d031c0b);
    apb_ctrl_wr_cmd(0x200, 31, 0, 0x1e1e);
    apb_ctrl_wr_cmd(0x200, 31, 0, 0x1e);
    apb_ctrl_wr_cmd(0xd0, 31, 0, 0x2);
    apb_ctrl_wr_cmd(0xd0, 31, 0, 0x2);
    apb_ctrl_wr_cmd(0x18, 31, 0, 0xf0f0f);
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804484);
    apb_ctrl_wr_cmd(0x20c, 31, 0, 0x1);
    apb_ctrl_wr_cmd(0x20c, 31, 0, 0x601);
    apb_ctrl_wr_cmd(0xb0, 31, 0, 0x12321232);
    apb_ctrl_wr_cmd(0xb4, 31, 0, 0x12321232);
    apb_ctrl_wr_cmd(0xb8, 31, 0, 0x12321232);
    apb_ctrl_wr_cmd(0xbc, 31, 0, 0x12321232);
    apb_ctrl_wr_cmd(0xb0, 31, 0, 0x12321232);
    apb_ctrl_wr_cmd(0xb4, 31, 0, 0x12321232);
    apb_ctrl_wr_cmd(0xb8, 31, 0, 0x12321232);
    apb_ctrl_wr_cmd(0xbc, 31, 0, 0x12321232);
    apb_ctrl_wr_cmd(0x58, 31, 0, 0xff050007);
    apb_ctrl_wr_cmd(0x58, 31, 0, 0xff050003);
    apb_ctrl_wr_cmd(0x214, 31, 0, 0x40f);
    apb_ctrl_wr_cmd(0x218, 31, 0, 0x4000000);
    apb_ctrl_wr_cmd(0x218, 31, 0, 0x4000000);
    apb_ctrl_wr_cmd(0x21c, 31, 0, 0x800000);
    apb_ctrl_wr_cmd(0x21c, 31, 0, 0x800511);
    apb_ctrl_wr_cmd(0x220, 31, 0, 0x3180000);
    apb_ctrl_wr_cmd(0x214, 31, 0, 0x40f);
    apb_ctrl_wr_cmd(0x34, 31, 0, 0xdf38000f);
    apb_ctrl_wr_cmd(0x34, 31, 0, 0xdf38b82a);
    apb_ctrl_wr_cmd(0x38, 31, 0, 0xf8aec);
    apb_ctrl_wr_cmd(0x38, 31, 0, 0x98498aec);
    apb_ctrl_wr_cmd(0x3c, 31, 0, 0xf6cd8);
    apb_ctrl_wr_cmd(0x3c, 31, 0, 0xdf896cd8);
    apb_ctrl_wr_cmd(0x4, 31, 0, 0xd000f);
    apb_ctrl_wr_cmd(0x4, 31, 0, 0xd000c);
    apb_ctrl_wr_cmd(0x8, 31, 0, 0x3d1d);
    apb_ctrl_wr_cmd(0xc, 31, 0, 0xf001c);
    apb_ctrl_wr_cmd(0xc, 31, 0, 0x26001c);
    apb_ctrl_wr_cmd(0x10, 31, 0, 0xf0006);
    apb_ctrl_wr_cmd(0x10, 31, 0, 0x60006);
    apb_ctrl_wr_cmd(0x14, 31, 0, 0xf0d0f0f);
    apb_ctrl_wr_cmd(0x14, 31, 0, 0xf0d020f);
    apb_ctrl_wr_cmd(0x14, 31, 0, 0xf0d0206);
    apb_ctrl_wr_cmd(0x18, 31, 0, 0x60f0f);
    apb_ctrl_wr_cmd(0x18, 31, 0, 0x6040f);
    apb_ctrl_wr_cmd(0x18, 31, 0, 0x60406);
    apb_ctrl_wr_cmd(0x14, 31, 0, 0x120d0206);
    apb_ctrl_wr_cmd(0x24, 31, 0, 0x7050000);
    apb_ctrl_wr_cmd(0x2c, 31, 0, 0x5000005);
    apb_ctrl_wr_cmd(0x30, 31, 0, 0x2570200);
    apb_ctrl_wr_cmd(0x30, 31, 0, 0x2570200);
    apb_ctrl_wr_cmd(0x20, 31, 0, 0x37407f);
    apb_ctrl_wr_cmd(0x20, 31, 0, 0x374060);
    apb_ctrl_wr_cmd(0x2c, 31, 0, 0x3000005);
    apb_ctrl_wr_cmd(0x24, 31, 0, 0x7000000);
    apb_ctrl_wr_cmd(0x2c, 31, 0, 0x3000005);
    apb_ctrl_wr_cmd(0x44, 31, 0, 0xd000);
    apb_ctrl_wr_cmd(0x40, 31, 0, 0x0);
    apb_ctrl_wr_cmd(0x40, 31, 0, 0x0);
    apb_ctrl_wr_cmd(0x40, 31, 0, 0x1);
    apb_ctrl_wr_cmd(0x44, 31, 0, 0x100d000);
    apb_ctrl_wr_cmd(0x44, 31, 0, 0x100d001);
    apb_ctrl_wr_cmd(0x28, 31, 0, 0x20040c01);
    apb_ctrl_wr_cmd(0x1c, 31, 0, 0x8000000);
    apb_ctrl_wr_cmd(0x1c, 31, 0, 0x8000c00);
    apb_ctrl_wr_cmd(0x1c, 31, 0, 0x81e0c00);
    apb_ctrl_wr_cmd(0x1c, 31, 0, 0x81e0c04);
    apb_ctrl_wr_cmd(0x20, 31, 0, 0x1f374060);
    apb_ctrl_wr_cmd(0x2c, 31, 0, 0x3000c05);
    apb_ctrl_wr_cmd(0x28, 31, 0, 0x20040c0c);
    apb_ctrl_wr_cmd(0x20, 31, 0, 0x1f374060);
    apb_ctrl_wr_cmd(0x24, 31, 0, 0x70000e0);
    apb_ctrl_wr_cmd(0x210, 31, 0, 0x31f02);
    apb_ctrl_wr_cmd(0x210, 31, 0, 0x31f02);


    if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR0) {
      LISOC_RCC->RCC_DPBLKRSTR.DDR0CORERST = 0x0;
      LISOC_RCC->RCC_DPBLKRSTR.DDR0PHYRST = 0x0;
    }
    if(ddr_ctrl_base_addr == DDR_CTRL_BASE_ADDR1) {
      LISOC_RCC->RCC_DPBLKRSTR.DDR1CORERST = 0x0;
      LISOC_RCC->RCC_DPBLKRSTR.DDR1PHYRST = 0x0;
    }

    
    apb_wr_cmd(0x84, 31, 0, 0x3596f);
    //------------------------PHY INITIAL START------------------------------.
    
    //---------------------PHY BASIC CONFIG START----------------------------.
    //Configure the DQ WIDTH, DQ32 para3[3:0] = 4'b1111, DQ16 para3[3:0] = 4'b0011
    apb_wr_cmd(0x0, 31, 0, 0xf87);
    
    //-----------------SET CWL OF PHY------------------
    //para3[7:0], Configure the CWL = 8h'09 at frequency point0
    apb_wr_cmd(0x10, 31, 0, 0x9000000);
    //---------------SET CWL OF PHY END----------------
    
    //-----------------SET CL OF PHY-------------------
    //para3[7:0], Configure the CL = 8h'0b at frequency point0
    apb_wr_cmd(0xc, 31, 0, 0xb060606);
    
    //-----------------SET AL OF PHY-------------------
    //para3[7:0], Configure the AL = 8h'09 at frequency point0
    apb_wr_cmd(0x8, 31, 0, 0x9000000);
    apb_wr_cmd(0xa8, 31, 0, 0x2581ba80);
    apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
    
    //CHOOSE MEM TYPE, para3[2:0], DDR2 = 3'b000, LPDDR2 = 3'b001, DDR3=3'b010, LPDDR3=3'b011, DDR4=3'b100, LPDDR4=3'b101
    apb_wr_cmd(0x0, 31, 0, 0xfc7);
    
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804494);
    //Wait the phy initial complete
    read_data = 0;
    while( (read_data&0x1) == 0){
        apb_ctrl_rd_cmd(phy_init_complete_to_reg,&read_data);
    }
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804484);
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x780448c);
    read_data = 0;
    while(((read_data>>1) & 0x1) == 0) {
        apb_ctrl_rd_cmd(sdram_init_done_to_reg,&read_data);
    }
    //the sdram initial complete
    apb_ctrl_wr_cmd(0x0, 31, 0, 0x7804484);
    
    //++++++++++++++++++RX DQS Gating Start+++++++++++++++++++++++++++.
    //The related registers hold default value
    apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
    apb_wr_cmd(0x44, 31, 0, 0x300120);
    apb_wr_cmd(0x300, 31, 0, 0x800800a0);
    apb_wr_cmd(0x480, 31, 0, 0x800800a0);
    apb_wr_cmd(0x600, 31, 0, 0x800800a0);
    apb_wr_cmd(0x780, 31, 0, 0x800800a0);
    apb_wr_cmd(0x4, 31, 0, 0x88);
    apb_wr_cmd(0x4, 31, 0, 0x89);
    read_data=0;
    while (((read_data>>5) & 0x1) != 1){
        apb_rd_cmd(calib_end, &read_data);
    }
    read_data=0;
    while ((read_data & 0xf) != 0xf) {
        apb_rd_cmd(calib_done_byte, &read_data);
    }
    apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
    apb_wr_cmd(0x4, 31, 0, 0x88);
    apb_wr_cmd(0x4, 31, 0, 0x80);
    apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
    apb_wr_cmd(0x44, 31, 0, 0x300120);
    apb_wr_cmd(0x300, 31, 0, 0x800800a0);
    apb_wr_cmd(0x480, 31, 0, 0x800800a0);
    apb_wr_cmd(0x600, 31, 0, 0x800800a0);
    apb_wr_cmd(0x780, 31, 0, 0x800800a0);
    apb_wr_cmd(0x4, 31, 0, 0x84);
    apb_wr_cmd(0x4, 31, 0, 0x85);
    read_data=0;
    while (((read_data>>5) & 0x1) != 1) {
        apb_rd_cmd(calib_end, &read_data);
    }
    read_data=0;
    while ((read_data & 0xf) != 0xf) {
        apb_rd_cmd(calib_done_byte, &read_data);
    }
    apb_wr_cmd(0xa8, 31, 0, 0x3081ba80);
    apb_wr_cmd(0x4, 31, 0, 0x84);
    apb_wr_cmd(0x4, 31, 0, 0x80);
}

