/*!
    \file    syscfg.c
    \brief   the syscfg configuration file

*/

#include "lisoc_test.h"
#include "syscfg.h"

/*!
    \brief      SYSC_AF_SET
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SYSC_GPIOA_AF_SET(uint8_t alt_func_num,uint32_t pin)
{
  if(alt_func_num)
    LISOC_SYSCFG->GPIOA_AFR_W |= pin;
  else
    LISOC_SYSCFG->GPIOA_AFR_W &= ~pin;
}

void SYSC_GPIOB_AF_SET(uint8_t alt_func_num,uint32_t pin)
{
  if(alt_func_num)
    LISOC_SYSCFG->GPIOB_AFR_W |= pin;
  else
    LISOC_SYSCFG->GPIOB_AFR_W &= ~pin;
}


