/*
 * AXMIspConfig.cpp
 */

#include "AXConfig.hpp"
#include "AXFLog.hpp"
#include "AXFStage.hpp"

#include "AXMIspConfig.hpp"
#include "AXMCommon/AXMCommonConfig.hpp"
#ifdef BB_TMP_PASS	/* 一旦コンパイルを通す用 */
#include "../../AXM/AXMPixcessor/AXMPixcessor.hpp"
#include "../../AXM/AXMPixcessor/AXMPixcessorInt/AXMPixcessorInt.hpp"
#include "../../AXM/AXMIsp/AXMIsp.hpp"
//#include "../../AXM/AXMIspAf/AXMIspAf.hpp"
#include "../../AXM/AXMIspAe/AXMIspAe.hpp"
#include "../../AXM/AXMIspAwb/AXMIspAwb.hpp"
#include "../../AXM/AXMIspAssist/AXMIspAssist.hpp"
#include "../../AXM/AXMIspAdjust/AXMIspAdjust.hpp"
#include "../../AXM/AXM/AXModelStage.hpp"
#include "../../AXM/AXMCommon/AXMCommonStruct.hpp"
#include "../../AXM/AXMImageSensor/AXMImageSensor.hpp"
//#include "../../AXM/AXMImageSensor/AXMImageSensorDrvState.hpp"
#else
#include "../../classes/AXMPixcessor/AXMPixcessor.hpp"
#include "../../classes/AXMPixcessor/AXMPixcessorInt/AXMPixcessorInt.hpp"
#include "../../classes/AXMIsp/AXMIsp.hpp"
//#include "../../classes/AXMIspAf/AXMIspAf.hpp"
#include "../../classes/AXMIspAe/AXMIspAe.hpp"
#include "../../classes/AXMIspAwb/AXMIspAwb.hpp"
#include "../../classes/AXMIspAssist/AXMIspAssist.hpp"
#include "../../classes/AXMIspAdjust/AXMIspAdjust.hpp"
#include "../../classes/AXM/AXModelStage.hpp"
#include "../../classes/AXMCommon/AXMCommonStruct.hpp"
#include "../../classes/AXMImageSensor/AXMImageSensor.hpp"
//#include "../../classes/AXMImageSensor/AXMImageSensorDrvState.hpp"
#endif

#include <vector>

/*
 * ispStage AXFLog出力 デフォルト設定
 */
bool AXFLog::isEnable = true;

/*
 * ispStage AXFLog出力レベル デフォルト設定
 */
//AXFLOG_LEVEL AXFLog::m_level = AXFLOG_WARN;
AXFLOG_LEVEL AXFLog::m_level = AXFLOG_DEBUG;

/*
 * ispStage AXFLog転送 デフォルト設定
 */
bool AXFLog::isTrans = false;

/*
 * AXFLogTask リード・ライト指定
 */
AXFStage::logRW AXFStage::isRW = AXFStage::LOG_WRITE;

/*
 * ispStage アクタ名オブジェクト定義
 */
const std::string stageName("ispStage");
const std::string ispName("isp");
const std::string afName("af");
const std::string aeName("ae");
const std::string awbName("awb");
const std::string assistName("assist");
const std::string adjustName("adjust");
const std::string correctName("correct");
#ifdef USE_AXFTEST_COMMAND
const std::string axtestName("axtest");
const std::string axtestName2("axtest2");
const std::string axtestName3("axtest3");
const std::string axtestName4("axtest4");
#endif /* USE_AXFTEST_COMMAND */

AXFObjectName nameStage(stageName, stageName);
AXFObjectName nameDaemon(stageName, "axdaemon");
AXFObjectName namePixessor("pixcessor", stageName);
AXFObjectName namePixessorInt("pixcsrInt", stageName);
AXFObjectName nameImageSensor("imagesensor", stageName);
AXFObjectName nameImageSensorDrv("imagesensorDrv", stageName);

AXFObjectName nameIsp(ispName, stageName);
AXFObjectName nameIspAf(afName, stageName);
AXFObjectName nameIspAe(aeName, stageName);
AXFObjectName nameIspAwb(awbName, stageName);
AXFObjectName nameIspAssist(assistName, stageName);
AXFObjectName nameIspAdjust(adjustName, stageName);
AXFObjectName nameIspCorrect(correctName, stageName);

#ifdef USE_AXFTEST_COMMAND
AXFObjectName nameAXTest(axtestName, stageName);
AXFObjectName nameAXTest2(axtestName2, stageName);
AXFObjectName nameAXTest3(axtestName3, stageName);
AXFObjectName nameAXTest4(axtestName4, stageName);
#endif /* USE_AXFTEST_COMMAND */

/* ispStage AX Stage名取得メソッド */
static AXFObjectName& getIspStageNameObject() {
  return nameStage;
}

/* ispStage AXリソース情報設定メソッド */
static bool setIspResourceInfo(
    std::vector<AXFStageResourceInfo>& resourceInfo) {
  // 1. Actorリソース管理情報を作成する
  AXFStageResourceInfo tmpResource;

  //    1.1. AXMPixcessor
  tmpResource.name = namePixessor;
  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_6; /* アクタ優先度(用途に合して編集してください) */
#else   //  ENABLE_OPD_CONFIG_ISP_TO_AXH
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_5; /* アクタ優先度(用途に合して編集してください) */
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
  tmpResource.actorStackSize = (8 * 1024); /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);
  //    1.1.1. AXMPixcessorInt
  tmpResource.name = namePixessorInt;
  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_6; /* アクタ優先度(用途に合して編集してください) */
  tmpResource.actorStackSize = (8 * 1024); /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);

  //    1.2. AXMIsp
  tmpResource.name = nameIsp;
  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
#ifndef ENABLE_OPD_CONFIG_ISP_TO_AXH
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_5; /* アクタ優先度(用途に合して編集してください) */
#else   //  ENABLE_OPD_CONFIG_ISP_TO_AXH
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_6; /* アクタ優先度(用途に合して編集してください) */
#endif  //  ENABLE_OPD_CONFIG_ISP_TO_AXH
  tmpResource.actorStackSize = (3 * 1024); /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);

//  //    1.3. AXMIspAf
//  tmpResource.name = nameIspAf;
//  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
//  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
//  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_1; /* アクタ優先度(用途に合して編集してください) */
//  tmpResource.actorStackSize = (2 * 1024); /* アクタ・スタックサイズ(用途に合して編集してください) */
//  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
//  resourceInfo.push_back(tmpResource);

  //    1.4. AXMIspAe
  tmpResource.name = nameIspAe;
  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_4; /* アクタ優先度(用途に合して編集してください) */
  tmpResource.actorStackSize = (4 * 1024); /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);

  //    1.5. AXMIspAwb
  tmpResource.name = nameIspAwb;
  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_2; /* アクタ優先度(用途に合して編集してください) */
  tmpResource.actorStackSize = (21 * 1048); /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);

  //    1.6. AXMIspAssist
  tmpResource.name = nameIspAssist;
  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_3; /* アクタ優先度(用途に合して編集してください) */
  tmpResource.actorStackSize = (2 * 1024); /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);

  //    1.7. AXMIspAdjust
  tmpResource.name = nameIspAdjust;
  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_1; /* アクタ優先度(用途に合して編集してください) */
  tmpResource.actorStackSize = (3 * 1024); /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);

  // K.Kawachi add v v v
  //    AXMImageSensor
  tmpResource.name = nameImageSensor;
  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_6; /* アクタ優先度(用途に合して編集してください) */
  //tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_5; /* アクタ優先度(用途に合して編集してください) */
  tmpResource.actorStackSize = 2048; /* アクタ・スタックサイズ(用途に合して編集してください) */
  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
  resourceInfo.push_back(tmpResource);

  //    AXMImageSensorDrv
//  tmpResource.name = nameImageSensorDrv;
//  tmpResource.mailMaxCount = 5; /* Mailboxデータ最大数(用途に合して編集してください) */
//  tmpResource.mailMaxSize = sizeof(ST_MSG); /* Mailboxデータ最大サイズ(用途に合して編集してください) */
//  tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_6; /* アクタ優先度(用途に合して編集してください) */
//  //tmpResource.actorPriority = AXFTask::MODEL_PRIORITY_5; /* アクタ優先度(用途に合して編集してください) */
//  tmpResource.actorStackSize = 2048; /* アクタ・スタックサイズ(用途に合して編集してください) */
//  tmpResource.actorWatchDogTime = 60000; /* アクタ・ウオッチドックタイム値(ms)(用途に合して編集してください) */
//  resourceInfo.push_back(tmpResource);
  // K.Kawachi add ^ ^ ^

  return true;
}

/* ispStage AX起動情報設定メソッド */
static bool setIspStartInfo(std::vector<AXFStageStartInfo>& startInfo) {
  // 1. ActorインスタンスとActor起動情報を作成する
  AXFStageStartInfo tmpStart;

  //    1.1. AXMPixcessor
  tmpStart.name = namePixessor;
  AXMPixcessor *pixcessor = new AXMPixcessor(namePixessor);
  tmpStart.startOrder = 1; /* ISP Stage が1番目に起動要求を行う */
  tmpStart.objRef = pixcessor;
  startInfo.push_back(tmpStart);
  //    1.1.1. AXMPixcessorInt
  tmpStart.name = namePixessorInt;
  AXMPixcessorInt *pixcessorInt = new AXMPixcessorInt(namePixessorInt);
  tmpStart.startOrder = 2; /* ISP Stage が2番目に起動要求を行う */
  tmpStart.objRef = pixcessorInt;
  startInfo.push_back(tmpStart);

  //    1.2. AXMIsp
  tmpStart.name = nameIsp;
  AXMIsp *isp = new AXMIsp(nameIsp);
  tmpStart.startOrder = 3; /* ISP Stage が3番目に起動要求を行う */
  tmpStart.objRef = isp;
  startInfo.push_back(tmpStart);

//  //    1.3. AXMIspAf
//  tmpStart.name = nameIspAf;
//  AXMIspAf *af = new AXMIspAf(nameIspAf);
//  tmpStart.startOrder = 6; /* ISP Stage が6番目に起動要求を行う */
//  tmpStart.objRef = af;
//  startInfo.push_back(tmpStart);

  //    1.4. AXMIspAe
  tmpStart.name = nameIspAe;
  AXMIspAe *ae = new AXMIspAe(nameIspAe);
  tmpStart.startOrder = 4; /* ISP Stage が4番目に起動要求を行う */
  tmpStart.objRef = ae;
  startInfo.push_back(tmpStart);

  //    1.5. AXMIspAwb
  tmpStart.name = nameIspAwb;
  AXMIspAwb *awb = new AXMIspAwb(nameIspAwb);
  tmpStart.startOrder = 5; /* ISP Stage が5番目に起動要求を行う */
  tmpStart.objRef = awb;
  startInfo.push_back(tmpStart);

  //    1.6. AXMIspAssist
  tmpStart.name = nameIspAssist;
  AXMIspAssist *assist = new AXMIspAssist(nameIspAssist);
  tmpStart.startOrder = 7; /* ISP Stage が7番目に起動要求を行う */
  tmpStart.objRef = assist;
  startInfo.push_back(tmpStart);

  //    1.7. AXMIspAdjust
  tmpStart.name = nameIspAdjust;
  AXMIspAdjust *adjust = new AXMIspAdjust(nameIspAdjust);
  tmpStart.startOrder = 8; /* ISP Stage が8番目に起動要求を行う */
  tmpStart.objRef = adjust;
  startInfo.push_back(tmpStart);

  // K.Kawachi add v v v
  //     AXMImageSensor
  tmpStart.name = nameImageSensor;
  AXMImageSensor *imagesensor = new AXMImageSensor(nameImageSensor);
  tmpStart.startOrder = 10;		// タスク起動順序の重複を回避　1→10
  tmpStart.objRef = imagesensor;
  startInfo.push_back(tmpStart);

  //    AXMImageSensorDrv
//  tmpStart.name = nameImageSensorDrv;
//  AXMImageSensorDrv *imagesensorDrv = new AXMImageSensorDrv(namegeSensorDrv);
//  tmpStart.startOrder = AXFSTAGE_NOTSTARTING;
//  tmpStart.objRef = imagesensorDrv;
//  startInfo.push_back(tmpStart);
  // K.Kawachi add ^ ^ ^

  return true;
}
/*
 * ispStage Stage間通信情報
 */
static const struct ax::stageComm_t stageComm[] = {
    {
    { ax::AXCOMMCPUID_XTENSA_TO_ARM, 256, 20}, /* CPU send */
    { ax::AXCOMMCPUID_ARM_TO_XTENSA, 256}, /* CPU receive */
    },
    {
    { ax::AXCOMMCPUID_MAX, 0, 0}, /* デリミタ */
    { ax::AXCOMMCPUID_MAX, 0}, /* デリミタ */
    },
  };

/*
 * ispStage AXShell拡張コマンド情報
 */
#ifdef USE_AXFTEST_COMMAND
static std::string sendTest("sendAXTest");
static std::string sendTestHelp("\t-- send axStage.axtest test");
static AXFObjectName axSendTestName("axSendTest", "axStage");
#endif /* USE_AXFTEST_COMMAND */
static std::string startIsr("startIsr");
static std::string startIsrHelp("\t-- start fake ISR timer");
static std::string stopIsr("stopIsr");
static std::string stopIsrHelp("\t\t-- stop fake ISR timer");
#ifndef USE_TKERNEL
static std::string modeRun("modeRun");
static std::string modeRunHelp("\t\t-- change Run mode");
static std::string modeRunATWMode("modeRunATWMode");
static std::string modeRunATWModeHelp("\t\t-- change Run mode(ATWモード)");
static std::string modeRunATWSceaneMode("modeRunATWSceaneMode");
static std::string modeRunATWSceaneModeHelp("\t\t-- change Run mode(ATWシーンモード)");
static std::string modeRunTempManuMode("modeRunTempManuMode");
static std::string modeRunTempManuModeHelp("\t\t-- change Run mode(色温度指定マニュアルモード)");
static std::string modeRunLightManuMode("modeRunLightManuMode");
static std::string modeRunLightManuModeHelp("\t\t-- change Run mode(照明指定マニュアルモード)");
static std::string modeRunOnePushMode("modeRunOnePushMode");
static std::string modeRunOnePushModeHelp("\t\t-- change Run mode(ワンプッシュモード)");
static std::string modeRunGainManuMode("modeRunGainManuMode");
static std::string modeRunGainManuModeHelp("\t\t-- change Run mode(ゲイン指定マニュアルモード)");
static std::string modeRunHoldMode("modeRunHoldMode");
static std::string modeRunHoldModeHelp("\t\t-- change Run mode(ホールドモード)");
static std::string modeAdjustWB("modeAdjustWB");
static std::string modeAdjustWBHelp("\t\t-- change Adjust WB mode");
static std::string modeAdjustWBLowTempStart("modeAdjustWBLowTempStart");
static std::string modeAdjustWBLowTempStartHelp("\t\t-- Adjust WB Start low temp. side");
static std::string modeAdjustWBHighTempStart("modeAdjustWBHighTempStart");
static std::string modeAdjustWBHighTempStartHelp("\t\t-- Adjust WB Start high temp. side");
static std::string modeAdjustIris("modeAdjustIris");
static std::string modeAdjustIrisHelp("\t\t-- change Adjust Iris mode");
static std::string modeAdjustShade("modeAdjustShade");
static std::string modeAdjustShadeHelp("\t\t-- change Adjust Shade mode");
static std::string modeAdjustShadeStart("modeAdjustShadeStart");
static std::string modeAdjustShadeStartHelp("\t\t\t-- Adjust Shade Start");
static std::string modeAdjustKizu("modeAdjustKizu");
static std::string modeAdjustKizuHelp("\t\t-- change Adjust Kizu mode");
static std::string modeAdjustKizuStart("modeAdjustKizuStart");
static std::string modeAdjustKizuStartHelp("\t\t\t-- Adjust Kizu Start");
static std::string modeRunATWSceaneIndoorMode("modeRunATWSceaneIndoorMode");
static std::string modeRunATWSceaneIndoorModeHelp("\t\t-- change Run mode(ATWシーン屋内モード)");
static std::string modeRunATWSceaneIndoorCWFMode("modeRunATWSceaneIndoorCWFMode");
static std::string modeRunATWSceaneIndoorCWFModeHelp("\t\t-- change Run mode(ATWシーン屋内蛍光灯モード)");
static std::string modeRunATWSceaneIndoorAMode("modeRunATWSceaneIndoorAMode");
static std::string modeRunATWSceaneIndoorAModeHelp("\t\t-- change Run mode(ATWシーン屋内暖色系モード)");
static std::string modeRunATWSceaneOutdoorMode("modeRunATWSceaneOutdoorMode");
static std::string modeRunATWSceaneOutdoorModeHelp("\t\t-- change Run mode(ATWシーン屋外モード)");
static std::string modeRunATWSceaneAsphaltMode("modeRunATWSceaneAsphaltMode");
static std::string modeRunATWSceaneAsphaltModeHelp("\t\t-- change Run mode(ATWシーン屋外アスファルトモード)");
static std::string modeRunATWSceaneLEDMode("modeRunATWSceaneLEDMode");
static std::string modeRunATWSceaneLEDModeHelp("\t\t-- change Run mode(ATWシーンLED照明モード)");
static std::string modeRunATWSceaneRollingMode("modeRunATWSceaneRollingMode");
static std::string modeRunATWSceaneRollingModeHelp("\t\t-- change Run mode(ATWシーンRollingモード)");
static std::string modeRunAeNormalMode("modeRunAeNormalMode");
static std::string modeRunAeNormalModeHelp("\t\t-- change Run mode(AE Normalモード)");
static std::string modeRunAeWdrMode("modeRunAeWdrMode");
static std::string modeRunAeWdrModeHelp("\t\t-- change Run mode(AE WDRモード)");
#endif  //  USE_TKERNEL
#ifdef USE_AXFTEST_COMMAND
static std::string actorComm("actorComm");
static std::string actorCommHelp("\t-- actor comm test");
static std::string priSched("priSched");
static std::string priSchedHelp("\t-- priority scheduling test");
static std::string memTest("memTest");
static std::string memTestHelp("\t-- memory test");
static AXFObjectName memTestName("awb", "ispStage");

static std::string startLoopback("startLoopback");
static std::string startLoopbackHelp("\t-- start loopback test");
static std::string stopLoopback("stopLoopback");
static std::string stopLoopbackHelp("\t-- stop loopback test");

static std::string startLoopback2("startLoopback2");
static std::string startLoopback2Help("\t-- start loopback test2");
static std::string stopLoopback2("stopLoopback2");
static std::string stopLoopback2Help("\t-- stop loopback test2");

static std::string startLoopback3("startLoopback3");
static std::string startLoopback3Help("\t-- start loopback test3");
static std::string stopLoopback3("stopLoopback3");
static std::string stopLoopback3Help("\t-- stop loopback test3");

static std::string startLoopback4("startLoopback4");
static std::string startLoopback4Help("\t-- start loopback test4");
static std::string stopLoopback4("stopLoopback4");
static std::string stopLoopback4Help("\t-- stop loopback test4");

static std::string startLoopbackAll("startLoopbackAll");
static std::string startLoopbackAllHelp("\t-- start loopback test all");
static std::string stopLoopbackAll("stopLoopbackAll");
static std::string stopLoopbackAllHelp("\t-- stop loopback test all");

static std::string timerTest("timerTest");
static std::string timerTestHelp("\t-- timer test");
#ifdef USE_AXFTEST_COMMAND_COMPLOG
  static AXFObjectName nameAXTestIsp("axtest", "ispStage");
  static std::string scnIspTout("scnIspTout");
  static std::string scnIspToutHelp("\t-- ScenarioTest Isp Timeout");
  static AXFObjectName nameAXTestAx("axtest", "axStage");
  static std::string scnAxTout("scnAxTout");
  static std::string scnAxToutHelp("\t-- ScenarioTest Ax Timeout");
#endif /*USE_AXFTEST_COMMAND_COMPLOG*/
#endif /* USE_AXFTEST_COMMAND */

static std::string dummy("dummy");
static ax::extendCommand_t extendCommandTable[] = {
#ifdef USE_AXFTEST_COMMAND
   {
    sendTest,              ///< 拡張コマンド名
    sendTestHelp,          ///< 拡張コマンドHelp情報
    axSendTestName,        ///< 拡張コマンドで送信する宛先
    AXFEVENT_MODEL(1),     ///< 拡張コマンドで送信するイベントID (AXMIspAwb::EVENT_AXCOMM_TEST)
    (void*)"abcdefghigklmnopqrstuvwxyz", ///< 拡張コマンドで送信するデータ
    27,                        ///< 拡張コマンドで送信するデータサイズ
   },
#endif /* USE_AXFTEST_COMMAND */
   {
     startIsr,              ///< 拡張コマンド名
     startIsrHelp,          ///< 拡張コマンドHelp情報
     namePixessorInt,       ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(1),     ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_FAKE_ISR_START)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                         ///< 拡張コマンドで送信するデータサイズ
    },
   {
     stopIsr,               ///< 拡張コマンド名
     stopIsrHelp,           ///< 拡張コマンドHelp情報
     namePixessorInt,       ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(2),     ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_FAKE_ISR_STOP)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                         //< 拡張コマンドで送信するデータサイズ
    },
#ifndef USE_TKERNEL
    {
      modeRun,              ///< 拡張コマンド名
      modeRunHelp,          ///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWMode)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWMode,       ///< 拡張コマンド名
      modeRunATWModeHelp,   ///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWMode)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWSceaneMode, ///< 拡張コマンド名
      modeRunATWSceaneModeHelp,///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(2),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWSceaneMode)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunTempManuMode,  ///< 拡張コマンド名
      modeRunTempManuModeHelp,///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(3),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_TempManuMode)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunLightManuMode, ///< 拡張コマンド名
      modeRunLightManuModeHelp,///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(4),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_LightManuMode)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunOnePushMode,   ///< 拡張コマンド名
      modeRunOnePushModeHelp,///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(5),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_OnePushMode)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunGainManuMode,  ///< 拡張コマンド名
      modeRunGainManuModeHelp,///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(6),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_GainManuMode)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunHoldMode,      ///< 拡張コマンド名
      modeRunHoldModeHelp,  ///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(7),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_HoldMode)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeAdjustWB,         ///< 拡張コマンド名
      modeAdjustWBHelp,     ///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(8),    ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_ADJ_WB)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeAdjustWBLowTempStart,         ///< 拡張コマンド名
      modeAdjustWBLowTempStartHelp,     ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(9),                ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_ADJ_WB)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeAdjustWBHighTempStart,        ///< 拡張コマンド名
      modeAdjustWBHighTempStartHelp,    ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(10),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_ADJ_WB)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeAdjustIris,       ///< 拡張コマンド名
      modeAdjustIrisHelp,   ///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(11),   ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_ADJ_IRIS)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeAdjustShade,      ///< 拡張コマンド名
      modeAdjustShadeHelp,  ///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(12),   ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_ADJ_SHADE)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeAdjustShadeStart,             ///< 拡張コマンド名
      modeAdjustShadeStartHelp,         ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(13),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_ADJ_SHADE_START)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                      ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeAdjustKizu,       ///< 拡張コマンド名
      modeAdjustKizuHelp,   ///< 拡張コマンドHelp情報
      namePixessor,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(14),   ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_ADJ_KIZU)
      NULL,                 ///< 拡張コマンドで送信するデータ
      0,                        ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeAdjustKizuStart,             ///< 拡張コマンド名
      modeAdjustKizuStartHelp,         ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(15),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_ADJ_KIZU_START)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                      ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWSceaneIndoorMode,       ///< 拡張コマンド名
      modeRunATWSceaneIndoorModeHelp,   ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(16),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWSceaneIndoorMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWSceaneIndoorCWFMode,    ///< 拡張コマンド名
      modeRunATWSceaneIndoorCWFModeHelp,///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(17),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWSceaneIndoorCWFMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWSceaneIndoorAMode,      ///< 拡張コマンド名
      modeRunATWSceaneIndoorAModeHelp,  ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(18),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWSceaneIndoorAMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWSceaneOutdoorMode,      ///< 拡張コマンド名
      modeRunATWSceaneOutdoorModeHelp,  ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(19),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWSceaneOutdoorMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWSceaneAsphaltMode,      ///< 拡張コマンド名
      modeRunATWSceaneAsphaltModeHelp,  ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(20),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWSceaneAsphaltMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWSceaneLEDMode,          ///< 拡張コマンド名
      modeRunATWSceaneLEDModeHelp,      ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(21),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWSceaneLEDMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunATWSceaneRollingMode,      ///< 拡張コマンド名
      modeRunATWSceaneRollingModeHelp,  ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(22),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_ATWSceaneRollingMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunAeNormalMode,              ///< 拡張コマンド名
      modeRunAeNormalModeHelp,          ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(23),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_AeNormalMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
    {
      modeRunAeWdrMode,                 ///< 拡張コマンド名
      modeRunAeWdrModeHelp,      ///< 拡張コマンドHelp情報
      namePixessor,                     ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(24),               ///< 拡張コマンドで送信するイベントID (PIXCESSOR_EVENT_MODE_RUN_AeWdrMode)
      NULL,                             ///< 拡張コマンドで送信するデータ
      0,                                ///< 拡張コマンドで送信するデータサイズ
    },
#endif  //  USE_TKERNEL
#ifdef USE_AXFTEST_COMMAND
   {
     actorComm,             ///< 拡張コマンド名
     actorCommHelp,         ///< 拡張コマンドHelp情報
     nameIspAf,             ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(1002),  ///< 拡張コマンドで送信するイベントID (AXMIspAf::EVENT_AXTORCOMM_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
      0,                        //< 拡張コマンドで送信するデータサイズ
   },
   {
     priSched,              ///< 拡張コマンド名
     priSchedHelp,          ///< 拡張コマンドHelp情報
     nameIsp,               ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(1000),  ///< 拡張コマンドで送信するイベントID (AXMIsp::EVENT_PRISCHED_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
      0,                        //< 拡張コマンドで送信するデータサイズ
    },
   { 
     memTest,               ///< 拡張コマンド名
     memTestHelp,           ///< 拡張コマンドHelp情報
     memTestName,           ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(1003),  ///< 拡張コマンドで送信するイベントID (EVENT_MEM_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                        //< 拡張コマンドで送信するデータサイズ
   },
   {
     startLoopback,         ///< 拡張コマンド名
     startLoopbackHelp,     ///< 拡張コマンドHelp情報
     nameAXTest,            ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(53),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     stopLoopback,          ///< 拡張コマンド名
     stopLoopbackHelp,      ///< 拡張コマンドHelp情報
     nameAXTest,            ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(54),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     startLoopback2,        ///< 拡張コマンド名
     startLoopback2Help,    ///< 拡張コマンドHelp情報
     nameAXTest2,           ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(53),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     stopLoopback2,         ///< 拡張コマンド名
     stopLoopback2Help,     ///< 拡張コマンドHelp情報
     nameAXTest2,           ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(54),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     startLoopback3,        ///< 拡張コマンド名
     startLoopback3Help,    ///< 拡張コマンドHelp情報
     nameAXTest3,           ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(53),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     stopLoopback3,         ///< 拡張コマンド名
     stopLoopback3Help,     ///< 拡張コマンドHelp情報
     nameAXTest3,           ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(54),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     startLoopback4,        ///< 拡張コマンド名
     startLoopback4Help,    ///< 拡張コマンドHelp情報
     nameAXTest4,           ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(53),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     stopLoopback4,         ///< 拡張コマンド名
     stopLoopback4Help,     ///< 拡張コマンドHelp情報
     nameAXTest4,           ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(54),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     startLoopbackAll,      ///< 拡張コマンド名
     startLoopbackAllHelp,  ///< 拡張コマンドHelp情報
     nameAXTest,            ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(55),    ///< 拡張コマンドで送信するイベントID (EVENT_START_LOOPBACK_ALL)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     stopLoopbackAll,       ///< 拡張コマンド名
     stopLoopbackAllHelp,   ///< 拡張コマンドHelp情報
     nameAXTest,            ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(56),    ///< 拡張コマンドで送信するイベントID (EVENT_STOP_LOOPBACK_ALL)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
   {
     timerTest,             ///< 拡張コマンド名
     timerTestHelp,         ///< 拡張コマンドHelp情報
     nameAXTest,            ///< 拡張コマンドで送信する宛先
     AXFEVENT_MODEL(80),    ///< 拡張コマンドで送信するイベントID (EVENT_TIMER_TEST)
     NULL,                  ///< 拡張コマンドで送信するデータ
     0,                     ///< 拡張コマンドで送信するデータサイズ
   },
#ifdef USE_AXFTEST_COMMAND_COMPLOG
    {
      scnIspTout,            ///< 拡張コマンド名
      scnIspToutHelp,        ///< 拡張コマンドHelp情報
      nameAXTestIsp,         ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1000),  ///< 拡張コマンドで送信するイベントID (EVENT_SCENARIOTEST_TIMEOUT)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
    {
      scnAxTout,             ///< 拡張コマンド名
      scnAxToutHelp,         ///< 拡張コマンドHelp情報
      nameAXTestAx,          ///< 拡張コマンドで送信する宛先
      AXFEVENT_MODEL(1001),  ///< 拡張コマンドで送信するイベントID (EVENT_SCENARIOTEST_TIMEOUT)
      NULL,                  ///< 拡張コマンドで送信するデータ
      0,                     ///< 拡張コマンドで送信するデータサイズ
    },
#endif /* USE_AXFTEST_COMMAND_COMPLOG */
#endif /* USE_AXFTEST_COMMAND */
   { /* デリミタ */dummy, dummy, nameStage, 0, NULL, 0 } };

/*
 * axStage  AXScript情報
 * @ToDo AXScript テキスト対応までの暫定定義
 */
static struct axScript_t* scriptTable[] = {
    NULL,
    NULL,
    NULL,
    NULL
};

/*
 * ispStage AXコンフィグレーション情報
 */
const ax::config_t AXConfig = {
    getIspStageNameObject,  ///< AX Stage名取得メソッド
    setIspResourceInfo,     ///< AXリソース情報設定メソッド
    setIspStartInfo,        ///< AX起動情報設定メソッド
    stageComm,              ///< Stage間通信情報
    extendCommandTable,     ///< AXShell拡張コマンド情報
    scriptTable             ///< AXScript情報
};
