#ifndef AF_Register_Table__H
#define AF_Register_Table__H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t SFTRST:1;
        } addr_0x00;
        uint32_t addr_0x00_W;
    };

    union {
        struct {
            uint32_t H_P_AREA_SIZE:12;
            uint32_t padding_15_to_12:4;
            uint32_t V_P_AREA_SIZE:12;
        } addr_0x04;
        uint32_t addr_0x04_W;
    };

    union {
        struct {
            uint32_t H_OFFSET:12;
            uint32_t padding_15_to_12:4;
            uint32_t V_OFFSET:12;
        } addr_0x08;
        uint32_t addr_0x08_W;
    };

    union {
        struct {
            uint32_t H_DIV:3;
            uint32_t padding_15_to_3:13;
            uint32_t V_DIV:3;
        } addr_0x0C;
        uint32_t addr_0x0C_W;
    };

    union {
        struct {
            uint32_t SSB:5;
        } addr_0x10;
        uint32_t addr_0x10_W;
    };

    union {
        struct {
            uint32_t STATUS_CLR_RES:2;
        } addr_0x14;
        uint32_t addr_0x14_W;
    };

} AF_Register_Table_s;
#ifdef __cplusplus
}
#endif

#endif /*AF_Register_Table__H*/
