#ifndef APB_TIMERS_Register_Table__H
#define APB_TIMERS_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t Timer1LoadCount:32;
        } TimerLoadCount;
        uint32_t TimerLoadCount_W;
    };

    union {
        struct {
            uint32_t Timer1CurrentValue:32;
        } TimerCurrentValue;
        uint32_t TimerCurrentValue_W;
    };

    union {
        struct {
            uint32_t TIMER_ENABLE:1;
            uint32_t TIMER_MODE:1;
            uint32_t TIMER_INTERRUPT_MASK:1;
            uint32_t TIMER_PWM:1;
            uint32_t TIMER_0N100PWM_EN:1;
            uint32_t RSVD_Timer1ControlReg:27;
        } TimerControlReg;
        uint32_t TimerControlReg_W;
    };

    union {
        struct {
            uint32_t Timer1EOI:1;
            uint32_t RSVD_Timer1EOI:31;
        } TimerEOI;
        uint32_t TimerEOI_W;
    };

    union {
        struct {
            uint32_t Timer1IntStatus:1;
            uint32_t RSVD_Timer1IntStatus:31;
        } TimerIntStatus;
        uint32_t TimerIntStatus_W;
    };

    uint32_t rsvd_0x14[0x8c/4];

    union {
        struct {
            uint32_t TimersIntStatus:1;
            uint32_t RSVD_TimersIntStatus:31;
        } TimersIntStatus;
        uint32_t TimersIntStatus_W;
    };

    union {
        struct {
            uint32_t TIMERSEOI:1;
            uint32_t RSVD_TIMERSEOI:31;
        } TimersEOI;
        uint32_t TimersEOI_W;
    };

    union {
        struct {
            uint32_t TIMERSRAWINTSTAT:1;
            uint32_t RSVD_TIMERSRAWINTSTAT:31;
        } TimersRawIntStatus;
        uint32_t TimersRawIntStatus_W;
    };

    union {
        struct {
            uint32_t TIMERSCOMPVERSION:32;
        } TIMERS_COMP_VERSION;
        uint32_t TIMERS_COMP_VERSION_W;
    };

} APB_TIMERS_Register_Table_s;
#endif
