#ifndef APB_WDT_Register_Table__H
#define APB_WDT_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t WDT_EN:1;
            uint32_t RMOD:1;
            uint32_t RPL:3;
            uint32_t NO_NAME:1;
            uint32_t RSVD_WDT_CR:26;
        } WDT_CR;
        uint32_t WDT_CR_W;
    };

    union {
        struct {
            uint32_t TOP:4;
            uint32_t TOP_INIT:4;
            uint32_t RSVD_WDT_TORR:24;
        } WDT_TORR;
        uint32_t WDT_TORR_W;
    };

    union {
        struct {
            uint32_t WDT_CCVR:32;
        } WDT_CCVR;
        uint32_t WDT_CCVR_W;
    };

    union {
        struct {
            uint32_t WDT_CRR:8;
            uint32_t RSVD_SDT_CRR:24;
        } WDT_CRR;
        uint32_t WDT_CRR_W;
    };

    union {
        struct {
            uint32_t WDT_STAT:1;
            uint32_t RSVD_WDT_STAT:31;
        } WDT_STAT;
        uint32_t WDT_STAT_W;
    };

    union {
        struct {
            uint32_t WDT_EOI:1;
            uint32_t RSVD_WDT_EOI:31;
        } WDT_EOI;
        uint32_t WDT_EOI_W;
    };

    uint32_t rsvd_0x18[0x4/4];

    union {
        struct {
            uint32_t WDT_PROT_LEVEL:3;
            uint32_t RSVD_WDT_PROT_LEVEL:29;
        } WDT_PROT_LEVEL;
        uint32_t WDT_PROT_LEVEL_W;
    };

    uint32_t rsvd_0x20[0xc4/4];

    union {
        struct {
            uint32_t CP_WDT_USER_TOP_MAX:32;
        } WDT_COMP_PARAM5;
        uint32_t WDT_COMP_PARAM5_W;
    };

    union {
        struct {
            uint32_t CP_WDT_USER_TOP_INIT_MAX:32;
        } WDT_COMP_PARAM4;
        uint32_t WDT_COMP_PARAM4_W;
    };

    union {
        struct {
            uint32_t CD_WDT_TOP_RST:32;
        } WDT_COMP_PARAM3;
        uint32_t WDT_COMP_PARAM3_W;
    };

    union {
        struct {
            uint32_t CP_WDT_CNT_RST:32;
        } WDT_COMP_PARAM2;
        uint32_t WDT_COMP_PARAM2_W;
    };

    union {
        struct {
            uint32_t WDT_ALWALYS_EN:1;
            uint32_t WDT_DFLT_RMOD:1;
            uint32_t WDT_DUAL_TOP:1;
            uint32_t WDT_HC_RMOD:1;
            uint32_t WDT_HC_RPL:1;
            uint32_t WDT_HC_TOP:1;
            uint32_t WDT_USE_FIX_TOP:1;
            uint32_t WDT_PAUSE:1;
            uint32_t APB_DATA_WIDTH:2;
            uint32_t WDT_DFLT_RPL:3;
            uint32_t RSVD_15_13:3;
            uint32_t WDT_DFLT_TOP:4;
            uint32_t WDT_DFLT_TOP_INIT:4;
            uint32_t WDT_CNT_WIDTH:5;
            uint32_t RSVD_31_29:3;
        } WDT_COMP_PARAM1;
        uint32_t WDT_COMP_PARAM1_W;
    };

    union {
        struct {
            uint32_t WDT_COMP_VERSION:32;
        } WDT_COMP_VERSION;
        uint32_t WDT_COMP_VERSION_W;
    };

    union {
        struct {
            uint32_t WDT_COMP_TYPE:32;
        } WDT_COMP_TYPE;
        uint32_t WDT_COMP_TYPE_W;
    };

} APB_WDT_Register_Table_s;
#endif
