#ifndef GPIOB_Register_Table__H
#define GPIOB_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t GPIO_SWPORTA_DR:16;
            uint32_t RSVD_GPIO_SWPORTA_DR:16;
        } GPIOB_SWPORT_DR;
        uint32_t GPIOB_SWPORT_DR_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTA_DDR:16;
            uint32_t RSVD_GPIO_SWPORTA_DDR:16;
        } GPIOB_SWPORT_DDR;
        uint32_t GPIOB_SWPORT_DDR_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTA_CTL:1;
            uint32_t RSVD_GPIO_SWPORTA_CTL:31;
        } GPIOB_SWPORT_CTL;
        uint32_t GPIOB_SWPORT_CTL_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTB_DR:8;
            uint32_t RSVD_GPIO_SWPORTB_DR:24;
        } reg_0x0C;
        uint32_t reg_0x0C_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTB_DDR:8;
            uint32_t RSVD_GPIO_SWPORTB_DDR:24;
        } reg_0x10;
        uint32_t reg_0x10_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTB_CTL:1;
            uint32_t RSVD_GPIO_SWPORTB_CTL:31;
        } reg_0x14;
        uint32_t reg_0x14_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTC_DR:8;
            uint32_t RSVD_GPIO_SWPORTC_DR:24;
        } reg_0x18;
        uint32_t reg_0x18_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTC_DDR:8;
            uint32_t RSVD_GPIO_SWPORTC_DDR:24;
        } reg_0x1C;
        uint32_t reg_0x1C_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTC_CTL:1;
            uint32_t RSVD_GPIO_SWPORTC_CTL:31;
        } reg_0x20;
        uint32_t reg_0x20_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTD_DR:8;
            uint32_t RSVD_GPIO_SWPORTD_DR:24;
        } reg_0x24;
        uint32_t reg_0x24_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTD_DDR:8;
            uint32_t RSVD_GPIO_SWPORTD_DDR:24;
        } reg_0x28;
        uint32_t reg_0x28_W;
    };

    union {
        struct {
            uint32_t GPIO_SWPORTD_CTL:1;
            uint32_t RSVD_GPIO_SWPORTD_CTL:31;
        } reg_0x2C;
        uint32_t reg_0x2C_W;
    };

    union {
        struct {
            uint32_t GPIO_INTEN:16;
            uint32_t RSVD_GPIO_INTEN:16;
        } GPIOB_INTEN;
        uint32_t GPIOB_INTEN_W;
    };

    union {
        struct {
            uint32_t GPIO_INTMASK:16;
            uint32_t RSVD_GPIO_INTMASK:16;
        } GPIOB_INTMASK;
        uint32_t GPIOB_INTMASK_W;
    };

    union {
        struct {
            uint32_t GPIO_INTTYPE_LEVEL:16;
            uint32_t RSVD_GPIO_INTTYPE_LEVEL:16;
        } GPIOB_INTTYPE_LEVEL;
        uint32_t GPIOB_INTTYPE_LEVEL_W;
    };

    union {
        struct {
            uint32_t GPIO_INT_POLARITY:16;
            uint32_t RSVD_GPIO_INT_POLARITY:16;
        } GPIOB_INT_POLARITY;
        uint32_t GPIOB_INT_POLARITY_W;
    };

    union {
        struct {
            uint32_t GPIO_INTSTATUS:16;
            uint32_t RSVD_GPIO_INTSTATUS:16;
        } GPIOB_INTSTATUS;
        uint32_t GPIOB_INTSTATUS_W;
    };

    union {
        struct {
            uint32_t GPIO_RAW_INTSTATUS:16;
            uint32_t RSVD_GPIO_RAW_INTSTATUS:16;
        } GPIOB_RAW_INTSTATUS;
        uint32_t GPIOB_RAW_INTSTATUS_W;
    };

    union {
        struct {
            uint32_t GPIO_DEBOUNCE:16;
            uint32_t RSVD_GPIO_DEBOUNCE:16;
        } GPIOB_DEBOUNCE;
        uint32_t GPIOB_DEBOUNCE_W;
    };

    union {
        struct {
            uint32_t GPIO_PORTA_EOI:16;
            uint32_t RSVD_GPIO_PORTA_EOI:16;
        } GPIOB_PORT_EOI;
        uint32_t GPIOB_PORT_EOI_W;
    };

    union {
        struct {
            uint32_t GPIO_EXT_PORTA:16;
            uint32_t RSVD_GPIO_EXT_PORTA:16;
        } GPIOB_EXT_PORT;
        uint32_t GPIOB_EXT_PORT_W;
    };

    union {
        struct {
            uint32_t GPIO_EXT_PORTB:8;
            uint32_t RSVD_GPIO_EXT_PORTB:24;
        } reg_0x54;
        uint32_t reg_0x54_W;
    };

    union {
        struct {
            uint32_t GPIO_EXT_PORTC:8;
            uint32_t RSVD_GPIO_EXT_PORTC:24;
        } reg_0x58;
        uint32_t reg_0x58_W;
    };

    union {
        struct {
            uint32_t GPIO_EXT_PORTD:8;
            uint32_t RSVD_GPIO_EXT_PORTD:24;
        } reg_0x5C;
        uint32_t reg_0x5C_W;
    };

    union {
        struct {
            uint32_t GPIO_LS_SYNC:1;
            uint32_t RSVD_GPIO_LS_SYNC:31;
        } GPIOB_LS_SYNC;
        uint32_t GPIOB_LS_SYNC_W;
    };

    union {
        struct {
            uint32_t GPIO_ID_CODE:32;
        } GPIOB_ID_CODE;
        uint32_t GPIOB_ID_CODE_W;
    };

    union {
        struct {
            uint32_t GPIO_INT_BOTHEDGE:16;
            uint32_t RSVD_GPIO_INT_BOTHEDGE:16;
        } GPIOB_INT_BOTHEDGE;
        uint32_t GPIOB_INT_BOTHEDGE_W;
    };

    union {
        struct {
            uint32_t GPIO_VER_ID_CODE:32;
        } GPIOB_VER_ID_CODE;
        uint32_t GPIOB_VER_ID_CODE_W;
    };

    union {
        struct {
            uint32_t ENCODED_ID_PWIDTH_A:5;
            uint32_t ENCODED_ID_PWIDTH_B:5;
            uint32_t ENCODED_ID_PWIDTH_C:5;
            uint32_t ENCODED_ID_PWIDTH_D:5;
            uint32_t RSVD_GPIO_CONFIG_REG2:12;
        } GPIOB_CONFIG_REG2;
        uint32_t GPIOB_CONFIG_REG2_W;
    };

    union {
        struct {
            uint32_t APB_DATA_WIDTH:2;
            uint32_t NUM_PORTS:2;
            uint32_t PORTA_SINGLE_CTL:1;
            uint32_t PORTB_SINGLE_CTL:1;
            uint32_t PORTC_SINGLE_CTL:1;
            uint32_t PORTD_SINGLE_CTL:1;
            uint32_t HW_PORTA:1;
            uint32_t HW_PORTB:1;
            uint32_t HW_PORTC:1;
            uint32_t HW_PORTD:1;
            uint32_t PORTA_INTR:1;
            uint32_t DEBOUNCE:1;
            uint32_t ADD_ENCODED_PARAMS:1;
            uint32_t GPIO_ID:1;
            uint32_t ENCODED_ID_WIDTH:5;
            uint32_t INTERRUPT_BOTH_EDGE_TYPE:1;
            uint32_t RSVD_GPIO_CONFIG_REG1:10;
        } GPIOB_CONFIG_REG1;
        uint32_t GPIOB_CONFIG_REG1_W;
    };

} GPIOB_Register_Table_s;
#endif
