#ifndef INNO_DDR_CTRL_Register_Table__H
#define INNO_DDR_CTRL_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t reg_ddrc_mem_choose:3;
            uint32_t reg_ddrc_init_start:1;
            uint32_t reg_phy_init_start:1;
            uint32_t reg_ddrc_skip_init_start:1;
            uint32_t reg_disable_imc_if:1;
            uint32_t reg_sdram_burst_length:2;
            uint32_t reg_sdram_dq_width:2;
            uint32_t reg_ctrl_ddrc_clk_disable:1;
            uint32_t reg_out_of_order_dis:1;
            uint32_t reg_ddrc_2t_mode:1;
            uint32_t reg_aclk_cg_en:1;
            uint32_t reg_ddrc_core_clock_gate_en:1;
            uint32_t rsvd_16:7;
            uint32_t reg_mem_bist_channel_en:9;
        } reg_0x000;
        uint32_t reg_0x000_W;
    };

    union {
        struct {
            uint32_t reg_trp:16;
            uint32_t reg_trcd:16;
        } reg_0x004;
        uint32_t reg_0x004_W;
    };

    union {
        struct {
            uint32_t reg_tras:16;
        } reg_0x008;
        uint32_t reg_0x008_W;
    };

    union {
        struct {
            uint32_t reg_tras_min:16;
            uint32_t reg_trc:16;
        } reg_0x00c;
        uint32_t reg_0x00c_W;
    };

    union {
        struct {
            uint32_t reg_trrd_s:16;
            uint32_t reg_trrd_l:16;
        } reg_0x010;
        uint32_t reg_0x010_W;
    };

    union {
        struct {
            uint32_t reg_twtr_l:8;
            uint32_t reg_twtr_s:8;
            uint32_t reg_twr:8;
            uint32_t reg_tfaw:8;
        } reg_0x014;
        uint32_t reg_0x014_W;
    };

    union {
        struct {
            uint32_t reg_tccd_l:8;
            uint32_t reg_tccd_s:8;
            uint32_t reg_trtp:8;
            uint32_t reg_trtw:8;
        } reg_0x018;
        uint32_t reg_0x018_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_tmrr:8;
            uint32_t reg_ddrc_tmrw:8;
            uint32_t reg_ddrc_tmod:8;
            uint32_t reg_ddrc_tmrd:8;
        } reg_0x01c;
        uint32_t reg_0x01c_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_trefi_x32:13;
            uint32_t reg_ddrc_trfc_min:10;
            uint32_t rsvd_23:1;
            uint32_t reg_ddrc_tmrr2mrw:8;
        } reg_0x020;
        uint32_t reg_0x020_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_txpr:12;
            uint32_t rsvd_12:4;
            uint32_t reg_tcke:5;
            uint32_t rsvd_21:3;
            uint32_t reg_tpd:5;
        } reg_0x024;
        uint32_t reg_0x024_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_trp:8;
            uint32_t reg_ddrc_tdllk:8;
            uint32_t reg_tppd:8;
            uint32_t reg_tccd_mw:8;
        } reg_0x028;
        uint32_t reg_0x028_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_txp:8;
            uint32_t reg_ddrc_trpa:8;
            uint32_t reg_ddrc_tescke:4;
            uint32_t rsvd_20:4;
            uint32_t reg_tckesr:4;
        } reg_0x02c;
        uint32_t reg_0x02c_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_tzqoper:14;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_txs:14;
        } reg_0x030;
        uint32_t reg_0x030_W;
    };

    union {
        struct {
            uint32_t reg_derated_trp:16;
            uint32_t reg_derated_trcd:16;
        } reg_0x034;
        uint32_t reg_0x034_W;
    };

    union {
        struct {
            uint32_t reg_derated_tras_min:16;
            uint32_t reg_derated_trc:16;
        } reg_0x038;
        uint32_t reg_0x038_W;
    };

    union {
        struct {
            uint32_t reg_derated_trrd_s:16;
            uint32_t reg_derated_trrd_l:16;
        } reg_0x03c;
        uint32_t reg_0x03c_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_init_tzqinit:11;
            uint32_t reg_ddrc_init_treset_h_x1024:13;
            uint32_t reg_ddrc_init_treset_l_x1024:8;
        } reg_0x040;
        uint32_t reg_0x040_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_init_tckeh:8;
            uint32_t reg_tinit1_100ns:8;
            uint32_t reg_lpddr23_tinit5:8;
            uint32_t reg_ddrc_init_tzqlat:8;
        } reg_0x044;
        uint32_t reg_0x044_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_txsr:8;
            uint32_t reg_ddrc_tsr:8;
        } reg_0x048;
        uint32_t reg_0x048_W;
    };

    union {
        struct {
            uint32_t reg_slm_cmd_idle_cnt_x32_sref:8;
            uint32_t reg_slm_cmd_idle_cnt_x32_ppd:8;
            uint32_t reg_ddrc_zqcal_after_sref_en:1;
        } reg_0x04c;
        uint32_t reg_0x04c_W;
    };

    union {
        struct {
            uint32_t reg_slm_sref_req:1;
            uint32_t reg_slm_ppd_req:1;
            uint32_t reg_slm_dis_auto_sref:1;
            uint32_t reg_slm_dis_auto_ppd:1;
            uint32_t reg_slm_sref_ppd_req:1;
            uint32_t reg_lpddr4_self_ppd_en:1;
            uint32_t reg_ddrc_dfilp_en:1;
            uint32_t reg_dfi_lp_state_clean:1;
            uint32_t reg_ddrc_dfilp2sref_gap:8;
            uint32_t reg_ddrc_sref2dfilp_gap:8;
            uint32_t reg_ddrc_lpddrn_exit_ppd_at_self_refresh:1;
            uint32_t reg_ddrc_lpddrn_enter_ppd_at_self_refresh:1;
        } reg_0x050;
        uint32_t reg_0x050_W;
    };

    union {
        struct {
            uint32_t reg_dfi_lp_wakeup_pd:4;
            uint32_t reg_dfi_lp_wakeup_sref:4;
            uint32_t reg_dfi_lp_entry_wait_time:8;
            uint32_t reg_ddrc_pd2dfilp_gap:8;
            uint32_t reg_ddrc_dfilp2pd_gap:8;
        } reg_0x054;
        uint32_t reg_0x054_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_rd2wr_of_diff_rank:8;
            uint32_t reg_two_rank_auto_ref_diff_r0:8;
            uint32_t reg_two_rank_auto_ref_diff_r1:8;
            uint32_t reg_ddrc_rd_gap_of_diff_rank:4;
            uint32_t reg_ddrc_wr_gap_of_diff_rank:4;
        } reg_0x058;
        uint32_t reg_0x058_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m0_r0:26;
        } reg_0x05c;
        uint32_t reg_0x05c_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m1_r0:26;
        } reg_0x060;
        uint32_t reg_0x060_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m2_r0:26;
        } reg_0x064;
        uint32_t reg_0x064_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m3_r0:26;
        } reg_0x068;
        uint32_t reg_0x068_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m4_r0:26;
        } reg_0x06c;
        uint32_t reg_0x06c_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m5_r0:26;
        } reg_0x070;
        uint32_t reg_0x070_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m6_r0:26;
        } reg_0x074;
        uint32_t reg_0x074_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m7_r0:26;
        } reg_0x078;
        uint32_t reg_0x078_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m0_r1:26;
        } reg_0x07c;
        uint32_t reg_0x07c_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m1_r1:26;
        } reg_0x080;
        uint32_t reg_0x080_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m2_r1:26;
        } reg_0x084;
        uint32_t reg_0x084_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m3_r1:26;
        } reg_0x088;
        uint32_t reg_0x088_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m4_r1:26;
        } reg_0x08c;
        uint32_t reg_0x08c_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m5_r1:26;
        } reg_0x090;
        uint32_t reg_0x090_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m6_r1:26;
        } reg_0x094;
        uint32_t reg_0x094_W;
    };

    union {
        struct {
            uint32_t reg_user_load_mode_value_m7_r1:26;
        } reg_0x098;
        uint32_t reg_0x098_W;
    };

    union {
        struct {
            uint32_t reg_init_lpddr4_mrw_2_en:1;
            uint32_t reg_init_lpddr4_mrw_1_en:1;
            uint32_t reg_init_lpddr4_mrr_en:1;
            uint32_t reg_init_lpddr4_mrr0_mrw1:1;
            uint32_t reg_user_load_mode_en:1;
        } reg_0x09c;
        uint32_t reg_0x09c_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_poison_bank:4;
            uint32_t reg_ddrc_ecc_poison_rank:1;
            uint32_t reg_ddrc_ecc_poison_sdram_beat:2;
            uint32_t rsvd_7:1;
            uint32_t reg_ddrc_ecc_poison_bit_num:5;
            uint32_t reg_ddrc_ecc_poison_data_mode:1;
            uint32_t reg_ddrc_ecc_poison_en:1;
            uint32_t rsvd_15:1;
            uint32_t reg_ddrc_ecc_corr_err_info_clr:1;
            uint32_t reg_ddrc_ecc_uncorr_err_info_clr:1;
            uint32_t reg_ddrc_ecc_corr_err_cnt_clr:1;
            uint32_t reg_ddrc_ecc_uncorr_err_cnt_clr:1;
            uint32_t rsvd_20:4;
            uint32_t reg_ddrc_ecc_dis_scrub:1;
            uint32_t reg_ddrc_ecc_en:1;
        } reg_0x0a0;
        uint32_t reg_0x0a0_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_poison_col:12;
            uint32_t reg_ddrc_ecc_poison_row:17;
        } reg_0x0a4;
        uint32_t reg_0x0a4_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_efficiency_cal_en:1;
            uint32_t reg_cal_efficiency_number_cnt:3;
        } reg_0x0a8;
        uint32_t reg_0x0a8_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_efficiency_cal_cnt:31;
        } reg_0x0ac;
        uint32_t reg_0x0ac_W;
    };

    union {
        struct {
            uint32_t reg_rd_port_urgent_en0:1;
            uint32_t reg_rd_port_aging_en0:1;
            uint32_t rsvd_2:2;
            uint32_t reg_rd_port_priority0:10;
            uint32_t rsvd_14:2;
            uint32_t reg_wr_port_urgent_en0:1;
            uint32_t reg_wr_port_aging_en0:1;
            uint32_t rsvd_18:2;
            uint32_t reg_wr_priority0:10;
        } reg_0x0b0;
        uint32_t reg_0x0b0_W;
    };

    union {
        struct {
            uint32_t reg_rd_port_urgent_en1:1;
            uint32_t reg_rd_port_aging_en1:1;
            uint32_t rsvd_2:2;
            uint32_t reg_rd_port_priority1:10;
            uint32_t rsvd_14:2;
            uint32_t reg_wr_port_urgent_en1:1;
            uint32_t reg_wr_port_aging_en1:1;
            uint32_t rsvd_18:2;
            uint32_t reg_wr_priority1:10;
        } reg_0x0b4;
        uint32_t reg_0x0b4_W;
    };

    union {
        struct {
            uint32_t reg_rd_port_urgent_en2:1;
            uint32_t reg_rd_port_aging_en2:1;
            uint32_t rsvd_2:2;
            uint32_t reg_rd_port_priority2:10;
            uint32_t rsvd_14:2;
            uint32_t reg_wr_port_urgent_en2:1;
            uint32_t reg_wr_port_aging_en2:1;
            uint32_t rsvd_18:2;
            uint32_t reg_wr_priority2:10;
        } reg_0x0b8;
        uint32_t reg_0x0b8_W;
    };

    union {
        struct {
            uint32_t reg_rd_port_urgent_en3:1;
            uint32_t reg_rd_port_aging_en3:1;
            uint32_t rsvd_2:2;
            uint32_t reg_rd_port_priority3:10;
            uint32_t rsvd_14:2;
            uint32_t reg_wr_port_urgent_en3:1;
            uint32_t reg_wr_port_aging_en3:1;
            uint32_t rsvd_18:2;
            uint32_t reg_wr_priority3:10;
        } reg_0x0bc;
        uint32_t reg_0x0bc_W;
    };

    union {
        struct {
            uint32_t reg_rd_port_urgent_en4:1;
            uint32_t reg_rd_port_aging_en4:1;
            uint32_t rsvd_2:2;
            uint32_t reg_rd_port_priority4:10;
            uint32_t rsvd_14:2;
            uint32_t reg_wr_port_urgent_en4:1;
            uint32_t reg_wr_port_aging_en4:1;
            uint32_t rsvd_18:2;
            uint32_t reg_wr_priority4:10;
        } reg_0x0c0;
        uint32_t reg_0x0c0_W;
    };

    union {
        struct {
            uint32_t reg_rd_port_urgent_en5:1;
            uint32_t reg_rd_port_aging_en5:1;
            uint32_t rsvd_2:2;
            uint32_t reg_rd_port_priority5:10;
            uint32_t rsvd_14:2;
            uint32_t reg_wr_port_urgent_en5:1;
            uint32_t reg_wr_port_aging_en5:1;
            uint32_t rsvd_18:2;
            uint32_t reg_wr_priority5:10;
        } reg_0x0c4;
        uint32_t reg_0x0c4_W;
    };

    union {
        struct {
            uint32_t reg_rd_port_urgent_en6:1;
            uint32_t reg_rd_port_aging_en6:1;
            uint32_t rsvd_2:2;
            uint32_t reg_rd_port_priority6:10;
            uint32_t rsvd_14:2;
            uint32_t reg_wr_port_urgent_en6:1;
            uint32_t reg_wr_port_aging_en6:1;
            uint32_t rsvd_18:2;
            uint32_t reg_wr_priority6:10;
        } reg_0x0c8;
        uint32_t reg_0x0c8_W;
    };

    union {
        struct {
            uint32_t reg_rd_port_urgent_en7:1;
            uint32_t reg_rd_port_aging_en7:1;
            uint32_t rsvd_2:2;
            uint32_t reg_rd_port_priority7:10;
            uint32_t rsvd_14:2;
            uint32_t reg_wr_port_urgent_en7:1;
            uint32_t reg_wr_port_aging_en7:1;
            uint32_t rsvd_18:2;
            uint32_t reg_wr_priority7:10;
        } reg_0x0cc;
        uint32_t reg_0x0cc_W;
    };

    union {
        struct {
            uint32_t reg_prefer_write:1;
            uint32_t reg_pagematch_limit:1;
            uint32_t reg_go2critical_en:1;
        } reg_0x0d0;
        uint32_t reg_0x0d0_W;
    };

    union {
        struct {
            uint32_t reg_wr2rd_switch_threhold:8;
            uint32_t reg_rd2wr_switch_threhold:8;
            uint32_t reg_rd_starve_time:8;
            uint32_t reg_wr_starve_time:8;
        } reg_0x0d4;
        uint32_t reg_0x0d4_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_wodt_st_bp:1;
            uint32_t reg_ddrc_wodt_always_open:1;
            uint32_t reg_ddrc_wodt_disable:1;
            uint32_t rsvd_3:5;
            uint32_t reg_ddrc_wodt_length:5;
            uint32_t rsvd_13:3;
            uint32_t reg_ddrc_wodt_delay:6;
        } reg_0x0d8;
        uint32_t reg_0x0d8_W;
    };

    union {
        struct {
            uint32_t reg_cwl_al_cl_bp:1;
            uint32_t rsvd_1:7;
            uint32_t reg_cl_bp:6;
            uint32_t rsvd_14:2;
            uint32_t reg_cwl_bp:6;
            uint32_t rsvd_22:2;
            uint32_t reg_al_bp:5;
        } reg_0x0dc;
        uint32_t reg_0x0dc_W;
    };

    union {
        struct {
            uint32_t reg_dfi_trdata_en_bp:1;
            uint32_t reg_dfi_tphy_wrlat_bp:1;
            uint32_t rsvd_2:6;
            uint32_t reg_dfi_trdata_en:5;
            uint32_t rsvd_13:3;
            uint32_t reg_ddrc_tctrl_delay:8;
            uint32_t reg_dfi_tphy_wrlat:5;
        } reg_0x0e0;
        uint32_t reg_0x0e0_W;
    };

    union {
        struct {
            uint32_t reg_wqueue_max_dep:6;
            uint32_t rsvd_6:2;
            uint32_t reg_lp_rqueue_max_dep:6;
            uint32_t rsvd_14:2;
            uint32_t reg_hp_rqueue_max_dep:6;
        } reg_0x0e4;
        uint32_t reg_0x0e4_W;
    };

    union {
        struct {
            uint32_t reg_bist_en:1;
            uint32_t reg_bist_start:1;
            uint32_t reg_bist_soft_rstn:1;
            uint32_t reg_bist_serial_wr_stop:1;
            uint32_t reg_bist_mode_sel:3;
            uint32_t reg_bist_data_pattern_sel:3;
            uint32_t reg_bist_addr_pattern_sel:3;
            uint32_t reg_bist_data_obs_sel:1;
            uint32_t reg_bit_sel:4;
        } reg_0x0e8;
        uint32_t reg_0x0e8_W;
    };

    union {
        struct {
            uint32_t reg_bist_start_addr:32;
        } reg_0x0ec;
        uint32_t reg_0x0ec_W;
    };

    union {
        struct {
            uint32_t reg_bist_end_addr:32;
        } reg_0x0f0;
        uint32_t reg_0x0f0_W;
    };

    union {
        struct {
            uint32_t reg_bist_data:32;
        } reg_0x0f4;
        uint32_t reg_0x0f4_W;
    };

    union {
        struct {
            uint32_t reg_bist_data0:32;
        } reg_0x0f8;
        uint32_t reg_0x0f8_W;
    };

    union {
        struct {
            uint32_t reg_bist_data1:32;
        } reg_0x0fc;
        uint32_t reg_0x0fc_W;
    };

    union {
        struct {
            uint32_t reg_bist_data2:32;
        } reg_0x100;
        uint32_t reg_0x100_W;
    };

    union {
        struct {
            uint32_t reg_bist_data3:32;
        } reg_0x104;
        uint32_t reg_0x104_W;
    };

    union {
        struct {
            uint32_t reg_bist_prbs_sel:1;
        } reg_0x108;
        uint32_t reg_0x108_W;
    };

    union {
        struct {
            uint32_t reg_bist_data_mask_0:32;
        } reg_0x10c;
        uint32_t reg_0x10c_W;
    };

    union {
        struct {
            uint32_t reg_bist_data_mask_1:32;
        } reg_0x110;
        uint32_t reg_0x110_W;
    };

    union {
        struct {
            uint32_t reg_bist_data_mask_2:16;
        } reg_0x114;
        uint32_t reg_0x114_W;
    };

    union {
        struct {
            uint32_t reg_bist_ecnt_set:8;
        } reg_0x118;
        uint32_t reg_0x118_W;
    };

    union {
        struct {
            uint32_t reg_bist_eaddr_set:32;
        } reg_0x11c;
        uint32_t reg_0x11c_W;
    };

    union {
        struct {
            uint32_t reg_bist_ebit_set_0:32;
        } reg_0x120;
        uint32_t reg_0x120_W;
    };

    union {
        struct {
            uint32_t reg_bist_ebit_set_1:32;
        } reg_0x124;
        uint32_t reg_0x124_W;
    };

    union {
        struct {
            uint32_t reg_bist_ebit_set_2:32;
        } reg_0x128;
        uint32_t reg_0x128_W;
    };

    union {
        struct {
            uint32_t reg_error_cnt_dqn_obs:7;
        } reg_0x12c;
        uint32_t reg_0x12c_W;
    };

    union {
        struct {
            uint32_t reg_error_cnt_dqn:16;
        } reg_0x130;
        uint32_t reg_0x130_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq0:32;
        } reg_0x134;
        uint32_t reg_0x134_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq1:32;
        } reg_0x138;
        uint32_t reg_0x138_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq2:32;
        } reg_0x13c;
        uint32_t reg_0x13c_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq3:32;
        } reg_0x140;
        uint32_t reg_0x140_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq4:32;
        } reg_0x144;
        uint32_t reg_0x144_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq5:32;
        } reg_0x148;
        uint32_t reg_0x148_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq6:32;
        } reg_0x14c;
        uint32_t reg_0x14c_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq7:32;
        } reg_0x150;
        uint32_t reg_0x150_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq8:32;
        } reg_0x154;
        uint32_t reg_0x154_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq9:32;
        } reg_0x158;
        uint32_t reg_0x158_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq10:32;
        } reg_0x15c;
        uint32_t reg_0x15c_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq11:32;
        } reg_0x160;
        uint32_t reg_0x160_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq12:32;
        } reg_0x164;
        uint32_t reg_0x164_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq13:32;
        } reg_0x168;
        uint32_t reg_0x168_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq14:32;
        } reg_0x16c;
        uint32_t reg_0x16c_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq15:32;
        } reg_0x170;
        uint32_t reg_0x170_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq16:32;
        } reg_0x174;
        uint32_t reg_0x174_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq17:32;
        } reg_0x178;
        uint32_t reg_0x178_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq18:32;
        } reg_0x17c;
        uint32_t reg_0x17c_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq19:32;
        } reg_0x180;
        uint32_t reg_0x180_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq20:32;
        } reg_0x184;
        uint32_t reg_0x184_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq21:32;
        } reg_0x188;
        uint32_t reg_0x188_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq22:32;
        } reg_0x18c;
        uint32_t reg_0x18c_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq23:32;
        } reg_0x190;
        uint32_t reg_0x190_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq24:32;
        } reg_0x194;
        uint32_t reg_0x194_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq25:32;
        } reg_0x198;
        uint32_t reg_0x198_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq26:32;
        } reg_0x19c;
        uint32_t reg_0x19c_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq27:32;
        } reg_0x1a0;
        uint32_t reg_0x1a0_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq28:32;
        } reg_0x1a4;
        uint32_t reg_0x1a4_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq29:32;
        } reg_0x1a8;
        uint32_t reg_0x1a8_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq30:32;
        } reg_0x1ac;
        uint32_t reg_0x1ac_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq31:32;
        } reg_0x1b0;
        uint32_t reg_0x1b0_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq32:32;
        } reg_0x1b4;
        uint32_t reg_0x1b4_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq33:32;
        } reg_0x1b8;
        uint32_t reg_0x1b8_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq34:32;
        } reg_0x1bc;
        uint32_t reg_0x1bc_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq35:32;
        } reg_0x1c0;
        uint32_t reg_0x1c0_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq36:32;
        } reg_0x1c4;
        uint32_t reg_0x1c4_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq37:32;
        } reg_0x1c8;
        uint32_t reg_0x1c8_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq38:32;
        } reg_0x1cc;
        uint32_t reg_0x1cc_W;
    };

    union {
        struct {
            uint32_t reg_random_seed_dq39:32;
        } reg_0x1d0;
        uint32_t reg_0x1d0_W;
    };

    union {
        struct {
            uint32_t reg_bist_ar_start_row:32;
        } reg_0x1d4;
        uint32_t reg_0x1d4_W;
    };

    union {
        struct {
            uint32_t reg_sdram_col_size:4;
            uint32_t reg_sdram_row_size:5;
            uint32_t reg_sdram_bank_size:3;
            uint32_t rsvd_12:2;
            uint32_t reg_sdram_rank_size:1;
        } reg_0x1d8;
        uint32_t reg_0x1d8_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_col_offset_bit0:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_col_offset_bit1:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_col_offset_bit2:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ddrc_col_offset_bit3:6;
        } reg_0x1dc;
        uint32_t reg_0x1dc_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_col_offset_bit4:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_col_offset_bit5:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_col_offset_bit6:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ddrc_col_offset_bit7:6;
        } reg_0x1e0;
        uint32_t reg_0x1e0_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_col_offset_bit8:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_col_offset_bit9:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_col_offset_bit10:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ddrc_col_offset_bit11:6;
        } reg_0x1e4;
        uint32_t reg_0x1e4_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_row_offset_bit0:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_row_offset_bit1:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_row_offset_bit2:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ddrc_row_offset_bit3:6;
        } reg_0x1e8;
        uint32_t reg_0x1e8_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_row_offset_bit4:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_row_offset_bit5:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_row_offset_bit6:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ddrc_row_offset_bit7:6;
        } reg_0x1ec;
        uint32_t reg_0x1ec_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_row_offset_bit8:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_row_offset_bit9:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_row_offset_bit10:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ddrc_row_offset_bit11:6;
        } reg_0x1f0;
        uint32_t reg_0x1f0_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_row_offset_bit12:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_row_offset_bit13:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_row_offset_bit14:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ddrc_row_offset_bit15:6;
        } reg_0x1f4;
        uint32_t reg_0x1f4_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_row_offset_bit16:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_row_offset_bit17:6;
        } reg_0x1f8;
        uint32_t reg_0x1f8_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ba_offset_bit0:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_ba_offset_bit1:6;
            uint32_t rsvd_14:2;
            uint32_t reg_ddrc_ba_offset_bit2:6;
            uint32_t rsvd_22:2;
            uint32_t reg_ddrc_ba_offset_bit3:6;
        } reg_0x1fc;
        uint32_t reg_0x1fc_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_rank_offset_bit0:6;
            uint32_t rsvd_6:2;
            uint32_t reg_ddrc_rank_offset_bit1:6;
        } reg_0x200;
        uint32_t reg_0x200_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_addrmap_hash_en:1;
        } reg_0x204;
        uint32_t reg_0x204_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_valid_rank_channel:2;
            uint32_t reg_ddrc_valid_rank_num:4;
        } reg_0x208;
        uint32_t reg_0x208_W;
    };

    union {
        struct {
            uint32_t reg_pageclose_en:1;
            uint32_t rsvd_1:7;
            uint32_t reg_pageclose_timer:8;
            uint32_t reg_wdbi_en:1;
            uint32_t reg_ddr4_rdbi_en:1;
        } reg_0x20c;
        uint32_t reg_0x20c_W;
    };

    union {
        struct {
            uint32_t reg_auto_ref_gen:1;
            uint32_t reg_ddrc_auto_ref_mode:1;
            uint32_t reg_ddrc_auto_ref_dis:1;
            uint32_t rsvd_3:5;
            uint32_t reg_ddrc_auto_ref_pre_margin:8;
            uint32_t reg_ddrc_auto_ref_burst:3;
        } reg_0x210;
        uint32_t reg_0x210_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode01:16;
            uint32_t reg_lpddrn_ddrn_load_mode00:16;
        } reg_0x214;
        uint32_t reg_0x214_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode03:16;
            uint32_t reg_lpddrn_ddrn_load_mode02:16;
        } reg_0x218;
        uint32_t reg_0x218_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode05:16;
            uint32_t reg_lpddrn_ddrn_load_mode04:16;
        } reg_0x21c;
        uint32_t reg_0x21c_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode07:16;
            uint32_t reg_lpddrn_ddrn_load_mode06:16;
        } reg_0x220;
        uint32_t reg_0x220_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode09:16;
            uint32_t reg_lpddrn_ddrn_load_mode08:16;
        } reg_0x224;
        uint32_t reg_0x224_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode11:16;
            uint32_t reg_lpddrn_ddrn_load_mode10:16;
        } reg_0x228;
        uint32_t reg_0x228_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode13:16;
            uint32_t reg_lpddrn_ddrn_load_mode12:16;
        } reg_0x22c;
        uint32_t reg_0x22c_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode15:16;
            uint32_t reg_lpddrn_ddrn_load_mode14:16;
        } reg_0x230;
        uint32_t reg_0x230_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode17:16;
            uint32_t reg_lpddrn_ddrn_load_mode16:16;
        } reg_0x234;
        uint32_t reg_0x234_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode19:16;
            uint32_t reg_lpddrn_ddrn_load_mode18:16;
        } reg_0x238;
        uint32_t reg_0x238_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode21:16;
            uint32_t reg_lpddrn_ddrn_load_mode20:16;
        } reg_0x23c;
        uint32_t reg_0x23c_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode23:16;
            uint32_t reg_lpddrn_ddrn_load_mode22:16;
        } reg_0x240;
        uint32_t reg_0x240_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode25:16;
            uint32_t reg_lpddrn_ddrn_load_mode24:16;
        } reg_0x244;
        uint32_t reg_0x244_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode27:16;
            uint32_t reg_lpddrn_ddrn_load_mode26:16;
        } reg_0x248;
        uint32_t reg_0x248_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode29:16;
            uint32_t reg_lpddrn_ddrn_load_mode28:16;
        } reg_0x24c;
        uint32_t reg_0x24c_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode31:16;
            uint32_t reg_lpddrn_ddrn_load_mode30:16;
        } reg_0x250;
        uint32_t reg_0x250_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode33:16;
            uint32_t reg_lpddrn_ddrn_load_mode32:16;
        } reg_0x254;
        uint32_t reg_0x254_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode35:16;
            uint32_t reg_lpddrn_ddrn_load_mode34:16;
        } reg_0x258;
        uint32_t reg_0x258_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode37:16;
            uint32_t reg_lpddrn_ddrn_load_mode36:16;
        } reg_0x25c;
        uint32_t reg_0x25c_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode39:16;
            uint32_t reg_lpddrn_ddrn_load_mode38:16;
        } reg_0x260;
        uint32_t reg_0x260_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode41:16;
            uint32_t reg_lpddrn_ddrn_load_mode40:16;
        } reg_0x264;
        uint32_t reg_0x264_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode43:16;
            uint32_t reg_lpddrn_ddrn_load_mode42:16;
        } reg_0x268;
        uint32_t reg_0x268_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode45:16;
            uint32_t reg_lpddrn_ddrn_load_mode44:16;
        } reg_0x26c;
        uint32_t reg_0x26c_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode47:16;
            uint32_t reg_lpddrn_ddrn_load_mode46:16;
        } reg_0x270;
        uint32_t reg_0x270_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode49:16;
            uint32_t reg_lpddrn_ddrn_load_mode48:16;
        } reg_0x274;
        uint32_t reg_0x274_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode51:16;
            uint32_t reg_lpddrn_ddrn_load_mode50:16;
        } reg_0x278;
        uint32_t reg_0x278_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode53:16;
            uint32_t reg_lpddrn_ddrn_load_mode52:16;
        } reg_0x27c;
        uint32_t reg_0x27c_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode55:16;
            uint32_t reg_lpddrn_ddrn_load_mode54:16;
        } reg_0x280;
        uint32_t reg_0x280_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode57:16;
            uint32_t reg_lpddrn_ddrn_load_mode56:16;
        } reg_0x284;
        uint32_t reg_0x284_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode59:16;
            uint32_t reg_lpddrn_ddrn_load_mode58:16;
        } reg_0x288;
        uint32_t reg_0x288_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode61:16;
            uint32_t reg_lpddrn_ddrn_load_mode60:16;
        } reg_0x28c;
        uint32_t reg_0x28c_W;
    };

    union {
        struct {
            uint32_t reg_lpddrn_ddrn_load_mode63:16;
            uint32_t reg_lpddrn_ddrn_load_mode62:16;
        } reg_0x290;
        uint32_t reg_0x290_W;
    };

    union {
        struct {
            uint32_t reg_lpddr23_preact_before_mrwreset:1;
            uint32_t reg_lpddr23_preall_before_mrwreset:1;
            uint32_t reg_init_lpddr23_pd_en:1;
            uint32_t reg_init_lpddr23_mrr_en:1;
            uint32_t lpddr23_init_prepb_bank:3;
            uint32_t rsvd_7:1;
            uint32_t timer_lpddr23_pd_wait_select:2;
            uint32_t timer_lpddr23_pd_exit_select:2;
            uint32_t timer_lpddr23_pd_entry_select:2;
            uint32_t reg_init_ddr34_mirror_en:1;
        } reg_0x294;
        uint32_t reg_0x294_W;
    };

    union {
        struct {
            uint32_t reg_lpddr23_load_mode_mrwzqcl:16;
            uint32_t reg_lpddr23_load_mode_mrwreset:16;
        } reg_0x298;
        uint32_t reg_0x298_W;
    };

    union {
        struct {
            uint32_t reg_lpddr23_load_mode_read:16;
        } reg_0x29c;
        uint32_t reg_0x29c_W;
    };

    union {
        struct {
            uint32_t reg_init_lpddr23_pd_wait:8;
            uint32_t reg_init_lpddr23_pd_entry:8;
            uint32_t reg_init_lpddr23_pd_exit:8;
        } reg_0x2a0;
        uint32_t reg_0x2a0_W;
    };

    union {
        struct {
            uint32_t reg_bufferen_core:1;
            uint32_t reg_dfi_idle_en:1;
            uint32_t reg_lpddr4_modevref_bp:1;
            uint32_t reg_lpddr4_tccdmw_bp:1;
            uint32_t mrr_dai:1;
            uint32_t rsvd_5:3;
            uint32_t reg_mrwreset_1us:8;
            uint32_t reg_mrr_pulse:8;
            uint32_t reg_dfi_frequency:5;
        } reg_0x2a4;
        uint32_t reg_0x2a4_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_mr4_read_interval_x32:32;
        } reg_0x2a8;
        uint32_t reg_0x2a8_W;
    };

    union {
        struct {
            uint32_t reg_lpddr45_derated_en:1;
            uint32_t reg_lpddr45_derated_pause:1;
            uint32_t reg_ddrc_mr4_tuf_dis:1;
            uint32_t reg_derated_trefi_x0p125_dis:1;
            uint32_t reg_derated_trefi_x6x8_dis:1;
            uint32_t reg_derated_limit_exceed_intr_clr:1;
            uint32_t rsvd_6:2;
            uint32_t reg_mrr_active_byte:4;
        } reg_0x2ac;
        uint32_t reg_0x2ac_W;
    };

    union {
        struct {
            uint32_t reg_byte0_wrap_ctrl_sel:2;
            uint32_t reg_byte1_wrap_ctrl_sel:2;
            uint32_t reg_byte2_wrap_ctrl_sel:2;
            uint32_t reg_byte3_wrap_ctrl_sel:2;
        } reg_0x2b0;
        uint32_t reg_0x2b0_W;
    };

    union {
        struct {
            uint32_t reg_byte0_dq7_wrap_sel:3;
            uint32_t reg_byte0_dq6_wrap_sel:3;
            uint32_t reg_byte0_dq5_wrap_sel:3;
            uint32_t reg_byte0_dq4_wrap_sel:3;
            uint32_t reg_byte0_dq3_wrap_sel:3;
            uint32_t reg_byte0_dq2_wrap_sel:3;
            uint32_t reg_byte0_dq1_wrap_sel:3;
            uint32_t reg_byte0_dq0_wrap_sel:3;
        } reg_0x2b4;
        uint32_t reg_0x2b4_W;
    };

    union {
        struct {
            uint32_t reg_byte1_dq7_wrap_sel:3;
            uint32_t reg_byte1_dq6_wrap_sel:3;
            uint32_t reg_byte1_dq5_wrap_sel:3;
            uint32_t reg_byte1_dq4_wrap_sel:3;
            uint32_t reg_byte1_dq3_wrap_sel:3;
            uint32_t reg_byte1_dq2_wrap_sel:3;
            uint32_t reg_byte1_dq1_wrap_sel:3;
            uint32_t reg_byte1_dq0_wrap_sel:3;
        } reg_0x2b8;
        uint32_t reg_0x2b8_W;
    };

    union {
        struct {
            uint32_t reg_byte2_dq7_wrap_sel:3;
            uint32_t reg_byte2_dq6_wrap_sel:3;
            uint32_t reg_byte2_dq5_wrap_sel:3;
            uint32_t reg_byte2_dq4_wrap_sel:3;
            uint32_t reg_byte2_dq3_wrap_sel:3;
            uint32_t reg_byte2_dq2_wrap_sel:3;
            uint32_t reg_byte2_dq1_wrap_sel:3;
            uint32_t reg_byte2_dq0_wrap_sel:3;
        } reg_0x2bc;
        uint32_t reg_0x2bc_W;
    };

    union {
        struct {
            uint32_t reg_byte3_dq7_wrap_sel:3;
            uint32_t reg_byte3_dq6_wrap_sel:3;
            uint32_t reg_byte3_dq5_wrap_sel:3;
            uint32_t reg_byte3_dq4_wrap_sel:3;
            uint32_t reg_byte3_dq3_wrap_sel:3;
            uint32_t reg_byte3_dq2_wrap_sel:3;
            uint32_t reg_byte3_dq1_wrap_sel:3;
            uint32_t reg_byte3_dq0_wrap_sel:3;
        } reg_0x2c0;
        uint32_t reg_0x2c0_W;
    };

    union {
        struct {
            uint32_t phy_init_complete_to_reg:1;
            uint32_t sdram_init_done_to_reg:1;
            uint32_t ddrc_init_act:1;
            uint32_t rsvd_3:26;
            uint32_t reg_dfi_lp_exit_handshake_timeout:1;
            uint32_t reg_dfi_lp_entry_handshake_fail:1;
        } reg_0x2c4;
        uint32_t reg_0x2c4_W;
    };

    union {
        struct {
            uint32_t reg_bist_done:1;
            uint32_t reg_bist_pass:1;
            uint32_t rsvd_2:2;
            uint32_t reg_bist_state:7;
            uint32_t rsvd_11:5;
            uint32_t reg_data_bist_state:7;
            uint32_t rsvd_23:1;
            uint32_t reg_bist_error_cnt:8;
        } reg_0x2c8;
        uint32_t reg_0x2c8_W;
    };

    union {
        struct {
            uint32_t reg_bist_error_addr_obs:32;
        } reg_0x2cc;
        uint32_t reg_0x2cc_W;
    };

    union {
        struct {
            uint32_t reg_bist_error_addr_obs:2;
        } reg_0x2d0;
        uint32_t reg_0x2d0_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_9:32;
        } reg_0x2d4;
        uint32_t reg_0x2d4_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_8:32;
        } reg_0x2d8;
        uint32_t reg_0x2d8_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_7:32;
        } reg_0x2dc;
        uint32_t reg_0x2dc_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_6:32;
        } reg_0x2e0;
        uint32_t reg_0x2e0_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_5:32;
        } reg_0x2e4;
        uint32_t reg_0x2e4_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_4:32;
        } reg_0x2e8;
        uint32_t reg_0x2e8_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_9:32;
        } reg_0x2ec;
        uint32_t reg_0x2ec_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_8:32;
        } reg_0x2f0;
        uint32_t reg_0x2f0_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_7:32;
        } reg_0x2f4;
        uint32_t reg_0x2f4_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_6:32;
        } reg_0x2f8;
        uint32_t reg_0x2f8_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_5:32;
        } reg_0x2fc;
        uint32_t reg_0x2fc_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_4:32;
        } reg_0x300;
        uint32_t reg_0x300_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_3:32;
        } reg_0x304;
        uint32_t reg_0x304_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_2:32;
        } reg_0x308;
        uint32_t reg_0x308_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_1:32;
        } reg_0x30c;
        uint32_t reg_0x30c_W;
    };

    union {
        struct {
            uint32_t reg_bist_act_data_obs_sel_0:32;
        } reg_0x310;
        uint32_t reg_0x310_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_3:32;
        } reg_0x314;
        uint32_t reg_0x314_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_2:32;
        } reg_0x318;
        uint32_t reg_0x318_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_1:32;
        } reg_0x31c;
        uint32_t reg_0x31c_W;
    };

    union {
        struct {
            uint32_t reg_bist_exp_data_obs_sel_0:32;
        } reg_0x320;
        uint32_t reg_0x320_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data9:32;
        } reg_0x324;
        uint32_t reg_0x324_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data8:32;
        } reg_0x328;
        uint32_t reg_0x328_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data7:32;
        } reg_0x32c;
        uint32_t reg_0x32c_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data6:32;
        } reg_0x330;
        uint32_t reg_0x330_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data5:32;
        } reg_0x334;
        uint32_t reg_0x334_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data4:32;
        } reg_0x338;
        uint32_t reg_0x338_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data3:32;
        } reg_0x33c;
        uint32_t reg_0x33c_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data2:32;
        } reg_0x340;
        uint32_t reg_0x340_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data1:32;
        } reg_0x344;
        uint32_t reg_0x344_W;
    };

    union {
        struct {
            uint32_t reg_bist_back_data0:32;
        } reg_0x348;
        uint32_t reg_0x348_W;
    };

    union {
        struct {
            uint32_t reg_ar_row_table_overflow:16;
        } reg_0x34c;
        uint32_t reg_0x34c_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_bit_num:32;
        } reg_0x350;
        uint32_t reg_0x350_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_bit_num:32;
        } reg_0x354;
        uint32_t reg_0x354_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_bit_num:8;
        } reg_0x358;
        uint32_t reg_0x358_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_uncorr_err_cnt:16;
        } reg_0x35c;
        uint32_t reg_0x35c_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_err_cnt:16;
        } reg_0x360;
        uint32_t reg_0x360_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_uncorr_err_bank:4;
            uint32_t reg_ddrc_ecc_uncorr_err_rank:1;
            uint32_t rsvd_5:3;
            uint32_t reg_ddrc_ecc_corr_err:4;
            uint32_t reg_ddrc_ecc_uncorr_err:4;
        } reg_0x364;
        uint32_t reg_0x364_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_uncorr_err_col:12;
            uint32_t reg_ddrc_ecc_uncorr_err_row:17;
        } reg_0x368;
        uint32_t reg_0x368_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_err_bank:4;
            uint32_t reg_ddrc_ecc_corr_err_rank:1;
        } reg_0x36c;
        uint32_t reg_0x36c_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_err_col:12;
            uint32_t reg_ddrc_ecc_corr_err_row:17;
        } reg_0x370;
        uint32_t reg_0x370_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_exp_data:32;
        } reg_0x374;
        uint32_t reg_0x374_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_exp_data:32;
        } reg_0x378;
        uint32_t reg_0x378_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_act_data:32;
        } reg_0x37c;
        uint32_t reg_0x37c_W;
    };

    union {
        struct {
            uint32_t reg_ddrc_ecc_corr_act_data:32;
        } reg_0x380;
        uint32_t reg_0x380_W;
    };

    union {
        struct {
            uint32_t ulm_state_to_reg:32;
        } reg_0x384;
        uint32_t reg_0x384_W;
    };

    union {
        struct {
            uint32_t core_cmd_empty_to_reg:1;
            uint32_t rsvd_1:3;
            uint32_t pd_fsm_cs_to_reg:4;
            uint32_t sr_fsm_cs_to_reg:3;
            uint32_t rsvd_11:1;
            uint32_t imc_gs_fsm_to_reg:6;
            uint32_t rsvd_18:6;
            uint32_t rank0_auto_ref_cs_to_reg:4;
            uint32_t rank1_auto_ref_cs_to_reg:4;
        } reg_0x388;
        uint32_t reg_0x388_W;
    };

    union {
        struct {
            uint32_t rcmd_pending_to_reg:32;
        } reg_0x38c;
        uint32_t reg_0x38c_W;
    };

    union {
        struct {
            uint32_t wcmd_pending_to_reg:32;
        } reg_0x390;
        uint32_t reg_0x390_W;
    };

    union {
        struct {
            uint32_t write_effi_value_cnt0:32;
        } reg_0x394;
        uint32_t reg_0x394_W;
    };

    union {
        struct {
            uint32_t read_effi_value_cnt0:32;
        } reg_0x398;
        uint32_t reg_0x398_W;
    };

    union {
        struct {
            uint32_t write_effi_value_cnt1:32;
        } reg_0x39c;
        uint32_t reg_0x39c_W;
    };

    union {
        struct {
            uint32_t read_effi_value_cnt1:32;
        } reg_0x3a0;
        uint32_t reg_0x3a0_W;
    };

    union {
        struct {
            uint32_t write_effi_value_cnt2:32;
        } reg_0x3a4;
        uint32_t reg_0x3a4_W;
    };

    union {
        struct {
            uint32_t read_effi_value_cnt2:32;
        } reg_0x3a8;
        uint32_t reg_0x3a8_W;
    };

    union {
        struct {
            uint32_t write_effi_value_cnt3:32;
        } reg_0x3ac;
        uint32_t reg_0x3ac_W;
    };

    union {
        struct {
            uint32_t read_effi_value_cnt3:32;
        } reg_0x3b0;
        uint32_t reg_0x3b0_W;
    };

    union {
        struct {
            uint32_t write_effi_value_cnt4:32;
        } reg_0x3b4;
        uint32_t reg_0x3b4_W;
    };

    union {
        struct {
            uint32_t read_effi_value_cnt4:32;
        } reg_0x3b8;
        uint32_t reg_0x3b8_W;
    };

    union {
        struct {
            uint32_t write_effi_value_cnt5:32;
        } reg_0x3bc;
        uint32_t reg_0x3bc_W;
    };

    union {
        struct {
            uint32_t read_effi_value_cnt5:32;
        } reg_0x3c0;
        uint32_t reg_0x3c0_W;
    };

    union {
        struct {
            uint32_t write_effi_value_cnt6:32;
        } reg_0x3c4;
        uint32_t reg_0x3c4_W;
    };

    union {
        struct {
            uint32_t read_effi_value_cnt6:32;
        } reg_0x3c8;
        uint32_t reg_0x3c8_W;
    };

    union {
        struct {
            uint32_t write_effi_value_cnt7:32;
        } reg_0x3cc;
        uint32_t reg_0x3cc_W;
    };

    union {
        struct {
            uint32_t read_effi_value_cnt7:32;
        } reg_0x3d0;
        uint32_t reg_0x3d0_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data_en:1;
        } reg_0x3d4;
        uint32_t reg_0x3d4_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data1:32;
        } reg_0x3d8;
        uint32_t reg_0x3d8_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data2:32;
        } reg_0x3dc;
        uint32_t reg_0x3dc_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data3:32;
        } reg_0x3e0;
        uint32_t reg_0x3e0_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data4:32;
        } reg_0x3e4;
        uint32_t reg_0x3e4_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data5:32;
        } reg_0x3e8;
        uint32_t reg_0x3e8_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data6:32;
        } reg_0x3ec;
        uint32_t reg_0x3ec_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data7:32;
        } reg_0x3f0;
        uint32_t reg_0x3f0_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data8:32;
        } reg_0x3f4;
        uint32_t reg_0x3f4_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data9:32;
        } reg_0x3f8;
        uint32_t reg_0x3f8_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data10:32;
        } reg_0x3fc;
        uint32_t reg_0x3fc_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data11:32;
        } reg_0x400;
        uint32_t reg_0x400_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data12:32;
        } reg_0x404;
        uint32_t reg_0x404_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data13:32;
        } reg_0x408;
        uint32_t reg_0x408_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data14:32;
        } reg_0x40c;
        uint32_t reg_0x40c_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data15:32;
        } reg_0x410;
        uint32_t reg_0x410_W;
    };

    union {
        struct {
            uint32_t reg_user_mrr_data16:32;
        } reg_0x414;
        uint32_t reg_0x414_W;
    };

} INNO_DDR_CTRL_Register_Table_s;
#endif
