#ifndef MIPI_Register_Table_RX__H
#define MIPI_Register_Table_RX__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t PHYA_RX_PDATA_RESET_N:1;
            uint32_t rsvd_1:7;
            uint32_t LINK_P0_RST_N:1;
        } reg_0x000;
        uint32_t reg_0x000_W;
    };

    union {
        struct {
            uint32_t MODE_P0_OPERATION:3;
        } reg_0x004;
        uint32_t reg_0x004_W;
    };

    uint32_t rsvd_0x8[0x4/4];

    union {
        struct {
            uint32_t PHYA_RX_MODE:3;
        } reg_0x00C;
        uint32_t reg_0x00C_W;
    };

    union {
        struct {
            uint32_t MODE_P0_PIX_PARA:2;
        } reg_0x010;
        uint32_t reg_0x010_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_IREF_POW_EN:1;
        } reg_0x014;
        uint32_t reg_0x014_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_C0_HS_AMP_POW_EN:1;
            uint32_t rsvd_1:15;
            uint32_t PHYA_RX_C0_LP_AMP_POW_EN:1;
        } reg_0x018;
        uint32_t reg_0x018_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_D0_LP_AMP_POW_EN:1;
            uint32_t PHYA_RX_D1_LP_AMP_POW_EN:1;
            uint32_t PHYA_RX_D2_LP_AMP_POW_EN:1;
            uint32_t PHYA_RX_D3_LP_AMP_POW_EN:1;
        } reg_0x01C;
        uint32_t reg_0x01C_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_D0_HS_AMP_POW_EN:1;
            uint32_t PHYA_RX_D1_HS_AMP_POW_EN:1;
            uint32_t PHYA_RX_D2_HS_AMP_POW_EN:1;
            uint32_t PHYA_RX_D3_HS_AMP_POW_EN:1;
        } reg_0x020;
        uint32_t reg_0x020_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_C0_RES_EN:1;
        } reg_0x024;
        uint32_t reg_0x024_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_D0_RES_EN:1;
            uint32_t PHYA_RX_D1_RES_EN:1;
            uint32_t PHYA_RX_D2_RES_EN:1;
            uint32_t PHYA_RX_D3_RES_EN:1;
        } reg_0x028;
        uint32_t reg_0x028_W;
    };

    uint32_t rsvd_0x2c[0x8/4];

    union {
        struct {
            uint32_t PHYA_RX_RESCTL:4;
        } reg_0x034;
        uint32_t reg_0x034_W;
    };

    uint32_t rsvd_0x38[0x28/4];

    union {
        struct {
            uint32_t PHYA_RX_BUS_MODE:3;
        } reg_0x060;
        uint32_t reg_0x060_W;
    };

    uint32_t rsvd_0x64[0x24/4];

    union {
        struct {
            uint32_t PHYA_RX_VRMSEL:1;
            uint32_t rsvd_1:3;
            uint32_t PHYA_RX_IRMSEL:1;
        } reg_0x088;
        uint32_t reg_0x088_W;
    };

    uint32_t rsvd_0x8c[0x1c/4];

    union {
        struct {
            uint32_t PHYA_RX_OFFSET:2;
            uint32_t rsvd_10:6;
            uint32_t PHYA_RX_LP_LH:2;
            uint32_t rsvd_18:2;
            uint32_t PHYA_RX_LP_HL:2;
        } reg_0x0A8;
        uint32_t reg_0x0A8_W;
    };

    union {
        struct {
            uint32_t MODE_P0_LBL:2;
            uint32_t rsvd_2:2;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_EN:4;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_0:4;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_1:4;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_2:4;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_3:4;
        } reg_0x0AC;
        uint32_t reg_0x0AC_W;
    };

    uint32_t rsvd_0xb0[0x68/4];

    union {
        struct {
            uint32_t DPHY_P0_MODE_LANENUM:3;
            uint32_t rsvd_3:13;
            uint32_t DPHY_P0_LP_SYNC_OFF:1;
            uint32_t rsvd_17:3;
            uint32_t DPHY_P0_MODE_HSDM_OFF:1;
            uint32_t rsvd_21:3;
            uint32_t DPHY_P0_MODE_MSB_FIRST:1;
            uint32_t rsvd_25:3;
            uint32_t DPHY_P0_MODE_LPOP_OFF:1;
        } reg_0x118;
        uint32_t reg_0x118_W;
    };

    uint32_t rsvd_0x11c[0x4/4];

    union {
        struct {
            uint32_t DPHY_P0_PREG_DLM_0:3;
            uint32_t rsvd_3:1;
            uint32_t DPHY_P0_PREG_DLM_1:3;
            uint32_t rsvd_7:1;
            uint32_t DPHY_P0_PREG_DLM_2:3;
            uint32_t rsvd_11:1;
            uint32_t DPHY_P0_PREG_DLM_3:3;
        } reg_0x120;
        uint32_t reg_0x120_W;
    };

    uint32_t rsvd_0x124[0x40/4];

    union {
        struct {
            uint32_t DPHY_P0_TIME_HS_ON:16;
            uint32_t DPHY_P0_TIME_RES_ON:16;
        } reg_0x164;
        uint32_t reg_0x164_W;
    };

    uint32_t rsvd_0x168[0x1c/4];

    union {
        struct {
            uint32_t CSI2_P0_STATE:3;
        } reg_0x184;
        uint32_t reg_0x184_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_DATA_ID:8;
            uint32_t CSI2_P0_WC:16;
            uint32_t CSI2_P0_ECC:8;
        } reg_0x188;
        uint32_t reg_0x188_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_LINE_LENGTH:16;
            uint32_t CSI2_P0_PKT_COUNT:16;
        } reg_0x18C;
        uint32_t reg_0x18C_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_ERR_ECC:16;
            uint32_t CSI2_P0_ERR_CS:16;
        } reg_0x190;
        uint32_t reg_0x190_W;
    };

    uint32_t rsvd_0x194[0x10c/4];

    union {
        struct {
            uint32_t APP_P0_CHK_HENA:1;
            uint32_t APP_P0_CHK_VENA:1;
        } reg_0x2A0;
        uint32_t reg_0x2A0_W;
    };

    union {
        struct {
            uint32_t APP_P0_CHK_HSIZE:16;
            uint32_t APP_P0_CHK_VSIZE:16;
        } reg_0x2A4;
        uint32_t reg_0x2A4_W;
    };

    uint32_t rsvd_0x2a8[0xa64/4];

    union {
        struct {
            uint32_t DPHY_P0_ERR_DET_SC_0:8;
            uint32_t DPHY_P0_ERR_DET_SC_1:8;
            uint32_t DPHY_P0_ERR_DET_SC_2:8;
            uint32_t DPHY_P0_ERR_DET_SC_3:8;
        } reg_0xD0C;
        uint32_t reg_0xD0C_W;
    };

    uint32_t rsvd_0xd10[0x3c/4];

    union {
        struct {
            uint32_t DPHY_P0_ERR_DET_SC_AL:8;
        } reg_0xD4C;
        uint32_t reg_0xD4C_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_DATA_TYPE_EBD:18;
        } reg_0xD50;
        uint32_t reg_0xD50_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_DATA_TYPE_USER:24;
        } reg_0xD54;
        uint32_t reg_0xD54_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_DATA_TYPE_RESERVED:24;
        } reg_0xD58;
        uint32_t reg_0xD58_W;
    };

    uint8_t RSVD_0D5C[420];
    union {
        struct {
            uint32_t REG_RDA_SEL:2;
            uint32_t rsvd_2:6;
            uint32_t RX_PDATA_OUT_SEL:3;
            uint32_t rsvd_11:2;
            uint32_t RX_PCLK_DIV_EN:1;
        } reg_0xF00;
        uint32_t reg_0xF00_W;
    };

    uint32_t rsvd_0xf04[0xbc/4];

    union {
        struct {
            uint32_t USER_CTRL:32;
        } reg_0xFC0;
        uint32_t reg_0xFC0_W;
    };

} MIPI_Register_Table_RX_s;
#endif
