/**************************************************************************//**
 * @file     SSE050.h
 * @brief    CMSIS Cortex-M3 Core Peripheral Access Layer Header File for
 *           Device SSE050
 * @version  V3.01
 * @date     06. March 2012
 *
 * @note
 * Copyright (C) 2010-2017  ARM Limited. All rights reserved.
 *
 * @par
 * ARM Limited (ARM) is supplying this software for use with Cortex-M
 * processor based microcontrollers.  This file can be freely distributed
 * within development tools that are supporting such ARM based processors.
 *
 * @par
 * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 ******************************************************************************/


#ifndef SSE050_H
#define SSE050_H

#ifdef __cplusplus
 extern "C" {
#endif

/** @addtogroup SSE050_Definitions SSE050 Definitions
  This file defines all structures and symbols for SSE050:
    - registers and bitfields
    - peripheral base address
    - peripheral ID
    - Peripheral definitions
  @{
*/


/******************************************************************************/
/*                Processor and Core Peripherals                              */
/******************************************************************************/
/** @addtogroup SSE050_CMSIS Device CMSIS Definitions
  Configuration of the Cortex-M3 Processor and Core Peripherals
  @{
*/

/*
 * ==========================================================================
 * ---------- Interrupt Number Definition -----------------------------------
 * ==========================================================================
 */

typedef enum IRQn
{
/******  Cortex-M3 Processor Exceptions Numbers ***************************************************/
  NonMaskableInt_IRQn           = -14,    /*!<  2 Cortex-M3 Non Maskable Interrupt                 */
  HardFault_IRQn                = -13,    /*!<  3 Cortex-M3 Hard Fault Interrupt                   */
  MemoryManagement_IRQn         = -12,    /*!<  4 Cortex-M3 Memory Management Interrupt            */
  BusFault_IRQn                 = -11,    /*!<  5 Cortex-M3 Bus Fault Interrupt                    */
  UsageFault_IRQn               = -10,    /*!<  6 Cortex-M3 Usage Fault Interrupt                  */
  SVCall_IRQn                   = -5,     /*!< 11 Cortex-M3 SV Call Interrupt                      */
  DebugMonitor_IRQn             = -4,     /*!< 12 Cortex-M3 Debug Monitor Interrupt                */
  PendSV_IRQn                   = -2,     /*!< 14 Cortex-M3 Pend SV Interrupt                      */
  SysTick_IRQn                  = -1,     /*!< 15 Cortex-M3 System Tick Interrupt                  */

/******  SSE050 Specific Interrupt Numbers *******************************************************/
  UART0_IRQn                    = 0,       /* UART 0 RX and TX Combined Interrupt   */
  UART1_IRQn                    = 1,       /* UART 1 RX and TX Combined Interrupt   */
  SPIM_IRQn                     = 2,       /* SPI Master Interrupt                  */
  SPIS_IRQn                     = 3,       /* SPI Slave Interrupt                   */
  QSPI_IRQn                     = 4,       /* QSPI Interrupt                        */
  RTC_IRQn                      = 5,       /* RTC Interrupt                         */
  WDT_IRQn                      = 6,       /* WDT Interrupt                         */
  GPIOA_IRQn                    = 7,       /* GPIO A Interrupt                      */
  GPIOB_IRQn                    = 8,       /* GPIO B Interrupt                      */
  TIMER0_IRQn                   = 9,       /* TIMER 0 Interrupt                     */
  TIMER1_IRQn                   = 10,      /* TIMER 1 Interrupt                     */
  TIMER2_IRQn                   = 11,      /* TIMER 2 Interrupt                     */
  I2C0_IRQn                     = 12,      /* I2C 0 Interrupt                       */
  I2C1_IRQn                     = 13,      /* I2C 1 Interrupt                       */
  I2C2_IRQn                     = 14,      /* I2C 2 Interrupt                       */
  ISP_IRQn                      = 15,      /* ISP Interrupt                         */
  CACHE_IRQn                    = 16,      /* CACHE Interrupt                       */
  MIPI_RX_ERR_ECC_IRQn          = 17,      /* MIPI Rx ECC Error interrupt           */
  MIPI_RX_ERR_CS_IRQn           = 18,      /* MIPI Rx CS Error interrupt            */
  AF_CMPL_IRQn                  = 19,      /* AF_CMPL interrupt                     */
  MIPI_RX_HERR_OUT_IRQn         = 20,      /* MIPI_RX_HERR_OUT interrupt            */
  MIPI_RX_VERR_OUT_IRQn         = 21,      /* MIPI_RX_VERR_OUT interrupt            */
} IRQn_Type;


/*
 * ==========================================================================
 * ----------- Processor and Core Peripheral Section ------------------------
 * ==========================================================================
 */

/* Configuration of the Cortex-M3 Processor and Core Peripherals */
#define __CM3_REV                 0x0201    /*!< Core Revision r2p1                             */
#define __NVIC_PRIO_BITS          3         /*!< Number of Bits used for Priority Levels        */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used   */
#define __MPU_PRESENT             0         /*!< MPU present or not                             */

/*@}*/ /* end of group SSE050_CMSIS */


#include "core_cm3.h"                     /* Cortex-M3 processor and core peripherals           */
#include "system_SSE050.h"             /* SSE050 System include file                      */

#define MSG(arg) { printf arg; }

/******************************************************************************/
/*                Device Specific Peripheral registers structures             */
/******************************************************************************/
/** @addtogroup SSE050_Peripherals SSE050 Peripherals
  SSE050 Device Specific Peripheral registers structures
  @{
*/

#if defined ( __CC_ARM   )
  #pragma push
#pragma anon_unions
#elif defined(__ICCARM__)
  #pragma language=extended
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning 586
#else
  #warning Not supported compiler type
#endif

/*------------- Universal Asynchronous Receiver Transmitter (UART) -----------*/
typedef struct
{
  __IO   uint32_t  DATA;          /*!< Offset: 0x000 Data Register    (R/W) */
  __IO   uint32_t  STATE;         /*!< Offset: 0x004 Status Register  (R/W) */
  __IO   uint32_t  CTRL;          /*!< Offset: 0x008 Control Register (R/W) */
  union {
    __I    uint32_t  INTSTATUS;   /*!< Offset: 0x00C Interrupt Status Register (R/ ) */
    __O    uint32_t  INTCLEAR;    /*!< Offset: 0x00C Interrupt Clear Register ( /W) */
    };
  __IO   uint32_t  BAUDDIV;       /*!< Offset: 0x010 Baudrate Divider Register (R/W) */

} SSE050_UART_TypeDef;

/* SSE050_UART DATA Register Definitions */

#define SSE050_UART_DATA_Pos               0                                            /*!< SSE050_UART_DATA_Pos: DATA Position */
#define SSE050_UART_DATA_Msk              (0xFFul << SSE050_UART_DATA_Pos)               /*!< SSE050_UART DATA: DATA Mask */

#define SSE050_UART_STATE_RXOR_Pos         3                                            /*!< SSE050_UART STATE: RXOR Position */
#define SSE050_UART_STATE_RXOR_Msk         (0x1ul << SSE050_UART_STATE_RXOR_Pos)         /*!< SSE050_UART STATE: RXOR Mask */

#define SSE050_UART_STATE_TXOR_Pos         2                                            /*!< SSE050_UART STATE: TXOR Position */
#define SSE050_UART_STATE_TXOR_Msk         (0x1ul << SSE050_UART_STATE_TXOR_Pos)         /*!< SSE050_UART STATE: TXOR Mask */

#define SSE050_UART_STATE_RXBF_Pos         1                                            /*!< SSE050_UART STATE: RXBF Position */
#define SSE050_UART_STATE_RXBF_Msk         (0x1ul << SSE050_UART_STATE_RXBF_Pos)         /*!< SSE050_UART STATE: RXBF Mask */

#define SSE050_UART_STATE_TXBF_Pos         0                                            /*!< SSE050_UART STATE: TXBF Position */
#define SSE050_UART_STATE_TXBF_Msk         (0x1ul << SSE050_UART_STATE_TXBF_Pos )        /*!< SSE050_UART STATE: TXBF Mask */

#define SSE050_UART_CTRL_HSTM_Pos          6                                            /*!< SSE050_UART CTRL: HSTM Position */
#define SSE050_UART_CTRL_HSTM_Msk          (0x01ul << SSE050_UART_CTRL_HSTM_Pos)         /*!< SSE050_UART CTRL: HSTM Mask */

#define SSE050_UART_CTRL_RXORIRQEN_Pos     5                                            /*!< SSE050_UART CTRL: RXORIRQEN Position */
#define SSE050_UART_CTRL_RXORIRQEN_Msk     (0x01ul << SSE050_UART_CTRL_RXORIRQEN_Pos)    /*!< SSE050_UART CTRL: RXORIRQEN Mask */

#define SSE050_UART_CTRL_TXORIRQEN_Pos     4                                            /*!< SSE050_UART CTRL: TXORIRQEN Position */
#define SSE050_UART_CTRL_TXORIRQEN_Msk     (0x01ul << SSE050_UART_CTRL_TXORIRQEN_Pos)    /*!< SSE050_UART CTRL: TXORIRQEN Mask */

#define SSE050_UART_CTRL_RXIRQEN_Pos       3                                            /*!< SSE050_UART CTRL: RXIRQEN Position */
#define SSE050_UART_CTRL_RXIRQEN_Msk       (0x01ul << SSE050_UART_CTRL_RXIRQEN_Pos)      /*!< SSE050_UART CTRL: RXIRQEN Mask */

#define SSE050_UART_CTRL_TXIRQEN_Pos       2                                            /*!< SSE050_UART CTRL: TXIRQEN Position */
#define SSE050_UART_CTRL_TXIRQEN_Msk       (0x01ul << SSE050_UART_CTRL_TXIRQEN_Pos)      /*!< SSE050_UART CTRL: TXIRQEN Mask */

#define SSE050_UART_CTRL_RXEN_Pos          1                                            /*!< SSE050_UART CTRL: RXEN Position */
#define SSE050_UART_CTRL_RXEN_Msk          (0x01ul << SSE050_UART_CTRL_RXEN_Pos)         /*!< SSE050_UART CTRL: RXEN Mask */

#define SSE050_UART_CTRL_TXEN_Pos          0                                            /*!< SSE050_UART CTRL: TXEN Position */
#define SSE050_UART_CTRL_TXEN_Msk          (0x01ul << SSE050_UART_CTRL_TXEN_Pos)         /*!< SSE050_UART CTRL: TXEN Mask */

#define SSE050_UART_INTSTATUS_RXORIRQ_Pos  3                                            /*!< SSE050_UART CTRL: RXORIRQ Position */
#define SSE050_UART_CTRL_RXORIRQ_Msk       (0x01ul << SSE050_UART_INTSTATUS_RXORIRQ_Pos) /*!< SSE050_UART CTRL: RXORIRQ Mask */

#define SSE050_UART_CTRL_TXORIRQ_Pos       2                                            /*!< SSE050_UART CTRL: TXORIRQ Position */
#define SSE050_UART_CTRL_TXORIRQ_Msk       (0x01ul << SSE050_UART_CTRL_TXORIRQ_Pos)      /*!< SSE050_UART CTRL: TXORIRQ Mask */

#define SSE050_UART_CTRL_RXIRQ_Pos         1                                            /*!< SSE050_UART CTRL: RXIRQ Position */
#define SSE050_UART_CTRL_RXIRQ_Msk         (0x01ul << SSE050_UART_CTRL_RXIRQ_Pos)        /*!< SSE050_UART CTRL: RXIRQ Mask */

#define SSE050_UART_CTRL_TXIRQ_Pos         0                                            /*!< SSE050_UART CTRL: TXIRQ Position */
#define SSE050_UART_CTRL_TXIRQ_Msk         (0x01ul << SSE050_UART_CTRL_TXIRQ_Pos)        /*!< SSE050_UART CTRL: TXIRQ Mask */

#define SSE050_UART_BAUDDIV_Pos            0                                            /*!< SSE050_UART BAUDDIV: BAUDDIV Position */
#define SSE050_UART_BAUDDIV_Msk            (0xFFFFFul << SSE050_UART_BAUDDIV_Pos)        /*!< SSE050_UART BAUDDIV: BAUDDIV Mask */


/*----------------------------- Timer (TIMER) -------------------------------*/
typedef struct
{
  __IO   uint32_t  CTRL;          /*!< Offset: 0x000 Control Register (R/W) */
  __IO   uint32_t  VALUE;         /*!< Offset: 0x004 Current Value Register (R/W) */
  __IO   uint32_t  RELOAD;        /*!< Offset: 0x008 Reload Value Register  (R/W) */
  union {
    __I    uint32_t  INTSTATUS;   /*!< Offset: 0x00C Interrupt Status Register (R/ ) */
    __O    uint32_t  INTCLEAR;    /*!< Offset: 0x00C Interrupt Clear Register ( /W) */
    };

} SSE050_TIMER_TypeDef;

/* SSE050_TIMER CTRL Register Definitions */

#define SSE050_TIMER_CTRL_IRQEN_Pos          3                                              /*!< SSE050_TIMER CTRL: IRQEN Position */
#define SSE050_TIMER_CTRL_IRQEN_Msk          (0x01ul << SSE050_TIMER_CTRL_IRQEN_Pos)         /*!< SSE050_TIMER CTRL: IRQEN Mask */

#define SSE050_TIMER_CTRL_SELEXTCLK_Pos      2                                              /*!< SSE050_TIMER CTRL: SELEXTCLK Position */
#define SSE050_TIMER_CTRL_SELEXTCLK_Msk      (0x01ul << SSE050_TIMER_CTRL_SELEXTCLK_Pos)     /*!< SSE050_TIMER CTRL: SELEXTCLK Mask */

#define SSE050_TIMER_CTRL_SELEXTEN_Pos       1                                              /*!< SSE050_TIMER CTRL: SELEXTEN Position */
#define SSE050_TIMER_CTRL_SELEXTEN_Msk       (0x01ul << SSE050_TIMER_CTRL_SELEXTEN_Pos)      /*!< SSE050_TIMER CTRL: SELEXTEN Mask */

#define SSE050_TIMER_CTRL_EN_Pos             0                                              /*!< SSE050_TIMER CTRL: EN Position */
#define SSE050_TIMER_CTRL_EN_Msk             (0x01ul << SSE050_TIMER_CTRL_EN_Pos)            /*!< SSE050_TIMER CTRL: EN Mask */

#define SSE050_TIMER_VAL_CURRENT_Pos         0                                              /*!< SSE050_TIMER VALUE: CURRENT Position */
#define SSE050_TIMER_VAL_CURRENT_Msk         (0xFFFFFFFFul << SSE050_TIMER_VAL_CURRENT_Pos)  /*!< SSE050_TIMER VALUE: CURRENT Mask */

#define SSE050_TIMER_RELOAD_VAL_Pos          0                                              /*!< SSE050_TIMER RELOAD: RELOAD Position */
#define SSE050_TIMER_RELOAD_VAL_Msk          (0xFFFFFFFFul << SSE050_TIMER_RELOAD_VAL_Pos)   /*!< SSE050_TIMER RELOAD: RELOAD Mask */

#define SSE050_TIMER_INTSTATUS_Pos           0                                              /*!< SSE050_TIMER INTSTATUS: INTSTATUSPosition */
#define SSE050_TIMER_INTSTATUS_Msk           (0x01ul << SSE050_TIMER_INTSTATUS_Pos)          /*!< SSE050_TIMER INTSTATUS: INTSTATUSMask */

#define SSE050_TIMER_INTCLEAR_Pos            0                                              /*!< SSE050_TIMER INTCLEAR: INTCLEAR Position */
#define SSE050_TIMER_INTCLEAR_Msk            (0x01ul << SSE050_TIMER_INTCLEAR_Pos)           /*!< SSE050_TIMER INTCLEAR: INTCLEAR Mask */


/*------------- Timer (TIM) --------------------------------------------------*/
typedef struct
{
  __IO uint32_t Timer1Load;                  /* Offset: 0x000 (R/W) Timer 1 Load */
  __I  uint32_t Timer1Value;                 /* Offset: 0x004 (R/ ) Timer 1 Counter Current Value */
  __IO uint32_t Timer1Control;               /* Offset: 0x008 (R/W) Timer 1 Control */
  __O  uint32_t Timer1IntClr;                /* Offset: 0x00C ( /W) Timer 1 Interrupt Clear */
  __I  uint32_t Timer1RIS;                   /* Offset: 0x010 (R/ ) Timer 1 Raw Interrupt Status */
  __I  uint32_t Timer1MIS;                   /* Offset: 0x014 (R/ ) Timer 1 Masked Interrupt Status */
  __IO uint32_t Timer1BGLoad;                /* Offset: 0x018 (R/W) Background Load Register */
       uint32_t RESERVED0;
  __IO uint32_t Timer2Load;                  /* Offset: 0x020 (R/W) Timer 2 Load */
  __I  uint32_t Timer2Value;                 /* Offset: 0x024 (R/ ) Timer 2 Counter Current Value */
  __IO uint32_t Timer2Control;               /* Offset: 0x028 (R/W) Timer 2 Control */
  __O  uint32_t Timer2IntClr;                /* Offset: 0x02C ( /W) Timer 2 Interrupt Clear */
  __I  uint32_t Timer2RIS;                   /* Offset: 0x030 (R/ ) Timer 2 Raw Interrupt Status */
  __I  uint32_t Timer2MIS;                   /* Offset: 0x034 (R/ ) Timer 2 Masked Interrupt Status */
  __IO uint32_t Timer2BGLoad;                /* Offset: 0x038 (R/W) Background Load Register */
       uint32_t RESERVED1[945];
  __IO uint32_t ITCR;                        /* Offset: 0xF00 (R/W) Integration Test Control Register */
  __O  uint32_t ITOP;                        /* Offset: 0xF04 ( /W) Integration Test Output Set Register */
} SSE050_DUALTIMER_BOTH_TypeDef;

#define SSE050_DUALTIMER1_LOAD_Pos            0                                                /* SSE050_DUALTIMER1 LOAD: LOAD Position */
#define SSE050_DUALTIMER1_LOAD_Msk            (0xFFFFFFFFul << SSE050_DUALTIMER1_LOAD_Pos)      /* SSE050_DUALTIMER1 LOAD: LOAD Mask */

#define SSE050_DUALTIMER1_VALUE_Pos           0                                                /* SSE050_DUALTIMER1 VALUE: VALUE Position */
#define SSE050_DUALTIMER1_VALUE_Msk           (0xFFFFFFFFul << SSE050_DUALTIMER1_VALUE_Pos)     /* SSE050_DUALTIMER1 VALUE: VALUE Mask */

#define SSE050_DUALTIMER1_CTRL_EN_Pos         7                                                /* SSE050_DUALTIMER1 CTRL_EN: CTRL Enable Position */
#define SSE050_DUALTIMER1_CTRL_EN_Msk         (0x1ul << SSE050_DUALTIMER1_CTRL_EN_Pos)          /* SSE050_DUALTIMER1 CTRL_EN: CTRL Enable Mask */

#define SSE050_DUALTIMER1_CTRL_MODE_Pos       6                                                /* SSE050_DUALTIMER1 CTRL_MODE: CTRL MODE Position */
#define SSE050_DUALTIMER1_CTRL_MODE_Msk       (0x1ul << SSE050_DUALTIMER1_CTRL_MODE_Pos)        /* SSE050_DUALTIMER1 CTRL_MODE: CTRL MODE Mask */

#define SSE050_DUALTIMER1_CTRL_INTEN_Pos      5                                                /* SSE050_DUALTIMER1 CTRL_INTEN: CTRL Int Enable Position */
#define SSE050_DUALTIMER1_CTRL_INTEN_Msk      (0x1ul << SSE050_DUALTIMER1_CTRL_INTEN_Pos)       /* SSE050_DUALTIMER1 CTRL_INTEN: CTRL Int Enable Mask */

#define SSE050_DUALTIMER1_CTRL_PRESCALE_Pos   2                                                /* SSE050_DUALTIMER1 CTRL_PRESCALE: CTRL PRESCALE Position */
#define SSE050_DUALTIMER1_CTRL_PRESCALE_Msk   (0x3ul << SSE050_DUALTIMER1_CTRL_PRESCALE_Pos)    /* SSE050_DUALTIMER1 CTRL_PRESCALE: CTRL PRESCALE Mask */

#define SSE050_DUALTIMER1_CTRL_SIZE_Pos       1                                                /* SSE050_DUALTIMER1 CTRL_SIZE: CTRL SIZE Position */
#define SSE050_DUALTIMER1_CTRL_SIZE_Msk       (0x1ul << SSE050_DUALTIMER1_CTRL_SIZE_Pos)        /* SSE050_DUALTIMER1 CTRL_SIZE: CTRL SIZE Mask */

#define SSE050_DUALTIMER1_CTRL_ONESHOOT_Pos   0                                                /* SSE050_DUALTIMER1 CTRL_ONESHOOT: CTRL ONESHOOT Position */
#define SSE050_DUALTIMER1_CTRL_ONESHOOT_Msk   (0x1ul << SSE050_DUALTIMER1_CTRL_ONESHOOT_Pos)    /* SSE050_DUALTIMER1 CTRL_ONESHOOT: CTRL ONESHOOT Mask */

#define SSE050_DUALTIMER1_INTCLR_Pos          0                                                /* SSE050_DUALTIMER1 INTCLR: INT Clear Position */
#define SSE050_DUALTIMER1_INTCLR_Msk          (0x1ul << SSE050_DUALTIMER1_INTCLR_Pos)           /* SSE050_DUALTIMER1 INTCLR: INT Clear  Mask */

#define SSE050_DUALTIMER1_RAWINTSTAT_Pos      0                                                /* SSE050_DUALTIMER1 RAWINTSTAT: Raw Int Status Position */
#define SSE050_DUALTIMER1_RAWINTSTAT_Msk      (0x1ul << SSE050_DUALTIMER1_RAWINTSTAT_Pos)       /* SSE050_DUALTIMER1 RAWINTSTAT: Raw Int Status Mask */

#define SSE050_DUALTIMER1_MASKINTSTAT_Pos     0                                                /* SSE050_DUALTIMER1 MASKINTSTAT: Mask Int Status Position */
#define SSE050_DUALTIMER1_MASKINTSTAT_Msk     (0x1ul << SSE050_DUALTIMER1_MASKINTSTAT_Pos)      /* SSE050_DUALTIMER1 MASKINTSTAT: Mask Int Status Mask */

#define SSE050_DUALTIMER1_BGLOAD_Pos          0                                                /* SSE050_DUALTIMER1 BGLOAD: Background Load Position */
#define SSE050_DUALTIMER1_BGLOAD_Msk          (0xFFFFFFFFul << SSE050_DUALTIMER1_BGLOAD_Pos)    /* SSE050_DUALTIMER1 BGLOAD: Background Load Mask */

#define SSE050_DUALTIMER2_LOAD_Pos            0                                                /* SSE050_DUALTIMER2 LOAD: LOAD Position */
#define SSE050_DUALTIMER2_LOAD_Msk            (0xFFFFFFFFul << SSE050_DUALTIMER2_LOAD_Pos)      /* SSE050_DUALTIMER2 LOAD: LOAD Mask */

#define SSE050_DUALTIMER2_VALUE_Pos           0                                                /* SSE050_DUALTIMER2 VALUE: VALUE Position */
#define SSE050_DUALTIMER2_VALUE_Msk           (0xFFFFFFFFul << SSE050_DUALTIMER2_VALUE_Pos)     /* SSE050_DUALTIMER2 VALUE: VALUE Mask */

#define SSE050_DUALTIMER2_CTRL_EN_Pos         7                                                /* SSE050_DUALTIMER2 CTRL_EN: CTRL Enable Position */
#define SSE050_DUALTIMER2_CTRL_EN_Msk         (0x1ul << SSE050_DUALTIMER2_CTRL_EN_Pos)          /* SSE050_DUALTIMER2 CTRL_EN: CTRL Enable Mask */

#define SSE050_DUALTIMER2_CTRL_MODE_Pos       6                                                /* SSE050_DUALTIMER2 CTRL_MODE: CTRL MODE Position */
#define SSE050_DUALTIMER2_CTRL_MODE_Msk       (0x1ul << SSE050_DUALTIMER2_CTRL_MODE_Pos)        /* SSE050_DUALTIMER2 CTRL_MODE: CTRL MODE Mask */

#define SSE050_DUALTIMER2_CTRL_INTEN_Pos      5                                                /* SSE050_DUALTIMER2 CTRL_INTEN: CTRL Int Enable Position */
#define SSE050_DUALTIMER2_CTRL_INTEN_Msk      (0x1ul << SSE050_DUALTIMER2_CTRL_INTEN_Pos)       /* SSE050_DUALTIMER2 CTRL_INTEN: CTRL Int Enable Mask */

#define SSE050_DUALTIMER2_CTRL_PRESCALE_Pos   2                                                /* SSE050_DUALTIMER2 CTRL_PRESCALE: CTRL PRESCALE Position */
#define SSE050_DUALTIMER2_CTRL_PRESCALE_Msk   (0x3ul << SSE050_DUALTIMER2_CTRL_PRESCALE_Pos)    /* SSE050_DUALTIMER2 CTRL_PRESCALE: CTRL PRESCALE Mask */

#define SSE050_DUALTIMER2_CTRL_SIZE_Pos       1                                                /* SSE050_DUALTIMER2 CTRL_SIZE: CTRL SIZE Position */
#define SSE050_DUALTIMER2_CTRL_SIZE_Msk       (0x1ul << SSE050_DUALTIMER2_CTRL_SIZE_Pos)        /* SSE050_DUALTIMER2 CTRL_SIZE: CTRL SIZE Mask */

#define SSE050_DUALTIMER2_CTRL_ONESHOOT_Pos   0                                                /* SSE050_DUALTIMER2 CTRL_ONESHOOT: CTRL ONESHOOT Position */
#define SSE050_DUALTIMER2_CTRL_ONESHOOT_Msk   (0x1ul << SSE050_DUALTIMER2_CTRL_ONESHOOT_Pos)    /* SSE050_DUALTIMER2 CTRL_ONESHOOT: CTRL ONESHOOT Mask */

#define SSE050_DUALTIMER2_INTCLR_Pos          0                                                /* SSE050_DUALTIMER2 INTCLR: INT Clear Position */
#define SSE050_DUALTIMER2_INTCLR_Msk          (0x1ul << SSE050_DUALTIMER2_INTCLR_Pos)           /* SSE050_DUALTIMER2 INTCLR: INT Clear  Mask */

#define SSE050_DUALTIMER2_RAWINTSTAT_Pos      0                                                /* SSE050_DUALTIMER2 RAWINTSTAT: Raw Int Status Position */
#define SSE050_DUALTIMER2_RAWINTSTAT_Msk      (0x1ul << SSE050_DUALTIMER2_RAWINTSTAT_Pos)       /* SSE050_DUALTIMER2 RAWINTSTAT: Raw Int Status Mask */

#define SSE050_DUALTIMER2_MASKINTSTAT_Pos     0                                                /* SSE050_DUALTIMER2 MASKINTSTAT: Mask Int Status Position */
#define SSE050_DUALTIMER2_MASKINTSTAT_Msk     (0x1ul << SSE050_DUALTIMER2_MASKINTSTAT_Pos)      /* SSE050_DUALTIMER2 MASKINTSTAT: Mask Int Status Mask */

#define SSE050_DUALTIMER2_BGLOAD_Pos          0                                                /* SSE050_DUALTIMER2 BGLOAD: Background Load Position */
#define SSE050_DUALTIMER2_BGLOAD_Msk          (0xFFFFFFFFul << SSE050_DUALTIMER2_BGLOAD_Pos)    /* SSE050_DUALTIMER2 BGLOAD: Background Load Mask */


typedef struct
{
  __IO uint32_t TimerLoad;                   /* Offset: 0x000 (R/W) Timer Load */
  __I  uint32_t TimerValue;                  /* Offset: 0x000 (R/W) Timer Counter Current Value */
  __IO uint32_t TimerControl;                /* Offset: 0x000 (R/W) Timer Control */
  __O  uint32_t TimerIntClr;                 /* Offset: 0x000 (R/W) Timer Interrupt Clear */
  __I  uint32_t TimerRIS;                    /* Offset: 0x000 (R/W) Timer Raw Interrupt Status */
  __I  uint32_t TimerMIS;                    /* Offset: 0x000 (R/W) Timer Masked Interrupt Status */
  __IO uint32_t TimerBGLoad;                 /* Offset: 0x000 (R/W) Background Load Register */
} SSE050_DUALTIMER_SINGLE_TypeDef;

#define SSE050_DUALTIMER_LOAD_Pos             0                                               /* SSE050_DUALTIMER LOAD: LOAD Position */
#define SSE050_DUALTIMER_LOAD_Msk             (0xFFFFFFFFul << SSE050_DUALTIMER_LOAD_Pos)      /* SSE050_DUALTIMER LOAD: LOAD Mask */

#define SSE050_DUALTIMER_VALUE_Pos            0                                               /* SSE050_DUALTIMER VALUE: VALUE Position */
#define SSE050_DUALTIMER_VALUE_Msk            (0xFFFFFFFFul << SSE050_DUALTIMER_VALUE_Pos)     /* SSE050_DUALTIMER VALUE: VALUE Mask */

#define SSE050_DUALTIMER_CTRL_EN_Pos          7                                               /* SSE050_DUALTIMER CTRL_EN: CTRL Enable Position */
#define SSE050_DUALTIMER_CTRL_EN_Msk          (0x1ul << SSE050_DUALTIMER_CTRL_EN_Pos)          /* SSE050_DUALTIMER CTRL_EN: CTRL Enable Mask */

#define SSE050_DUALTIMER_CTRL_MODE_Pos        6                                               /* SSE050_DUALTIMER CTRL_MODE: CTRL MODE Position */
#define SSE050_DUALTIMER_CTRL_MODE_Msk        (0x1ul << SSE050_DUALTIMER_CTRL_MODE_Pos)        /* SSE050_DUALTIMER CTRL_MODE: CTRL MODE Mask */

#define SSE050_DUALTIMER_CTRL_INTEN_Pos       5                                               /* SSE050_DUALTIMER CTRL_INTEN: CTRL Int Enable Position */
#define SSE050_DUALTIMER_CTRL_INTEN_Msk       (0x1ul << SSE050_DUALTIMER_CTRL_INTEN_Pos)       /* SSE050_DUALTIMER CTRL_INTEN: CTRL Int Enable Mask */

#define SSE050_DUALTIMER_CTRL_PRESCALE_Pos    2                                               /* SSE050_DUALTIMER CTRL_PRESCALE: CTRL PRESCALE Position */
#define SSE050_DUALTIMER_CTRL_PRESCALE_Msk    (0x3ul << SSE050_DUALTIMER_CTRL_PRESCALE_Pos)    /* SSE050_DUALTIMER CTRL_PRESCALE: CTRL PRESCALE Mask */

#define SSE050_DUALTIMER_CTRL_SIZE_Pos        1                                               /* SSE050_DUALTIMER CTRL_SIZE: CTRL SIZE Position */
#define SSE050_DUALTIMER_CTRL_SIZE_Msk        (0x1ul << SSE050_DUALTIMER_CTRL_SIZE_Pos)        /* SSE050_DUALTIMER CTRL_SIZE: CTRL SIZE Mask */

#define SSE050_DUALTIMER_CTRL_ONESHOOT_Pos    0                                               /* SSE050_DUALTIMER CTRL_ONESHOOT: CTRL ONESHOOT Position */
#define SSE050_DUALTIMER_CTRL_ONESHOOT_Msk    (0x1ul << SSE050_DUALTIMER_CTRL_ONESHOOT_Pos)    /* SSE050_DUALTIMER CTRL_ONESHOOT: CTRL ONESHOOT Mask */

#define SSE050_DUALTIMER_INTCLR_Pos           0                                               /* SSE050_DUALTIMER INTCLR: INT Clear Position */
#define SSE050_DUALTIMER_INTCLR_Msk           (0x1ul << SSE050_DUALTIMER_INTCLR_Pos)           /* SSE050_DUALTIMER INTCLR: INT Clear  Mask */

#define SSE050_DUALTIMER_RAWINTSTAT_Pos       0                                               /* SSE050_DUALTIMER RAWINTSTAT: Raw Int Status Position */
#define SSE050_DUALTIMER_RAWINTSTAT_Msk       (0x1ul << SSE050_DUALTIMER_RAWINTSTAT_Pos)       /* SSE050_DUALTIMER RAWINTSTAT: Raw Int Status Mask */

#define SSE050_DUALTIMER_MASKINTSTAT_Pos      0                                               /* SSE050_DUALTIMER MASKINTSTAT: Mask Int Status Position */
#define SSE050_DUALTIMER_MASKINTSTAT_Msk      (0x1ul << SSE050_DUALTIMER_MASKINTSTAT_Pos)      /* SSE050_DUALTIMER MASKINTSTAT: Mask Int Status Mask */

#define SSE050_DUALTIMER_BGLOAD_Pos           0                                               /* SSE050_DUALTIMER BGLOAD: Background Load Position */
#define SSE050_DUALTIMER_BGLOAD_Msk           (0xFFFFFFFFul << SSE050_DUALTIMER_BGLOAD_Pos)    /* SSE050_DUALTIMER BGLOAD: Background Load Mask */

/*-------------------- General Purpose Input Output (GPIO) -------------------*/
typedef struct
{
  __IO   uint32_t  DATA;                     /* Offset: 0x000 (R/W) DATA Register */
  __IO   uint32_t  DATAOUT;                  /* Offset: 0x004 (R/W) Data Output Latch Register */
         uint32_t  RESERVED0[2];
  __IO   uint32_t  OUTENABLESET;             /* Offset: 0x010 (R/W) Output Enable Set Register */
  __IO   uint32_t  OUTENABLECLR;             /* Offset: 0x014 (R/W) Output Enable Clear Register */
  __IO   uint32_t  ALTFUNCSET;               /* Offset: 0x018 (R/W) Alternate Function Set Register */
  __IO   uint32_t  ALTFUNCCLR;               /* Offset: 0x01C (R/W) Alternate Function Clear Register */
  __IO   uint32_t  INTENSET;                 /* Offset: 0x020 (R/W) Interrupt Enable Set Register */
  __IO   uint32_t  INTENCLR;                 /* Offset: 0x024 (R/W) Interrupt Enable Clear Register */
  __IO   uint32_t  INTTYPESET;               /* Offset: 0x028 (R/W) Interrupt Type Set Register */
  __IO   uint32_t  INTTYPECLR;               /* Offset: 0x02C (R/W) Interrupt Type Clear Register */
  __IO   uint32_t  INTPOLSET;                /* Offset: 0x030 (R/W) Interrupt Polarity Set Register */
  __IO   uint32_t  INTPOLCLR;                /* Offset: 0x034 (R/W) Interrupt Polarity Clear Register */
  union {
    __I    uint32_t  INTSTATUS;              /* Offset: 0x038 (R/ ) Interrupt Status Register */
    __O    uint32_t  INTCLEAR;               /* Offset: 0x038 ( /W) Interrupt Clear Register */
    };
         uint32_t RESERVED1[241];
  __IO   uint32_t LB_MASKED[256];            /* Offset: 0x400 - 0x7FC Lower byte Masked Access Register (R/W) */
  __IO   uint32_t UB_MASKED[256];            /* Offset: 0x800 - 0xBFC Upper byte Masked Access Register (R/W) */
} SSE050_GPIO_TypeDef;

#define SSE050_GPIO_DATA_Pos            0                                          /* SSE050_GPIO DATA: DATA Position */
#define SSE050_GPIO_DATA_Msk            (0xFFFFul << SSE050_GPIO_DATA_Pos)          /* SSE050_GPIO DATA: DATA Mask */

#define SSE050_GPIO_DATAOUT_Pos         0                                          /* SSE050_GPIO DATAOUT: DATAOUT Position */
#define SSE050_GPIO_DATAOUT_Msk         (0xFFFFul << SSE050_GPIO_DATAOUT_Pos)       /* SSE050_GPIO DATAOUT: DATAOUT Mask */

#define SSE050_GPIO_OUTENSET_Pos        0                                          /* SSE050_GPIO OUTEN: OUTEN Position */
#define SSE050_GPIO_OUTENSET_Msk        (0xFFFFul << SSE050_GPIO_OUTEN_Pos)         /* SSE050_GPIO OUTEN: OUTEN Mask */

#define SSE050_GPIO_OUTENCLR_Pos        0                                          /* SSE050_GPIO OUTEN: OUTEN Position */
#define SSE050_GPIO_OUTENCLR_Msk        (0xFFFFul << SSE050_GPIO_OUTEN_Pos)         /* SSE050_GPIO OUTEN: OUTEN Mask */

#define SSE050_GPIO_ALTFUNCSET_Pos      0                                          /* SSE050_GPIO ALTFUNC: ALTFUNC Position */
#define SSE050_GPIO_ALTFUNCSET_Msk      (0xFFFFul << SSE050_GPIO_ALTFUNC_Pos)       /* SSE050_GPIO ALTFUNC: ALTFUNC Mask */

#define SSE050_GPIO_ALTFUNCCLR_Pos      0                                          /* SSE050_GPIO ALTFUNC: ALTFUNC Position */
#define SSE050_GPIO_ALTFUNCCLR_Msk      (0xFFFFul << SSE050_GPIO_ALTFUNC_Pos)       /* SSE050_GPIO ALTFUNC: ALTFUNC Mask */

#define SSE050_GPIO_INTENSET_Pos        0                                          /* SSE050_GPIO INTEN: INTEN Position */
#define SSE050_GPIO_INTENSET_Msk        (0xFFFFul << SSE050_GPIO_INTEN_Pos)         /* SSE050_GPIO INTEN: INTEN Mask */

#define SSE050_GPIO_INTENCLR_Pos        0                                          /* SSE050_GPIO INTEN: INTEN Position */
#define SSE050_GPIO_INTENCLR_Msk        (0xFFFFul << SSE050_GPIO_INTEN_Pos)         /* SSE050_GPIO INTEN: INTEN Mask */

#define SSE050_GPIO_INTTYPESET_Pos      0                                          /* SSE050_GPIO INTTYPE: INTTYPE Position */
#define SSE050_GPIO_INTTYPESET_Msk      (0xFFFFul << SSE050_GPIO_INTTYPE_Pos)       /* SSE050_GPIO INTTYPE: INTTYPE Mask */

#define SSE050_GPIO_INTTYPECLR_Pos      0                                          /* SSE050_GPIO INTTYPE: INTTYPE Position */
#define SSE050_GPIO_INTTYPECLR_Msk      (0xFFFFul << SSE050_GPIO_INTTYPE_Pos)       /* SSE050_GPIO INTTYPE: INTTYPE Mask */

#define SSE050_GPIO_INTPOLSET_Pos       0                                          /* SSE050_GPIO INTPOL: INTPOL Position */
#define SSE050_GPIO_INTPOLSET_Msk       (0xFFFFul << SSE050_GPIO_INTPOL_Pos)        /* SSE050_GPIO INTPOL: INTPOL Mask */

#define SSE050_GPIO_INTPOLCLR_Pos       0                                          /* SSE050_GPIO INTPOL: INTPOL Position */
#define SSE050_GPIO_INTPOLCLR_Msk       (0xFFFFul << SSE050_GPIO_INTPOL_Pos)        /* SSE050_GPIO INTPOL: INTPOL Mask */

#define SSE050_GPIO_INTSTATUS_Pos       0                                          /* SSE050_GPIO INTSTATUS: INTSTATUS Position */
#define SSE050_GPIO_INTSTATUS_Msk       (0xFFul << SSE050_GPIO_INTSTATUS_Pos)       /* SSE050_GPIO INTSTATUS: INTSTATUS Mask */

#define SSE050_GPIO_INTCLEAR_Pos        0                                          /* SSE050_GPIO INTCLEAR: INTCLEAR Position */
#define SSE050_GPIO_INTCLEAR_Msk        (0xFFul << SSE050_GPIO_INTCLEAR_Pos)        /* SSE050_GPIO INTCLEAR: INTCLEAR Mask */

#define SSE050_GPIO_MASKLOWBYTE_Pos     0                                          /* SSE050_GPIO MASKLOWBYTE: MASKLOWBYTE Position */
#define SSE050_GPIO_MASKLOWBYTE_Msk     (0x00FFul << SSE050_GPIO_MASKLOWBYTE_Pos)   /* SSE050_GPIO MASKLOWBYTE: MASKLOWBYTE Mask */

#define SSE050_GPIO_MASKHIGHBYTE_Pos    0                                          /* SSE050_GPIO MASKHIGHBYTE: MASKHIGHBYTE Position */
#define SSE050_GPIO_MASKHIGHBYTE_Msk    (0xFF00ul << SSE050_GPIO_MASKHIGHBYTE_Pos)  /* SSE050_GPIO MASKHIGHBYTE: MASKHIGHBYTE Mask */

/*------------- System Control (SYSCON) --------------------------------------*/
typedef struct
{
  __IO   uint32_t  REMAP;                    /* Offset: 0x000 (R/W) Remap Control Register */
  __IO   uint32_t  PMUCTRL;                  /* Offset: 0x004 (R/W) PMU Control Register */
  __IO   uint32_t  RESETOP;                  /* Offset: 0x008 (R/W) Reset Option Register */
  __IO   uint32_t  RESERVED0;
  __IO   uint32_t  RSTINFO;                  /* Offset: 0x010 (R/W) Reset Information Register */
} SSE050_SYSCON_TypeDef;

#define SSE050_SYSCON_REMAP_Pos                 0
#define SSE050_SYSCON_REMAP_Msk                 (0x01ul << SSE050_SYSCON_REMAP_Pos)               /* SSE050_SYSCON MEME_CTRL: REMAP Mask */

#define SSE050_SYSCON_PMUCTRL_EN_Pos            0
#define SSE050_SYSCON_PMUCTRL_EN_Msk            (0x01ul << SSE050_SYSCON_PMUCTRL_EN_Pos)          /* SSE050_SYSCON PMUCTRL: PMUCTRL ENABLE Mask */

#define SSE050_SYSCON_LOCKUPRST_RESETOP_Pos     0
#define SSE050_SYSCON_LOCKUPRST_RESETOP_Msk     (0x01ul << SSE050_SYSCON_LOCKUPRST_RESETOP_Pos)   /* SSE050_SYSCON SYS_CTRL: LOCKUP RESET ENABLE Mask */

#define SSE050_SYSCON_RSTINFO_SYSRESETREQ_Pos   0
#define SSE050_SYSCON_RSTINFO_SYSRESETREQ_Msk   (0x00001ul << SSE050_SYSCON_RSTINFO_SYSRESETREQ_Pos) /* SSE050_SYSCON RSTINFO: SYSRESETREQ Mask */

#define SSE050_SYSCON_RSTINFO_WDOGRESETREQ_Pos  1
#define SSE050_SYSCON_RSTINFO_WDOGRESETREQ_Msk  (0x00001ul << SSE050_SYSCON_RSTINFO_WDOGRESETREQ_Pos) /* SSE050_SYSCON RSTINFO: WDOGRESETREQ Mask */

#define SSE050_SYSCON_RSTINFO_LOCKUPRESET_Pos   2
#define SSE050_SYSCON_RSTINFO_LOCKUPRESET_Msk   (0x00001ul << SSE050_SYSCON_RSTINFO_LOCKUPRESET_Pos) /* SSE050_SYSCON RSTINFO: LOCKUPRESET Mask */

/*------------- PL230 uDMA (PL230) --------------------------------------*/
/** @addtogroup SSE050_PL230 SSE050 uDMA controller
  @{
*/
typedef struct
{
  __I    uint32_t  DMA_STATUS;           /*!< Offset: 0x000 DMA status Register (R/W) */
  __O    uint32_t  DMA_CFG;              /*!< Offset: 0x004 DMA configuration Register ( /W) */
  __IO   uint32_t  CTRL_BASE_PTR;        /*!< Offset: 0x008 Channel Control Data Base Pointer Register  (R/W) */
  __I    uint32_t  ALT_CTRL_BASE_PTR;    /*!< Offset: 0x00C Channel Alternate Control Data Base Pointer Register  (R/ ) */
  __I    uint32_t  DMA_WAITONREQ_STATUS; /*!< Offset: 0x010 Channel Wait On Request Status Register  (R/ ) */
  __O    uint32_t  CHNL_SW_REQUEST;      /*!< Offset: 0x014 Channel Software Request Register  ( /W) */
  __IO   uint32_t  CHNL_USEBURST_SET;    /*!< Offset: 0x018 Channel UseBurst Set Register  (R/W) */
  __O    uint32_t  CHNL_USEBURST_CLR;    /*!< Offset: 0x01C Channel UseBurst Clear Register  ( /W) */
  __IO   uint32_t  CHNL_REQ_MASK_SET;    /*!< Offset: 0x020 Channel Request Mask Set Register  (R/W) */
  __O    uint32_t  CHNL_REQ_MASK_CLR;    /*!< Offset: 0x024 Channel Request Mask Clear Register  ( /W) */
  __IO   uint32_t  CHNL_ENABLE_SET;      /*!< Offset: 0x028 Channel Enable Set Register  (R/W) */
  __O    uint32_t  CHNL_ENABLE_CLR;      /*!< Offset: 0x02C Channel Enable Clear Register  ( /W) */
  __IO   uint32_t  CHNL_PRI_ALT_SET;     /*!< Offset: 0x030 Channel Primary-Alterante Set Register  (R/W) */
  __O    uint32_t  CHNL_PRI_ALT_CLR;     /*!< Offset: 0x034 Channel Primary-Alterante Clear Register  ( /W) */
  __IO   uint32_t  CHNL_PRIORITY_SET;    /*!< Offset: 0x038 Channel Priority Set Register  (R/W) */
  __O    uint32_t  CHNL_PRIORITY_CLR;    /*!< Offset: 0x03C Channel Priority Clear Register  ( /W) */
         uint32_t  RESERVED0[3];
  __IO   uint32_t  ERR_CLR;              /*!< Offset: 0x04C Bus Error Clear Register  (R/W) */

} SSE050_PL230_TypeDef;

#define PL230_DMA_CHNL_BITS 0

#define SSE050_PL230_DMA_STATUS_MSTREN_Pos          0                                                          /*!< SSE050_PL230 DMA STATUS: MSTREN Position */
#define SSE050_PL230_DMA_STATUS_MSTREN_Msk          (0x00000001ul << SSE050_PL230_DMA_STATUS_MSTREN_Pos)        /*!< SSE050_PL230 DMA STATUS: MSTREN Mask */

#define SSE050_PL230_DMA_STATUS_STATE_Pos           0                                                          /*!< SSE050_PL230 DMA STATUS: STATE Position */
#define SSE050_PL230_DMA_STATUS_STATE_Msk           (0x0000000Ful << SSE050_PL230_DMA_STATUS_STATE_Pos)         /*!< SSE050_PL230 DMA STATUS: STATE Mask */

#define SSE050_PL230_DMA_STATUS_CHNLS_MINUS1_Pos    0                                                          /*!< SSE050_PL230 DMA STATUS: CHNLS_MINUS1 Position */
#define SSE050_PL230_DMA_STATUS_CHNLS_MINUS1_Msk    (0x0000001Ful << SSE050_PL230_DMA_STATUS_CHNLS_MINUS1_Pos)  /*!< SSE050_PL230 DMA STATUS: CHNLS_MINUS1 Mask */

#define SSE050_PL230_DMA_STATUS_TEST_STATUS_Pos     0                                                          /*!< SSE050_PL230 DMA STATUS: TEST_STATUS Position */
#define SSE050_PL230_DMA_STATUS_TEST_STATUS_Msk     (0x00000001ul << SSE050_PL230_DMA_STATUS_TEST_STATUS_Pos)   /*!< SSE050_PL230 DMA STATUS: TEST_STATUS Mask */

#define SSE050_PL230_DMA_CFG_MSTREN_Pos             0                                                          /*!< SSE050_PL230 DMA CFG: MSTREN Position */
#define SSE050_PL230_DMA_CFG_MSTREN_Msk             (0x00000001ul << SSE050_PL230_DMA_CFG_MSTREN_Pos)           /*!< SSE050_PL230 DMA CFG: MSTREN Mask */

#define SSE050_PL230_DMA_CFG_CPCCACHE_Pos           2                                                          /*!< SSE050_PL230 DMA CFG: CPCCACHE Position */
#define SSE050_PL230_DMA_CFG_CPCCACHE_Msk           (0x00000001ul << SSE050_PL230_DMA_CFG_CPCCACHE_Pos)         /*!< SSE050_PL230 DMA CFG: CPCCACHE Mask */

#define SSE050_PL230_DMA_CFG_CPCBUF_Pos             1                                                          /*!< SSE050_PL230 DMA CFG: CPCBUF Position */
#define SSE050_PL230_DMA_CFG_CPCBUF_Msk             (0x00000001ul << SSE050_PL230_DMA_CFG_CPCBUF_Pos)           /*!< SSE050_PL230 DMA CFG: CPCBUF Mask */

#define SSE050_PL230_DMA_CFG_CPCPRIV_Pos            0                                                          /*!< SSE050_PL230 DMA CFG: CPCPRIV Position */
#define SSE050_PL230_DMA_CFG_CPCPRIV_Msk            (0x00000001ul << SSE050_PL230_DMA_CFG_CPCPRIV_Pos)          /*!< SSE050_PL230 DMA CFG: CPCPRIV Mask */

#define SSE050_PL230_CTRL_BASE_PTR_Pos              PL230_DMA_CHNL_BITS + 5                                    /*!< SSE050_PL230 STATUS: BASE_PTR Position */
#define SSE050_PL230_CTRL_BASE_PTR_Msk              (0x0FFFFFFFul << SSE050_PL230_CTRL_BASE_PTR_Pos)            /*!< SSE050_PL230 STATUS: BASE_PTR Mask */

#define SSE050_PL230_ALT_CTRL_BASE_PTR_Pos          0                                                          /*!< SSE050_PL230 STATUS: MSTREN Position */
#define SSE050_PL230_ALT_CTRL_BASE_PTR_Msk          (0xFFFFFFFFul << SSE050_PL230_ALT_CTRL_BASE_PTR_Pos)        /*!< SSE050_PL230 STATUS: MSTREN Mask */

#define SSE050_PL230_DMA_WAITONREQ_STATUS_Pos       0                                                          /*!< SSE050_PL230 DMA_WAITONREQ_STATUS: DMA_WAITONREQ_STATUS Position */
#define SSE050_PL230_DMA_WAITONREQ_STATUS_Msk       (0xFFFFFFFFul << SSE050_PL230_DMA_WAITONREQ_STATUS_Pos)     /*!< SSE050_PL230 DMA_WAITONREQ_STATUS: DMA_WAITONREQ_STATUS Mask */

#define SSE050_PL230_CHNL_SW_REQUEST_Pos            0                                                          /*!< SSE050_PL230 CHNL_SW_REQUEST: CHNL_SW_REQUEST Position */
#define SSE050_PL230_CHNL_SW_REQUEST_Msk            (0xFFFFFFFFul << SSE050_PL230_CHNL_SW_REQUEST_Pos)          /*!< SSE050_PL230 CHNL_SW_REQUEST: CHNL_SW_REQUEST Mask */

#define SSE050_PL230_CHNL_USEBURST_SET_Pos          0                                                          /*!< SSE050_PL230 CHNL_USEBURST: SET Position */
#define SSE050_PL230_CHNL_USEBURST_SET_Msk          (0xFFFFFFFFul << SSE050_PL230_CHNL_USEBURST_SET_Pos)        /*!< SSE050_PL230 CHNL_USEBURST: SET Mask */

#define SSE050_PL230_CHNL_USEBURST_CLR_Pos          0                                                          /*!< SSE050_PL230 CHNL_USEBURST: CLR Position */
#define SSE050_PL230_CHNL_USEBURST_CLR_Msk          (0xFFFFFFFFul << SSE050_PL230_CHNL_USEBURST_CLR_Pos)        /*!< SSE050_PL230 CHNL_USEBURST: CLR Mask */

#define SSE050_PL230_CHNL_REQ_MASK_SET_Pos          0                                                          /*!< SSE050_PL230 CHNL_REQ_MASK: SET Position */
#define SSE050_PL230_CHNL_REQ_MASK_SET_Msk          (0xFFFFFFFFul << SSE050_PL230_CHNL_REQ_MASK_SET_Pos)        /*!< SSE050_PL230 CHNL_REQ_MASK: SET Mask */

#define SSE050_PL230_CHNL_REQ_MASK_CLR_Pos          0                                                          /*!< SSE050_PL230 CHNL_REQ_MASK: CLR Position */
#define SSE050_PL230_CHNL_REQ_MASK_CLR_Msk          (0xFFFFFFFFul << SSE050_PL230_CHNL_REQ_MASK_CLR_Pos)        /*!< SSE050_PL230 CHNL_REQ_MASK: CLR Mask */

#define SSE050_PL230_CHNL_ENABLE_SET_Pos            0                                                          /*!< SSE050_PL230 CHNL_ENABLE: SET Position */
#define SSE050_PL230_CHNL_ENABLE_SET_Msk            (0xFFFFFFFFul << SSE050_PL230_CHNL_ENABLE_SET_Pos)          /*!< SSE050_PL230 CHNL_ENABLE: SET Mask */

#define SSE050_PL230_CHNL_ENABLE_CLR_Pos            0                                                          /*!< SSE050_PL230 CHNL_ENABLE: CLR Position */
#define SSE050_PL230_CHNL_ENABLE_CLR_Msk            (0xFFFFFFFFul << SSE050_PL230_CHNL_ENABLE_CLR_Pos)          /*!< SSE050_PL230 CHNL_ENABLE: CLR Mask */

#define SSE050_PL230_CHNL_PRI_ALT_SET_Pos           0                                                          /*!< SSE050_PL230 CHNL_PRI_ALT: SET Position */
#define SSE050_PL230_CHNL_PRI_ALT_SET_Msk           (0xFFFFFFFFul << SSE050_PL230_CHNL_PRI_ALT_SET_Pos)         /*!< SSE050_PL230 CHNL_PRI_ALT: SET Mask */

#define SSE050_PL230_CHNL_PRI_ALT_CLR_Pos           0                                                          /*!< SSE050_PL230 CHNL_PRI_ALT: CLR Position */
#define SSE050_PL230_CHNL_PRI_ALT_CLR_Msk           (0xFFFFFFFFul << SSE050_PL230_CHNL_PRI_ALT_CLR_Pos)         /*!< SSE050_PL230 CHNL_PRI_ALT: CLR Mask */

#define SSE050_PL230_CHNL_PRIORITY_SET_Pos          0                                                          /*!< SSE050_PL230 CHNL_PRIORITY: SET Position */
#define SSE050_PL230_CHNL_PRIORITY_SET_Msk          (0xFFFFFFFFul << SSE050_PL230_CHNL_PRIORITY_SET_Pos)        /*!< SSE050_PL230 CHNL_PRIORITY: SET Mask */

#define SSE050_PL230_CHNL_PRIORITY_CLR_Pos          0                                                          /*!< SSE050_PL230 CHNL_PRIORITY: CLR Position */
#define SSE050_PL230_CHNL_PRIORITY_CLR_Msk          (0xFFFFFFFFul << SSE050_PL230_CHNL_PRIORITY_CLR_Pos)        /*!< SSE050_PL230 CHNL_PRIORITY: CLR Mask */

#define SSE050_PL230_ERR_CLR_Pos                    0                                                          /*!< SSE050_PL230 ERR: CLR Position */
#define SSE050_PL230_ERR_CLR_Msk                    (0x00000001ul << SSE050_PL230_ERR_CLR_Pos)                  /*!< SSE050_PL230 ERR: CLR Mask */


/*------------------- Watchdog ----------------------------------------------*/
typedef struct
{

  __IO    uint32_t  LOAD;                   /* Offset: 0x000 (R/W) Watchdog Load Register */
  __I     uint32_t  VALUE;                  /* Offset: 0x004 (R/ ) Watchdog Value Register */
  __IO    uint32_t  CTRL;                   /* Offset: 0x008 (R/W) Watchdog Control Register */
  __O     uint32_t  INTCLR;                 /* Offset: 0x00C ( /W) Watchdog Clear Interrupt Register */
  __I     uint32_t  RAWINTSTAT;             /* Offset: 0x010 (R/ ) Watchdog Raw Interrupt Status Register */
  __I     uint32_t  MASKINTSTAT;            /* Offset: 0x014 (R/ ) Watchdog Interrupt Status Register */
        uint32_t  RESERVED0[762];
  __IO    uint32_t  LOCK;                   /* Offset: 0xC00 (R/W) Watchdog Lock Register */
        uint32_t  RESERVED1[191];
  __IO    uint32_t  ITCR;                   /* Offset: 0xF00 (R/W) Watchdog Integration Test Control Register */
  __O     uint32_t  ITOP;                   /* Offset: 0xF04 ( /W) Watchdog Integration Test Output Set Register */
}SSE050_WATCHDOG_TypeDef;

#define SSE050_Watchdog_LOAD_Pos               0                                              /* SSE050_Watchdog LOAD: LOAD Position */
#define SSE050_Watchdog_LOAD_Msk              (0xFFFFFFFFul << SSE050_Watchdog_LOAD_Pos)       /* SSE050_Watchdog LOAD: LOAD Mask */

#define SSE050_Watchdog_VALUE_Pos              0                                              /* SSE050_Watchdog VALUE: VALUE Position */
#define SSE050_Watchdog_VALUE_Msk             (0xFFFFFFFFul << SSE050_Watchdog_VALUE_Pos)      /* SSE050_Watchdog VALUE: VALUE Mask */

#define SSE050_Watchdog_CTRL_RESEN_Pos         1                                              /* SSE050_Watchdog CTRL_RESEN: Enable Reset Output Position */
#define SSE050_Watchdog_CTRL_RESEN_Msk        (0x1ul << SSE050_Watchdog_CTRL_RESEN_Pos)        /* SSE050_Watchdog CTRL_RESEN: Enable Reset Output Mask */

#define SSE050_Watchdog_CTRL_INTEN_Pos         0                                              /* SSE050_Watchdog CTRL_INTEN: Int Enable Position */
#define SSE050_Watchdog_CTRL_INTEN_Msk        (0x1ul << SSE050_Watchdog_CTRL_INTEN_Pos)        /* SSE050_Watchdog CTRL_INTEN: Int Enable Mask */

#define SSE050_Watchdog_INTCLR_Pos             0                                              /* SSE050_Watchdog INTCLR: Int Clear Position */
#define SSE050_Watchdog_INTCLR_Msk            (0x1ul << SSE050_Watchdog_INTCLR_Pos)            /* SSE050_Watchdog INTCLR: Int Clear Mask */

#define SSE050_Watchdog_RAWINTSTAT_Pos         0                                              /* SSE050_Watchdog RAWINTSTAT: Raw Int Status Position */
#define SSE050_Watchdog_RAWINTSTAT_Msk        (0x1ul << SSE050_Watchdog_RAWINTSTAT_Pos)        /* SSE050_Watchdog RAWINTSTAT: Raw Int Status Mask */

#define SSE050_Watchdog_MASKINTSTAT_Pos        0                                              /* SSE050_Watchdog MASKINTSTAT: Mask Int Status Position */
#define SSE050_Watchdog_MASKINTSTAT_Msk       (0x1ul << SSE050_Watchdog_MASKINTSTAT_Pos)       /* SSE050_Watchdog MASKINTSTAT: Mask Int Status Mask */

#define SSE050_Watchdog_LOCK_Pos               0                                              /* SSE050_Watchdog LOCK: LOCK Position */
#define SSE050_Watchdog_LOCK_Msk              (0x1ul << SSE050_Watchdog_LOCK_Pos)              /* SSE050_Watchdog LOCK: LOCK Mask */

#define SSE050_Watchdog_INTEGTESTEN_Pos        0                                              /* SSE050_Watchdog INTEGTESTEN: Integration Test Enable Position */
#define SSE050_Watchdog_INTEGTESTEN_Msk       (0x1ul << SSE050_Watchdog_INTEGTESTEN_Pos)       /* SSE050_Watchdog INTEGTESTEN: Integration Test Enable Mask */

#define SSE050_Watchdog_INTEGTESTOUTSET_Pos    1                                              /* SSE050_Watchdog INTEGTESTOUTSET: Integration Test Output Set Position */
#define SSE050_Watchdog_INTEGTESTOUTSET_Msk   (0x1ul << SSE050_Watchdog_INTEGTESTOUTSET_Pos)   /* SSE050_Watchdog INTEGTESTOUTSET: Integration Test Output Set Mask */

/*------------------- FPGA control ----------------------------------------------*/
#if defined ( __CC_ARM   )
#pragma anon_unions
#endif

typedef struct
{
  /*!< Offset: 0x000 LDE0 Register    (R/W) */
  __IO   uint32_t  LEDS;      // <h> LEDS </h>
                              //   <o.0> LED0
                              //     <0=> LED0 off
                              //     <1=> LED0 on
                              //   <o.1> LED1
                              //     <0=> LED1 off
                              //     <1=> LED1 on
         uint32_t  RESERVED0;
  __I    uint32_t  BUTTONS;   // <h> BUTTONS </h>
                              //   <o.0> BUTTON0
                              //     <0=> off
                              //     <1=> on
                              //   <o.1> BUTTON1
                              //     <0=> off
                              //     <1=> on
         uint32_t  RESERVED1;
  __IO   uint32_t  COUNT1HZ;  // <h> 1Hz up counter </h>
  __IO   uint32_t  CNT100HZ;  // <h> 100Hz up counter </h>
  __IO   uint32_t  COUNTCYC;  // <h> Cycle counter </h>
  __IO   uint32_t  PRESCALE;  // <h> Reload value for prescale counter</h>
  __IO   uint32_t  PSCNTR;    // <h> Prescale counter for cycle counter</h>
         uint32_t  RESERVED2[10];
  __IO   uint32_t  MISC;      // <h> Misc controls </h>
                              //   <o.0> CLCD_CS
                              //     <0=> off
                              //     <1=> on
                              //   <o.1> SPI_nSS
                              //     <0=> off
                              //     <1=> on
                              //   <o.2> CLCD_T_CS
                              //     <0=> off
                              //     <1=> on
                              //   <o.3> CLCD_RESET
                              //     <0=> off
                              //     <1=> on
                              //   <o.4> CLCD_RS
                              //     <0=> off
                              //     <1=> on
                              //   <o.5> CLCD_RD
                              //     <0=> off
                              //     <1=> on
                              //   <o.6> CLCD_BL_CTRL
                              //     <0=> off
                              //     <1=> on

} SSE050_FPGASYS_TypeDef;

/*------------------- Audio I2S control ----------------------------------------------*/
typedef struct
{
  /*!< Offset: 0x000 CONTROL Register    (R/W) */
  __IO   uint32_t  CONTROL; // <h> CONTROL </h>
                              //   <o.0> TX Enable
                              //     <0=> TX disabled
                              //     <1=> TX enabled
                              //   <o.1> TX IRQ Enable
                              //     <0=> TX IRQ disabled
                              //     <1=> TX IRQ enabled
                              //   <o.2> RX Enable
                              //     <0=> RX disabled
                              //     <1=> RX enabled
                              //   <o.3> RX IRQ Enable
                              //     <0=> RX IRQ disabled
                              //     <1=> RX IRQ enabled
                              //   <o.10..8> TX Buffer Water Level
                              //     <0=> / IRQ triggers when any space available
                              //     <1=> / IRQ triggers when more than 1 space available
                              //     <2=> / IRQ triggers when more than 2 space available
                              //     <3=> / IRQ triggers when more than 3 space available
                              //     <4=> Undefined!
                              //     <5=> Undefined!
                              //     <6=> Undefined!
                              //     <7=> Undefined!
                              //   <o.14..12> RX Buffer Water Level
                              //     <0=> Undefined!
                              //     <1=> / IRQ triggers when less than 1 space available
                              //     <2=> / IRQ triggers when less than 2 space available
                              //     <3=> / IRQ triggers when less than 3 space available
                              //     <4=> / IRQ triggers when less than 4 space available
                              //     <5=> Undefined!
                              //     <6=> Undefined!
                              //     <7=> Undefined!
                              //   <o.16> FIFO reset
                              //     <0=> Normal operation
                              //     <1=> FIFO reset
                              //   <o.17> Audio Codec reset
                              //     <0=> Normal operation
                              //     <1=> Assert audio Codec reset
  /*!< Offset: 0x004 STATUS Register     (R/ ) */
  __I    uint32_t  STATUS;  // <h> STATUS </h>
                              //   <o.0> TX Buffer alert
                              //     <0=> TX buffer don't need service yet
                              //     <1=> TX buffer need service
                              //   <o.1> RX Buffer alert
                              //     <0=> RX buffer don't need service yet
                              //     <1=> RX buffer need service
                              //   <o.2> TX Buffer Empty
                              //     <0=> TX buffer have data
                              //     <1=> TX buffer empty
                              //   <o.3> TX Buffer Full
                              //     <0=> TX buffer not full
                              //     <1=> TX buffer full
                              //   <o.4> RX Buffer Empty
                              //     <0=> RX buffer have data
                              //     <1=> RX buffer empty
                              //   <o.5> RX Buffer Full
                              //     <0=> RX buffer not full
                              //     <1=> RX buffer full
  union {
   /*!< Offset: 0x008 Error Status Register (R/ ) */
    __I    uint32_t  ERROR;  // <h> ERROR </h>
                              //   <o.0> TX error
                              //     <0=> Okay
                              //     <1=> TX overrun/underrun
                              //   <o.1> RX error
                              //     <0=> Okay
                              //     <1=> RX overrun/underrun
   /*!< Offset: 0x008 Error Clear Register  ( /W) */
    __O    uint32_t  ERRORCLR;  // <h> ERRORCLR </h>
                              //   <o.0> TX error
                              //     <0=> Okay
                              //     <1=> Clear TX error
                              //   <o.1> RX error
                              //     <0=> Okay
                              //     <1=> Clear RX error
    };
   /*!< Offset: 0x00C Divide ratio Register (R/W) */
  __IO   uint32_t  DIVIDE;  // <h> Divide ratio for Left/Right clock </h>
                              //   <o.9..0> TX error (default 0x80)
   /*!< Offset: 0x010 Transmit Buffer       ( /W) */
  __O    uint32_t  TXBUF;  // <h> Transmit buffer </h>
                              //   <o.15..0> Right channel
                              //   <o.31..16> Left channel
   /*!< Offset: 0x014 Receive Buffer        (R/ ) */
  __I    uint32_t  RXBUF;  // <h> Receive buffer </h>
                              //   <o.15..0> Right channel
                              //   <o.31..16> Left channel
         uint32_t  RESERVED1[186];
  __IO uint32_t ITCR;         // <h> Integration Test Control Register </h>
                              //   <o.0> ITEN
                              //     <0=> Normal operation
                              //     <1=> Integration Test mode enable
  __O  uint32_t ITIP1;        // <h> Integration Test Input Register 1</h>
                              //   <o.0> SDIN
  __O  uint32_t ITOP1;        // <h> Integration Test Output Register 1</h>
                              //   <o.0> SDOUT
                              //   <o.1> SCLK
                              //   <o.2> LRCK
                              //   <o.3> IRQOUT
} SSE050_I2S_TypeDef;

#define SSE050_I2S_CONTROL_TXEN_Pos        0
#define SSE050_I2S_CONTROL_TXEN_Msk        (1UL<<SSE050_I2S_CONTROL_TXEN_Pos)

#define SSE050_I2S_CONTROL_TXIRQEN_Pos     1
#define SSE050_I2S_CONTROL_TXIRQEN_Msk     (1UL<<SSE050_I2S_CONTROL_TXIRQEN_Pos)

#define SSE050_I2S_CONTROL_RXEN_Pos        2
#define SSE050_I2S_CONTROL_RXEN_Msk        (1UL<<SSE050_I2S_CONTROL_RXEN_Pos)

#define SSE050_I2S_CONTROL_RXIRQEN_Pos     3
#define SSE050_I2S_CONTROL_RXIRQEN_Msk     (1UL<<SSE050_I2S_CONTROL_RXIRQEN_Pos)

#define SSE050_I2S_CONTROL_TXWLVL_Pos      8
#define SSE050_I2S_CONTROL_TXWLVL_Msk      (7UL<<SSE050_I2S_CONTROL_TXWLVL_Pos)

#define SSE050_I2S_CONTROL_RXWLVL_Pos      12
#define SSE050_I2S_CONTROL_RXWLVL_Msk      (7UL<<SSE050_I2S_CONTROL_RXWLVL_Pos)
/* FIFO reset*/
#define SSE050_I2S_CONTROL_FIFORST_Pos     16
#define SSE050_I2S_CONTROL_FIFORST_Msk     (1UL<<SSE050_I2S_CONTROL_FIFORST_Pos)
/* Codec reset*/
#define SSE050_I2S_CONTROL_CODECRST_Pos    17
#define SSE050_I2S_CONTROL_CODECRST_Msk    (1UL<<SSE050_I2S_CONTROL_CODECRST_Pos)

#define SSE050_I2S_STATUS_TXIRQ_Pos        0
#define SSE050_I2S_STATUS_TXIRQ_Msk        (1UL<<SSE050_I2S_STATUS_TXIRQ_Pos)

#define SSE050_I2S_STATUS_RXIRQ_Pos        1
#define SSE050_I2S_STATUS_RXIRQ_Msk        (1UL<<SSE050_I2S_STATUS_RXIRQ_Pos)

#define SSE050_I2S_STATUS_TXEmpty_Pos      2
#define SSE050_I2S_STATUS_TXEmpty_Msk      (1UL<<SSE050_I2S_STATUS_TXEmpty_Pos)

#define SSE050_I2S_STATUS_TXFull_Pos       3
#define SSE050_I2S_STATUS_TXFull_Msk       (1UL<<SSE050_I2S_STATUS_TXFull_Pos)

#define SSE050_I2S_STATUS_RXEmpty_Pos      4
#define SSE050_I2S_STATUS_RXEmpty_Msk      (1UL<<SSE050_I2S_STATUS_RXEmpty_Pos)

#define SSE050_I2S_STATUS_RXFull_Pos       5
#define SSE050_I2S_STATUS_RXFull_Msk       (1UL<<SSE050_I2S_STATUS_RXFull_Pos)

#define SSE050_I2S_ERROR_TXERR_Pos         0
#define SSE050_I2S_ERROR_TXERR_Msk         (1UL<<SSE050_I2S_ERROR_TXERR_Pos)

#define SSE050_I2S_ERROR_RXERR_Pos         1
#define SSE050_I2S_ERROR_RXERR_Msk         (1UL<<SSE050_I2S_ERROR_RXERR_Pos)

/*------------------- I2C ----------------------------------------------*/
typedef struct
{
  __IO    uint32_t  CONTROL;
  __IO    uint32_t  CONTROLC;
}SSE050_I2C_TypeDef;

#define SSE050_I2C_SCL_Pos  0
#define SSE050_I2C_SCL_Msk  (1UL<<SSE050_I2C_SCL_Pos)

#define SSE050_I2C_SDA_Pos  1
#define SSE050_I2C_SDA_Msk  (1UL<<SSE050_I2C_SDA_Pos)

/*------------------- SCC ----------------------------------------------*/
typedef struct
{
          uint32_t  RESERVED0[40];
  __IO    uint32_t  SYS_CFGDATA_SERIAL; /* Offset: 0xA0 APB RW SCC */
  __IO    uint32_t  SYS_CFGDATA_APB;    /* Offset: 0xA4 APB RW SCC */
  __IO    uint32_t  SYS_CFGCTRL;        /* Offset: 0xA8 APB RW SCC */
  __IO    uint32_t  SYS_CFGSTAT;        /* Offset: 0xAC APB RW SCC */
          uint32_t  RESERVED1[20];
  __IO    uint32_t  SCC_DLLLOCK; /* Offset: 0x100 APB R  SCC RW */
  __IO    uint32_t  SCC_LED;     /* Offset: 0x104 APB RW SCC R */
  __IO    uint32_t  SCC_SW;      /* Offset: 0x108 APB R  SCC RW */
          uint32_t  RESERVED2[5];
  __IO    uint32_t  SCC_APBLOCK; /* Offset: 0x120 APB RW SCC R */
          uint32_t  RESERVED3[949];
  __IO    uint32_t  SCC_AID;     /* Offset: 0xff8 APB R  SCC RW */
  __IO    uint32_t  SCC_ID;      /* Offset: 0xffc APB R  SCC RW */
}SSE050_SCC_TypeDef;


/* --------------------  End of section using anonymous unions  ------------------- */

#if defined ( __CC_ARM   )
  #pragma pop
#elif defined(__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning restore
#else
  #warning Not supported compiler type
#endif


/******************************************************************************/
/*                         Peripheral memory map                              */
/******************************************************************************/
/* Peripheral and SRAM base address */
#define SSE050_FLASH_BASE        (0x00000000UL)  /*!< (FLASH     ) Base Address */
#define SSE050_SRAM_BASE         (0x20000000UL)  /*!< (SRAM      ) Base Address */
#define SSE050_SRAM_BANK1_BASE   (0x20008000UL)  /*!< (SRAM      ) Base Address */
#define SSE050_SRAM_BANK2_BASE   (0x20010000UL)  /*!< (SRAM      ) Base Address */
#define SSE050_SRAM_BANK3_BASE   (0x20018000UL)  /*!< (SRAM      ) Base Address */
#define SSE050_SRAM_END_ADDR     (0x20020000UL)  /*!< (SRAM      ) Base Address */
#define SSE050_PERIPH_BASE       (0x40000000UL)  /*!< (Peripheral) Base Address */

#define SSE050_RAM_BASE          (0x20000000UL)
#define SSE050_APB_BASE          (0x40000000UL)
#define SSE050_AHB_BASE          (0x40010000UL)

/* Peripheral and SRAM size */
#define SSE050_FLASH_SIZE        (0x40000UL)
#define SSE050_SRAM_SIZE         (0x20000UL)
#define SSE050_APB_SIZE          (0x10000UL)

/* APB peripherals                                                           */
#define SSE050_TIMER0_BASE       (SSE050_APB_BASE + 0x0000UL)
#define SSE050_TIMER1_BASE       (SSE050_APB_BASE + 0x1000UL)
#define SSE050_DUALTIMER_BASE    (SSE050_APB_BASE + 0x2000UL)
#define SSE050_DUALTIMER_1_BASE  (SSE050_DUALTIMER_BASE)
#define SSE050_DUALTIMER_2_BASE  (SSE050_DUALTIMER_BASE + 0x20UL)
#define SSE050_UART0_BASE        (SSE050_APB_BASE + 0x4000UL)
#define SSE050_UART1_BASE        (SSE050_APB_BASE + 0x5000UL)
#define SSE050_RTC_BASE          (SSE050_APB_BASE + 0x6000UL)
#define SSE050_WATCHDOG_BASE     (SSE050_APB_BASE + 0x8000UL)
#define SSE050_TRNG_BASE         (SSE050_APB_BASE + 0xF000UL)

/* AHB peripherals                                                           */
#define SSE050_ZBT1_BASE         (0x00400000UL)
#define SSE050_ZBT2_BASE         (0x20400000UL)
#define SSE050_PSRAM_BASE        (0x21000000UL)
#define SSE050_GPIO0_BASE        (SSE050_AHB_BASE + 0x0000UL)
#define SSE050_GPIO1_BASE        (SSE050_AHB_BASE + 0x1000UL)
#define SSE050_GPIO2_BASE        (SSE050_AHB_BASE + 0x2000UL)
#define SSE050_GPIO3_BASE        (SSE050_AHB_BASE + 0x3000UL)
#define SSE050_SYSCTRL_BASE      (SSE050_AHB_BASE + 0xF000UL)
#define SSE050_EXTSPI_BASE       (0x40020000UL)
#define SSE050_CLCDSPI_BASE      (0x40021000UL)
#define SSE050_CLCDTOUCH_BASE    (0x40022000UL)
#define SSE050_AUDIOCFG_BASE     (0x40023000UL)
#define SSE050_AUDIO_BASE        (0x40024000UL)
#define SSE050_SPIADC_BASE       (0x40025000UL)
#define SSE050_SPISH0_BASE       (0x40026000UL)
#define SSE050_SPISH1_BASE       (0x40027000UL)
#define SSE050_FPGASYS_BASE      (0x40028000UL)
#define SSE050_AUDIOSH0_BASE     (0x40029000UL)
#define SSE050_AUDIOSH1_BASE     (0x4002A000UL)
#define SSE050_UART2_BASE        (0x4002C000UL)
#define SSE050_UART3_BASE        (0x4002D000UL)
#define SSE050_UART4_BASE        (0x4002E000UL)
#define SSE050_SCC_BASE          (0x4002F000UL)
#define SSE050_GPIO4_BASE        (0x40030000UL)
#define SSE050_GPIO5_BASE        (0x40031000UL)
#define SSE050_ETH_BASE          (0x40200000UL)
#define SSE050_VGACON_BASE       (0x41000000UL)
#define SSE050_VGAIMAGE_BASE     (0x41100000UL)

/* Core peripherals                                                           */
#define SSE050_COREPERIP_BASE    (0xE0000000UL)
#define SSE050_COREAPB_BASE      (0xE0040000UL)
#define SSE050_COREROM_BASE      (0xE00FF000UL)

/******************************************************************************/
/*                         Peripheral declaration                             */
/******************************************************************************/
#define SSE050_UART0             ((SSE050_UART_TypeDef   *) SSE050_UART0_BASE   )
#define SSE050_UART1             ((SSE050_UART_TypeDef   *) SSE050_UART1_BASE   )
#define SSE050_UART2             ((SSE050_UART_TypeDef   *) SSE050_UART2_BASE   )
#define SSE050_UART3             ((SSE050_UART_TypeDef   *) SSE050_UART3_BASE   )
#define SSE050_UART4             ((SSE050_UART_TypeDef   *) SSE050_UART4_BASE   )
#define SSE050_TIMER0            ((SSE050_TIMER_TypeDef  *) SSE050_TIMER0_BASE )
#define SSE050_TIMER1            ((SSE050_TIMER_TypeDef  *) SSE050_TIMER1_BASE )
#define SSE050_DUALTIMER         ((SSE050_DUALTIMER_BOTH_TypeDef  *) SSE050_DUALTIMER_BASE )
#define SSE050_DUALTIMER1        ((SSE050_DUALTIMER_SINGLE_TypeDef  *) SSE050_DUALTIMER_1_BASE )
#define SSE050_DUALTIMER2        ((SSE050_DUALTIMER_SINGLE_TypeDef  *) SSE050_DUALTIMER_2_BASE )
#define SSE050_WATCHDOG          ((SSE050_WATCHDOG_TypeDef  *) SSE050_WATCHDOG_BASE   )
#define SSE050_GPIO0             ((SSE050_GPIO_TypeDef   *) SSE050_GPIO0_BASE )
#define SSE050_GPIO1             ((SSE050_GPIO_TypeDef   *) SSE050_GPIO1_BASE )
#define SSE050_GPIO2             ((SSE050_GPIO_TypeDef   *) SSE050_GPIO2_BASE )
#define SSE050_GPIO3             ((SSE050_GPIO_TypeDef   *) SSE050_GPIO3_BASE )
#define SSE050_GPIO4             ((SSE050_GPIO_TypeDef   *) SSE050_GPIO4_BASE )
#define SSE050_GPIO5             ((SSE050_GPIO_TypeDef   *) SSE050_GPIO5_BASE )
#define SSE050_SYSCON            ((SSE050_SYSCON_TypeDef *) SSE050_SYSCTRL_BASE )
#define SSE050_I2C               ((SSE050_I2C_TypeDef *) SSE050_AUDIOCFG_BASE )
#define SSE050_I2S               ((SSE050_I2S_TypeDef     *) SSE050_AUDIO_BASE )
#define SSE050_FPGASYS           ((SSE050_FPGASYS_TypeDef *) SSE050_FPGASYS_BASE )
#define SSE050_SCC               ((SSE050_SCC_TypeDef *) SSE050_SCC_BASE )

#ifdef __cplusplus
}
#endif

#endif  /* SSE050_H */
