/**************************************************************************//**
 * @file     system_SSE050.h
 * @brief    CMSIS Cortex-M3 Device Peripheral Access Layer Header File for
 *           Device SSE050
 * @version  V3.01
 * @date     06. March 2012
 *
 * @note
 * Copyright (C) 2010-2017  ARM Limited. All rights reserved.
 *
 * @par
 * ARM Limited (ARM) is supplying this software for use with Cortex-M
 * processor based microcontrollers.  This file can be freely distributed
 * within development tools that are supporting such ARM based processors.
 *
 * @par
 * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 ******************************************************************************/


#ifndef SYSTEM_SSE050_H
#define SYSTEM_SSE050_H


#define ADDR_TC_TAG          (0x400F13F0)
#define ADDR_TC_ADDR         (0x400F13F0)
#define ADDR_TC_WDATA        (0x400F13F4)
#define ADDR_TC_RDATA        (0x400F13F8)
#define ADDR_TC_RETURN_VALUE (0x400F13FC)

#define TAG_IDLE           0x00
#define TAG_PRINT          0x01
#define TAG_SH_SYNC        0x02
#define TAG_DUMP           0xFE
#define TAG_FINISH         0xFF
#define WDAT_DUMP_ENA      0xdddd0000
#define WDAT_FINISH_FAIL   0xeeee0000
#define WDAT_FINISH_PASS   0xffff0000
#define WDAT_SH_SYNC_TYP1  0xccdd0001
#define WDAT_SH_SYNC_TYP2  0xccdd0002



#define TEST_PASS               ((uint32_t)0x00)
#define TEST_FAIL               ((uint32_t)0x01)

//#define TESTCASE_PASS           VCS_Finish_Test(TEST_PASS);
//#define TESTCASE_FAIL           VCS_Finish_Test(TEST_FAIL);

//#define START_DUMP_FSDB         VCS_Finish_dump_FSDB();
//#define SH_SYNC_TYP1            VCS_SH_SYNC_TYP1();
//#define SH_SYNC_TYP2            VCS_SH_SYNC_TYP2();


#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

extern uint32_t SystemFrequency;    /*!< System Clock Frequency (Core Clock)  */
extern uint32_t SystemCoreClock;    /*!< Processor Clock Frequency            */


/**
 * Initialize the system
 *
 * @param  none
 * @return none
 *
 * @brief  Setup the microcontroller system.
 *         Initialize the System and update the SystemCoreClock variable.
 */
extern void SystemInit (void);

/**
 * Update SystemCoreClock variable
 *
 * @param  none
 * @return none
 *
 * @brief  Updates the SystemCoreClock with current core Clock
 *         retrieved from cpu registers.
 */
extern void SystemCoreClockUpdate (void);

#ifdef __cplusplus
}
#endif

#endif /* SYSTEM_SSE050_H */
