/*!
    \file    LISOC_RCC.c
    \brief   the LISOC_RCC configuration file

*/

#include "lisoc_test.h"
#include "dpreg_test.h"

#define isp_base 0x20040000
#define cchg_base 0x20040000 + 0x1000
#define lisr_base 0x20040000 + 0x2000
#define mipirx_base 0x20040000 + 0x3000
#define mipitx_base 0x20040000 + 0x4000

ISP_Register_Table_s ISP_Register_rw;
CCHG_Register_Table_s CCHG_Register_rw;
LiSR_Register_Table_s LiSR_Register_rw;
MIPI_Register_Table_RX_s MIPI_Register_RX_rw;
MIPI_Register_Table_TX_s MIPI_Register_TX_rw;

void dpreg_rw_init()
{
  ISP_Register_rw.reg_0x00.NUM_R1 = RO;
  ISP_Register_rw.reg_0x00.NUM_ROW = RW;
  ISP_Register_rw.reg_0x00.NUM_R0 = RO;
  ISP_Register_rw.reg_0x00.NUM_COL = RW;

  ISP_Register_rw.reg_0x04.BAYER_R2 = RO;
  ISP_Register_rw.reg_0x04.BIT_MODE = RW;
  ISP_Register_rw.reg_0x04.THROUGH_MODE = RW;
  ISP_Register_rw.reg_0x04.BAYER_R1 = RO;
  ISP_Register_rw.reg_0x04.BAYER_PATTERN = RW;

  ISP_Register_rw.reg_0x08.OB_B_SUB = RW;
  ISP_Register_rw.reg_0x08.OB_GB_SUB = RW;
  ISP_Register_rw.reg_0x08.OB_GR_SUB = RW;
  ISP_Register_rw.reg_0x08.OB_R_SUB = RW;

  ISP_Register_rw.reg_0x0C.TG_R = RO;
  ISP_Register_rw.reg_0x0C.TOTAL_GAIN = RW;

  ISP_Register_rw.reg_0x10.WBG_R1 = RO;
  ISP_Register_rw.reg_0x10.WB_B_GAIN = RW;
  ISP_Register_rw.reg_0x10.WBG_R0 = RO;
  ISP_Register_rw.reg_0x10.WB_R_GAIN = RW;

  ISP_Register_rw.reg_0x14.GF_R = RO;
  ISP_Register_rw.reg_0x14.GAMMA_FACTOR = RW;
  
  ISP_Register_rw.reg_0x18.APERTURE_V = RW;
  ISP_Register_rw.reg_0x18.APERTURE_H = RW;
  ISP_Register_rw.reg_0x18.APERTURE_RESERVE = RO;
  ISP_Register_rw.reg_0x18.APERTURE_TH = RW;
  
  ISP_Register_rw.reg_0x1C.MATRIX_B_Y_G2 = RW;
  ISP_Register_rw.reg_0x1C.MATRIX_B_Y_G1 = RW;
  ISP_Register_rw.reg_0x1C.MATRIX_R_Y_G2 = RW;
  ISP_Register_rw.reg_0x1C.MATRIX_R_Y_G1 = RW;
  
  ISP_Register_rw.reg_0x20.Y_OUT_R = RO;
  ISP_Register_rw.reg_0x20.Y_OUT_OFFSET = RW;
  ISP_Register_rw.reg_0x20.Y_OUT_GAIN = RW;
  
  ISP_Register_rw.reg_0x24.PSEUDO_R = RO;
  ISP_Register_rw.reg_0x24.PSEUDO_SUPPRESS = RW;
  
  ISP_Register_rw.reg_0x28.AE_AWB_R3 = RO;
  ISP_Register_rw.reg_0x28.AE_AWB_ROW = RW;
  ISP_Register_rw.reg_0x28.AE_AWB_R2 = RO;
  ISP_Register_rw.reg_0x28.AE_AWB_COL = RW;
  ISP_Register_rw.reg_0x28.AE_AWB_R1 = RO;
  ISP_Register_rw.reg_0x28.AE_AWB_UNIT = RW;
  
  ISP_Register_rw.reg_0x2C.IN_OFFSET_R = RO;
  ISP_Register_rw.reg_0x2C.V_IN_OFFSET = RW;
  ISP_Register_rw.reg_0x2C.H_IN_OFFSET = RW;
  
  ISP_Register_rw.reg_0x30.VS_WIDTH = RW;
  ISP_Register_rw.reg_0x30.HS_WIDTH = RW;
  ISP_Register_rw.reg_0x30.V_OUT_OFFSET = RW;
  ISP_Register_rw.reg_0x30.H_OUT_OFFSET = RW;
  
  ISP_Register_rw.reg_0x34.SIZE_R1 = RO;
  ISP_Register_rw.reg_0x34.V_SIZE = RW;
  ISP_Register_rw.reg_0x34.SIZE_R0 = RO;
  ISP_Register_rw.reg_0x34.H_SIZE = RW;
  
  ISP_Register_rw.reg_0x38.OUT_SIZE_R1 = RO;
  ISP_Register_rw.reg_0x38.V_OUT_SIZE = RW;
  ISP_Register_rw.reg_0x38.OUT_SIZE_R0 = RO;
  ISP_Register_rw.reg_0x38.H_OUT_SIZE = RW;
  
  ISP_Register_rw.reg_0x3C.FR_BLK_R1 = RO;
  ISP_Register_rw.reg_0x3C.V_FR_BLK = RW;
  ISP_Register_rw.reg_0x3C.FR_BLK_R0 = RO;
  ISP_Register_rw.reg_0x3C.H_FR_BLK = RW;

  //CCHG_Register_rw.reg_0x00.SFTRST = 
  CCHG_Register_rw.reg_0x04.V_SIZE = RW;
  CCHG_Register_rw.reg_0x04.H_SIZE = RW;

  CCHG_Register_rw.reg_0x08.V_VALID_SIZE = RW;
  CCHG_Register_rw.reg_0x08.H_VALID_SIZE = RW;
  //CCHG_Register_rw.reg_0x0c.W_OUT = 

  CCHG_Register_rw.reg_0x10.BANK_CYCLE = RW;

  LiSR_Register_rw.reg_0x00.IN_SEL = RW;
  LiSR_Register_rw.reg_0x00.IN_FORM = RW;
  LiSR_Register_rw.reg_0x00.IN_FRATE = RW;
  LiSR_Register_rw.reg_0x00.IN_HSIZE = RW;
  LiSR_Register_rw.reg_0x00.IN_VSIZE = RW;

  LiSR_Register_rw.reg_0x04.INH_SD = RW;
  LiSR_Register_rw.reg_0x04.SD_MODE = RW;
  LiSR_Register_rw.reg_0x04.SD_HSIZE = RW;
  LiSR_Register_rw.reg_0x04.SD_VSIZE = RW;

  LiSR_Register_rw.reg_0x08.SD_HOFS = RW;
  LiSR_Register_rw.reg_0x08.SD_VOFS = RW;

  LiSR_Register_rw.reg_0x0c.OUT_RESO = RW;
  LiSR_Register_rw.reg_0x0c.OUT_FRATE = RW;
  LiSR_Register_rw.reg_0x0c.OUT_I_P = RW;
  LiSR_Register_rw.reg_0x0c.AHE_BLKSIZ = RW;
  LiSR_Register_rw.reg_0x0c.CROP_HOFF = RW;
  LiSR_Register_rw.reg_0x0c.CROP_VOFF = RW;

  LiSR_Register_rw.reg_0x10.IN_RANGE = RW;
  LiSR_Register_rw.reg_0x10.OUT_RANGE = RW;
  LiSR_Register_rw.reg_0x10.T0444AVE = RW;
  LiSR_Register_rw.reg_0x10.T0422AVE = RW;
  LiSR_Register_rw.reg_0x10.Y8RND = RW;
  LiSR_Register_rw.reg_0x10.NR8MEM10 = RW;

  LiSR_Register_rw.reg_0x14.MED_FIL = RW;
  LiSR_Register_rw.reg_0x14.TMAP4 = RW;
  LiSR_Register_rw.reg_0x14.TMAP3 = RW;
  LiSR_Register_rw.reg_0x14.TMAP2 = RW;
  LiSR_Register_rw.reg_0x14.TMAP1 = RW;
  LiSR_Register_rw.reg_0x14.K_FIL4 = RW;
  LiSR_Register_rw.reg_0x14.K_ADDON4 = RW;
  LiSR_Register_rw.reg_0x14.K4_EXP = RW;
  LiSR_Register_rw.reg_0x14.K_FIL3 = RW;
  LiSR_Register_rw.reg_0x14.K_ADDON3 = RW;
  LiSR_Register_rw.reg_0x14.K3_EXP = RW;
  LiSR_Register_rw.reg_0x14.K_FIL2 = RW;
  LiSR_Register_rw.reg_0x14.K_ADDON2 = RW;
  LiSR_Register_rw.reg_0x14.K2_EXP = RW;
  LiSR_Register_rw.reg_0x14.K_FIL1 = RW;
  LiSR_Register_rw.reg_0x14.K_ADDON1 = RW;
  LiSR_Register_rw.reg_0x14.K1_EXP = RW;

  LiSR_Register_rw.reg_0x18.AHE_ON = RW;
  LiSR_Register_rw.reg_0x18.VIDEO_ON = RW;
  LiSR_Register_rw.reg_0x18.OUT_FORM = RW;
  LiSR_Register_rw.reg_0x18.OUT_THRU = RW;
  LiSR_Register_rw.reg_0x18.OUT_DISP_ON = RW;
  
  LiSR_Register_rw.reg_0x1c.AHE_HOFS = RW;
  LiSR_Register_rw.reg_0x20.AHE_HWIDH = RW;
  LiSR_Register_rw.reg_0x24.AHE_VOFS = RW;
  LiSR_Register_rw.reg_0x28.AHE_VWIDH = RW;

  LiSR_Register_rw.reg_0x34.CONTRAST = RW;
  LiSR_Register_rw.reg_0x34.T_MAP_SHAP = RW;
  LiSR_Register_rw.reg_0x34.AUTO_OFFSET = RW;
  LiSR_Register_rw.reg_0x34.PIXEL_CONV = RW;

  LiSR_Register_rw.reg_0x38.T_MAP_TH = RW;
  LiSR_Register_rw.reg_0x38.T_MAP_OFFSET = RW;

  LiSR_Register_rw.reg_0x3c.AOFF_VAL = RW;
  LiSR_Register_rw.reg_0x3c.FCF_ON = RW;
  LiSR_Register_rw.reg_0x3c.AHEF_ON = RW;
  LiSR_Register_rw.reg_0x3c.UVENHON = RW;
  LiSR_Register_rw.reg_0x3c.MOVESW = RW;

  LiSR_Register_rw.reg_0x40.ALPHA_AHE = RW;
  LiSR_Register_rw.reg_0x44.ALPHA_FC = RW;

  LiSR_Register_rw.reg_0x48.CRATE = RW;
  LiSR_Register_rw.reg_0x48.CB_OFSET = RW;
  LiSR_Register_rw.reg_0x4C.CR_OFSET = RW;

  LiSR_Register_rw.reg_0x50.MDBLD = RW;
  LiSR_Register_rw.reg_0x50.MOVETHVAL = RW;
  LiSR_Register_rw.reg_0x54.YBUF_BLD = RW;
  LiSR_Register_rw.reg_0x54.NEWY_BLD = RW;
  LiSR_Register_rw.reg_0x58.UVBUF_BLD = RW;
  LiSR_Register_rw.reg_0x58.NEWUV_BLD = RW;
  LiSR_Register_rw.reg_0x60.KVAL_1U = RW;
  LiSR_Register_rw.reg_0x60.KVAL_1L = RW;
  LiSR_Register_rw.reg_0x64.KVAL_2U = RW;
  LiSR_Register_rw.reg_0x64.KVAL_2L = RW;
  LiSR_Register_rw.reg_0x68.KVAL_3U = RW;
  LiSR_Register_rw.reg_0x68.KVAL_3L = RW;
  LiSR_Register_rw.reg_0x6C.KVAL_4U = RW;
  LiSR_Register_rw.reg_0x6C.KVAL_4L = RW;
  LiSR_Register_rw.reg_0x7C.HIST_ON = RW;
  LiSR_Register_rw.reg_0x7C.AVE_YUV = RW;
  LiSR_Register_rw.reg_0x80.YAVE_XP = RW;
  LiSR_Register_rw.reg_0x84.YAVE_YP = RW;
  LiSR_Register_rw.reg_0x88.YAVE_HW = RW;
  LiSR_Register_rw.reg_0x8C.YAVE_VW = RW;
  LiSR_Register_rw.reg_0x90.CAVE_XP = RW;
  LiSR_Register_rw.reg_0x94.CAVE_YP = RW;
  LiSR_Register_rw.reg_0x98.CAVE_HW = RW;
  LiSR_Register_rw.reg_0x9C.CAVE_VW = RW;

  LiSR_Register_rw.reg_0xD0.PN_SW_LED1 = RW;
  //LiSR_Register_rw.reg_0xEC.FLG_CLR wc
  LiSR_Register_rw.reg_0xF0.SOFT_RST = RW;
  LiSR_Register_rw.reg_0xF0.SYS_RST = RW;
  LiSR_Register_rw.reg_0xF4.LEDC = RW;
  LiSR_Register_rw.reg_0xF4.LEDP = RW;
  LiSR_Register_rw.reg_0xF8.DIPSW = RW;
  //LiSR_Register_rw.reg_0xFC.REVISION = RW;

  MIPI_Register_RX_rw.reg_0x000.LINK_P0_RST_N = RW;
  MIPI_Register_RX_rw.reg_0x000.PHYA_RX_PDATA_RESET_N = RW;

  MIPI_Register_RX_rw.reg_0x004.MODE_P0_OPERATION = RW;
  MIPI_Register_RX_rw.reg_0x00C.PHYA_RX_MODE = RW;
  MIPI_Register_RX_rw.reg_0x010.MODE_P0_PIX_PARA = RW;
  MIPI_Register_RX_rw.reg_0x014.PHYA_RX_IREF_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x018.PHYA_RX_C0_LP_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x018.PHYA_RX_C0_HS_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x01C.PHYA_RX_D3_LP_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x01C.PHYA_RX_D2_LP_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x01C.PHYA_RX_D1_LP_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x01C.PHYA_RX_D0_LP_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x020.PHYA_RX_D3_HS_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x020.PHYA_RX_D2_HS_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x020.PHYA_RX_D1_HS_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x020.PHYA_RX_D0_HS_AMP_POW_EN = RW;
  MIPI_Register_RX_rw.reg_0x024.PHYA_RX_C0_RES_EN = RW;
  MIPI_Register_RX_rw.reg_0x028.PHYA_RX_D3_RES_EN = RW;
  MIPI_Register_RX_rw.reg_0x028.PHYA_RX_D2_RES_EN = RW;
  MIPI_Register_RX_rw.reg_0x028.PHYA_RX_D1_RES_EN = RW;
  MIPI_Register_RX_rw.reg_0x028.PHYA_RX_D0_RES_EN = RW;
  MIPI_Register_RX_rw.reg_0x034.PHYA_RX_RESCTL = RW;
  MIPI_Register_RX_rw.reg_0x060.PHYA_RX_BUS_MODE = RW;
  MIPI_Register_RX_rw.reg_0x088.PHYA_RX_IRMSEL = RW;
  MIPI_Register_RX_rw.reg_0x088.PHYA_RX_VRMSEL = RW;
  MIPI_Register_RX_rw.reg_0x0A8.PHYA_RX_LP_HL = RW;
  MIPI_Register_RX_rw.reg_0x0A8.PHYA_RX_LP_LH = RW;
  MIPI_Register_RX_rw.reg_0x0A8.PHYA_RX_OFFSET = RW;
  MIPI_Register_RX_rw.reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_3 = RW;
  MIPI_Register_RX_rw.reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_2 = RW;
  MIPI_Register_RX_rw.reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_1 = RW;
  MIPI_Register_RX_rw.reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_0 = RW;
  MIPI_Register_RX_rw.reg_0x0AC.MODE_P0_LBL_FIDMAP_SEL_EN = RW;
  MIPI_Register_RX_rw.reg_0x0AC.MODE_P0_LBL = RW;
  MIPI_Register_RX_rw.reg_0x118.DPHY_P0_MODE_LPOP_OFF = RW;
  MIPI_Register_RX_rw.reg_0x118.DPHY_P0_MODE_MSB_FIRST = RW;
  MIPI_Register_RX_rw.reg_0x118.DPHY_P0_MODE_HSDM_OFF = RW;
  MIPI_Register_RX_rw.reg_0x118.DPHY_P0_LP_SYNC_OFF = RW;
  MIPI_Register_RX_rw.reg_0x118.DPHY_P0_MODE_LANENUM = RW;
  MIPI_Register_RX_rw.reg_0x120.DPHY_P0_PREG_DLM_3 = RW;
  MIPI_Register_RX_rw.reg_0x120.DPHY_P0_PREG_DLM_2 = RW;
  MIPI_Register_RX_rw.reg_0x120.DPHY_P0_PREG_DLM_1 = RW;
  MIPI_Register_RX_rw.reg_0x120.DPHY_P0_PREG_DLM_0 = RW;
  MIPI_Register_RX_rw.reg_0x164.DPHY_P0_TIME_RES_ON = RW;
  MIPI_Register_RX_rw.reg_0x164.DPHY_P0_TIME_HS_ON = RW;

  MIPI_Register_RX_rw.reg_0x2A0.APP_P0_CHK_VENA = RW;
  MIPI_Register_RX_rw.reg_0x2A0.APP_P0_CHK_HENA = RW;
  MIPI_Register_RX_rw.reg_0x2A4.APP_P0_CHK_VSIZE = RW;
  MIPI_Register_RX_rw.reg_0x2A4.APP_P0_CHK_HSIZE = RW;
  MIPI_Register_RX_rw.reg_0xD54.CSI2_P0_DATA_TYPE_USER = RW;
  MIPI_Register_RX_rw.reg_0xF00.RX_PCLK_DIV_EN = RW;
  MIPI_Register_RX_rw.reg_0xF00.RX_PDATA_OUT_SEL = RW;
  MIPI_Register_RX_rw.reg_0xF00.REG_RDA_SEL = RW;
  MIPI_Register_RX_rw.reg_0xFC0.USER_CTRL = RW;

  MIPI_Register_TX_rw.reg_0x000.PHYA_PLL_RESETN = RW;
  MIPI_Register_TX_rw.reg_0x000.PHYA_PLL_ANA_EN = RW;
  MIPI_Register_TX_rw.reg_0x000.PHYA_CNT_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x000.PHYA_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x000.PHYA_EN = RW;
  MIPI_Register_TX_rw.reg_0x000.PHYA_TX_POW_EN = RW;
  MIPI_Register_TX_rw.reg_0x000.PHYA_REF_POW_EN = RW;
  MIPI_Register_TX_rw.reg_0x004.PHYA_PLL_K3DIV = RW;
  MIPI_Register_TX_rw.reg_0x004.PHYA_PLL_K2DIV = RW;
  MIPI_Register_TX_rw.reg_0x004.PHYA_PLL_K1DIV = RW;
  MIPI_Register_TX_rw.reg_0x004.PHYA_PLL_N2DIV = RW;
  MIPI_Register_TX_rw.reg_0x004.PHYA_PLL_N1DIV = RW;
  MIPI_Register_TX_rw.reg_0x004.PHYA_PLL_PDIV = RW;
  MIPI_Register_TX_rw.reg_0x008.PHYA_PLL_VCO_IGAIN = RW;
  MIPI_Register_TX_rw.reg_0x008.PHYA_PLL_OSC_CLMP_DIS = RW;
  MIPI_Register_TX_rw.reg_0x008.PHYA_PLL_V2I_OFFSET = RW;
  MIPI_Register_TX_rw.reg_0x008.PHYA_PLL_OSC_SEL = RW;
  MIPI_Register_TX_rw.reg_0x008.PHYA_PLL_KVCO_TRIM = RW;
  MIPI_Register_TX_rw.reg_0x008.PHYA_PLL_CHP_TRIM = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_PLL_LPE_SEL_3ORD = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_PLL_LPF_RSEL = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_PLL_LPF_CSEL = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_CK_EDG = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_POL_SCK = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_IRM = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_VRM = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_ZDN = RW;
  MIPI_Register_TX_rw.reg_0x00C.PHYA_ZUP = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D3_INITDATA = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D2_INITDATA = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D1_INITDATA = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D0_INITDATA = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D3_PN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D2_PN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D1_PN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D0_PN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_CK_PN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D3_PLDN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D2_PLDN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D1_PLDN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D0_PLDN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_CK_PLDN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D3_POW_EN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D2_POW_EN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D1_POW_EN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_D0_POW_EN = RW;
  MIPI_Register_TX_rw.reg_0x010.PHYA_CK_POW_EN = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D3_LPTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D2_LPTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D1_LPTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D0_LPTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_CK_LPTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D3_LPTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D2_LPTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D1_LPTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D0_LPTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_CK_LPTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D3_HSTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D2_HSTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D1_HSTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D0_HSTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_CK_HSTX_EN_RST_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D3_HSTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D2_HSTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D1_HSTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_D0_HSTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x014.PHYA_CK_HSTX_EN_SET_N = RW;
  MIPI_Register_TX_rw.reg_0x018.PHYA_D3_DLY = RW;
  MIPI_Register_TX_rw.reg_0x018.PHYA_D2_DLY = RW;
  MIPI_Register_TX_rw.reg_0x018.PHYA_D1_DLY = RW;
  MIPI_Register_TX_rw.reg_0x018.PHYA_D0_DLY = RW;
  MIPI_Register_TX_rw.reg_0x018.PHYA_CK_DLY = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D3_TST_PSI = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D2_TST_PSI = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D1_TST_PSI = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D0_TST_PSI = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_CK_TST_PSI = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D3_TSTIN_N = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D3_TSTIN_P = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D2_TSTIN_N = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D2_TSTIN_P = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D1_TSTIN_N = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D1_TSTIN_P = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D0_TSTIN_N = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_D0_TSTIN_P = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_CK_TSTIN_N = RW;
  MIPI_Register_TX_rw.reg_0x020.PHYA_CK_TSTIN_P = RW;

  MIPI_Register_TX_rw.reg_0x030.DPHY_P0_TX_LP11 = RW;
  MIPI_Register_TX_rw.reg_0x030.DPHY_P0_TX_LP10 = RW;
  MIPI_Register_TX_rw.reg_0x030.DPHY_P0_TX_LP01 = RW;
  MIPI_Register_TX_rw.reg_0x030.DPHY_P0_TX_LP00 = RW;
  MIPI_Register_TX_rw.reg_0x030.CSI2_P0_TX_TC = RW;
  MIPI_Register_TX_rw.reg_0x030.CSI2_P0_TX_TS = RW;
  MIPI_Register_TX_rw.reg_0x100.MODE_LANENUM = RW;
  MIPI_Register_TX_rw.reg_0x034.DPHY_P0_TX_TIME_T_CLK_PRE = RW;
  MIPI_Register_TX_rw.reg_0x034.DPHY_P0_TX_TIME_T_CLK_ZERO = RW;
  MIPI_Register_TX_rw.reg_0x034.DPHY_P0_TX_TIME_T_CLK_PREPARE = RW;
  MIPI_Register_TX_rw.reg_0x034.DPHY_P0_TX_TIME_T_CLK_LPX = RW;
  MIPI_Register_TX_rw.reg_0x038.DPHY_P0_TX_TIME_T_HS_EOT = RW;
  MIPI_Register_TX_rw.reg_0x038.DPHY_P0_TX_TIME_T_HS_SOT = RW;
  MIPI_Register_TX_rw.reg_0x038.DPHY_P0_TX_TIME_T_HS_ZERO = RW;
  MIPI_Register_TX_rw.reg_0x038.DPHY_P0_TX_TIME_T_HS_PREPARE = RW;
  MIPI_Register_TX_rw.reg_0x03C.DPHY_P0_TX_TIME_T_CLK_EOT = RW;
  MIPI_Register_TX_rw.reg_0x03C.DPHY_P0_TX_TIME_T_CLK_POST = RW;
  MIPI_Register_TX_rw.reg_0x040.DPHY_P0_TX_DESKEW_LENGTH = RW;
  MIPI_Register_TX_rw.reg_0x040.DPHY_P0_TX_DESKEW_AUTO = RW;
  MIPI_Register_TX_rw.reg_0x044.CSI2_P0_TX_HD_DLY = RW;
  MIPI_Register_TX_rw.reg_0x044.CSI2_P0_TX_SP_DLY = RW;

  MIPI_Register_TX_rw.reg_0x054.CSI2_P0_TX_DATA_TYPE_USER = RW;
  MIPI_Register_TX_rw.reg_0xF00.PHYA_PLL_ANA_MON_SEL = RW;
  MIPI_Register_TX_rw.reg_0xF00.PHYA_PLL_ANA_TSTPD_EN = RW;
  MIPI_Register_TX_rw.reg_0xF00.PHYA_TSTTX = RW;
  MIPI_Register_TX_rw.reg_0xF00.REG_RDA_SEL = RW;
  MIPI_Register_TX_rw.reg_0xFC0.USER_CTRL = RW;

}

void reg_test(uint32_t *p_addr,uint32_t size,uint32_t *reg_addr)
{
  uint8_t bit_val,bit_pos;
  uint32_t reg_val,reg_pos;

  for(reg_pos = 0; reg_pos <= size; reg_pos += 4){
    reg_val = *(p_addr + reg_pos/4);
    if(reg_val !=0){
      //printf("0x%03x[ ",reg_pos);
      for(bit_pos = 0; bit_pos < 32; bit_pos++){
      bit_val = (reg_val >> bit_pos) & 0x01;
        if(bit_val == BIT_RW){
          *(reg_addr + reg_pos/4) |= 1u << bit_pos;
          //printf("1:0x%0x %d\n",*reg_addr,bit_pos);
          delay_ms(1);
          if(((*(reg_addr + reg_pos/4) >> bit_pos ) & 0x01) != 0x01){
            printf("0x%03x[ %d ] write 1 ng %d\n",reg_addr + reg_pos/4,bit_pos,(*(reg_addr + reg_pos/4) >> bit_pos ) & 0x01);
          }
          #if 1
          *(reg_addr + reg_pos/4) &= ~(0x1 << bit_pos);;
          //printf("0:0x%0x %d\n",*reg_addr,bit_pos);
          delay_ms(1);
          if(((*(reg_addr + reg_pos/4) >> bit_pos ) & 0x01) != 0x00){
            printf("0x%03x[ %d ] write 0 ng %d\n",reg_addr + reg_pos/4,bit_pos,(*(reg_addr + reg_pos/4) >> bit_pos ) & 0x01);
          }
          #endif
        }
      }
      //printf("]\n");
    }
  }

}

void dpreg_test(void)
{

  dpreg_rw_init();

  //ISP_Register_rw.reg_0x00_W = RW;
  //printf("isp reg test %x\n",*(uint32_t *)(LISOC_ISP_BASE));

  //reg_test((uint32_t *)&ISP_Register_rw.reg_0x00_W,0x00,(uint32_t *)(LISOC_CACHE_BASE+0x8));
  //printf("lisr reg test\n");
  //reg_test((uint32_t *)&LiSR_Register_rw.reg_0x00_W,0xFC,(uint32_t *)LISOC_LISR_BASE);

#if 0
  LISOC_LISR->reg_0x7C.HIST_ON = 0;
  delay_ms(1000);
  LISOC_LISR->reg_0x7C.HIST_ON = 1;
  delay_ms(1000);
  LISOC_LISR->reg_0x7C.HIST_ON = 0;
#endif
  #if 1

  printf("isp reg test start\n");
  reg_test((uint32_t *)&ISP_Register_rw.reg_0x00_W,0x3C,(uint32_t *)LISOC_ISP_BASE);
  printf("isp reg test end\n");

  printf("cchg reg test\n");
  reg_test((uint32_t *)&CCHG_Register_rw.reg_0x00_W,0x10,(uint32_t *)LISOC_CCHG_BASE);
  printf("cchg reg test end\n");

  printf("lisr reg test\n");
  reg_test((uint32_t *)&LiSR_Register_rw.reg_0x00_W,0xFC,(uint32_t *)LISOC_LISR_BASE);
  printf("lisr reg test end\n");

  printf("mipi rx reg test\n");
  reg_test((uint32_t *)&MIPI_Register_RX_rw.reg_0x000_W,0xFC0,(uint32_t *)LISOC_MIPI_RX_BASE);
  printf("mipi rx reg test end\n");

  printf("mipi tx reg test\n");
  reg_test((uint32_t *)&MIPI_Register_TX_rw.reg_0x000_W,0xFC0,(uint32_t *)LISOC_MIPI_TX_BASE);
  printf("mipi tx reg test end\n");

  #endif
}

