#include "lisoc_test.h"
#include "wdt_test.h"

#define INT_TIMEOUT 5000

 /*!
    \brief      wdt test
    \param[in]  none
    \param[out] none
    \retval     none
*/
void wdt_test(void)
{
  uint32_t int_tmo;

  printf("watch dog test start\n");
  // tbench.u_lisoc.WDT_PAUSE
  NVIC_DisableIRQ(WDT_IRQn);  //wdt irq disable  
  //WDT_TORR = 0x06; //initial counter will be 3fffff
  WDT_CRR = 0x76; //restart the counter

  int_tmo = SysTick1msCount + INT_TIMEOUT;

  SysTick1msStart = SysTick1msCount;
  while ((WDT_STAT & 0x1) == 0x0 && IS_TIME_NOT_REACHED(int_tmo)) {
    ;
  }
  SysTick1msEnd = SysTick1msCount;
  
  //restart the counter
  WDT_CRR = 0x76;
  NVIC_EnableIRQ(WDT_IRQn);  //wdt irq enable

  if((SysTick1msEnd - SysTick1msStart) < INT_TIMEOUT){
    debug("watch dog trigger: %d ms\n",SysTick1msEnd - SysTick1msStart);
    printf("watch dog test pass\n");
  }else{
    printf("watch dog test fail\n");
  }
  
}


