/*!
    \file    datapath.c
    \brief   the datapath configuration file

*/

#include "lisoc_test.h"
#include "datapath.h"
#include "dp_config\datapath_fhd60_yuv422_8.h"
#include "dp_config\datapath_uhd30_yuv422_8.h"
#include "dp_config\datapath_uhd60_yuv422_8.h"


//#define LISR_THRU

ST_DatapathCfg datapath_def_cfg;
/*!
    \brief      datapath init
    \param[in]  none
    \param[out] none
    \retval     none
*/
#if 1
void datapath_init()
{
  // MIPI-Rx configuration
  LISOC_MIPI_RX->addr_0x118.DPHY_P0_MODE_LANENUM = datapath_def_cfg.DPHY_P0_MODE_LANENUM;
  LISOC_MIPI_RX->addr_0x164.DPHY_P0_TIME_RES_ON = datapath_def_cfg.DPHY_P0_TIME_RES_ON;
  LISOC_MIPI_RX->addr_0x2A0.APP_P0_CHK_VENA = datapath_def_cfg.APP_P0_CHK_VENA;
  LISOC_MIPI_RX->addr_0x2A0.APP_P0_CHK_HENA = datapath_def_cfg.APP_P0_CHK_HENA;
  LISOC_MIPI_RX->addr_0x2A4.APP_P0_CHK_VSIZE = datapath_def_cfg.APP_P0_CHK_VSIZE;
  LISOC_MIPI_RX->addr_0x2A4.APP_P0_CHK_HSIZE = datapath_def_cfg.APP_P0_CHK_HSIZE;


  //-------Main Mode Setting
  delay_us(1);

  LISOC_MIPI_RX->addr_0x4.MODE_P0_OPERATION = datapath_def_cfg.MODE_P0_OPERATION;
  LISOC_MIPI_RX->addr_0xC.PHYA_RX_MODE = datapath_def_cfg.PHYA_RX_MODE;
  LISOC_MIPI_RX->addr_0x10.MODE_P0_PIX_PARA = datapath_def_cfg.MODE_P0_PIX_PARA;

  //-------Link Layer Reset
  delay_us(20);
  
  LISOC_MIPI_RX->addr_0x0.LINK_P0_RST_N = datapath_def_cfg.LINK_P0_RST_N;

  //-------Power Down for PHYA
  delay_us(1);

  LISOC_MIPI_RX->addr_0x14.PHYA_RX_IREF_POW_EN = datapath_def_cfg.PHYA_RX_IREF_POW_EN;

  delay_us(20);

  LISOC_MIPI_RX->addr_0x18.PHYA_RX_C0_LP_AMP_POW_EN = datapath_def_cfg.PHYA_RX_C0_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x18.PHYA_RX_C0_HS_AMP_POW_EN = datapath_def_cfg.PHYA_RX_C0_HS_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x1C.PHYA_RX_D3_LP_AMP_POW_EN = datapath_def_cfg.PHYA_RX_D3_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x1C.PHYA_RX_D2_LP_AMP_POW_EN = datapath_def_cfg.PHYA_RX_D2_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x1C.PHYA_RX_D1_LP_AMP_POW_EN = datapath_def_cfg.PHYA_RX_D1_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x1C.PHYA_RX_D0_LP_AMP_POW_EN = datapath_def_cfg.PHYA_RX_D0_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x20.PHYA_RX_D3_HS_AMP_POW_EN = datapath_def_cfg.PHYA_RX_D3_HS_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x20.PHYA_RX_D2_HS_AMP_POW_EN = datapath_def_cfg.PHYA_RX_D2_HS_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x20.PHYA_RX_D1_HS_AMP_POW_EN = datapath_def_cfg.PHYA_RX_D1_HS_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x20.PHYA_RX_D0_HS_AMP_POW_EN = datapath_def_cfg.PHYA_RX_D0_HS_AMP_POW_EN;
//#100;
  delay_us(20);

  if(test_cmd == UHD60_RAW10_RXTX_TEST){
    LISOC_MIPI_RX->addr_0xD50_W = 0x1;
    LISOC_MIPI_RX->addr_0xD54_W = 0x00200000;
  }

  if(LISOC_SYSCFG->SOC_CCON1.mipi_rx_tx_thru == 0){ 

  if(datapath_def_cfg.BIT_MODE == 0){ //0:10bit,1:12bit
    LISOC_MIPI_RX->addr_0xD50_W = 0x1;
    LISOC_MIPI_RX->addr_0xD54_W = 0x00200000;
  }else{
    LISOC_MIPI_RX->addr_0xD50_W = 0x2;
    LISOC_MIPI_RX->addr_0xD54_W = 0x00400000;
  }

    


    // CCHG configuration
    LISOC_CCHG->addr_0x04.V_SIZE = datapath_def_cfg.CCHG_V_SIZE;
    LISOC_CCHG->addr_0x04.H_SIZE = datapath_def_cfg.CCHG_H_SIZE;
    LISOC_CCHG->addr_0x08.V_VALID_SIZE = datapath_def_cfg.V_VALID_SIZE;
    LISOC_CCHG->addr_0x08.H_VALID_SIZE = datapath_def_cfg.H_VALID_SIZE;
    LISOC_CCHG->addr_0x10.BANK_CYCLE = datapath_def_cfg.BANK_CYCLE;


    // ISP configuration
    LISOC_ISP->addr_0x00.NUM_ROW = datapath_def_cfg.NUM_ROW;
    LISOC_ISP->addr_0x00.NUM_COL = datapath_def_cfg.NUM_COL;
    
    LISOC_ISP->addr_0x04.BIT_MODE = datapath_def_cfg.BIT_MODE;
    LISOC_ISP->addr_0x04.THROUGH_MODE = datapath_def_cfg.THROUGH_MODE;
    LISOC_ISP->addr_0x04.BAYER_PATTERN = datapath_def_cfg.BAYER_PATTERN;
    
    LISOC_ISP->addr_0x08.OB_B_SUB = datapath_def_cfg.OB_B_SUB;
    LISOC_ISP->addr_0x08.OB_GB_SUB = datapath_def_cfg.OB_GB_SUB;
    LISOC_ISP->addr_0x08.OB_GR_SUB = datapath_def_cfg.OB_GR_SUB;
    LISOC_ISP->addr_0x08.OB_R_SUB = datapath_def_cfg.OB_R_SUB;
    
    LISOC_ISP->addr_0x0C.TOTAL_GAIN = datapath_def_cfg.TOTAL_GAIN;
    
    LISOC_ISP->addr_0x10.WB_B_GAIN = datapath_def_cfg.WB_B_GAIN;
    LISOC_ISP->addr_0x10.WB_R_GAIN = datapath_def_cfg.WB_R_GAIN;
    
    LISOC_ISP->addr_0x14.GAMMA_FACTOR = datapath_def_cfg.GAMMA_FACTOR;
    
    LISOC_ISP->addr_0x18.APERTURE_V = datapath_def_cfg.APERTURE_V;
    LISOC_ISP->addr_0x18.APERTURE_H = datapath_def_cfg.APERTURE_H;
    LISOC_ISP->addr_0x18.APERTURE_TH = datapath_def_cfg.APERTURE_TH;
    
    LISOC_ISP->addr_0x1C.MATRIX_B_Y_G2 = datapath_def_cfg.MATRIX_B_Y_G2;
    LISOC_ISP->addr_0x1C.MATRIX_B_Y_G1 = datapath_def_cfg.MATRIX_B_Y_G1;
    LISOC_ISP->addr_0x1C.MATRIX_R_Y_G2 = datapath_def_cfg.MATRIX_R_Y_G2;
    LISOC_ISP->addr_0x1C.MATRIX_R_Y_G1 = datapath_def_cfg.MATRIX_R_Y_G1;
    
    LISOC_ISP->addr_0x20.Y_OUT_OFFSET = datapath_def_cfg.Y_OUT_OFFSET;
    LISOC_ISP->addr_0x20.Y_OUT_GAIN = datapath_def_cfg.Y_OUT_GAIN;
    
    LISOC_ISP->addr_0x24.PSEUDO_SUPPRESS = datapath_def_cfg.PSEUDO_SUPPRESS;
    
    LISOC_ISP->addr_0x28.AE_AWB_ROW = datapath_def_cfg.AE_AWB_COL;
    LISOC_ISP->addr_0x28.AE_AWB_COL = datapath_def_cfg.AE_AWB_ROW;
    LISOC_ISP->addr_0x28.AE_AWB_UNIT = datapath_def_cfg.AE_AWB_UNIT;
    
    LISOC_ISP->addr_0x2C.V_IN_OFFSET = datapath_def_cfg.V_IN_OFFSET;
    LISOC_ISP->addr_0x2C.H_IN_OFFSET = datapath_def_cfg.H_IN_OFFSET;
    
    LISOC_ISP->addr_0x30.VS_WIDTH = datapath_def_cfg.VS_WIDTH;
    LISOC_ISP->addr_0x30.HS_WIDTH = datapath_def_cfg.HS_WIDTH;
    LISOC_ISP->addr_0x30.V_OUT_OFFSET = datapath_def_cfg.V_OUT_OFFSET;
    LISOC_ISP->addr_0x30.H_OUT_OFFSET = datapath_def_cfg.H_OUT_OFFSET;
    
    LISOC_ISP->addr_0x34.V_SIZE = datapath_def_cfg.V_SIZE;
    LISOC_ISP->addr_0x34.H_SIZE = datapath_def_cfg.H_SIZE;
    
    LISOC_ISP->addr_0x38.V_OUT_SIZE = datapath_def_cfg.V_OUT_SIZE;
    LISOC_ISP->addr_0x38.H_OUT_SIZE = datapath_def_cfg.H_OUT_SIZE;
    
    LISOC_ISP->addr_0x3C.V_FR_BLK = datapath_def_cfg.V_FR_BLK;
    LISOC_ISP->addr_0x3C.H_FR_BLK = datapath_def_cfg.H_FR_BLK;

    //LISR configuration

    LISOC_LISR->addr_0x00.IN_SEL = datapath_def_cfg.IN_SEL;
    LISOC_LISR->addr_0x00.IN_FORM = datapath_def_cfg.IN_FORM;
    LISOC_LISR->addr_0x00.IN_FRATE = datapath_def_cfg.IN_FRATE;
    LISOC_LISR->addr_0x00.IN_HSIZE = datapath_def_cfg.IN_HSIZE;
    LISOC_LISR->addr_0x00.IN_VSIZE = datapath_def_cfg.IN_VSIZE;

    LISOC_LISR->addr_0x04.INH_SD = datapath_def_cfg.INH_SD;
    LISOC_LISR->addr_0x04.SD_MODE = datapath_def_cfg.SD_MODE;
    LISOC_LISR->addr_0x04.SD_HSIZE = datapath_def_cfg.SD_HSIZE;
    LISOC_LISR->addr_0x04.SD_VSIZE = datapath_def_cfg.SD_VSIZE;
    
    LISOC_LISR->addr_0x0c.OUT_RESO = datapath_def_cfg.OUT_RESO;
    LISOC_LISR->addr_0x0c.OUT_FRATE = datapath_def_cfg.OUT_FRATE;
    LISOC_LISR->addr_0x0c.OUT_I_P = datapath_def_cfg.OUT_I_P;
    LISOC_LISR->addr_0x0c.AHE_BLKSIZ = datapath_def_cfg.AHE_BLKSIZ;
    LISOC_LISR->addr_0x0c.CROP_HOFF = datapath_def_cfg.CROP_HOFF;
    LISOC_LISR->addr_0x0c.CROP_VOFF = datapath_def_cfg.CROP_VOFF;

    LISOC_LISR->addr_0x18.AHE_ON = datapath_def_cfg.AHE_ON;
    LISOC_LISR->addr_0x18.VIDEO_ON = datapath_def_cfg.VIDEO_ON;
    LISOC_LISR->addr_0x18.OUT_FORM = datapath_def_cfg.OUT_FORM;
    LISOC_LISR->addr_0x18.OUT_THRU = datapath_def_cfg.OUT_THRU;
    LISOC_LISR->addr_0x18.OUT_DISP_ON = datapath_def_cfg.OUT_DISP_ON;

    LISOC_LISR->addr_0x20.AHE_HWIDH = datapath_def_cfg.AHE_HWIDTH;
    LISOC_LISR->addr_0x28.AHE_VWIDH = datapath_def_cfg.AHE_VWIDTH;

    LISOC_LISR->addr_0x3c.AHEF_ON = datapath_def_cfg.AHEF_ON;
    LISOC_LISR->addr_0x3c.UVENHON = datapath_def_cfg.UVENHON;
    LISOC_LISR->addr_0x3c.MOVESW = datapath_def_cfg.MOVESW;

    LISOC_LISR->addr_0x40.ALPHA_AHE = datapath_def_cfg.ALPHA_AHE;

    if(test_cmd >= FHD60_RAW12_YUV422_8_DQ16_TEST && test_cmd <= UHD60_RAW10_YUV422_8_DQ16_TEST){
      LISOC_LISR->addr_0xF8.DDR16MODE = 1;
    }

  }


  // MIPI-TX configuration

  LISOC_MIPI_TX->addr_0x014_W = 0xF1F1F1F1;

  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_PDIV  = datapath_def_cfg.PHYA_PLL_PDIV; // Input reference clock divider: Divider ratio = datapath_def_cfg.(PDIV + 1)
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_N1DIV = datapath_def_cfg.PHYA_PLL_N1DIV; // High Speed Feedback clock divider: Divider ratio: 1/2/4/8
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_N2DIV = datapath_def_cfg.PHYA_PLL_N2DIV; // Feedback clock divider: Divider ratio = datapath_def_cfg.(N2DIV + 1)
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_K1DIV = datapath_def_cfg.PHYA_PLL_K1DIV; // Output clock divider for CLK_P/N_O : Divider ratio : 1/2/4/8
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_K2DIV = datapath_def_cfg.PHYA_PLL_K2DIV; // Output clock divider-1 for LS_CLK_O : Divider ratio : 1/2/4/8
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_K3DIV = datapath_def_cfg.PHYA_PLL_K3DIV; // Output clock divider-2 for LS_CLK_O : Divider ratio = datapath_def_cfg.(K3DIV + 1)

#if 1// 1.485 ghz
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_CHP_TRIM = 0x14;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_KVCO_TRIM = 0x7;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_OSC_SEL = 0x3;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_V2I_OFFSET = 0x3;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_OSC_CLMP_DIS = 0x0;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_VCO_IGAIN = 0xA;
  LISOC_MIPI_TX->addr_0xC.PHYA_ZUP = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_ZDN = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_VRM = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_IRM = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_POL_SCK = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_CK_EDG = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPF_CSEL = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPF_RSEL = 0x1;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPE_SEL_3ORD = 0x0;
#else
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_CHP_TRIM = 0x13;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_KVCO_TRIM = 0x7;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_OSC_SEL = 0x3;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_V2I_OFFSET = 0x3;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_OSC_CLMP_DIS = 0x0;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_VCO_IGAIN = 0xD;
  LISOC_MIPI_TX->addr_0xC.PHYA_ZUP = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_ZDN = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_VRM = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_IRM = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_POL_SCK = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_CK_EDG = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPF_CSEL = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPF_RSEL = 0x1;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPE_SEL_3ORD = 0x0;
#endif

  LISOC_MIPI_TX->addr_0x104.DPHY_P0_PREG_DLM_0 = 0;
  LISOC_MIPI_TX->addr_0x104.DPHY_P0_PREG_DLM_1 = 1;
  LISOC_MIPI_TX->addr_0x104.DPHY_P0_PREG_DLM_2 = 2;
  LISOC_MIPI_TX->addr_0x104.DPHY_P0_PREG_DLM_3 = 3;

  //printf("%d %d %d %d",LISOC_MIPI_TX->addr_0x104.DPHY_P0_PREG_DLM_0,LISOC_MIPI_TX->addr_0x104.DPHY_P0_PREG_DLM_1,LISOC_MIPI_TX->addr_0x104.DPHY_P0_PREG_DLM_2,LISOC_MIPI_TX->addr_0x104.DPHY_P0_PREG_DLM_3);


  LISOC_MIPI_TX->addr_0x030.DPHY_P0_TX_LP11 = datapath_def_cfg.DPHY_P0_TX_LP11;
  LISOC_MIPI_TX->addr_0x030.DPHY_P0_TX_LP10 = datapath_def_cfg.DPHY_P0_TX_LP10;
  LISOC_MIPI_TX->addr_0x030.DPHY_P0_TX_LP01 = datapath_def_cfg.DPHY_P0_TX_LP01;
  LISOC_MIPI_TX->addr_0x030.DPHY_P0_TX_LP00 = datapath_def_cfg.DPHY_P0_TX_LP00;
  LISOC_MIPI_TX->addr_0x030.CSI2_P0_TX_TC = datapath_def_cfg.CSI2_P0_TX_TC;
  LISOC_MIPI_TX->addr_0x030.CSI2_P0_TX_TS = datapath_def_cfg.CSI2_P0_TX_TS;
  #ifdef ES1
  LISOC_MIPI_TX->addr_0x030.MODE_LANENUM = datapath_def_cfg.MODE_LANENUM; //for es1
  #else
  LISOC_MIPI_TX->addr_0x100.MODE_LANENUM = datapath_def_cfg.MODE_LANENUM; //for es2
  #endif
  
  LISOC_MIPI_TX->addr_0x034.DPHY_P0_TX_TIME_T_CLK_PRE = datapath_def_cfg.DPHY_P0_TX_TIME_T_CLK_PRE;
  LISOC_MIPI_TX->addr_0x034.DPHY_P0_TX_TIME_T_CLK_ZERO = datapath_def_cfg.DPHY_P0_TX_TIME_T_CLK_ZERO;
  LISOC_MIPI_TX->addr_0x034.DPHY_P0_TX_TIME_T_CLK_PREPARE = datapath_def_cfg.DPHY_P0_TX_TIME_T_CLK_PREPARE;
  LISOC_MIPI_TX->addr_0x034.DPHY_P0_TX_TIME_T_CLK_LPX = datapath_def_cfg.DPHY_P0_TX_TIME_T_LPX;
  
  LISOC_MIPI_TX->addr_0x038.DPHY_P0_TX_TIME_T_HS_EOT = datapath_def_cfg.DPHY_P0_TX_TIME_T_HS_EOT;
  LISOC_MIPI_TX->addr_0x038.DPHY_P0_TX_TIME_T_HS_SOT = datapath_def_cfg.DPHY_P0_TX_TIME_T_HS_SOT;
  LISOC_MIPI_TX->addr_0x038.DPHY_P0_TX_TIME_T_HS_ZERO = datapath_def_cfg.DPHY_P0_TX_TIME_T_HS_ZERO;
  LISOC_MIPI_TX->addr_0x038.DPHY_P0_TX_TIME_T_HS_PREPARE = datapath_def_cfg.DPHY_P0_TX_TIME_T_HS_PREPARE;
  
  LISOC_MIPI_TX->addr_0x03C.DPHY_P0_TX_TIME_T_CLK_EOT = datapath_def_cfg.DPHY_P0_TX_TIME_T_CLK_EOT;
  LISOC_MIPI_TX->addr_0x03C.DPHY_P0_TX_TIME_T_CLK_POST = datapath_def_cfg.DPHY_P0_TX_TIME_T_CLK_POST;
  LISOC_MIPI_TX->addr_0x03C.DPHY_P0_TX_TIME_T_WAKEUP = datapath_def_cfg.DPHY_P0_TX_TIME_T_WAKEUP;

//#100;
  delay_us(1);

  // Intentionally, place MIPI-RX reset release after CCHG/ISP configuration
  LISOC_MIPI_RX->addr_0x0.LINK_P0_RST_N = 1;
  LISOC_MIPI_RX->addr_0x0.PHYA_RX_PDATA_RESET_N = 1;

  LISOC_MIPI_TX->addr_0x0_W = 0x01111111;
  LISOC_MIPI_TX->addr_0x010_W = 0x000000F1;

}
#else
void datapath_init(void)
{
  // MIPI-Rx configuration
  LISOC_MIPI_RX->addr_0x118.DPHY_P0_MODE_LANENUM = D_DPHY_P0_MODE_LANENUM;
  LISOC_MIPI_RX->addr_0x164.DPHY_P0_TIME_RES_ON = D_DPHY_P0_TIME_RES_ON;
  LISOC_MIPI_RX->addr_0x2A0.APP_P0_CHK_VENA = D_APP_P0_CHK_VENA;
  LISOC_MIPI_RX->addr_0x2A0.APP_P0_CHK_HENA = D_APP_P0_CHK_HENA;
  LISOC_MIPI_RX->addr_0x2A4.APP_P0_CHK_VSIZE = D_APP_P0_CHK_VSIZE;
  LISOC_MIPI_RX->addr_0x2A4.APP_P0_CHK_HSIZE = D_APP_P0_CHK_HSIZE;


  //-------Main Mode Setting
  delay_us(1);

  LISOC_MIPI_RX->addr_0x4.MODE_P0_OPERATION = D_MODE_P0_OPERATION;
  LISOC_MIPI_RX->addr_0xC.PHYA_RX_MODE = D_PHYA_RX_MODE;
  LISOC_MIPI_RX->addr_0x10.MODE_P0_PIX_PARA = D_MODE_P0_PIX_PARA;

  //-------Link Layer Reset
  delay_us(20);
  
  LISOC_MIPI_RX->addr_0x0.LINK_P0_RST_N = D_LINK_P0_RST_N;

  //-------Power Down for PHYA
  delay_us(1);

  LISOC_MIPI_RX->addr_0x14.PHYA_RX_IREF_POW_EN = D_PHYA_RX_IREF_POW_EN;

  delay_us(20);

  LISOC_MIPI_RX->addr_0x18.PHYA_RX_C0_LP_AMP_POW_EN = D_PHYA_RX_C0_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x18.PHYA_RX_C0_HS_AMP_POW_EN = D_PHYA_RX_C0_HS_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x1C.PHYA_RX_D3_LP_AMP_POW_EN = D_PHYA_RX_D3_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x1C.PHYA_RX_D2_LP_AMP_POW_EN = D_PHYA_RX_D2_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x1C.PHYA_RX_D1_LP_AMP_POW_EN = D_PHYA_RX_D1_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x1C.PHYA_RX_D0_LP_AMP_POW_EN = D_PHYA_RX_D0_LP_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x20.PHYA_RX_D3_HS_AMP_POW_EN = D_PHYA_RX_D3_HS_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x20.PHYA_RX_D2_HS_AMP_POW_EN = D_PHYA_RX_D2_HS_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x20.PHYA_RX_D1_HS_AMP_POW_EN = D_PHYA_RX_D1_HS_AMP_POW_EN;
  LISOC_MIPI_RX->addr_0x20.PHYA_RX_D0_HS_AMP_POW_EN = D_PHYA_RX_D0_HS_AMP_POW_EN;
//#100;
  delay_us(20);

  #if(video_format != FHD60_RAW12_RXTX_TEST && video_format != UHD30_RAW12_RXTX_TEST && video_format != UHD60_RAW10_RXTX_TEST)
  if(D_BIT_MODE == 0){ //0:10bit,1:12bit
    LISOC_MIPI_RX->addr_0xD50_W = 0x1;
    LISOC_MIPI_RX->addr_0xD54_W = 0x00200000;
  }else{
    LISOC_MIPI_RX->addr_0xD50_W = 0x2;
    LISOC_MIPI_RX->addr_0xD54_W = 0x00400000;
  }

  // CCHG configuration
  LISOC_CCHG->addr_0x04.V_SIZE = D_CCHG_V_SIZE;
  LISOC_CCHG->addr_0x04.H_SIZE = D_CCHG_H_SIZE;
  LISOC_CCHG->addr_0x08.V_VALID_SIZE = D_V_VALID_SIZE;
  LISOC_CCHG->addr_0x08.H_VALID_SIZE = D_H_VALID_SIZE;
  LISOC_CCHG->addr_0x10.BANK_CYCLE = D_BANK_CYCLE;


  // ISP configuration
  LISOC_ISP->addr_0x00.NUM_ROW = D_NUM_ROW;
  LISOC_ISP->addr_0x00.NUM_COL = D_NUM_COL;
  
  LISOC_ISP->addr_0x04.BIT_MODE = D_BIT_MODE;
  LISOC_ISP->addr_0x04.THROUGH_MODE = D_THROUGH_MODE;
  LISOC_ISP->addr_0x04.BAYER_PATTERN = D_BAYER_PATTERN;
  
  LISOC_ISP->addr_0x08.OB_B_SUB = D_OB_B_SUB;
  LISOC_ISP->addr_0x08.OB_GB_SUB = D_OB_GB_SUB;
  LISOC_ISP->addr_0x08.OB_GR_SUB = D_OB_GR_SUB;
  LISOC_ISP->addr_0x08.OB_R_SUB = D_OB_R_SUB;
  
  LISOC_ISP->addr_0x0C.TOTAL_GAIN = D_TOTAL_GAIN;
  
  LISOC_ISP->addr_0x10.WB_B_GAIN = D_WB_B_GAIN;
  LISOC_ISP->addr_0x10.WB_R_GAIN = D_WB_R_GAIN;
  
  LISOC_ISP->addr_0x14.GAMMA_FACTOR = D_GAMMA_FACTOR;
  
  LISOC_ISP->addr_0x18.APERTURE_V = D_APERTURE_V;
  LISOC_ISP->addr_0x18.APERTURE_H = D_APERTURE_H;
  LISOC_ISP->addr_0x18.APERTURE_TH = D_APERTURE_TH;
  
  LISOC_ISP->addr_0x1C.MATRIX_B_Y_G2 = D_MATRIX_B_Y_G2;
  LISOC_ISP->addr_0x1C.MATRIX_B_Y_G1 = D_MATRIX_B_Y_G1;
  LISOC_ISP->addr_0x1C.MATRIX_R_Y_G2 = D_MATRIX_R_Y_G2;
  LISOC_ISP->addr_0x1C.MATRIX_R_Y_G1 = D_MATRIX_R_Y_G1;
  
  LISOC_ISP->addr_0x20.Y_OUT_OFFSET = D_Y_OUT_OFFSET;
  LISOC_ISP->addr_0x20.Y_OUT_GAIN = D_Y_OUT_GAIN;
  
  LISOC_ISP->addr_0x24.PSEUDO_SUPPRESS = D_PSEUDO_SUPPRESS;
  
  LISOC_ISP->addr_0x28.AE_AWB_ROW = D_AE_AWB_COL;
  LISOC_ISP->addr_0x28.AE_AWB_COL = D_AE_AWB_ROW;
  LISOC_ISP->addr_0x28.AE_AWB_UNIT = D_AE_AWB_UNIT;
  
  LISOC_ISP->addr_0x2C.V_IN_OFFSET = D_V_IN_OFFSET;
  LISOC_ISP->addr_0x2C.H_IN_OFFSET = D_H_IN_OFFSET;
  
  LISOC_ISP->addr_0x30.VS_WIDTH = D_VS_WIDTH;
  LISOC_ISP->addr_0x30.HS_WIDTH = D_HS_WIDTH;
  LISOC_ISP->addr_0x30.V_OUT_OFFSET = D_V_OUT_OFFSET;
  LISOC_ISP->addr_0x30.H_OUT_OFFSET = D_H_OUT_OFFSET;
  
  LISOC_ISP->addr_0x34.V_SIZE = D_V_SIZE;
  LISOC_ISP->addr_0x34.H_SIZE = D_H_SIZE;
  
  LISOC_ISP->addr_0x38.V_OUT_SIZE = D_V_OUT_SIZE;
  LISOC_ISP->addr_0x38.H_OUT_SIZE = D_H_OUT_SIZE;
  
  LISOC_ISP->addr_0x3C.V_FR_BLK = D_V_FR_BLK;
  LISOC_ISP->addr_0x3C.H_FR_BLK = D_H_FR_BLK;

  //LISR configuration

  LISOC_LISR->addr_0x00.IN_SEL = D_IN_SEL;
  LISOC_LISR->addr_0x00.IN_FORM = D_IN_FORM;
  LISOC_LISR->addr_0x00.IN_FRATE = D_IN_FRATE;
  LISOC_LISR->addr_0x00.IN_HSIZE = D_IN_HSIZE;
  LISOC_LISR->addr_0x00.IN_VSIZE = D_IN_VSIZE;

  LISOC_LISR->addr_0x04.INH_SD = D_INH_SD;
  LISOC_LISR->addr_0x04.SD_MODE = D_SD_MODE;
  LISOC_LISR->addr_0x04.SD_HSIZE = D_SD_HSIZE;
  LISOC_LISR->addr_0x04.SD_VSIZE = D_SD_VSIZE;
  
  LISOC_LISR->addr_0x0c.OUT_RESO = D_OUT_RESO;
  LISOC_LISR->addr_0x0c.OUT_FRATE = D_OUT_FRATE;
  LISOC_LISR->addr_0x0c.OUT_I_P = D_OUT_I_P;
  LISOC_LISR->addr_0x0c.AHE_BLKSIZ = D_AHE_BLKSIZ;
  LISOC_LISR->addr_0x0c.CROP_HOFF = D_CROP_HOFF;
  LISOC_LISR->addr_0x0c.CROP_VOFF = D_CROP_VOFF;

  LISOC_LISR->addr_0x18.AHE_ON = D_AHE_ON;
  LISOC_LISR->addr_0x18.VIDEO_ON = D_VIDEO_ON;
  LISOC_LISR->addr_0x18.OUT_FORM = D_OUT_FORM;
  LISOC_LISR->addr_0x18.OUT_THRU = D_OUT_THRU;
  LISOC_LISR->addr_0x18.OUT_DISP_ON = D_OUT_DISP_ON;

  LISOC_LISR->addr_0x20.AHE_HWIDH = D_AHE_HWIDTH;
  LISOC_LISR->addr_0x28.AHE_VWIDH = D_AHE_VWIDTH;

  LISOC_LISR->addr_0x3c.AHEF_ON = D_AHEF_ON;
  LISOC_LISR->addr_0x3c.UVENHON = D_UVENHON;
  LISOC_LISR->addr_0x3c.MOVESW = D_MOVESW;

  LISOC_LISR->addr_0x40.ALPHA_AHE = D_ALPHA_AHE;

  #ifdef DQ16
  LISOC_LISR->addr_0xF8.DDR16MODE = 1;
  #endif
  #else
  LISOC_SYSCFG->SOC_CCON1.mipi_rx_tx_thru = 1;
  #endif


  // MIPI-TX configuration

  LISOC_MIPI_TX->addr_0x014_W = 0xF1F1F1F1;

  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_PDIV  = D_PHYA_PLL_PDIV; // Input reference clock divider: Divider ratio = D_(PDIV + 1)
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_N1DIV = D_PHYA_PLL_N1DIV; // High Speed Feedback clock divider: Divider ratio: 1/2/4/8
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_N2DIV = D_PHYA_PLL_N2DIV; // Feedback clock divider: Divider ratio = D_(N2DIV + 1)
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_K1DIV = D_PHYA_PLL_K1DIV; // Output clock divider for CLK_P/N_O : Divider ratio : 1/2/4/8
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_K2DIV = D_PHYA_PLL_K2DIV; // Output clock divider-1 for LS_CLK_O : Divider ratio : 1/2/4/8
  LISOC_MIPI_TX->addr_0x4.PHYA_PLL_K3DIV = D_PHYA_PLL_K3DIV; // Output clock divider-2 for LS_CLK_O : Divider ratio = D_(K3DIV + 1)
#if 1
#if 1// 1.485 ghz
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_CHP_TRIM = 0x14;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_KVCO_TRIM = 0x7;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_OSC_SEL = 0x3;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_V2I_OFFSET = 0x3;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_OSC_CLMP_DIS = 0x0;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_VCO_IGAIN = 0xA;
  LISOC_MIPI_TX->addr_0xC.PHYA_ZUP = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_ZDN = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_VRM = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_IRM = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_POL_SCK = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_CK_EDG = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPF_CSEL = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPF_RSEL = 0x1;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPE_SEL_3ORD = 0x0;
#else
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_CHP_TRIM = 0x13;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_KVCO_TRIM = 0x7;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_OSC_SEL = 0x3;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_V2I_OFFSET = 0x3;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_OSC_CLMP_DIS = 0x0;
  LISOC_MIPI_TX->addr_0x8.PHYA_PLL_VCO_IGAIN = 0xD;
  LISOC_MIPI_TX->addr_0xC.PHYA_ZUP = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_ZDN = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_VRM = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_IRM = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_POL_SCK = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_CK_EDG = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPF_CSEL = 0x0;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPF_RSEL = 0x1;
  LISOC_MIPI_TX->addr_0xC.PHYA_PLL_LPE_SEL_3ORD = 0x0;
#endif
#endif

  LISOC_MIPI_TX->addr_0x030.DPHY_P0_TX_LP11 = D_DPHY_P0_TX_LP11;
  LISOC_MIPI_TX->addr_0x030.DPHY_P0_TX_LP10 = D_DPHY_P0_TX_LP10;
  LISOC_MIPI_TX->addr_0x030.DPHY_P0_TX_LP01 = D_DPHY_P0_TX_LP01;
  LISOC_MIPI_TX->addr_0x030.DPHY_P0_TX_LP00 = D_DPHY_P0_TX_LP00;
  LISOC_MIPI_TX->addr_0x030.CSI2_P0_TX_TC = D_CSI2_P0_TX_TC;
  LISOC_MIPI_TX->addr_0x030.CSI2_P0_TX_TS = D_CSI2_P0_TX_TS;
  //LISOC_MIPI_TX->addr_0x030.MODE_LANENUM = D_MODE_LANENUM; //for es1
  LISOC_MIPI_TX->addr_0x100.MODE_LANENUM = D_MODE_LANENUM; //for es2

  
  LISOC_MIPI_TX->addr_0x034.DPHY_P0_TX_TIME_T_CLK_PRE = D_DPHY_P0_TX_TIME_T_CLK_PRE;
  LISOC_MIPI_TX->addr_0x034.DPHY_P0_TX_TIME_T_CLK_ZERO = D_DPHY_P0_TX_TIME_T_CLK_ZERO;
  LISOC_MIPI_TX->addr_0x034.DPHY_P0_TX_TIME_T_CLK_PREPARE = D_DPHY_P0_TX_TIME_T_CLK_PREPARE;
  LISOC_MIPI_TX->addr_0x034.DPHY_P0_TX_TIME_T_CLK_LPX = D_DPHY_P0_TX_TIME_T_LPX;
  
  LISOC_MIPI_TX->addr_0x038.DPHY_P0_TX_TIME_T_HS_EOT = D_DPHY_P0_TX_TIME_T_HS_EOT;
  LISOC_MIPI_TX->addr_0x038.DPHY_P0_TX_TIME_T_HS_SOT = D_DPHY_P0_TX_TIME_T_HS_SOT;
  LISOC_MIPI_TX->addr_0x038.DPHY_P0_TX_TIME_T_HS_ZERO = D_DPHY_P0_TX_TIME_T_HS_ZERO;
  LISOC_MIPI_TX->addr_0x038.DPHY_P0_TX_TIME_T_HS_PREPARE = D_DPHY_P0_TX_TIME_T_HS_PREPARE;
  
  LISOC_MIPI_TX->addr_0x03C.DPHY_P0_TX_TIME_T_CLK_EOT = D_DPHY_P0_TX_TIME_T_CLK_EOT;
  LISOC_MIPI_TX->addr_0x03C.DPHY_P0_TX_TIME_T_CLK_POST = D_DPHY_P0_TX_TIME_T_CLK_POST;
  LISOC_MIPI_TX->addr_0x03C.DPHY_P0_TX_TIME_T_WAKEUP = D_DPHY_P0_TX_TIME_T_WAKEUP;

//#100;
  delay_us(1);

  // Intentionally, place MIPI-RX reset release after CCHG/ISP configuration
  #if 0
  wr_val = {32'h0000_0101};
  m_ral_sys_soc_top_block.MIPI_RX.addr_0x0.set(wr_val);
  m_ral_sys_soc_top_block.MIPI_RX.update(status,UVM_FRONTDOOR,.parent(this));

  wr_val = {{32'h0111_1111}};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x0.write(status,wr_val,UVM_FRONTDOOR);

  wr_val = {{32'h0000_00F1}};
  m_ral_sys_soc_top_block.MIPI_TX.addr_0x010.write(status,wr_val,UVM_FRONTDOOR);
  #endif

  LISOC_MIPI_RX->addr_0x0.LINK_P0_RST_N = 1;
  LISOC_MIPI_RX->addr_0x0.PHYA_RX_PDATA_RESET_N = 1;

  LISOC_MIPI_TX->addr_0x0_W = 0x01111111;
  LISOC_MIPI_TX->addr_0x010_W = 0x000000F1;

}
#endif


void datapath_cfg_set()
{
  switch(test_cmd)
  {
    case FHD60_RAW12_YUV422_8:
    case FHD60_RAW12_YUV422_8_DQ16_TEST:
      printf("FHD60_RAW12_YUV422_8.\n");
      memcpy(&datapath_def_cfg, &FHD60_R12_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 1;// 0:RGB888 1:YUV422_8 5:YUV422_10
      //datapath_def_cfg.MOVESW = 3;
      #if 0
      //datapath_def_cfg.NMP =        1;
      datapath_def_cfg.NVC2_S2 =    1;

      datapath_def_cfg.INH_SD =     1;
      datapath_def_cfg.SD_HSIZE =   0;
      datapath_def_cfg.SD_VSIZE =   0;
      datapath_def_cfg.AHE_BLKSIZ = 0;
      datapath_def_cfg.AHE_ON =     0;
      datapath_def_cfg.VIDEO_ON =   0;
      datapath_def_cfg.OUT_THRU =   1;
      datapath_def_cfg.AHE_HWIDTH = 0;
      datapath_def_cfg.AHE_VWIDTH = 0;
      datapath_def_cfg.AHEF_ON =    0;
      datapath_def_cfg.UVENHON =    0;
      datapath_def_cfg.MOVESW =     0;
      datapath_def_cfg.ALPHA_AHE =  0;
      #endif
      #if 0 //fhd30
      datapath_def_cfg.NVC2_S2 = 3;  //37.125mhz
      datapath_def_cfg.CCHG_H_SIZE = 8800;
      datapath_def_cfg.H_SIZE = 8800/2;
      datapath_def_cfg.IN_FRATE = 0;
      datapath_def_cfg.OUT_FRATE = 0;
      #endif
      break;
    case FHD60_RAW12_YUV422_10:
      printf("FHD60_RAW12_YUV422_10.\n");
      memcpy(&datapath_def_cfg, &FHD60_R12_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 5;// 0:RGB888 1:YUV422_8 5:YUV422_10
      break;
    case FHD60_RAW12_RGB888:
      printf("FHD60_RAW12_RGB888.\n");
      memcpy(&datapath_def_cfg, &FHD60_R12_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 0;// 0:RGB888 1:YUV422_8 5:YUV422_10
      break;
    case UHD30_RAW10_YUV422_8:
      printf("UHD30_RAW10_YUV422_8.\n");
      memcpy(&datapath_def_cfg, &UHD30_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 1;// 0:RGB888 1:YUV422_8 5:YUV422_10
      datapath_def_cfg.BANK_CYCLE = 600;

		  #if 0
      //datapath_def_cfg.NMP =        1;
      datapath_def_cfg.NVC2_S2 =    1;

      datapath_def_cfg.INH_SD =     1;
      datapath_def_cfg.SD_HSIZE =   0;
      datapath_def_cfg.SD_VSIZE =   0;
      datapath_def_cfg.AHE_BLKSIZ = 0;
      datapath_def_cfg.AHE_ON =     0;
      datapath_def_cfg.VIDEO_ON =   0;
      datapath_def_cfg.OUT_THRU =   1;
      datapath_def_cfg.AHE_HWIDTH = 0;
      datapath_def_cfg.AHE_VWIDTH = 0;
      datapath_def_cfg.AHEF_ON =    0;
      datapath_def_cfg.UVENHON =    0;
      datapath_def_cfg.MOVESW =     0;
      datapath_def_cfg.ALPHA_AHE =  0;
      #endif
      break;
    case UHD30_RAW10_YUV422_10:
      printf("UHD30_RAW10_YUV422_10.\n");
      memcpy(&datapath_def_cfg, &UHD30_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 5;// 0:RGB888 1:YUV422_8 5:YUV422_10
      datapath_def_cfg.PHYA_PLL_N2DIV = 54;
      datapath_def_cfg.BANK_CYCLE = 600;
      break;
    case UHD30_RAW10_RGB888:
      printf("UHD30_RAW10_RGB888.\n");
      memcpy(&datapath_def_cfg, &UHD30_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 0;// 0:RGB888 1:YUV422_8 5:YUV422_10 
      datapath_def_cfg.PHYA_PLL_N2DIV = 65;
      datapath_def_cfg.BANK_CYCLE = 600;
      break;
    case UHD30_RAW12_YUV422_8:
    case UHD30_RAW12_YUV422_8_DQ16_TEST:
      printf("UHD30_RAW12_YUV422_8.\n");
      memcpy(&datapath_def_cfg, &UHD30_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 1;// 0:RGB888 1:YUV422_8 5:YUV422_10
      datapath_def_cfg.BIT_MODE = 1;
      //datapath_def_cfg.BANK_CYCLE = 600;
      //datapath_def_cfg.INH_SD = 0;

      datapath_def_cfg.MOVESW = 1;
      #if 0 //uhd15
      datapath_def_cfg.NVC2_S2 = 4;
      datapath_def_cfg.CCHG_H_SIZE = 8800;
      datapath_def_cfg.H_SIZE = 8800/2;
      datapath_def_cfg.IN_FRATE = 7;
      datapath_def_cfg.OUT_FRATE = 7;

      #endif
      //datapath_def_cfg.NMP =        0;
      //datapath_def_cfg.NVC2_S2 =    1;
      //datapath_def_cfg.OUT_FORM = 3;//YUV420_8

#if 0
      //datapath_def_cfg.NMP =        1;
      datapath_def_cfg.NVC2_S2 =    1;

      datapath_def_cfg.INH_SD =     1;
      datapath_def_cfg.SD_HSIZE =   0;
      datapath_def_cfg.SD_VSIZE =   0;
      datapath_def_cfg.AHE_BLKSIZ = 0;
      datapath_def_cfg.AHE_ON =     0;
      datapath_def_cfg.VIDEO_ON =   0;
      datapath_def_cfg.OUT_THRU =   1;
      datapath_def_cfg.AHE_HWIDTH = 0;
      datapath_def_cfg.AHE_VWIDTH = 0;
      datapath_def_cfg.AHEF_ON =    0;
      datapath_def_cfg.UVENHON =    0;
      datapath_def_cfg.MOVESW =     0;
      datapath_def_cfg.ALPHA_AHE =  0;
#endif

      break;
    case UHD30_RAW12_YUV422_10:
      printf("UHD30_RAW12_YUV422_10.\n");
      memcpy(&datapath_def_cfg, &UHD30_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 5;// 0:RGB888 1:YUV422_8 5:YUV422_10
      datapath_def_cfg.BIT_MODE = 1;
      datapath_def_cfg.PHYA_PLL_N2DIV = 54;
      break;
    case UHD30_RAW12_RGB888:
      printf("UHD30_RAW12_RGB888.\n");
      memcpy(&datapath_def_cfg, &UHD30_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.OUT_FORM = 0;// 0:RGB888 1:YUV422_8 5:YUV422_10
      datapath_def_cfg.BIT_MODE = 1;
      datapath_def_cfg.PHYA_PLL_N2DIV = 65;
      break;
    case UHD60_RAW10_YUV422_8:
    case UHD60_RAW10_YUV422_8_DQ16_TEST:
      printf("UHD60_RAW10_YUV422_8.\n");
      memcpy(&datapath_def_cfg, &UHD60_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      //datapath_def_cfg.MOVESW = 1;
      //datapath_def_cfg.PHYA_PLL_N2DIV = 65;
      //datapath_def_cfg.OUT_FORM = 3;//YUV420_8
      #if 0
      //datapath_def_cfg.NMP =        1;
      //datapath_def_cfg.NVC2_S2 =    1;

      datapath_def_cfg.INH_SD =     1;
      datapath_def_cfg.SD_HSIZE =   0;
      datapath_def_cfg.SD_VSIZE =   0;
      datapath_def_cfg.AHE_BLKSIZ = 0;
      datapath_def_cfg.AHE_ON =     0;
      datapath_def_cfg.VIDEO_ON =   0;
      datapath_def_cfg.OUT_THRU =   1;
      datapath_def_cfg.AHE_HWIDTH = 0;
      datapath_def_cfg.AHE_VWIDTH = 0;
      datapath_def_cfg.AHEF_ON =    0;
      datapath_def_cfg.UVENHON =    0;
      datapath_def_cfg.MOVESW =     0;
      datapath_def_cfg.ALPHA_AHE =  0;
    #endif

      break;
    case FHD60_RAW12_RXTX_TEST:
      printf("FHD60_RAW12_RXTX_TEST.\n");
      memcpy(&datapath_def_cfg, &FHD60_R12_YUV422_8_CFG, sizeof(datapath_def_cfg));
      LISOC_SYSCFG->SOC_CCON1.mipi_rx_tx_thru = 1;
      datapath_def_cfg.NMP = 1;
      break;
    case UHD30_RAW12_RXTX_TEST:
      printf("UHD30_RAW12_RXTX_TEST.\n");
      memcpy(&datapath_def_cfg, &UHD30_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.BIT_MODE = 1;
      LISOC_SYSCFG->SOC_CCON1.mipi_rx_tx_thru = 1;
      break;
    case UHD60_RAW10_RXTX_TEST:
      printf("UHD60_RAW10_RXTX_TEST.\n");
      memcpy(&datapath_def_cfg, &UHD60_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.PHYA_PLL_N2DIV = 54;
      LISOC_SYSCFG->SOC_CCON1.mipi_rx_tx_thru = 1;
      break;
    case FHD60_TPGEN_CCHG_TEST:
    case FHD60_TPGEN_ISP_TEST:
    case FHD60_TPGEN_LISR_TEST:
      printf("FHD60_TPGEN_TEST.\n");
      memcpy(&datapath_def_cfg, &FHD60_R12_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.WB_B_GAIN = 0x400;
      datapath_def_cfg.WB_R_GAIN = 0x400;
      datapath_def_cfg.AHE_ON = 0;

      datapath_def_cfg.OB_R_SUB = 0;
      datapath_def_cfg.OB_GR_SUB = 0;
      datapath_def_cfg.OB_GB_SUB = 0;
      datapath_def_cfg.OB_B_SUB = 0;
#ifdef LISR_THRU
//#if 1
      //datapath_def_cfg.NMP =        1;
      datapath_def_cfg.NVC2_S2 =    1;

      datapath_def_cfg.INH_SD =     1;
      datapath_def_cfg.SD_HSIZE =   0;
      datapath_def_cfg.SD_VSIZE =   0;
      datapath_def_cfg.AHE_BLKSIZ = 0;
      datapath_def_cfg.AHE_ON =     0;
      datapath_def_cfg.VIDEO_ON =   0;
      datapath_def_cfg.OUT_THRU =   1;
      datapath_def_cfg.AHE_HWIDTH = 0;
      datapath_def_cfg.AHE_VWIDTH = 0;
      datapath_def_cfg.AHEF_ON =    0;
      datapath_def_cfg.UVENHON =    0;
      datapath_def_cfg.MOVESW =     0;
      datapath_def_cfg.ALPHA_AHE =  0;
#endif

      break;
    case UHD60_TPGEN_CCHG_TEST:
    case UHD60_TPGEN_ISP_TEST:
    case UHD60_TPGEN_LISR_TEST:
      printf("UHD60_TPGEN_TEST.\n");
      memcpy(&datapath_def_cfg, &UHD60_R10_YUV422_8_CFG, sizeof(datapath_def_cfg));
      datapath_def_cfg.WB_B_GAIN = 0x400;
      datapath_def_cfg.WB_R_GAIN = 0x400;
      datapath_def_cfg.AHE_ON = 0;

      datapath_def_cfg.OB_R_SUB = 0;
      datapath_def_cfg.OB_GR_SUB = 0;
      datapath_def_cfg.OB_GB_SUB = 0;
      datapath_def_cfg.OB_B_SUB = 0;

      break;
    default:
      memcpy(&datapath_def_cfg, &FHD60_R12_YUV422_8_CFG, sizeof(datapath_def_cfg));
      break;
  }
}

