/*!
    \file    datapath.h
    \brief   the header file of datapath

*/

#ifndef DATAPATH_H
#define DATAPATH_H


#define  FHD60_RAW12_YUV422_8                   0x0
#define  FHD60_RAW12_YUV422_10                  0x1
#define  FHD60_RAW12_RGB888                     0x2

#define  UHD30_RAW10_YUV422_8                   0x3
#define  UHD30_RAW10_YUV422_10                  0x4
#define  UHD30_RAW10_RGB888                     0x5

#define  UHD30_RAW12_YUV422_8                   0x6
#define  UHD30_RAW12_YUV422_10                  0x7
#define  UHD30_RAW12_RGB888                     0x8

#define  UHD60_RAW10_YUV422_8                   0x9

#define  FHD60_RAW12_RXTX_TEST                  0x10
#define  UHD30_RAW12_RXTX_TEST                  0x11
#define  UHD60_RAW10_RXTX_TEST                  0x12

#define  FHD60_TPGEN_CCHG_TEST                  0x20
#define  FHD60_TPGEN_ISP_TEST                   0x21
#define  FHD60_TPGEN_LISR_TEST                  0x22

#define  UHD60_TPGEN_CCHG_TEST                  0x23
#define  UHD60_TPGEN_ISP_TEST                   0x24
#define  UHD60_TPGEN_LISR_TEST                  0x25

#define  FHD60_RAW12_YUV422_8_DQ16_TEST         0x30
#define  UHD30_RAW12_YUV422_8_DQ16_TEST         0x31
#define  UHD60_RAW10_YUV422_8_DQ16_TEST         0x32

#if 0
//#define video_format FHD60_RAW12_YUV422_8

#if (video_format == FHD60_RAW12_YUV422_8 || video_format == FHD60_TPGEN_TEST)
#include "dp_config\datapath_fhd60_r12_yuv422_8.h"
#elif (video_format == FHD60_RAW12_YUV422_10)
#include "dp_config\datapath_fhd60_r12_yuv422_10.h"
#elif (video_format == FHD60_RAW12_RGB888)
#include "dp_config\datapath_fhd60_r12_rgb888.h"

#elif (video_format == UHD30_RAW10_YUV422_8)
#include "dp_config\datapath_uhd30_r10_yuv422_8.h"
#elif (video_format == UHD30_RAW10_YUV422_10)
#include "dp_config\datapath_uhd30_r10_yuv422_10.h"
#elif (video_format == UHD30_RAW10_RGB888)
#include "dp_config\datapath_uhd30_r10_rgb888.h"

#elif (video_format == UHD30_RAW12_YUV422_8)
#include "dp_config\datapath_uhd30_r12_yuv422_8.h"
#elif (video_format == UHD30_RAW12_YUV422_10)
#include "dp_config\datapath_uhd30_r12_yuv422_10.h"
#elif (video_format == UHD30_RAW12_RGB888)
#include "dp_config\datapath_uhd30_r12_rgb888.h"

#elif (video_format == UHD60_RAW10_YUV422_8)
#include "dp_config\datapath_uhd60_r10_yuv422_8.h"
#elif (video_format == UHD60_TPGEN_TEST)
#include "dp_config\datapath_uhd60_r10_yuv422_8.h"

#elif (video_format == FHD60_RAW12_RXTX_TEST)
#include "dp_config\datapath_fhd60_r12_yuv422_8.h"
#elif (video_format == UHD30_RAW12_RXTX_TEST)
#include "dp_config\datapath_uhd30_r12_yuv422_8.h"
#elif (video_format == UHD60_RAW10_RXTX_TEST)
#include "dp_config\datapath_uhd60_r10_yuv422_8.h"
//#include "dp_config\datapath_uhd60_r10_yuv422_8_4800.h"

#endif
#endif
typedef struct tag_ST_DatapathCfg
{

  uint8_t NMP;       //rx pix_clk: 0,162 1,297 2,324
  uint8_t NVC1;      //video_clk1: 0,297mhz 1,148.5mhz 2,13.5mhz
  uint8_t NVC2_S1;
  uint8_t NVC2_S2;   //video_clk2: 0x3f 0,297 0x3f 1,148 0x3f 4,74.25

  //Regs of MIPI-RX
  uint8_t MODE_P0_OPERATION;
  uint8_t PHYA_RX_MODE;
  uint8_t MODE_P0_PIX_PARA;
  uint8_t DPHY_P0_MODE_LANENUM; // 4 lane MODE
  uint8_t DPHY_P0_LP_SYNC_OFF;
  uint8_t DPHY_P0_MODE_HSDM_OFF;
  uint8_t DPHY_P0_MODE_MSB_FIRST; // 1'h0 NG(?)
  uint8_t DPHY_P0_MODE_LPOP_OFF;
  
  uint8_t DPHY_P0_TIME_HS_ON;
  //  uint8_t DPHY_P0_TIME_RES_ON     0x0020 // for os05a20 742.5 mbps 0x11~0x37 is ok
  uint8_t DPHY_P0_TIME_RES_ON; // for imx415 891 mpbs 0x0d~0x26 is ok
  
  uint8_t APP_P0_CHK_VENA;
  uint8_t APP_P0_CHK_HENA;
  uint16_t APP_P0_CHK_VSIZE;
  uint16_t APP_P0_CHK_HSIZE;
  uint8_t LINK_P0_RST_N;
  uint8_t PHYA_RX_IREF_POW_EN;
  uint8_t PHYA_RX_D0_HS_AMP_POW_EN;
  uint8_t PHYA_RX_D1_HS_AMP_POW_EN;
  uint8_t PHYA_RX_D2_HS_AMP_POW_EN;
  uint8_t PHYA_RX_D3_HS_AMP_POW_EN;
  uint8_t PHYA_RX_C0_HS_AMP_POW_EN;
  uint8_t PHYA_RX_D0_LP_AMP_POW_EN;
  uint8_t PHYA_RX_D1_LP_AMP_POW_EN;
  uint8_t PHYA_RX_D2_LP_AMP_POW_EN;
  uint8_t PHYA_RX_D3_LP_AMP_POW_EN;
  uint8_t PHYA_RX_C0_LP_AMP_POW_EN;
  
  //Regs of CCHG
  uint16_t CCHG_V_SIZE;
  uint16_t CCHG_H_SIZE;
  uint16_t V_VALID_SIZE; //   NUM_ROL
  uint16_t H_VALID_SIZE; //   NUM_COL
  uint16_t BANK_CYCLE;
  //Regs of ISP
  uint16_t NUM_COL;
  uint16_t NUM_ROW;
  uint8_t BAYER_PATTERN;
  uint8_t THROUGH_MODE;
  uint8_t BIT_MODE; // For 10bits mode {raw-12 --> yuv-10}
  uint8_t OB_R_SUB;
  uint8_t OB_GR_SUB;
  uint8_t OB_GB_SUB;
  uint8_t OB_B_SUB;
  uint8_t TOTAL_GAIN;
  uint16_t WB_R_GAIN;
  uint16_t WB_B_GAIN;
  uint8_t GAMMA_FACTOR;
  uint8_t APERTURE_TH;
  uint8_t APERTURE_H; // ES2 needs to be modified
  uint8_t APERTURE_V; // ES2 needs to be modified
  uint8_t MATRIX_R_Y_G1;
  uint8_t MATRIX_R_Y_G2;
  uint8_t MATRIX_B_Y_G1;
  uint8_t MATRIX_B_Y_G2;
  uint8_t Y_OUT_GAIN;
  uint8_t Y_OUT_OFFSET;
  uint8_t PSEUDO_SUPPRESS;
  uint8_t AE_AWB_UNIT;
  uint8_t AE_AWB_COL;
  uint8_t AE_AWB_ROW;
  uint8_t H_IN_OFFSET;
  uint8_t V_IN_OFFSET;
  uint8_t H_OUT_OFFSET;
  uint8_t V_OUT_OFFSET;
  uint8_t HS_WIDTH;
  uint8_t VS_WIDTH;
  uint16_t H_SIZE;
  uint16_t V_SIZE;
  uint16_t H_OUT_SIZE;
  uint16_t V_OUT_SIZE;
  uint8_t H_FR_BLK;
  uint8_t V_FR_BLK;
  
  //Regs of LISR
  uint8_t IN_SEL; //input on/off
  uint8_t IN_FORM; //00/01/10/11->RGB/YUV422/YUV444/RESVE
  uint8_t IN_FRATE; //000/001/010/011/100/111->30/60/120/240/59.9401/else fps
  uint16_t IN_HSIZE;
  uint16_t IN_VSIZE;
  
  uint8_t INH_SD;
  uint8_t SD_MODE;
  uint16_t SD_HSIZE;
  uint16_t SD_VSIZE;
  
  uint8_t OUT_RESO;
  uint8_t OUT_FRATE;
  uint8_t OUT_I_P;
  uint8_t AHE_BLKSIZ;
  uint8_t CROP_HOFF;
  uint8_t CROP_VOFF;
  
  uint8_t AHE_ON;
  uint8_t VIDEO_ON;
  uint8_t OUT_FORM; // 0:RGB888 1:YUV422_8 5:YUV422_10
  uint8_t OUT_THRU;
  uint8_t OUT_DISP_ON;
  
  uint16_t AHE_HWIDTH;
  uint16_t AHE_VWIDTH;
  
  uint8_t AHEF_ON;
  uint8_t UVENHON;
  uint8_t MOVESW;
  
  uint8_t ALPHA_AHE;
  
  // Regs of MIPI_TX
  uint8_t DPHY_P0_TX_TIME_T_LPX;
  uint8_t DPHY_P0_TX_TIME_T_CLK_PREPARE;
  uint8_t DPHY_P0_TX_TIME_T_CLK_ZERO;
  uint8_t DPHY_P0_TX_TIME_T_CLK_PRE;
  uint8_t DPHY_P0_TX_TIME_T_HS_PREPARE;
  uint8_t DPHY_P0_TX_TIME_T_HS_ZERO;
  uint8_t DPHY_P0_TX_TIME_T_HS_SOT;
  uint8_t DPHY_P0_TX_TIME_T_HS_EOT;
  uint8_t DPHY_P0_TX_TIME_T_CLK_POST;
  uint8_t DPHY_P0_TX_TIME_T_CLK_EOT;
  uint16_t DPHY_P0_TX_TIME_T_WAKEUP;
  uint8_t DPHY_P0_TX_LP11;
  uint8_t DPHY_P0_TX_LP10;
  uint8_t DPHY_P0_TX_LP01;
  uint8_t DPHY_P0_TX_LP00;
  uint8_t CSI2_P0_TX_TC;
  uint8_t CSI2_P0_TX_TS;
  uint8_t MODE_LANENUM;
  uint8_t PHYA_PLL_PDIV; // Input reference clock divider: Divider ratio  (PDIV + 1)
  uint8_t PHYA_PLL_N1DIV; // High Speed Feedback clock divider: Divider ratio: 1/2/4/8
  uint8_t PHYA_PLL_N2DIV; // Feedback clock divider: Divider ratio  (N2DIV + 1)
  uint8_t PHYA_PLL_K1DIV; // Output clock divider for CLK_P/N_O : Divider ratio : 1/2/4/8
  uint8_t PHYA_PLL_K2DIV; // Output clock divider-1 for LS_CLK_O : Divider ratio : 1/2/4/8
  uint8_t PHYA_PLL_K3DIV; // Output clock divider-2 for LS_CLK_O : Divider ratio  (K3DIV + 1)

} ST_DatapathCfg;
extern ST_DatapathCfg datapath_def_cfg;
void datapath_init(void);
void datapath_cfg_set(void);

#endif  /* DATAPATH_H */
