/*!
    \file    sensor.c
    \brief   the sensor configuration file

*/

#include "lisoc_test.h"
#include "imx415_fhd60fps.h"
#include "imx415_uhd30fps.h"
#include "imx415_uhd60fps.h"

#include "i2c.h"
#include "gpio.h"
#include "tpgen_test.h"


#define IMX415_ID 0x1A

void imx415_init()
{
  int i = 0;
  sensor_reg *p_sensor_cfg;// = Sensor_2m_60fps_init_table_4lane_linear_binning_stock;
  #if 1
  switch(test_cmd)
  {
    case FHD60_RAW12_YUV422_8:
    case FHD60_RAW12_YUV422_10:
    case FHD60_RAW12_RGB888:
    case FHD60_RAW12_RXTX_TEST:
    case FHD60_RAW12_YUV422_8_DQ16_TEST:
      p_sensor_cfg = Sensor_2m_60fps_init_table_4lane_linear_binning_stock;
      break;
    case UHD30_RAW10_YUV422_8:
    case UHD30_RAW10_YUV422_10:
    case UHD30_RAW10_RGB888:
      p_sensor_cfg = Sensor_8m_30fps_init_table_4lane_linear;
      break;
    case UHD30_RAW12_YUV422_8:
    case UHD30_RAW12_YUV422_10:
    case UHD30_RAW12_RGB888:
    case UHD30_RAW12_RXTX_TEST:
    case UHD30_RAW12_YUV422_8_DQ16_TEST:
      p_sensor_cfg = Sensor_8m_30fps_init_table_4lane_linear;
      /* use RAW 12-bit mode */
      p_sensor_cfg[2].val = 1;  //{ 0x3031, 0x01 },
      p_sensor_cfg[3].val = 1;  //{ 0x3032, 0x01 },
      break;
    case UHD60_RAW10_YUV422_8:
    case UHD60_RAW10_RXTX_TEST:
    case UHD60_RAW10_YUV422_8_DQ16_TEST:
      p_sensor_cfg = Sensor_8m_60fps_init_table_4lane_linear;
      break;
    case FHD60_TPGEN_CCHG_TEST:
      tpgen_test(TPGEN_FHD60n,TPGEN_CCHGn);
      return;
    case FHD60_TPGEN_ISP_TEST:
      tpgen_test(TPGEN_FHD60n,TPGEN_ISPn);
      return;
    case FHD60_TPGEN_LISR_TEST:
      tpgen_test(TPGEN_FHD60n,TPGEN_LISRn);
      return;
    case UHD60_TPGEN_CCHG_TEST:
      tpgen_test(TPGEN_UHD60n,TPGEN_CCHGn);
      return;
    case UHD60_TPGEN_ISP_TEST:
      tpgen_test(TPGEN_UHD60n,TPGEN_ISPn);
      return;
    case UHD60_TPGEN_LISR_TEST:
      tpgen_test(TPGEN_UHD60n,TPGEN_LISRn);
      return;
    default:
      printf("invalid cmd.\n");
      return;
  }
  #endif
  gpioa_setPinDreict(PA15, GPIO_OUT);
  gpioa_out(PA15, GPIO_LOW); //rst
  delay_ms(1);
  gpioa_out(PA15, GPIO_HIGH); //rst


  i2c_Disable(LISOC_I2C0);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C0, FREQ_400K, IMX415_ID);
  i2c_Enable(LISOC_I2C0);

  while (p_sensor_cfg[i].reg != SEQUENCE_END) {
    if(p_sensor_cfg[i].reg == SEQUENCE_WAIT_MS)
      delay_ms(p_sensor_cfg[i].val);
    else
      i2c_reg16_write(LISOC_I2C0,p_sensor_cfg[i].reg,p_sensor_cfg[i].val);
    i++;
  }

  printf("imx415 init sucess.\r\n");
}


