/*!
    \file    syscfg.c
    \brief   the syscfg configuration file

*/

#include "lisoc_test.h"
#include "syscfg.h"
#include "gpio.h"
/*!
    \brief      SYSC_AF_SET
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SYSC_GPIOA_AF_SET(uint8_t alt_func_num,uint32_t pin)
{
  if(alt_func_num)
    LISOC_SYSCFG->GPIOA_AFR_W |= pin;
  else
    LISOC_SYSCFG->GPIOA_AFR_W &= ~pin;
}

void SYSC_GPIOB_AF_SET(uint8_t alt_func_num,uint32_t pin)
{
  if(alt_func_num)
    LISOC_SYSCFG->GPIOB_AFR_W |= pin;
  else
    LISOC_SYSCFG->GPIOB_AFR_W &= ~pin;
}
#if 0
void af_test()
{
  int i;
  gpioa_setPinDreict(PA15, GPIO_OUT);

  LISOC_SYSCFG->AF_CCON1.mode2 = 1;
  LISOC_SYSCFG->AF_CCON1.mode1 = 1;
  LISOC_SYSCFG->AF_CCON1.mode0 = 1;
  LISOC_SYSCFG->AF_CCON1.enable = 1;
  LISOC_SYSCFG->AF_CCON1.CW = 1;

  LISOC_SYSCFG->AF_CCON_W = 0x0;

  LISOC_SYSCFG->AF_CCON0.pre_div = 200;

  LISOC_SYSCFG->AF_CCON0.mask0 = 0;
  LISOC_SYSCFG->AF_CCON0.mask1 = 0;
  LISOC_SYSCFG->AF_CCON0.mask2 = 0;
  LISOC_SYSCFG->AF_CCON0.mask3 = 0;
  LISOC_SYSCFG->AF_CCON0.mask4 = 0;

  LISOC_SYSCFG->AF_CCON0.EN = 1;


  printf("AF_CCON0_W:%x\n",reg32(0x400f1000 + 0x4c));
  printf("AF_CCON1_W:%x\n",reg32(0x400f1000 + 0x50));

  while(1){
    if(i++ % 2 == 0)
      gpioa_out(PA15, GPIO_HIGH);
    else
      gpioa_out(PA15, GPIO_LOW);

    printf("af_count:%d\n",LISOC_SYSCFG->AF_COUNT.af_count);
    delay_ms(1000);
  }
  }
#endif
