/*!
    \file    timer.c
    \brief   the timer configuration file

*/

#include "lisoc_test.h"
#include "timer.h"

void timer_ClearIRQ(APB_TIMERS_Register_Table_s *LISOC_TIM)
{
  // clear the interrupt by reading EOI    
  LISOC_TIM->TimerEOI.Timer1EOI;
}
uint32_t timer_StatusIRQ(APB_TIMERS_Register_Table_s *LISOC_TIM)
{
  return LISOC_TIM->TimerIntStatus.Timer1IntStatus;
}

void timer_StartTimer(APB_TIMERS_Register_Table_s *LISOC_TIM)
{
  LISOC_TIM->TimerControlReg.TIMER_ENABLE = 0x1u;
}

void timer_StopTimer(APB_TIMERS_Register_Table_s *LISOC_TIM)
{
  LISOC_TIM->TimerControlReg.TIMER_ENABLE = 0x0u;
}

void timer_SetMode(APB_TIMERS_Register_Table_s *LISOC_TIM, uint32_t Mode)
{
  LISOC_TIM->TimerControlReg.TIMER_MODE = Mode;
}

void timer_Setload(APB_TIMERS_Register_Table_s *LISOC_TIM, uint32_t value)
{
  LISOC_TIM->TimerLoadCount.Timer1LoadCount = value;
}

void CPU_TIM_Init(void)
{
  // disable the timer, configure timer mode as userdefine,
  timer_StopTimer(LISOC_TIMER0);
  timer_SetMode(LISOC_TIMER0, TIMER_USERMODE);
  // configure the initial value of counter
  timer_Setload(LISOC_TIMER0, LISOC_TIMER_CLK / 1000000u * 1000000);
  //timer_Setload(LISOC_TIMER0, 8000000 / 1000u * 100);
  // enable timer
  timer_StartTimer(LISOC_TIMER0);
  NVIC_ClearPendingIRQ(TIMER0_IRQn);
  NVIC_EnableIRQ(TIMER0_IRQn);
}

