/*!
    \file    lisoc.h
    \brief   general definitions for LiSoC

*/

#ifndef LISOC_H
#define LISOC_H

/* rcc controller reg map */
#define RCC_BASE_ADDR       0x400F0000

/* systen controller reg map */
#define SYSC_BASE_ADDR      0x400F1000

#define SYSC_GPIOA_OER      (*(volatile uint32_t*)(SYSC_BASE_ADDR + 0x00))
#define SYSC_GPIOA_PUPDR    (*(volatile uint32_t*)(SYSC_BASE_ADDR + 0x04))    /*PIN 0~3 Reuse Control Register */
#define SYSC_GPIOA_AFR      (*(volatile uint32_t*)(SYSC_BASE_ADDR + 0x08))    /*PIN 4~8 Reuse Control Register*/
#define SYSC_GPIOB_OER      (*(volatile uint32_t*)(SYSC_BASE_ADDR + 0x0C))
#define SYSC_GPIOB_PUPDR    (*(volatile uint32_t*)(SYSC_BASE_ADDR + 0x10))    /*PIN 0~3 Reuse Control Register */
#define SYSC_GPIOB_AFR      (*(volatile uint32_t*)(SYSC_BASE_ADDR + 0x14))    /*PIN 4~8 Reuse Control Register*/
#define SYSC_BOOT_STATR     (*(volatile uint32_t*)(SYSC_BASE_ADDR + 0x18))
#define SYSC_SOC_CCON0      (*(volatile uint32_t*)(SYSC_BASE_ADDR + 0x1C))

/* UART0 reg map */
#define  UART0_BASE_ADDR    0x40000000

#define  UART0_RBR_THR_DLL  (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x00))  /*Receive Buffer Register__Transmit Holding Regster__Divisor Latch(Low)*/
#define  UART0_DLH          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x04))  /*Divisor Latch(High)*/
#define  UART0_IER          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x04))  /*Interrupt Enable Register*/
#define  UART0_IIR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x08))  /*Interrupt Identification Register*/
#define  UART0_FCR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x08))  /*FIFO Control Register*/
#define  UART0_LCR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x0C))  /*Line Control Register*/
#define  UART0_MCR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x10))  /*Modem Control Register*/
#define  UART0_LSR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x14))  /*Line Staturs Register*/
#define  UART0_MSR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x18))  /*Modem Status Register*/
#define  UART0_SCR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x1C))  /*Scratchpad Register*/
#define  UART0_USR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x7C))  /*Uart Staturs Register */
#define  UART0_SRR          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0x88))  /*reset*/
#define  UART0_HTX          (*(volatile uint32_t*)(UART0_BASE_ADDR + 0xA4))  /*Halt TX */

/* *UART1 reg map */
#define  UART1_BASE_ADDR    0x40000400

#define  UART1_RBR_THR_DLL  (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x00))  /*Receive Buffer Register__Transmit Holding Regster__Divisor Latch(Low)*/
#define  UART1_DLH          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x04))  /*Divisor Latch(High)*/
#define  UART1_IER          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x04))  /*Interrupt Enable Register*/
#define  UART1_IIR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x08))  /*Interrupt Identification Register*/
#define  UART1_FCR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x08))  /*FIFO Control Register*/
#define  UART1_LCR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x0C))  /*Line Control Register*/
#define  UART1_MCR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x10))  /*Modem Control Register*/
#define  UART1_LSR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x14))  /*Line Staturs Register*/
#define  UART1_MSR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x18))  /*Modem Status Register*/
#define  UART1_SCR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x1C))  /*Scratchpad Register*/
#define  UART1_USR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x7C))  /*Uart Staturs Register */
#define  UART1_SRR          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0x88))  /*reset*/
#define  UART1_HTX          (*(volatile uint32_t*)(UART1_BASE_ADDR + 0xA4))  /*Halt TX */

/* GPIO reg map */
#define  GPIOA_BASE_ADDR    0x40003400

#define  GPIOA_PADR         (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x00))  /*GPIO Port A Data Register          */
#define  GPIOA_PADDR        (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x04))  /*GPIO Port A Data Direction Register*/
#define  GPIOA_EXTDR        (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x50))  /*GPIO Port A Input Data Register    */
#define  GPIOA_INTEN        (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x30))  /*GPIO Port A Interrupt enable Register     */
#define  GPIOA_INTMASK      (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x34))  /*GPIO Port A Interrupt MASK Register       */
#define  GPIOA_INTTYPE_LEVEL    (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x38))  /*GPIO Port A Interrupt Level Register    */
#define  GPIOA_INT_POLARITY     (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x3C))  /*GPIO Port A Interrupt polarity Register */
#define  GPIOA_INTSTATUS        (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x40))  /*GPIO Port A Interrupt status Register   */
#define  GPIOA_RAW_INTSTATUS    (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x44))  /*GPIO Port A Raw Interrupt Status Register  */
#define  GPIOA_DEBOUNCE         (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x48))  /*GPIO Port A Debounce enable Register       */
#define  GPIOA_EOI              (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x4C))  /*GPIO Port A clear interrupt Register              */
#define  GPIOA_INT_BOTHEDGE     (*(volatile uint32_t*)(GPIOA_BASE_ADDR + 0x68))  /*GPIO Port A Interrupt Both Edge type Register     */

/* GPIO reg map */
#define  GPIOB_BASE_ADDR    0x40003800

#define  GPIOB_PADR         (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x00))  /*GPIO Port B Data Register          */
#define  GPIOB_PADDR        (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x04))  /*GPIO Port B Data Direction Register*/
#define  GPIOB_EXTDR        (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x50))  /*GPIO Port B Input Data Register    */
#define  GPIOB_VER          (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x6c))  /*GPIO Port B Version String         */
#define  GPIOB_INTEN        (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x30))  /*GPIO Port B Interrupt enable Register     */
#define  GPIOB_INTMASK      (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x34))  /*GPIO Port B Interrupt MASK Register       */
#define  GPIOB_INTTYPE_LEVEL    (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x38))  /*GPIO Port B Interrupt Level Register    */
#define  GPIOB_INT_POLARITY     (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x3C))  /*GPIO Port B Interrupt polarity Register */
#define  GPIOB_INTSTATUS        (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x40))  /*GPIO Port B Interrupt status Register   */
#define  GPIOB_RAW_INTSTATUS    (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x44))  /*GPIO Port B Raw Interrupt Status Register  */
#define  GPIOB_DEBOUNCE         (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x48))  /*GPIO Port B Debounce enable Register       */
#define  GPIOB_EOI              (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x4C))  /*GPIO Port B clear interrupt Register              */
#define  GPIOB_INT_BOTHEDGE     (*(volatile uint32_t*)(GPIOB_BASE_ADDR + 0x68))  /*GPIO Port B Interrupt Both Edge type Register     */

/*******************************SSI0/spi master0 reg map**********************************/
#define  SSI0_BASE_ADDR     0x1F000000 //spi master1

#define  SSI0_CTRLR0        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x00))   /*Control Register 0*/
#define  SSI0_CTRLR1        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x04))
#define  SSI0_SSIENR        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x08))   /*Enable Register*/
#define  SSI0_MWCR          (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x0C))   /*Microwire Control Register*/
#define  SSI0_SER           (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x10))   /*Slave Enable Register*/
#define  SSI0_BAUDR         (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x14))   /*Baud Rate Select*/
#define  SSI0_TXFTLR        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x18))   /*Transmit FIFO Threshold Level*/
#define  SSI0_RXFTLR        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x1C))   /*Receive FIFO Threshold Level*/
#define  SSI0_TXFLR         (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x20))   /*Transmit FIFO Level Register*/
#define  SSI0_RXFLR         (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x24))   /*Receive FIFO Level Register*/
#define  SSI0_SR            (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x28))   /*Status Register*/
#define  SSI0_IMR           (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x2C))   /*Interrupt Mask Register*/
#define  SSI0_ISR           (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x30))   /*Interrupt Status Register*/
#define  SSI0_RISR          (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x34))   /*Raw Interrupt Status Register*/
#define  SSI0_TXOICR        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x38))   /*Transmit FIFO Overflow Interrupt Clear Register*/
#define  SSI0_RXOICR        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x3C))   /*Receive FIFO Overflow Interrupt Clear Register*/
#define  SSI0_RXUICR        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x40))   /*Receive FIFO Underflow Interrupt Clear Register*/
#define  SSI0_MSTICR        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x44))   /*Multi-Master Interrupt Clear Register*/
#define  SSI0_ICR           (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x48))   /*Interrupt Clear Register*/
#define  SSI0_DMACR         (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x4C))   /*DMA Control Register*/
#define  SSI0_DMATDLR       (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x50))   /*DMA Transmit Data Level*/
#define  SSI0_DMARDLR       (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x54))   /*DMA Receive Data Level*/
#define  SSI0_IDR           (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x58))   /*Identification Register*/
#define  SSI0_VERID         (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x5C))   /*coreKit version ID register*/
#define  SSI0_DR0           (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x60))   /*Data Register 0*/
#define  SSI0_DR(x)         (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x60 + ((x)<<2))) /*Data Register x,max 31*/
#define  SSI0_RX_SMPL_DLY   (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0xF0))   /*RX Sample Delay Register*/
#define  SSI0_SPI_CTRLR0    (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0xF4))   /*SPI_CTRLR0 - SPI Control Register*/
#define  SSI0_SPI_XIP_MODE_BITS  (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0xFC))   /*XIP Mode bits Register*/


#define SSI0_XIP_INCR_INST  (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x100))   /*XIP INCR transfer opcode*/
#define SSI0_XIP_WRAP_INST  (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x104))   /*XIP WRAP transfer opcode*/
#define SSI0_XIP_CTRL       (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x108))   /*XIP Control Register*/
#define SSI0_XIP_SER        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x10C))   /*Slave Enable Register*/
#define SSI0_XRXOICR        (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x110))   /*XIP Receive FIFO Overflow Interrupt Clear Register*/
#define SSI0_XIP_CNT_TIME_OUT (*(volatile uint32_t*)(SSI0_BASE_ADDR + 0x114)) /*XIP Receive FIFO Overflow Interrupt Clear Register*/


/* WDT reg map */
#define  WDT_BASE_ADDR      0x40003000

#define  WDT_CR             (*(volatile uint32_t*)(WDT_BASE_ADDR + 0x00))     /*Control Register*/
#define  WDT_TORR           (*(volatile uint32_t*)(WDT_BASE_ADDR + 0x04))     /*Timeout Range Register*/
#define  WDT_CCVR           (*(volatile uint32_t*)(WDT_BASE_ADDR + 0x08))     /*Current Counter Value Register*/
#define  WDT_CRR            (*(volatile uint32_t*)(WDT_BASE_ADDR + 0x0C))     /*Counter Restart Register*/
#define  WDT_STAT           (*(volatile uint32_t*)(WDT_BASE_ADDR + 0x10))     /*Status Register*/
#define  WDT_EOI            (*(volatile uint32_t*)(WDT_BASE_ADDR + 0x14))     /*End-of-Interrupt Register*/

/* Cache reg map */
#define  CACHE_BASE_ADDR    0x40090000

#define  CACHE_CR           (*(volatile uint32_t*)(CACHE_BASE_ADDR + 0x00))   /*Control Register*/
#define  CACHE_SR           (*(volatile uint32_t*)(CACHE_BASE_ADDR + 0x04))   /*Status Register*/
#define  CACHE_CSHR         (*(volatile uint32_t*)(CACHE_BASE_ADDR + 0x14))   /*Cache Statistic Hit Register*/
#define  CACHE_CSMR         (*(volatile uint32_t*)(CACHE_BASE_ADDR + 0x18))   /*Cache Statistic Miss Register*/

/* Timer0 reg map */
#define  TIMER0_BASE_ADDR   0x40000800

#define  TIMER0_LOADCOUNT     (*(volatile uint32_t*)(TIMER0_BASE_ADDR + 0x00))   /*Load Count Register*/
#define  TIMER0_CURRENTVALUE  (*(volatile uint32_t*)(TIMER0_BASE_ADDR + 0x04))   /*Current value Register*/
#define  TIMER0_CONTROLREG    (*(volatile uint32_t*)(TIMER0_BASE_ADDR + 0x08))   /*Control Register*/
#define  TIMER0_EOI           (*(volatile uint32_t*)(TIMER0_BASE_ADDR + 0x0C))   /*End-of-Interrupt Register*/
#define  TIMER0_INTSTATUS     (*(volatile uint32_t*)(TIMER0_BASE_ADDR + 0x10))   /*Interrupt Status Register*/

/* Timer1 reg map */
#define  TIMER1_BASE_ADDR   0x40000C00

#define  TIMER1_LOADCOUNT     (*(volatile uint32_t*)(TIMER1_BASE_ADDR + 0x00))   /*Load Count Register*/
#define  TIMER1_CURRENTVALUE  (*(volatile uint32_t*)(TIMER1_BASE_ADDR + 0x04))   /*Current value Register*/
#define  TIMER1_CONTROLREG    (*(volatile uint32_t*)(TIMER1_BASE_ADDR + 0x08))   /*Control Register*/
#define  TIMER1_EOI           (*(volatile uint32_t*)(TIMER1_BASE_ADDR + 0x0C))   /*End-of-Interrupt Register*/
#define  TIMER1_INTSTATUS     (*(volatile uint32_t*)(TIMER1_BASE_ADDR + 0x10))   /*Interrupt Status Register*/

/* Timer2 reg map */
#define  TIMER2_BASE_ADDR   0x40001000

#define  TIMER2_LOADCOUNT     (*(volatile uint32_t*)(TIMER2_BASE_ADDR + 0x00))   /*Load Count Register*/
#define  TIMER2_CURRENTVALUE  (*(volatile uint32_t*)(TIMER2_BASE_ADDR + 0x04))   /*Current value Register*/
#define  TIMER2_CONTROLREG    (*(volatile uint32_t*)(TIMER2_BASE_ADDR + 0x08))   /*Control Register*/
#define  TIMER2_EOI           (*(volatile uint32_t*)(TIMER2_BASE_ADDR + 0x0C))   /*End-of-Interrupt Register*/
#define  TIMER2_INTSTATUS     (*(volatile uint32_t*)(TIMER2_BASE_ADDR + 0x10))   /*Interrupt Status Register*/

/* I2C0 reg map */
#define  I2C0_BASE_ADDR     0x40001400

#define  I2C0_CON               (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x00))   /*Control Register*/
#define  I2C0_TAR               (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x04))   /*Target Address Register*/
#define  I2C0_SAR               (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x08))   /*Slave Address Register*/
#define  I2C0_DATA_CMD          (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x10))   /*Data Buffer and Command Register*/
#define  I2C0_SS_SCL_HCNT       (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x14))   /*Clock SCL High Count Register*/
#define  I2C0_SS_SCL_LCNT       (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x18))   /*Clock SCL High Count Register*/
#define  I2C0_INTR_MASK         (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x30))   /*Interrupt Mask Register*/
#define  I2C0_RX_TL             (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x38))   /*Receive FIFO Threshold Register*/
#define  I2C0_TX_TL             (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x3C))   /*Transmit FIFO Threshold Register*/
#define  I2C0_ENABLE            (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x6C))   /*ENABLE Register*/
#define  I2C0_STATUS            (*(volatile uint32_t*)(I2C0_BASE_ADDR + 0x70))   /*Status Register*/

/* I2C1 reg map */
#define  I2C1_BASE_ADDR     0x40001800

#define  I2C1_CON               (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x00))   /*Control Register*/
#define  I2C1_TAR               (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x04))   /*Target Address Register*/
#define  I2C1_SAR               (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x08))   /*Slave Address Register*/
#define  I2C1_DATA_CMD          (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x10))   /*Data Buffer and Command Register*/
#define  I2C1_SS_SCL_HCNT       (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x14))   /*Clock SCL High Count Register*/
#define  I2C1_SS_SCL_LCNT       (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x18))   /*Clock SCL High Count Register*/
#define  I2C1_INTR_MASK         (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x30))   /*Interrupt Mask Register*/
#define  I2C1_RX_TL             (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x38))   /*Receive FIFO Threshold Register*/
#define  I2C1_TX_TL             (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x3C))   /*Transmit FIFO Threshold Register*/
#define  I2C1_ENABLE            (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x6C))   /*ENABLE Register*/
#define  I2C1_STATUS            (*(volatile uint32_t*)(I2C1_BASE_ADDR + 0x70))   /*Status Register*/

/* I2C2 reg map */
#define  I2C2_BASE_ADDR     0x40001C00

#define  I2C2_CON               (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x00))   /*Control Register*/
#define  I2C2_TAR               (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x04))   /*Target Address Register*/
#define  I2C2_SAR               (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x08))   /*Slave Address Register*/
#define  I2C2_DATA_CMD          (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x10))   /*Data Buffer and Command Register*/
#define  I2C2_SS_SCL_HCNT       (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x14))   /*Clock SCL High Count Register*/
#define  I2C2_SS_SCL_LCNT       (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x18))   /*Clock SCL High Count Register*/
#define  I2C2_INTR_MASK         (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x30))   /*Interrupt Mask Register*/
#define  I2C2_RX_TL             (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x38))   /*Receive FIFO Threshold Register*/
#define  I2C2_TX_TL             (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x3C))   /*Transmit FIFO Threshold Register*/
#define  I2C2_ENABLE            (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x6C))   /*ENABLE Register*/
#define  I2C2_STATUS            (*(volatile uint32_t*)(I2C2_BASE_ADDR + 0x70))   /*Status Register*/

/*SPI master reg map*/
#define  SPI0_MST_BASE_ADDR    0x40002400
#define  SPI0_MST_CTRLR0        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x00))   /*Control Register 0*/
#define  SPI0_MST_CTRLR1        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x04))
#define  SPI0_MST_SSIENR        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x08))   /*Enable Register*/
#define  SPI0_MST_MWCR          (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x0C))   /*Microwire Control Register*/
#define  SPI0_MST_SER           (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x10))   /*Slave Enable Register*/
#define  SPI0_MST_BAUDR         (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x14))   /*Baud Rate Select*/
#define  SPI0_MST_TXFTLR        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x18))   /*Transmit FIFO Threshold Level*/
#define  SPI0_MST_RXFTLR        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x1C))   /*Receive FIFO Threshold Level*/
#define  SPI0_MST_TXFLR         (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x20))   /*Transmit FIFO Level Register*/
#define  SPI0_MST_RXFLR         (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x24))   /*Receive FIFO Level Register*/
#define  SPI0_MST_SR            (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x28))   /*Status Register*/
#define  SPI0_MST_IMR           (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x2C))   /*Interrupt Mask Register*/
#define  SPI0_MST_ISR           (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x30))   /*Interrupt Status Register*/
#define  SPI0_MST_RISR          (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x34))   /*Raw Interrupt Status Register*/
#define  SPI0_MST_TXOICR        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x38))   /*Transmit FIFO Overflow Interrupt Clear Register*/
#define  SPI0_MST_RXOICR        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x3C))   /*Receive FIFO Overflow Interrupt Clear Register*/
#define  SPI0_MST_RXUICR        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x40))   /*Receive FIFO Underflow Interrupt Clear Register*/
#define  SPI0_MST_MSTICR        (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x44))   /*Multi-Master Interrupt Clear Register*/
#define  SPI0_MST_ICR           (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x48))   /*Interrupt Clear Register*/
#define  SPI0_MST_DMACR         (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x4C))   /*DMA Control Register*/
#define  SPI0_MST_DMATDLR       (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x50))   /*DMA Transmit Data Level*/
#define  SPI0_MST_DMARDLR       (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x54))   /*DMA Receive Data Level*/
#define  SPI0_MST_IDR           (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x58))   /*Identification Register*/
#define  SPI0_MST_VERID         (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x5C))   /*coreKit version ID register*/
#define  SPI0_MST_DR0           (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x60))   /*Data Register 0*/
#define  SPI0_MST_DR(x)         (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0x60 + ((x)<<2))) /*Data Register x,max 31*/
#define  SPI0_MST_RX_SMPL_DLY   (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0xF0))   /*RX Sample Delay Register*/
#define  SPI0_MST_SPI_CTRLR0    (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0xF4))   /*SPI_CTRLR0 - SPI Control Register*/
#define  SPI0_MST_TXD_DRIVE_EDGE  (*(volatile uint32_t*)(SPI0_MST_BASE_ADDR + 0xF8))   /*Transmit Drive Edge Register*/


/*SPI slave reg map*/
#define SPI0_SLV_BASE_ADDR    0x40002000

#define  SPI0_SLV_CTRLR0        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x00))   /*Control Register 0*/
#define  SPI0_SLV_CTRLR1        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x04))
#define  SPI0_SLV_SSIENR        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x08))   /*Enable Register*/
#define  SPI0_SLV_MWCR          (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x0C))   /*Microwire Control Register*/
#define  SPI0_SLV_SER           (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x10))   /*Slave Enable Register*/
#define  SPI0_SLV_BAUDR         (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x14))   /*Baud Rate Select*/
#define  SPI0_SLV_TXFTLR        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x18))   /*Transmit FIFO Threshold Level*/
#define  SPI0_SLV_RXFTLR        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x1C))   /*Receive FIFO Threshold Level*/
#define  SPI0_SLV_TXFLR         (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x20))   /*Transmit FIFO Level Register*/
#define  SPI0_SLV_RXFLR         (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x24))   /*Receive FIFO Level Register*/
#define  SPI0_SLV_SR            (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x28))   /*Status Register*/
#define  SPI0_SLV_IMR           (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x2C))   /*Interrupt Mask Register*/
#define  SPI0_SLV_ISR           (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x30))   /*Interrupt Status Register*/
#define  SPI0_SLV_RISR          (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x34))   /*Raw Interrupt Status Register*/
#define  SPI0_SLV_TXOICR        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x38))   /*Transmit FIFO Overflow Interrupt Clear Register*/
#define  SPI0_SLV_RXOICR        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x3C))   /*Receive FIFO Overflow Interrupt Clear Register*/
#define  SPI0_SLV_RXUICR        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x40))   /*Receive FIFO Underflow Interrupt Clear Register*/
#define  SPI0_SLV_MSTICR        (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x44))   /*Multi-Master Interrupt Clear Register*/
#define  SPI0_SLV_ICR           (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x48))   /*Interrupt Clear Register*/
#define  SPI0_SLV_DMACR         (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x4C))   /*DMA Control Register*/
#define  SPI0_SLV_DMATDLR       (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x50))   /*DMA Transmit Data Level*/
#define  SPI0_SLV_DMARDLR       (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x54))   /*DMA Receive Data Level*/
#define  SPI0_SLV_IDR           (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x58))   /*Identification Register*/
#define  SPI0_SLV_VERID         (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x5C))   /*coreKit version ID register*/
#define  SPI0_SLV_DR0           (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x60))   /*Data Register 0*/
#define  SPI0_SLV_DR(x)         (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0x60 + ((x)<<2))) /*Data Register x,max 31*/
#define  SPI0_SLV_RX_SMPL_DLY   (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0xF0))   /*RX Sample Delay Register*/
#define  SPI0_SLV_SPI_CTRLR0    (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0xF4))   /*SPI_CTRLR0 - SPI Control Register*/
#define  SPI0_SLV_TXD_DRIVE_EDGE  (*(volatile uint32_t*)(SPI0_SLV_BASE_ADDR + 0xF8))   /*Transmit Drive Edge Register*/


#endif  /* LISOC_H */
