#ifndef CCHG_Register_Table__H
#define CCHG_Register_Table__H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t SFTRST:1;
        } addr_0x00;
        uint32_t addr_0x00_W;
    };

    union {
        struct {
            uint32_t H_SIZE:15;
            uint32_t padding_15_to_15:1;
            uint32_t V_SIZE:12;
        } addr_0x04;
        uint32_t addr_0x04_W;
    };

    union {
        struct {
            uint32_t H_VALID_SIZE:14;
            uint32_t padding_15_to_14:2;
            uint32_t V_VALID_SIZE:12;
        } addr_0x08;
        uint32_t addr_0x08_W;
    };

    union {
        struct {
            uint32_t W_OUT:1;
        } addr_0x0C;
        uint32_t addr_0x0C_W;
    };

    union {
        struct {
            uint32_t BANK_CYCLE:11;
        } addr_0x10;
        uint32_t addr_0x10_W;
    };

    union {
        struct {
            uint32_t VD_DELAY:13;
        } addr_0x14;
        uint32_t addr_0x14_W;
    };

} CCHG_Register_Table_s;
#ifdef __cplusplus
}
#endif

#endif /*CCHG_Register_Table__H*/
