#ifndef FlashCache_Register_Table__H
#define FlashCache_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t EN:1;
            uint32_t INV_REQ:1;
            uint32_t POW_REQ:1;
            uint32_t SET_MAN_POW:1;
            uint32_t SET_MAN_INV:1;
            uint32_t SET_PREFETCH:1;
            uint32_t STATISTIC_EN:1;
            uint32_t Reserved:25;
        } CCR;
        uint32_t CCR_W;
    };

    union {
        struct {
            uint32_t CS:2;
            uint32_t INV_STAT:1;
            uint32_t Reserved:1;
            uint32_t POW_STAT:1;
        } SR;
        uint32_t SR_W;
    };

    union {
        struct {
            uint32_t POW_ERR:1;
            uint32_t MAN_INV_ERR:1;
            uint32_t Reserved:30;
        } IRQ_MASK;
        uint32_t IRQ_MASK_W;
    };

    union {
        struct {
            uint32_t POW_ERR:1;
            uint32_t MAN_INV_ERR:1;
            uint32_t Reserved:30;
        } IRQSTAT;
        uint32_t IRQSTAT_W;
    };

    union {
        struct {
            uint32_t AW:5;
            uint32_t CW:5;
            uint32_t CACHE_WAY:2;
            uint32_t RESET_ALL_REGS:1;
            uint32_t GEN_STAT_LOGIC:1;
            uint32_t Reserved:18;
        } HWPARAMS;
        uint32_t HWPARAMS_W;
    };

    union {
        struct {
            uint32_t CSHR:32;
        } CSHR;
        uint32_t CSHR_W;
    };

    union {
        struct {
            uint32_t CSMR:32;
        } CSMR;
        uint32_t CSMR_W;
    };

    uint32_t rsvd_0x1c[0xfb4/4];

    union {
        struct {
            uint32_t DES_2:4;
            uint32_t SIZE:4;
            uint32_t Reserved:24;
        } PIDR4;
        uint32_t PIDR4_W;
    };

    uint32_t rsvd_0xfd4[0xc/4];

    union {
        struct {
            uint32_t PART_0:8;
            uint32_t Reserved:24;
        } PIDR0;
        uint32_t PIDR0_W;
    };

    union {
        struct {
            uint32_t PART_1:4;
            uint32_t DES_0:4;
            uint32_t Reserved:24;
        } PIDR1;
        uint32_t PIDR1_W;
    };

    union {
        struct {
            uint32_t DES_1:3;
            uint32_t JEDEC:1;
            uint32_t REVISION:4;
            uint32_t Reserved:24;
        } PIDR2;
        uint32_t PIDR2_W;
    };

    union {
        struct {
            uint32_t CMOD:3;
            uint32_t rsvd_3:1;
            uint32_t REVAND:4;
            uint32_t Reserved:24;
        } PIDR3;
        uint32_t PIDR3_W;
    };

    union {
        struct {
            uint32_t PRMBL_0:8;
            uint32_t Reserved:24;
        } CIDR0;
        uint32_t CIDR0_W;
    };

    union {
        struct {
            uint32_t PRMBL_1:4;
            uint32_t CLASS:4;
            uint32_t Reserved:24;
        } CIDR1;
        uint32_t CIDR1_W;
    };

    union {
        struct {
            uint32_t PRMBL_2:8;
            uint32_t Reserved:24;
        } CIDR2;
        uint32_t CIDR2_W;
    };

    union {
        struct {
            uint32_t PRMBL_3:8;
            uint32_t Reserved:24;
        } CIDR3;
        uint32_t CIDR3_W;
    };

} FlashCache_Register_Table_s;
#endif
