#ifndef ISP_Register_Table__H
#define ISP_Register_Table__H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t NUM_COL:13;
            uint32_t NUM_R0:3;
            uint32_t NUM_ROW:12;
            uint32_t NUM_R1:4;
        } addr_0x00;
        uint32_t addr_0x00_W;
    };

    union {
        struct {
            uint32_t BAYER_PATTERN:2;
            uint32_t BAYER_R1:14;
            uint32_t THROUGH_MODE:1;
            uint32_t BIT_MODE:1;
            uint32_t BAYER_R2:14;
        } addr_0x04;
        uint32_t addr_0x04_W;
    };

    union {
        struct {
            uint32_t OB_R_SUB:8;
            uint32_t OB_GR_SUB:8;
            uint32_t OB_GB_SUB:8;
            uint32_t OB_B_SUB:8;
        } addr_0x08;
        uint32_t addr_0x08_W;
    };

    union {
        struct {
            uint32_t TOTAL_GAIN:8;
            uint32_t TG_R:24;
        } addr_0x0C;
        uint32_t addr_0x0C_W;
    };

    union {
        struct {
            uint32_t WB_R_GAIN:12;
            uint32_t WBG_R0:4;
            uint32_t WB_B_GAIN:12;
            uint32_t WBG_R1:4;
        } addr_0x10;
        uint32_t addr_0x10_W;
    };

    union {
        struct {
            uint32_t GAMMA_FACTOR:3;
            uint32_t GF_R:29;
        } addr_0x14;
        uint32_t addr_0x14_W;
    };

    union {
        struct {
            uint32_t APERTURE_TH:12;
            uint32_t APERTURE_RESERVE:4;
            uint32_t APERTURE_H:8;
            uint32_t APERTURE_V:8;
        } addr_0x18;
        uint32_t addr_0x18_W;
    };

    union {
        struct {
            uint32_t MATRIX_R_Y_G1:8;
            uint32_t MATRIX_R_Y_G2:8;
            uint32_t MATRIX_B_Y_G1:8;
            uint32_t MATRIX_B_Y_G2:8;
        } addr_0x1C;
        uint32_t addr_0x1C_W;
    };

    union {
        struct {
            uint32_t Y_OUT_GAIN:8;
            uint32_t Y_OUT_OFFSET:8;
            uint32_t Y_OUT_R:16;
        } addr_0x20;
        uint32_t addr_0x20_W;
    };

    union {
        struct {
            uint32_t PSEUDO_SUPPRESS:8;
            uint32_t PSEUDO_R:24;
        } addr_0x24;
        uint32_t addr_0x24_W;
    };

    union {
        struct {
            uint32_t AE_AWB_UNIT:7;
            uint32_t AE_AWB_R1:9;
            uint32_t AE_AWB_COL:6;
            uint32_t AE_AWB_R2:2;
            uint32_t AE_AWB_ROW:6;
            uint32_t AE_AWB_R3:2;
        } addr_0x28;
        uint32_t addr_0x28_W;
    };

    union {
        struct {
            uint32_t H_IN_OFFSET:8;
            uint32_t V_IN_OFFSET:8;
            uint32_t IN_OFFSET_R:16;
        } addr_0x2C;
        uint32_t addr_0x2C_W;
    };

    union {
        struct {
            uint32_t H_OUT_OFFSET:8;
            uint32_t V_OUT_OFFSET:8;
            uint32_t HS_WIDTH:8;
            uint32_t VS_WIDTH:8;
        } addr_0x30;
        uint32_t addr_0x30_W;
    };

    union {
        struct {
            uint32_t H_SIZE:14;
            uint32_t SIZE_R0:2;
            uint32_t V_SIZE:12;
            uint32_t SIZE_R1:4;
        } addr_0x34;
        uint32_t addr_0x34_W;
    };

    union {
        struct {
            uint32_t H_OUT_SIZE:13;
            uint32_t OUT_SIZE_R0:3;
            uint32_t V_OUT_SIZE:12;
            uint32_t OUT_SIZE_R1:4;
        } addr_0x38;
        uint32_t addr_0x38_W;
    };

    union {
        struct {
            uint32_t H_FR_BLK:13;
            uint32_t FR_BLK_R0:3;
            uint32_t V_FR_BLK:12;
            uint32_t FR_BLK_R1:4;
        } addr_0x3C;
        uint32_t addr_0x3C_W;
    };

} ISP_Register_Table_s;
#ifdef __cplusplus
}
#endif

#endif /*ISP_Register_Table__H*/
