#ifndef LiSR_Register_Table__H
#define LiSR_Register_Table__H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t IN_VSIZE:12;
            uint32_t IN_HSIZE:12;
            uint32_t IN_FRATE:3;
            uint32_t padding_27_to_27:1;
            uint32_t IN_FORM:2;
            uint32_t padding_30_to_30:1;
            uint32_t IN_SEL:1;
        } addr_0x00;
        uint32_t addr_0x00_W;
    };

    union {
        struct {
            uint32_t SD_VSIZE:12;
            uint32_t padding_15_to_12:4;
            uint32_t SD_HSIZE:12;
            uint32_t padding_29_to_28:2;
            uint32_t SD_MODE:1;
            uint32_t INH_SD:1;
        } addr_0x04;
        uint32_t addr_0x04_W;
    };

    union {
        struct {
            uint32_t SD_VOFS:12;
            uint32_t padding_15_to_12:4;
            uint32_t SD_HOFS:12;
        } addr_0x08;
        uint32_t addr_0x08_W;
    };

    union {
        struct {
            uint32_t CROP_VOFF:8;
            uint32_t CROP_HOFF:10;
            uint32_t padding_19_to_18:2;
            uint32_t AHE_BLKSIZ:4;
            uint32_t OUT_I_P:1;
            uint32_t OUT_FRATE:3;
            uint32_t OUT_RESO:4;
        } addr_0x0c;
        uint32_t addr_0x0c_W;
    };

    union {
        struct {
            uint32_t NR8MEM10:1;
            uint32_t Y8RND:1;
            uint32_t T0422AVE:1;
            uint32_t T0444AVE:1;
            uint32_t OUT_RANGE:2;
            uint32_t IN_RANGE:2;
        } addr_0x10;
        uint32_t addr_0x10_W;
    };

    union {
        struct {
            uint32_t K1_EXP:1;
            uint32_t K_ADDON1:1;
            uint32_t K_FIL1:1;
            uint32_t padding_3_to_3:1;
            uint32_t K2_EXP:1;
            uint32_t K_ADDON2:1;
            uint32_t K_FIL2:1;
            uint32_t padding_7_to_7:1;
            uint32_t K3_EXP:1;
            uint32_t K_ADDON3:1;
            uint32_t K_FIL3:1;
            uint32_t padding_11_to_11:1;
            uint32_t K4_EXP:1;
            uint32_t K_ADDON4:1;
            uint32_t K_FIL4:1;
            uint32_t padding_15_to_15:1;
            uint32_t TMAP1:1;
            uint32_t TMAP2:1;
            uint32_t TMAP3:1;
            uint32_t TMAP4:1;
            uint32_t MED_FIL:1;
        } addr_0x14;
        uint32_t addr_0x14_W;
    };

    union {
        struct {
            uint32_t OUT_DISP_ON:1;
            uint32_t OUT_THRU:1;
            uint32_t padding_3_to_2:2;
            uint32_t OUT_FORM:4;
            uint32_t VIDEO_ON:1;
            uint32_t AHE_ON:1;
            uint32_t padding_19_to_10:10;
            uint32_t MIPI_WC:1;
            uint32_t MIPI_DESKEW:1;
        } addr_0x18;
        uint32_t addr_0x18_W;
    };

    union {
        struct {
            uint32_t AHE_HOFS:12;
        } addr_0x1c;
        uint32_t addr_0x1c_W;
    };

    union {
        struct {
            uint32_t AHE_HWIDH:12;
        } addr_0x20;
        uint32_t addr_0x20_W;
    };

    union {
        struct {
            uint32_t AHE_VOFS:12;
        } addr_0x24;
        uint32_t addr_0x24_W;
    };

    union {
        struct {
            uint32_t AHE_VWIDH:12;
        } addr_0x28;
        uint32_t addr_0x28_W;
    };

    uint8_t RSVD_002C[8];

    union {
        struct {
            uint32_t PIXEL_CONV:1;
            uint32_t AUTO_OFFSET:1;
            uint32_t T_MAP_SHAP:1;
            uint32_t padding_7_to_3:5;
            uint32_t CONTRAST:8;
        } addr_0x34;
        uint32_t addr_0x34_W;
    };

    union {
        struct {
            uint32_t T_MAP_OFFSET:8;
            uint32_t T_MAP_TH:8;
        } addr_0x38;
        uint32_t addr_0x38_W;
    };

    union {
        struct {
            uint32_t MOVESW:2;
            uint32_t UVENHON:1;
            uint32_t padding_3_to_3:1;
            uint32_t AHEF_ON:1;
            uint32_t FCF_ON:1;
            uint32_t padding_7_to_6:2;
            uint32_t AOFF_VAL:8;
        } addr_0x3c;
        uint32_t addr_0x3c_W;
    };

    union {
        struct {
            uint32_t ALPHA_AHE:8;
        } addr_0x40;
        uint32_t addr_0x40_W;
    };

    union {
        struct {
            uint32_t ALPHA_FC:8;
        } addr_0x44;
        uint32_t addr_0x44_W;
    };

    union {
        struct {
            uint32_t CB_OFSET:8;
            uint32_t padding_9_to_8:2;
            uint32_t CRATE:6;
        } addr_0x48;
        uint32_t addr_0x48_W;
    };

    union {
        struct {
            uint32_t CR_OFSET:8;
        } addr_0x4C;
        uint32_t addr_0x4C_W;
    };

    union {
        struct {
            uint32_t MOVETHVAL:8;
            uint32_t padding_9_to_8:2;
            uint32_t MDBLD:2;
        } addr_0x50;
        uint32_t addr_0x50_W;
    };

    union {
        struct {
            uint32_t NEWY_BLD:8;
            uint32_t YBUF_BLD:8;
        } addr_0x54;
        uint32_t addr_0x54_W;
    };

    union {
        struct {
            uint32_t NEWUV_BLD:8;
            uint32_t UVBUF_BLD:8;
        } addr_0x58;
        uint32_t addr_0x58_W;
    };

    uint8_t RSVD_005C[4];

    union {
        struct {
            uint32_t KVAL_1L:16;
            uint32_t KVAL_1U:8;
        } addr_0x60;
        uint32_t addr_0x60_W;
    };

    union {
        struct {
            uint32_t KVAL_2L:16;
            uint32_t KVAL_2U:8;
        } addr_0x64;
        uint32_t addr_0x64_W;
    };

    union {
        struct {
            uint32_t KVAL_3L:16;
            uint32_t KVAL_3U:8;
        } addr_0x68;
        uint32_t addr_0x68_W;
    };

    union {
        struct {
            uint32_t KVAL_4L:16;
            uint32_t KVAL_4U:8;
        } addr_0x6C;
        uint32_t addr_0x6C_W;
    };

    uint8_t RSVD_0070[12];

    union {
        struct {
            uint32_t AVE_YUV:1;
            uint32_t HIST_ON:1;
        } addr_0x7C;
        uint32_t addr_0x7C_W;
    };

    union {
        struct {
            uint32_t YAVE_XP:12;
        } addr_0x80;
        uint32_t addr_0x80_W;
    };

    union {
        struct {
            uint32_t YAVE_YP:12;
        } addr_0x84;
        uint32_t addr_0x84_W;
    };

    union {
        struct {
            uint32_t YAVE_HW:12;
        } addr_0x88;
        uint32_t addr_0x88_W;
    };

    union {
        struct {
            uint32_t YAVE_VW:12;
        } addr_0x8C;
        uint32_t addr_0x8C_W;
    };

    union {
        struct {
            uint32_t CAVE_XP:12;
        } addr_0x90;
        uint32_t addr_0x90_W;
    };

    union {
        struct {
            uint32_t CAVE_YP:12;
        } addr_0x94;
        uint32_t addr_0x94_W;
    };

    union {
        struct {
            uint32_t CAVE_HW:12;
        } addr_0x98;
        uint32_t addr_0x98_W;
    };

    union {
        struct {
            uint32_t CAVE_VW:12;
        } addr_0x9C;
        uint32_t addr_0x9C_W;
    };

    union {
        struct {
            uint32_t YAVE_R1D:16;
        } addr_0xA0;
        uint32_t addr_0xA0_W;
    };

    union {
        struct {
            uint32_t YAVE_R2D:16;
        } addr_0xA4;
        uint32_t addr_0xA4_W;
    };

    union {
        struct {
            uint32_t YAVE_R3D:16;
        } addr_0xA8;
        uint32_t addr_0xA8_W;
    };

    union {
        struct {
            uint32_t YAVE_R4D:16;
        } addr_0xAC;
        uint32_t addr_0xAC_W;
    };

    union {
        struct {
            uint32_t CBAVE_R1D:16;
        } addr_0xB0;
        uint32_t addr_0xB0_W;
    };

    union {
        struct {
            uint32_t CBAVE_R2D:16;
        } addr_0xB4;
        uint32_t addr_0xB4_W;
    };

    union {
        struct {
            uint32_t CBAVE_R3D:16;
        } addr_0xB8;
        uint32_t addr_0xB8_W;
    };

    union {
        struct {
            uint32_t CBAVE_R4D:16;
        } addr_0xBC;
        uint32_t addr_0xBC_W;
    };

    union {
        struct {
            uint32_t CRAVE_R1D:16;
        } addr_0xC0;
        uint32_t addr_0xC0_W;
    };

    union {
        struct {
            uint32_t CRAVE_R2D:16;
        } addr_0xC4;
        uint32_t addr_0xC4_W;
    };

    union {
        struct {
            uint32_t CRAVE_R3D:16;
        } addr_0xC8;
        uint32_t addr_0xC8_W;
    };

    union {
        struct {
            uint32_t CRAVE_R4D:16;
        } addr_0xCC;
        uint32_t addr_0xCC_W;
    };

    union {
        struct {
            uint32_t PN_SW1_CN:4;
            uint32_t PN_SW1_ST:1;
            uint32_t padding_22_to_5:18;
            uint32_t PN_SW_LED1:9;
        } addr_0xD0;
        uint32_t addr_0xD0_W;
    };

    union {
        struct {
            uint32_t PN_RESW_CN:16;
            uint32_t PN_RE_PSW_CN:4;
            uint32_t RE_B_ST:1;
            uint32_t RE_A_ST:1;
            uint32_t RE_PSW_ST:1;
        } addr_0xD4;
        uint32_t addr_0xD4_W;
    };

    uint8_t RSVD_00D8[12];

    union {
        struct {
            uint32_t padding_0_to_13:14;
            uint32_t SELF_RESULT:1;
            uint32_t CHK_START:1;
        } addr_0xE4;
        uint32_t addr_0xE4_W;
    };

    uint8_t RSVD_00E8[4];

    union {
        struct {
            uint32_t URUN_UVNR:1;
            uint32_t ORUN_UVNR:1;
            uint32_t URUN_YNR:1;
            uint32_t ORUN_YNR:1;
            uint32_t URUN_MD:1;
            uint32_t ORUN_MD:1;
            uint32_t URUN_LBUF_A:1;
            uint32_t URUN_LBUF_B:1;
            uint32_t ORUN_LBUF:1;
            uint32_t URUN_LBUF_T:1;
            uint32_t URUN_SCALE:1;
            uint32_t ORUN_SCALE:1;
            uint32_t padding_30_to_19:12;
            uint32_t FLG_CLR:1;
        } addr_0xEC;
        uint32_t addr_0xEC_W;
    };

    union {
        struct {
            uint32_t SYS_RST:1;
            uint32_t SOFT_RST:1;
        } addr_0xF0;
        uint32_t addr_0xF0_W;
    };

    union {
        struct {
            uint32_t LEDP:4;
            uint32_t LEDC:1;
        } addr_0xF4;
        uint32_t addr_0xF4_W;
    };

    union {
        struct {
            uint32_t DIPSW:4;
            uint32_t padding_30_to_4:27;
            uint32_t DDR16MODE:1;
        } addr_0xF8;
        uint32_t addr_0xF8_W;
    };

    union {
        struct {
            uint32_t REVISION:8;
            uint32_t PRODUCT:8;
        } addr_0xFC;
        uint32_t addr_0xFC_W;
    };
    uint32_t addr_0x100_W;
    uint32_t addr_0x104_W;
    uint32_t addr_0x108_W;
    uint32_t addr_0x10C_W;
    uint32_t addr_0x110_W;
    uint32_t addr_0x114_W;

} LiSR_Register_Table_s;
#ifdef __cplusplus
}
#endif

#endif /*LiSR_Register_Table__H*/
