#ifndef MIPI_Register_Table_RX__H
#define MIPI_Register_Table_RX__H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t PHYA_RX_PDATA_RESET_N:1;
            uint32_t padding_7_to_1:7;
            uint32_t LINK_P0_RST_N:1;
        } addr_0x0;
        uint32_t addr_0x0_W;
    };

    union {
        struct {
            uint32_t MODE_P0_OPERATION:3;
        } addr_0x4;
        uint32_t addr_0x4_W;
    };

    uint8_t RSVD_0008[4];

    union {
        struct {
            uint32_t PHYA_RX_MODE:3;
        } addr_0xC;
        uint32_t addr_0xC_W;
    };

    union {
        struct {
            uint32_t MODE_P0_PIX_PARA:2;
        } addr_0x10;
        uint32_t addr_0x10_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_IREF_POW_EN:1;
        } addr_0x14;
        uint32_t addr_0x14_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_C0_HS_AMP_POW_EN:1;
            uint32_t padding_15_to_1:15;
            uint32_t PHYA_RX_C0_LP_AMP_POW_EN:1;
        } addr_0x18;
        uint32_t addr_0x18_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_D0_LP_AMP_POW_EN:1;
            uint32_t PHYA_RX_D1_LP_AMP_POW_EN:1;
            uint32_t PHYA_RX_D2_LP_AMP_POW_EN:1;
            uint32_t PHYA_RX_D3_LP_AMP_POW_EN:1;
        } addr_0x1C;
        uint32_t addr_0x1C_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_D0_HS_AMP_POW_EN:1;
            uint32_t PHYA_RX_D1_HS_AMP_POW_EN:1;
            uint32_t PHYA_RX_D2_HS_AMP_POW_EN:1;
            uint32_t PHYA_RX_D3_HS_AMP_POW_EN:1;
        } addr_0x20;
        uint32_t addr_0x20_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_C0_RES_EN:1;
        } addr_0x24;
        uint32_t addr_0x24_W;
    };

    union {
        struct {
            uint32_t PHYA_RX_D0_RES_EN:1;
            uint32_t PHYA_RX_D1_RES_EN:1;
            uint32_t PHYA_RX_D2_RES_EN:1;
            uint32_t PHYA_RX_D3_RES_EN:1;
        } addr_0x28;
        uint32_t addr_0x28_W;
    };

    uint8_t RSVD_002C[8];

    union {
        struct {
            uint32_t PHYA_RX_RESCTL:4;
        } addr_0x34;
        uint32_t addr_0x34_W;
    };

    uint8_t RSVD_0038[40];

    union {
        struct {
            uint32_t PHYA_RX_BUS_MODE:3;
        } addr_0x60;
        uint32_t addr_0x60_W;
    };

    uint8_t RSVD_0064[36];

    union {
        struct {
            uint32_t PHYA_RX_VRMSEL:1;
            uint32_t padding_3_to_1:3;
            uint32_t PHYA_RX_IRMSEL:1;
        } addr_0x88;
        uint32_t addr_0x88_W;
    };

    uint8_t RSVD_008C[28];

    union {
        struct {
            uint32_t PHYA_RX_OFFSET:2;
            uint32_t padding_15_to_10:6;
            uint32_t PHYA_RX_LP_LH:2;
            uint32_t padding_19_to_18:2;
            uint32_t PHYA_RX_LP_HL:2;
        } addr_0xA8;
        uint32_t addr_0xA8_W;
    };

    union {
        struct {
            uint32_t MODE_P0_LBL:2;
            uint32_t padding_3_to_2:2;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_EN:4;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_0:4;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_1:4;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_2:4;
            uint32_t MODE_P0_LBL_FIDMAP_SEL_3:4;
        } addr_0xAC;
        uint32_t addr_0xAC_W;
    };

    uint8_t RSVD_00B0[104];

    union {
        struct {
            uint32_t DPHY_P0_MODE_LANENUM:3;
            uint32_t padding_15_to_3:13;
            uint32_t DPHY_P0_LP_SYNC_OFF:1;
            uint32_t padding_19_to_17:3;
            uint32_t DPHY_P0_MODE_HSDM_OFF:1;
            uint32_t padding_23_to_21:3;
            uint32_t DPHY_P0_MODE_MSB_FIRST:1;
            uint32_t padding_27_to_25:3;
            uint32_t DPHY_P0_MODE_LPOP_OFF:1;
        } addr_0x118;
        uint32_t addr_0x118_W;
    };

    uint8_t RSVD_011C[4];

    union {
        struct {
            uint32_t DPHY_P0_PREG_DLM_0:3;
            uint32_t padding_3_to_3:1;
            uint32_t DPHY_P0_PREG_DLM_1:3;
            uint32_t padding_7_to_7:1;
            uint32_t DPHY_P0_PREG_DLM_2:3;
            uint32_t padding_11_to_11:1;
            uint32_t DPHY_P0_PREG_DLM_3:3;
        } addr_0x120;
        uint32_t addr_0x120_W;
    };

    uint8_t RSVD_0124[64];

    union {
        struct {
            uint32_t DPHY_P0_TIME_HS_ON:16;
            uint32_t DPHY_P0_TIME_RES_ON:16;
        } addr_0x164;
        uint32_t addr_0x164_W;
    };

    uint8_t RSVD_0168[28];

    union {
        struct {
            uint32_t CSI2_P0_STATE:3;
        } addr_0x184;
        uint32_t addr_0x184_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_DATA_ID:8;
            uint32_t CSI2_P0_WC:16;
            uint32_t CSI2_P0_ECC:8;
        } addr_0x188;
        uint32_t addr_0x188_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_LINE_LENGTH:16;
            uint32_t CSI2_P0_PKT_COUNT:16;
        } addr_0x18C;
        uint32_t addr_0x18C_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_ERR_ECC:16;
            uint32_t CSI2_P0_ERR_CS:16;
        } addr_0x190;
        uint32_t addr_0x190_W;
    };

    uint8_t RSVD_0194[268];

    union {
        struct {
            uint32_t APP_P0_CHK_HENA:1;
            uint32_t APP_P0_CHK_VENA:1;
        } addr_0x2A0;
        uint32_t addr_0x2A0_W;
    };

    union {
        struct {
            uint32_t APP_P0_CHK_HSIZE:16;
            uint32_t APP_P0_CHK_VSIZE:16;
        } addr_0x2A4;
        uint32_t addr_0x2A4_W;
    };

    uint8_t RSVD_02A8[2660];

    union {
        struct {
            uint32_t DPHY_P0_ERR_DET_SC_0:8;
            uint32_t DPHY_P0_ERR_DET_SC_1:8;
            uint32_t DPHY_P0_ERR_DET_SC_2:8;
            uint32_t DPHY_P0_ERR_DET_SC_3:8;
        } addr_0xD0C;
        uint32_t addr_0xD0C_W;
    };

    uint8_t RSVD_0D10[60];

    union {
        struct {
            uint32_t DPHY_P0_ERR_DET_SC_AL:8;
        } addr_0xD4C;
        uint32_t addr_0xD4C_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_DATA_TYPE_EBD:18;
        } addr_0xD50;
        uint32_t addr_0xD50_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_DATA_TYPE_USER:24;
        } addr_0xD54;
        uint32_t addr_0xD54_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_DATA_TYPE_RESERVED:24;
        } addr_0xD58;
        uint32_t addr_0xD58_W;
    };

    uint8_t RSVD_0D5C[420];

    union {
        struct {
            uint32_t REG_RDA_SEL:2;
            uint32_t padding_7_to_2:6;
            uint32_t RX_PDATA_OUT_SEL:3;
            uint32_t padding_12_to_11:2;
            uint32_t RX_PCLK_DIV_EN:1;
        } addr_0xF00;
        uint32_t addr_0xF00_W;
    };

    uint8_t RSVD_0F04[188];

    union {
        struct {
            uint32_t USER_CTRL:32;
        } addr_0xFC0;
        uint32_t addr_0xFC0_W;
    };

} MIPI_Register_Table_RX_s;
#ifdef __cplusplus
}
#endif

#endif /*MIPI_Register_Table_RX__H*/
