#ifndef MIPI_Register_Table_TX__H
#define MIPI_Register_Table_TX__H

#ifdef __cplusplus
extern "C" {
#endif

#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t PHYA_REF_POW_EN:1;
            uint32_t padding_3_to_1:3;
            uint32_t PHYA_TX_POW_EN:1;
            uint32_t padding_7_to_5:3;
            uint32_t PHYA_EN:1;
            uint32_t padding_11_to_9:3;
            uint32_t PHYA_RST_N:1;
            uint32_t padding_15_to_13:3;
            uint32_t PHYA_CNT_RST_N:1;
            uint32_t padding_19_to_17:3;
            uint32_t PHYA_PLL_ANA_EN:1;
            uint32_t padding_23_to_21:3;
            uint32_t PHYA_PLL_RESETN:1;
        } addr_0x0;
        uint32_t addr_0x0_W;
    };

    union {
        struct {
            uint32_t PHYA_PLL_PDIV:3;
            uint32_t padding_3_to_3:1;
            uint32_t PHYA_PLL_N1DIV:2;
            uint32_t padding_7_to_6:2;
            uint32_t PHYA_PLL_N2DIV:7;
            uint32_t padding_15_to_15:1;
            uint32_t PHYA_PLL_K1DIV:2;
            uint32_t padding_19_to_18:2;
            uint32_t PHYA_PLL_K2DIV:2;
            uint32_t padding_23_to_22:2;
            uint32_t PHYA_PLL_K3DIV:7;
        } addr_0x4;
        uint32_t addr_0x4_W;
    };

    union {
        struct {
            uint32_t PHYA_PLL_CHP_TRIM:6;
            uint32_t padding_7_to_6:2;
            uint32_t PHYA_PLL_KVCO_TRIM:3;
            uint32_t padding_11_to_11:1;
            uint32_t PHYA_PLL_OSC_SEL:2;
            uint32_t padding_15_to_14:2;
            uint32_t PHYA_PLL_V2I_OFFSET:2;
            uint32_t padding_19_to_18:2;
            uint32_t PHYA_PLL_OSC_CLMP_DIS:1;
            uint32_t padding_23_to_21:3;
            uint32_t PHYA_PLL_VCO_IGAIN:4;
        } addr_0x8;
        uint32_t addr_0x8_W;
    };

    union {
        struct {
            uint32_t PHYA_ZUP:1;
            uint32_t PHYA_ZDN:1;
            uint32_t padding_3_to_2:2;
            uint32_t PHYA_VRM:1;
            uint32_t PHYA_IRM:1;
            uint32_t padding_7_to_6:2;
            uint32_t PHYA_POL_SCK:1;
            uint32_t padding_11_to_9:3;
            uint32_t PHYA_CK_EDG:1;
            uint32_t padding_15_to_13:3;
            uint32_t PHYA_PLL_LPF_CSEL:1;
            uint32_t padding_19_to_17:3;
            uint32_t PHYA_PLL_LPF_RSEL:1;
            uint32_t padding_23_to_21:3;
            uint32_t PHYA_PLL_LPE_SEL_3ORD:1;
        } addr_0xC;
        uint32_t addr_0xC_W;
    };

    union {
        struct {
            uint32_t PHYA_CK_POW_EN:1;
            uint32_t padding_3_to_1:3;
            uint32_t PHYA_D0_POW_EN:1;
            uint32_t PHYA_D1_POW_EN:1;
            uint32_t PHYA_D2_POW_EN:1;
            uint32_t PHYA_D3_POW_EN:1;
            uint32_t PHYA_CK_PLDN:1;
            uint32_t padding_11_to_9:3;
            uint32_t PHYA_D0_PLDN:1;
            uint32_t PHYA_D1_PLDN:1;
            uint32_t PHYA_D2_PLDN:1;
            uint32_t PHYA_D3_PLDN:1;
            uint32_t PHYA_CK_PN:1;
            uint32_t padding_19_to_17:3;
            uint32_t PHYA_D0_PN:1;
            uint32_t PHYA_D1_PN:1;
            uint32_t PHYA_D2_PN:1;
            uint32_t PHYA_D3_PN:1;
            uint32_t padding_27_to_24:4;
            uint32_t PHYA_D0_INITDATA:1;
            uint32_t PHYA_D1_INITDATA:1;
            uint32_t PHYA_D2_INITDATA:1;
            uint32_t PHYA_D3_INITDATA:1;
        } addr_0x010;
        uint32_t addr_0x010_W;
    };

    union {
        struct {
            uint32_t PHYA_CK_HSTX_EN_SET_N:1;
            uint32_t padding_3_to_1:3;
            uint32_t PHYA_D0_HSTX_EN_SET_N:1;
            uint32_t PHYA_D1_HSTX_EN_SET_N:1;
            uint32_t PHYA_D2_HSTX_EN_SET_N:1;
            uint32_t PHYA_D3_HSTX_EN_SET_N:1;
            uint32_t PHYA_CK_HSTX_EN_RST_N:1;
            uint32_t padding_11_to_9:3;
            uint32_t PHYA_D0_HSTX_EN_RST_N:1;
            uint32_t PHYA_D1_HSTX_EN_RST_N:1;
            uint32_t PHYA_D2_HSTX_EN_RST_N:1;
            uint32_t PHYA_D3_HSTX_EN_RST_N:1;
            uint32_t PHYA_CK_LPTX_EN_SET_N:1;
            uint32_t padding_19_to_17:3;
            uint32_t PHYA_D0_LPTX_EN_SET_N:1;
            uint32_t PHYA_D1_LPTX_EN_SET_N:1;
            uint32_t PHYA_D2_LPTX_EN_SET_N:1;
            uint32_t PHYA_D3_LPTX_EN_SET_N:1;
            uint32_t PHYA_CK_LPTX_EN_RST_N:1;
            uint32_t padding_27_to_25:3;
            uint32_t PHYA_D0_LPTX_EN_RST_N:1;
            uint32_t PHYA_D1_LPTX_EN_RST_N:1;
            uint32_t PHYA_D2_LPTX_EN_RST_N:1;
            uint32_t PHYA_D3_LPTX_EN_RST_N:1;
        } addr_0x014;
        uint32_t addr_0x014_W;
    };

    union {
        struct {
            uint32_t PHYA_CK_DLY:2;
            uint32_t padding_15_to_2:14;
            uint32_t PHYA_D0_DLY:2;
            uint32_t padding_19_to_18:2;
            uint32_t PHYA_D1_DLY:2;
            uint32_t padding_23_to_22:2;
            uint32_t PHYA_D2_DLY:2;
            uint32_t padding_27_to_26:2;
            uint32_t PHYA_D3_DLY:2;
        } addr_0x018;
        uint32_t addr_0x018_W;
    };

    uint8_t RSVD_001C[4];

    union {
        struct {
            uint32_t PHYA_CK_TSTIN_P:1;
            uint32_t PHYA_CK_TSTIN_N:1;
            uint32_t padding_7_to_2:6;
            uint32_t PHYA_D0_TSTIN_P:1;
            uint32_t PHYA_D0_TSTIN_N:1;
            uint32_t PHYA_D1_TSTIN_P:1;
            uint32_t PHYA_D1_TSTIN_N:1;
            uint32_t PHYA_D2_TSTIN_P:1;
            uint32_t PHYA_D2_TSTIN_N:1;
            uint32_t PHYA_D3_TSTIN_P:1;
            uint32_t PHYA_D3_TSTIN_N:1;
            uint32_t PHYA_CK_TST_PSI:1;
            uint32_t padding_19_to_17:3;
            uint32_t PHYA_D0_TST_PSI:1;
            uint32_t PHYA_D1_TST_PSI:1;
            uint32_t PHYA_D2_TST_PSI:1;
            uint32_t PHYA_D3_TST_PSI:1;
        } addr_0x020;
        uint32_t addr_0x020_W;
    };

    union {
        struct {
            uint32_t PHYA_CK_TST_DLO:1;
            uint32_t padding_3_to_1:3;
            uint32_t PHYA_D0_TST_DLO:1;
            uint32_t PHYA_D1_TST_DLO:1;
            uint32_t PHYA_D2_TST_DLO:1;
            uint32_t PHYA_D3_TST_DLO:1;
            uint32_t PHYA_CK_TST_PSO:1;
            uint32_t padding_11_to_9:3;
            uint32_t PHYA_D0_TST_PSO:1;
            uint32_t PHYA_D1_TST_PSO:1;
            uint32_t PHYA_D2_TST_PSO:1;
            uint32_t PHYA_D3_TST_PSO:1;
        } addr_0x024;
        uint32_t addr_0x024_W;
    };

    uint8_t RSVD_0028[8];

    union {
        struct {
            #if 1 //es1
            uint32_t MODE_LANENUM:3;
            uint32_t rsvd_3:5;
            #endif
            uint32_t CSI2_P0_TX_TS:1;
            uint32_t padding_11_to_9:3;
            uint32_t CSI2_P0_TX_TC:1;
            uint32_t padding_15_to_13:3;
            uint32_t DPHY_P0_TX_LP00:2;
            uint32_t padding_19_to_18:2;
            uint32_t DPHY_P0_TX_LP01:2;
            uint32_t padding_23_to_22:2;
            uint32_t DPHY_P0_TX_LP10:2;
            uint32_t padding_27_to_26:2;
            uint32_t DPHY_P0_TX_LP11:2;
        } addr_0x030;
        uint32_t addr_0x030_W;
    };

    union {
        struct {
            uint32_t DPHY_P0_TX_TIME_T_CLK_LPX:6;
            uint32_t padding_7_to_6:2;
            uint32_t DPHY_P0_TX_TIME_T_CLK_PREPARE:6;
            uint32_t padding_15_to_14:2;
            uint32_t DPHY_P0_TX_TIME_T_CLK_ZERO:7;
            uint32_t padding_23_to_23:1;
            uint32_t DPHY_P0_TX_TIME_T_CLK_PRE:6;
        } addr_0x034;
        uint32_t addr_0x034_W;
    };

    union {
        struct {
            uint32_t DPHY_P0_TX_TIME_T_HS_PREPARE:6;
            uint32_t padding_7_to_6:2;
            uint32_t DPHY_P0_TX_TIME_T_HS_ZERO:6;
            uint32_t padding_15_to_14:2;
            uint32_t DPHY_P0_TX_TIME_T_HS_SOT:6;
            uint32_t padding_23_to_22:2;
            uint32_t DPHY_P0_TX_TIME_T_HS_EOT:6;
        } addr_0x038;
        uint32_t addr_0x038_W;
    };

    union {
        struct {
            uint32_t DPHY_P0_TX_TIME_T_CLK_POST:6;
            uint32_t padding_7_to_6:2;
            uint32_t DPHY_P0_TX_TIME_T_CLK_EOT:6;
            uint32_t padding_15_to_14:2;
            uint32_t DPHY_P0_TX_TIME_T_WAKEUP:9;
        } addr_0x03C;
        uint32_t addr_0x03C_W;
    };

    union {
        struct {
            uint32_t DPHY_P0_TX_DESKEW_AUTO:1;
            uint32_t padding_15_to_1:15;
            uint32_t DPHY_P0_TX_DESKEW_LENGTH:16;
        } addr_0x040;
        uint32_t addr_0x040_W;
    };

    union {
        struct {
            uint32_t CSI2_P0_TX_SP_DLY:16;
            uint32_t CSI2_P0_TX_HD_DLY:16;
        } addr_0x044;
        uint32_t addr_0x044_W;
    };

    uint8_t RSVD_0048[4];

    union {
        struct {
            uint32_t CSI2_P0_TX_FSM_APP:4;
            uint32_t CSI2_P0_TX_FSM_LINK:4;
            uint32_t DPHY_P0_TX_FSM_PHYD:5;
        } addr_0x04C;
        uint32_t addr_0x04C_W;
    };

    uint8_t RSVD_0050[4];

    union {
        struct {
            uint32_t CSI2_P0_TX_DATA_TYPE_USER:24;
        } addr_0x054;
        uint32_t addr_0x054_W;
    };

    uint8_t RSVD_0058[8];

    union {
        struct {
            uint32_t LVDS_P0_TX_XIV_EN:1;
            uint32_t padding_3_to_1:3;
            uint32_t LVDS_P0_TX_XIV_FV:1;
            uint32_t padding_7_to_5:3;
            uint32_t LVDS_P0_TX_BLANK_SEL:2;
        } addr_0x060;
        uint32_t addr_0x060_W;
    };

    union {
        struct {
            uint32_t PREG_H_SIZE:16;
            uint32_t PREG_V_SIZE:16;
        } addr_0x064;
        uint32_t addr_0x064_W;
    };

    union {
        struct {
            uint32_t LVDS_P0_TX_FSM_APP:3;
            uint32_t padding_3_to_3:1;
            uint32_t LVDS_P0_TX_FSM_LINK:3;
        } addr_0x068;
        uint32_t addr_0x068_W;
    };

    uint8_t RSVD_006C[4];

    union {
        struct {
            uint32_t LVDS_P0_TX_CODE_SOF:32;
        } addr_0x070;
        uint32_t addr_0x070_W;
    };

    union {
        struct {
            uint32_t LVDS_P0_TX_CODE_SOF:32;
        } addr_0x074;
        uint32_t addr_0x074_W;
    };

    union {
        struct {
            uint32_t LVDS_P0_TX_CODE_SOL:32;
        } addr_0x078;
        uint32_t addr_0x078_W;
    };

    union {
        struct {
            uint32_t LVDS_P0_TX_CODE_SOL:32;
        } addr_0x07C;
        uint32_t addr_0x07C_W;
    };

    union {
        struct {
            uint32_t LVDS_P0_TX_CODE_EOL:32;
        } addr_0x080;
        uint32_t addr_0x080_W;
    };

    union {
        struct {
            uint32_t LVDS_P0_TX_CODE_EOL:32;
        } addr_0x084;
        uint32_t addr_0x084_W;
    };

    union {
        struct {
            uint32_t LVDS_P0_TX_CODE_EOF:32;
        } addr_0x088;
        uint32_t addr_0x088_W;
    };

    union {
        struct {
            uint32_t LVDS_P0_TX_CODE_EOF:32;
        } addr_0x08C;
        uint32_t addr_0x08C_W;
    };

    uint8_t RSVD_0090[112];

    union {
        struct {
            uint32_t MODE_OPERATION:3;
            uint32_t padding_3_to_3:1;
            uint32_t MODE_LANENUM:3;
            uint32_t padding_7_to_7:1;
            uint32_t MODE_BITSEL:3;
        } addr_0x100;
        uint32_t addr_0x100_W;
    };

    union {
        struct {
            uint32_t DPHY_P0_PREG_DLM_0:2;
            uint32_t padding_2_to_3:2;
            uint32_t DPHY_P0_PREG_DLM_1:2;
            uint32_t padding_6_to_7:2;
            uint32_t DPHY_P0_PREG_DLM_2:2;
            uint32_t padding_10_to_11:2;
            uint32_t DPHY_P0_PREG_DLM_3:2;
        } addr_0x104;
        uint32_t addr_0x104_W;
    };

    uint8_t RSVD_0108[3580 - 4];

    union {
        struct {
            uint32_t REG_RDA_SEL:2;
            uint32_t padding_7_to_2:6;
            uint32_t PHYA_TSTTX:3;
            uint32_t padding_15_to_11:5;
            uint32_t PHYA_PLL_ANA_TSTPD_EN:1;
            uint32_t padding_23_to_17:7;
            uint32_t PHYA_PLL_ANA_MON_SEL:3;
        } addr_0xF00;
        uint32_t addr_0xF00_W;
    };

    uint8_t RSVD_0F04[188];

    union {
        struct {
            uint32_t USER_CTRL:32;
        } addr_0xFC0;
        uint32_t addr_0xFC0_W;
    };

} MIPI_Register_Table_TX_s;
#ifdef __cplusplus
}
#endif

#endif /*MIPI_Register_Table_TX__H*/
