#ifndef QSPI_Register_Table__H
#define QSPI_Register_Table__H
#include "stdint.h"
typedef volatile struct {
    union {
        struct {
            uint32_t DFS:5;
            uint32_t RSVD_CTRLR0_5:1;
            uint32_t FRF:2;
            uint32_t SCPH:1;
            uint32_t SCPOL:1;
            uint32_t TMOD:2;
            uint32_t SLV_OE:1;
            uint32_t SRL:1;
            uint32_t SSTE:1;
            uint32_t RSVD_CTRLR0_15:1;
            uint32_t CFS:4;
            uint32_t RSVD_CTRLR0_20_21:2;
            uint32_t SPI_FRF:2;
            uint32_t SPI_HYPERBUS_EN:1;
            uint32_t RSVD_CTRLR0_25_31:6;
            uint32_t SSI_IS_MST:1;
        } CTRLR0;
        uint32_t CTRLR0_W;
    };

    union {
        struct {
            uint32_t NDF:16;
            uint32_t RSVD_CTRLR1:16;
        } CTRLR1;
        uint32_t CTRLR1_W;
    };

    union {
        struct {
            uint32_t SSIC_EN:1;
            uint32_t RSVD_SSIENR:31;
        } SSIENR;
        uint32_t SSIENR_W;
    };

    union {
        struct {
            uint32_t MWMOD:1;
            uint32_t MDD:1;
            uint32_t MHS:1;
            uint32_t RSVD_MWCR:29;
        } MWCR;
        uint32_t MWCR_W;
    };

    union {
        struct {
            uint32_t SER:1;
            uint32_t RSVD_SER:31;
        } SER;
        uint32_t SER_W;
    };

    union {
        struct {
            uint32_t RSVD_BAUDR_0:1;
            uint32_t SCKDV:15;
            uint32_t RSVD_BAUDR_16_31:16;
        } BAUDR;
        uint32_t BAUDR_W;
    };

    union {
        struct {
            uint32_t TFT:5;
            uint32_t RSVD_TXFTLR:11;
            uint32_t TXFTHR:5;
            uint32_t RSVD_TXFTHR:11;
        } TXFTLR;
        uint32_t TXFTLR_W;
    };

    union {
        struct {
            uint32_t RFT:5;
            uint32_t RSVD_RXFTLR:27;
        } RXFTLR;
        uint32_t RXFTLR_W;
    };

    union {
        struct {
            uint32_t TXTFL:6;
            uint32_t RSVD_TXFLR:26;
        } TXFLR;
        uint32_t TXFLR_W;
    };

    union {
        struct {
            uint32_t RXTFL:6;
            uint32_t RSVD_RXFLR:26;
        } RXFLR;
        uint32_t RXFLR_W;
    };

    union {
        struct {
            uint32_t BUSY:1;
            uint32_t TFNF:1;
            uint32_t TFE:1;
            uint32_t RFNE:1;
            uint32_t RFF:1;
            uint32_t TXE:1;
            uint32_t DCOL:1;
            uint32_t RSVD_SR:25;
        } SR;
        uint32_t SR_W;
    };

    union {
        struct {
            uint32_t TXEIM:1;
            uint32_t TXOIM:1;
            uint32_t RXUIM:1;
            uint32_t RXOIM:1;
            uint32_t RXFIM:1;
            uint32_t MSTIM:1;
            uint32_t XRXOIM:1;
            uint32_t RSVD_IMR:25;
        } IMR;
        uint32_t IMR_W;
    };

    union {
        struct {
            uint32_t TXEIS:1;
            uint32_t TXOIS:1;
            uint32_t RXUIS:1;
            uint32_t RXOIS:1;
            uint32_t RXFIS:1;
            uint32_t MSTIS:1;
            uint32_t XRXOIS:1;
            uint32_t RSVD_ISR:25;
        } ISR;
        uint32_t ISR_W;
    };

    union {
        struct {
            uint32_t TXEIR:1;
            uint32_t TXOIR:1;
            uint32_t RXUIR:1;
            uint32_t RXOIR:1;
            uint32_t RXFIR:1;
            uint32_t MSTIR:1;
            uint32_t XRXOIR:1;
            uint32_t RSVD_RISR:25;
        } RISR;
        uint32_t RISR_W;
    };

    union {
        struct {
            uint32_t TXOICR:1;
            uint32_t RSVD_TXOICR:31;
        } TXOICR;
        uint32_t TXOICR_W;
    };

    union {
        struct {
            uint32_t RXOICR:1;
            uint32_t RSVD_RXOICR:31;
        } RXOICR;
        uint32_t RXOICR_W;
    };

    union {
        struct {
            uint32_t RXUICR:1;
            uint32_t RSVD_RXUICR:31;
        } RXUICR;
        uint32_t RXUICR_W;
    };

    union {
        struct {
            uint32_t MSTICR:1;
            uint32_t RSVD_MSTICR:31;
        } MSTICR;
        uint32_t MSTICR_W;
    };

    union {
        struct {
            uint32_t ICR:1;
            uint32_t RSVD_ICR:31;
        } ICR;
        uint32_t ICR_W;
    };

    union {
        struct {
            uint32_t RDMAE:1;
            uint32_t TDMAE:1;
            uint32_t RSVD_DMACR:30;
        } DMACR;
        uint32_t DMACR_W;
    };

    union {
        struct {
            uint32_t DMATDL:5;
            uint32_t RSVD_DMATDLR:27;
        } DMATDLR;
        uint32_t DMATDLR_W;
    };

    union {
        struct {
            uint32_t DMARDL:5;
            uint32_t RSVD_DMARDLR:27;
        } DMARDLR;
        uint32_t DMARDLR_W;
    };

    union {
        struct {
            uint32_t IDCODE:32;
        } IDR;
        uint32_t IDR_W;
    };

    union {
        struct {
            uint32_t SSIC_COMP_VERSION:32;
        } SSIC_VERSION_ID;
        uint32_t SSIC_VERSION_ID_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR0;
        uint32_t DR0_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR1;
        uint32_t DR1_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR2;
        uint32_t DR2_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR3;
        uint32_t DR3_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR4;
        uint32_t DR4_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR5;
        uint32_t DR5_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR6;
        uint32_t DR6_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR7;
        uint32_t DR7_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR8;
        uint32_t DR8_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR9;
        uint32_t DR9_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR10;
        uint32_t DR10_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR11;
        uint32_t DR11_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR12;
        uint32_t DR12_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR13;
        uint32_t DR13_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR14;
        uint32_t DR14_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR15;
        uint32_t DR15_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR16;
        uint32_t DR16_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR17;
        uint32_t DR17_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR18;
        uint32_t DR18_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR19;
        uint32_t DR19_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR20;
        uint32_t DR20_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR21;
        uint32_t DR21_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR22;
        uint32_t DR22_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR23;
        uint32_t DR23_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR24;
        uint32_t DR24_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR25;
        uint32_t DR25_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR26;
        uint32_t DR26_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR27;
        uint32_t DR27_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR28;
        uint32_t DR28_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR29;
        uint32_t DR29_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR30;
        uint32_t DR30_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR31;
        uint32_t DR31_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR32;
        uint32_t DR32_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR33;
        uint32_t DR33_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR34;
        uint32_t DR34_W;
    };

    union {
        struct {
            uint32_t DR:32;
        } DR35;
        uint32_t DR35_W;
    };

    union {
        struct {
            uint32_t RSD:8;
            uint32_t RSVD0_RX_SAMPLE_DLY:8;
            uint32_t SE:1;
            uint32_t RSVD1_RX_SAMPLE_DLY:15;
        } RX_SAMPLE_DELAY;
        uint32_t RX_SAMPLE_DELAY_W;
    };

    union {
        struct {
            uint32_t TRANS_TYPE:2;
            uint32_t ADDR_L:4;
            uint32_t RSVD_SPI_CTRLR0_6:1;
            uint32_t XIP_MD_BIT_EN:1;
            uint32_t INST_L:2;
            uint32_t RSVD_SPI_CTRLR0_10:1;
            uint32_t WAIT_CYCLES:5;
            uint32_t SPI_DDR_EN:1;
            uint32_t INST_DDR_EN:1;
            uint32_t SPI_RXDS_EN:1;
            uint32_t XIP_DFS_HC:1;
            uint32_t XIP_INST_EN:1;
            uint32_t SSIC_XIP_CONT_XFER_EN:1;
            uint32_t RSVD_SPI_CTRLR0_22_23:2;
            uint32_t SPI_DM_EN:1;
            uint32_t SPI_RXDS_SIG_EN:1;
            uint32_t XIP_MBL:2;
            uint32_t RSVD_SPI_CTRLR0_28:1;
            uint32_t XIP_PREFETCH_EN:1;
            uint32_t CLK_STRETCH_EN:1;
            uint32_t RSVD_SPI_CTRLR0:1;
        } SPI_CTRLR0;
        uint32_t SPI_CTRLR0_W;
    };

    union {
        struct {
            uint32_t TDE:8;
            uint32_t RSVD_DDR_DRIVE_EDGE:24;
        } DDR_DRIVE_EDGE;
        uint32_t DDR_DRIVE_EDGE_W;
    };

    union {
        struct {
            uint32_t XIP_MD_BITS:16;
            uint32_t RSVD_XIP_MD_BITS:16;
        } XIP_MODE_BITS;
        uint32_t XIP_MODE_BITS_W;
    };

    union {
        struct {
            uint32_t INCR_INST:16;
            uint32_t RSVD_INCR_INST:16;
        } XIP_INCR_INST;
        uint32_t XIP_INCR_INST_W;
    };

    union {
        struct {
            uint32_t WRAP_INST:16;
            uint32_t RSVD_WRAP_INST:16;
        } XIP_WRAP_INST;
        uint32_t XIP_WRAP_INST_W;
    };

    union {
        struct {
            uint32_t FRF:2;
            uint32_t TRANS_TYPE:2;
            uint32_t ADDR_L:4;
            uint32_t RSVD_XIP_CTRL_8:1;
            uint32_t INST_L:2;
            uint32_t RSVD_SPI_CTRLR0_11:1;
            uint32_t MD_BITS_EN:1;
            uint32_t WAIT_CYCLES:5;
            uint32_t DFS_HC:1;
            uint32_t DDR_EN:1;
            uint32_t INST_DDR_EN:1;
            uint32_t RXDS_EN:1;
            uint32_t INST_EN:1;
            uint32_t CONT_XFER_EN:1;
            uint32_t XIP_HYPERBUS_EN:1;
            uint32_t RXDS_SIG_EN:1;
            uint32_t XIP_MBL:2;
            uint32_t RSVD_XIP_CTRL_28:1;
            uint32_t XIP_PREFETCH_EN:1;
            uint32_t RSVD_XIP_CTRL:2;
        } XIP_CTRL;
        uint32_t XIP_CTRL_W;
    };

    union {
        struct {
            uint32_t SER:1;
        } XIP_SER;
        uint32_t XIP_SER_W;
    };

    union {
        struct {
            uint32_t XRXOICR:1;
            uint32_t RSVD_XRXOICR:31;
        } XRXOICR;
        uint32_t XRXOICR_W;
    };

    union {
        struct {
            uint32_t XTOC:8;
            uint32_t RSVD_XTOC:24;
        } XIP_CNT_TIME_OUT;
        uint32_t XIP_CNT_TIME_OUT_W;
    };

} QSPI_Register_Table_s;
#endif
