#ifndef Register_Top__H
#define Register_Top__H

#if defined ( __CC_ARM   )
#pragma anon_unions
#endif

#include "RCC_Register_Table.h"
#include "APB_TIMERS_Register_Table.h"
#include "I2C_Register_Table.h"
#include "SYSCFG_Register_Table.h"
#include "UART_Register_Table.h"
#include "ISP_Register_Table.h"
#include "CCHG_Register_Table.h"
#include "MIPI_Register_Table_RX.h"
#include "MIPI_Register_Table_TX.h"
#include "LiSR_Register_Table.h"
#include "LiSR_Register_Table.h"
#include "RTC_Register_Table.h"
#include "AF_Register_Table.h"
#include "TPGEN_Register_Table.h"
#include "INNO_DDR_PHY_Com_Register_Table.h"

/******************************************************************************/
/*                         Peripheral memory map                              */
/******************************************************************************/
/* Peripheral and SRAM base address */
#define LISOC_FLASH_BASE        (0x1F000000UL)  /*!< (FLASH     ) Base Address */
#define LISOC_SRAM_BASE         (0x20000000UL)  /*!< (SRAM      ) Base Address */
#define LISOC_SRAM_BANK1_BASE   (0x20000000UL)  /*!< (SRAM      ) Base Address */
#define LISOC_SRAM_BANK2_BASE   (0x20020000UL)  /*!< (SRAM      ) Base Address */
#define LISOC_SRAM_BANK3_BASE   (0x20040000UL)  /*!< (SRAM      ) Base Address */
#define LISOC_SRAM_END_ADDR     (0x20060000UL)  /*!< (SRAM      ) Base Address */
#define LISOC_PERIPH_BASE       (0x40000000UL)  /*!< (Peripheral) Base Address */

#define LISOC_RAM_BASE          (0x20000000UL)
#define LISOC_APB_BASE          (0x40000000UL)
#define LISOC_AHB_BASE          (0x400F0000UL)

/* APB peripherals                                                           */
#define LISOC_UART0_BASE        (LISOC_APB_BASE + 0x0000UL)
#define LISOC_UART1_BASE        (LISOC_APB_BASE + 0x0400UL)
#define LISOC_TIMER0_BASE       (LISOC_APB_BASE + 0x0800UL)
#define LISOC_TIMER1_BASE       (LISOC_APB_BASE + 0x0C00UL)
#define LISOC_TIMER2_BASE       (LISOC_APB_BASE + 0x1000UL)
#define LISOC_I2C0_BASE         (LISOC_APB_BASE + 0x1400UL)
#define LISOC_I2C1_BASE         (LISOC_APB_BASE + 0x1800UL)
#define LISOC_I2C2_BASE         (LISOC_APB_BASE + 0x1C00UL)
#define LISOC_SPIS_BASE         (LISOC_APB_BASE + 0x2000UL)
#define LISOC_SPIM_BASE         (LISOC_APB_BASE + 0x2400UL)
#define LISOC_TRNG_BASE         (LISOC_APB_BASE + 0x2800UL)
#define LISOC_RTC_BASE          (LISOC_APB_BASE + 0x2C00UL)
#define LISOC_WDT_BASE          (LISOC_APB_BASE + 0x3000UL)
#define LISOC_GPIOA_BASE        (LISOC_APB_BASE + 0x3400UL)
#define LISOC_GPIOB_BASE        (LISOC_APB_BASE + 0x3800UL)

#define LISOC_DDR0_PHY_BASE     (LISOC_APB_BASE + 0x10000UL)
#define LISOC_DDR1_PHY_BASE     (LISOC_APB_BASE + 0x20000UL)
#define LISOC_DDR0_CTRL_BASE    (LISOC_APB_BASE + 0x30000UL)
#define LISOC_DDR1_CTRL_BASE    (LISOC_APB_BASE + 0x40000UL)
#define LISOC_MIPI_RX_BASE      (LISOC_APB_BASE + 0x50000UL)
#define LISOC_MIPI_TX_BASE      (LISOC_APB_BASE + 0x60000UL)
#define LISOC_ISP_BASE          (LISOC_APB_BASE + 0x70000UL)
#define LISOC_LISR_BASE         (LISOC_APB_BASE + 0x80000UL)
#define LISOC_CACHE_BASE        (LISOC_APB_BASE + 0x90000UL)
#define LISOC_CCHG_BASE         (LISOC_APB_BASE + 0xA0000UL)
#define LISOC_AF_BASE           (LISOC_APB_BASE + 0xB0000UL)
#define LISOC_TPGEN_BASE        (LISOC_APB_BASE + 0xC0000UL)

/* AHB peripherals                                                           */
#define LISOC_RCC_BASE          (LISOC_AHB_BASE + 0x0000UL)
#define LISOC_SYSCFG_BASE       (LISOC_AHB_BASE + 0x1000UL)
#define LISOC_QSPI_BASE         (LISOC_AHB_BASE + 0x2000UL)

#define LISOC_QSPI              ((volatile QSPI_Register_Table_s *) LISOC_QSPI_BASE)
#define LISOC_RCC               ((volatile RCC_Register_Table_s *) LISOC_RCC_BASE)
#define LISOC_SYSCFG            ((volatile SYSCFG_Register_Table_s *) LISOC_SYSCFG_BASE)

#define LISOC_CCHG              ((volatile CCHG_Register_Table_s *) LISOC_CCHG_BASE)
#define LISOC_FLASHCACHE        ((volatile FlashCache_Register_Table_s *) LISOC_CACHE_BASE)
#define LISOC_LISR              ((volatile LiSR_Register_Table_s *) LISOC_LISR_BASE)
#define LISOC_ISP               ((volatile ISP_Register_Table_s *) LISOC_ISP_BASE)
#define LISOC_MIPI_TX           ((volatile MIPI_Register_Table_TX_s *) LISOC_MIPI_TX_BASE)
#define LISOC_MIPI_RX           ((volatile MIPI_Register_Table_RX_s *) LISOC_MIPI_RX_BASE)
#define LISOC_DDR0_PHY          ((volatile INNO_DDR_PHY_Com_Register_Table_s *) LISOC_DDR0_PHY_BASE)
#define LISOC_DDR1_PHY          ((volatile INNO_DDR_PHY_Com_Register_Table_s *) LISOC_DDR1_PHY_BASE)
#define LISOC_DDR0_CTL          ((volatile INNO_DDR_CTRL_Register_Table_s *) LISOC_DDR0_CTRL_BASE)
#define LISOC_DDR1_CTL          ((volatile INNO_DDR_CTRL_Register_Table_s *) LISOC_DDR1_CTRL_BASE)
#define LISOC_GPIOB             ((volatile GPIOB_Register_Table_s *) LISOC_GPIOB_BASE)
#define LISOC_GPIOA             ((volatile GPIOB_Register_Table_s *) LISOC_GPIOA_BASE)
#define LISOC_WDT               ((volatile APB_WDT_Register_Table_s *) LISOC_WDT_BASE) 
#define LISOC_RTC               ((volatile RTC_Register_Table_s *) LISOC_RTC_BASE) 
#define LISOC_SPIM              ((volatile SPI_Register_Table_mst_s *) LISOC_SPIM_BASE)
#define LISOC_SPIS              ((volatile SPI_Register_Table_slv_s *) LISOC_SPIS_BASE)
#define LISOC_I2C2              ((volatile I2C_Register_Table_s *) LISOC_I2C2_BASE) 
#define LISOC_I2C1              ((volatile I2C_Register_Table_s *) LISOC_I2C1_BASE) 
#define LISOC_I2C0              ((volatile I2C_Register_Table_s *) LISOC_I2C0_BASE) 
#define LISOC_TIMER2            ((volatile APB_TIMERS_Register_Table_s *) LISOC_TIMER2_BASE) 
#define LISOC_TIMER1            ((volatile APB_TIMERS_Register_Table_s *) LISOC_TIMER1_BASE) 
#define LISOC_TIMER0            ((volatile APB_TIMERS_Register_Table_s *) LISOC_TIMER0_BASE) 
#define LISOC_UART1             ((volatile UART_Register_Table_s *) LISOC_UART1_BASE) 
#define LISOC_UART0             ((volatile UART_Register_Table_s *) LISOC_UART0_BASE)
#define LISOC_AF                ((volatile AF_Register_Table_s *) LISOC_AF_BASE) 
#define LISOC_TPGEN             ((volatile TPGEN_Register_Table_s *) LISOC_TPGEN_BASE)

#endif

