;/**************************************************************************//**
; * @file     startup_SSE050.s
; * @brief    CMSIS Cortex-M3 Core Device Startup File for
; *           Device SSE050
; * @version  V3.01
; * @date     06. March 2012
; *
; * @note
; * Copyright (C) 2012,2017  ARM Limited. All rights reserved.
; *
; * @par
; * ARM Limited (ARM) is supplying this software for use with Cortex-M
; * processor based microcontrollers.  This file can be freely distributed
; * within development tools that are supporting such ARM based processors.
; *
; * @par
; * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
; * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
; * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
; * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
; *
; ******************************************************************************/
;/*
;//-------- <<< Use Configuration Wizard in Context Menu >>> ------------------
;*/


; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000400

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000C00

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                EXPORT  __Vectors_End
                EXPORT  __Vectors_Size

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler
                DCD     NMI_Handler               ; NMI Handler
                DCD     HardFault_Handler         ; Hard Fault Handler
                DCD     MemManage_Handler         ; MPU Fault Handler
                DCD     BusFault_Handler          ; Bus Fault Handler
                DCD     UsageFault_Handler        ; Usage Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     SVC_Handler               ; SVCall Handler
                DCD     DebugMon_Handler          ; Debug Monitor Handler
                DCD     0                         ; Reserved
                DCD     PendSV_Handler            ; PendSV Handler
                DCD     SysTick_Handler           ; SysTick Handler

                ; External Interrupts
                DCD     UART0_Handler             ; UART 0 RX and TX Handler
                DCD     UART1_Handler             ; UART 1 RX and TX Handler
                DCD     SPIMST_Handler            ; SPI Master Handler
                DCD     SPISLV_Handler            ; SPI Slave Handler
                DCD     QSPI_Handler              ; QSPI Handler
                DCD     RTC_Handler               ; RTC Handler
                DCD     WDT_Handler               ; Watchdog Timer Handler
                DCD     GPIOA_Handler             ; GPIOA Handler
                DCD     GPIOB_Handler             ; GPIOB Handler
                DCD     TIMER0_Handler            ; TIMER 0 Handler
                DCD     TIMER1_Handler            ; TIMER 1 Handler
                DCD     TIMER2_Handler            ; TIMER 2 Handler
                DCD     I2C0_Handler              ; I2C 0 Handler
                DCD     I2C1_Handler              ; I2C 1 Handler
                DCD     I2C2_Handler              ; I2C 2 Handler
                DCD     ISP_Handler               ; ISP Handler
                DCD     CACHE_Handler             ; CACHE Handler
                DCD     MIPI_RX_ERR_ECC_Handler   ; MIPI Rx ECC Error Handler
                DCD     MIPI_RX_ERR_CS_Handler    ; MIPI Rx CS Error Handler
                DCD     AF_CMPL_Handler           ; AF_CMPL Handler
                DCD     MIPI_RX_HERR_OUT_Handler  ; MIPI_RX_HERR_OUT Handler
                DCD     MIPI_RX_VERR_OUT_Handler  ; MIPI_RX_VERR_OUT Handler					
__Vectors_End

__Vectors_Size  EQU     __Vectors_End - __Vectors

                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
                IMPORT  SystemInit
                IMPORT  __main
                LDR     R0, =SystemInit
                BLX     R0
                LDR     R0, =__main
                BX      R0
                ENDP


; Dummy Exception Handlers (infinite loops which can be modified)

NMI_Handler     PROC
                EXPORT  NMI_Handler               [WEAK]
                B       .
                ENDP
HardFault_Handler\
                PROC
                EXPORT  HardFault_Handler         [WEAK]
                B       .
                ENDP
MemManage_Handler\
                PROC
                EXPORT  MemManage_Handler         [WEAK]
                B       .
                ENDP
BusFault_Handler\
                PROC
                EXPORT  BusFault_Handler          [WEAK]
                B       .
                ENDP
UsageFault_Handler\
                PROC
                EXPORT  UsageFault_Handler        [WEAK]
                B       .
                ENDP
SVC_Handler     PROC
                EXPORT  SVC_Handler               [WEAK]
                B       .
                ENDP
DebugMon_Handler\
                PROC
                EXPORT  DebugMon_Handler          [WEAK]
                B       .
                ENDP
PendSV_Handler\
                PROC
                EXPORT  PendSV_Handler            [WEAK]
                B       .
                ENDP
SysTick_Handler\
                PROC
                EXPORT  SysTick_Handler           [WEAK]
                B       .
                ENDP

Default_Handler PROC
                EXPORT UART0_Handler              [WEAK]
                EXPORT UART1_Handler              [WEAK]
                EXPORT SPIMST_Handler             [WEAK]
                EXPORT SPISLV_Handler             [WEAK]
                EXPORT QSPI_Handler               [WEAK]
                EXPORT RTC_Handler                [WEAK]
                EXPORT WDT_Handler                [WEAK]
                EXPORT GPIOA_Handler              [WEAK]
                EXPORT GPIOB_Handler              [WEAK]
                EXPORT TIMER0_Handler             [WEAK]
                EXPORT TIMER1_Handler             [WEAK]
                EXPORT TIMER2_Handler             [WEAK]
                EXPORT I2C0_Handler               [WEAK]
                EXPORT I2C1_Handler               [WEAK]
                EXPORT I2C2_Handler               [WEAK]
                EXPORT CACHE_Handler              [WEAK]
                EXPORT ISP_Handler                [WEAK]
                EXPORT MIPI_RX_ERR_ECC_Handler    [WEAK]
                EXPORT MIPI_RX_ERR_CS_Handler     [WEAK]
                EXPORT AF_CMPL_Handler            [WEAK]
                EXPORT MIPI_RX_HERR_OUT_Handler   [WEAK]
                EXPORT MIPI_RX_VERR_OUT_Handler   [WEAK]
UART0_Handler
UART1_Handler
SPIMST_Handler
SPISLV_Handler
QSPI_Handler
RTC_Handler
WDT_Handler
GPIOA_Handler
GPIOB_Handler
TIMER0_Handler
TIMER1_Handler
TIMER2_Handler
I2C0_Handler
I2C1_Handler
I2C2_Handler
ISP_Handler
CACHE_Handler
MIPI_RX_ERR_ECC_Handler
MIPI_RX_ERR_CS_Handler
AF_CMPL_Handler
MIPI_RX_HERR_OUT_Handler
MIPI_RX_VERR_OUT_Handler
                B       .

                ENDP


                ALIGN


; User Initial Stack & Heap

                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap

__user_initial_stackheap PROC
                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR
                ENDP

                ALIGN

                ENDIF


                END
