/*
 *-----------------------------------------------------------------------------
 * The confidential and proprietary information contained in this file may
 * only be used by a person authorised under and to the extent permitted
 * by a subsisting licensing agreement from ARM Limited.
 *
 *            (C) COPYRIGHT 2010-2017   ARM Limited or its affiliates.
 *                ALL RIGHTS RESERVED
 *
 * This entire notice must be reproduced on all copies of this file
 * and copies of this file may only be made by a person if such person is
 * permitted to do so under the terms of a subsisting license agreement
 * from ARM Limited.
 *
 *      SVN Information
 *
 *      Checked In          : $Date: 2013-04-10 15:14:20 +0100 (Wed, 10 Apr 2013) $
 *
 *      Revision            : $Revision: 366156 $
 *
 *      Release Information : SSE050-r0p1-00rel0
 *-----------------------------------------------------------------------------
 */

 /*

 UART functions for retargetting

 */
#include "lisoc_test.h"
#include "uart.h"

void UartStdOutInit(void)
{
  SSE050_UART0->BAUDDIV = 16;
  SSE050_UART0->CTRL    = 0x41; // High speed test mode, TX only
//  SSE050_GPIO1->ALTFUNCSET = (1<<5);
  return;
}
// Output a character
unsigned char UartPutc(unsigned char my_ch)
{
  // while ((SSE050_UART0->STATE & 1)); // Wait if Transmit Holding register is full
  // SSE050_UART0->DATA = my_ch; // write to transmit holding register
  // *((volatile uint32_t *)ADDR_TC_WDATA) = my_ch;
  #ifdef CFG_SIM //the print interface for simulation environment
  static int sim_i=0;
  *(volatile uint8_t*) (0x20020000 + sim_i++) = my_ch;
  if(my_ch == 0x0A){
    *(volatile uint8_t*) (0x20020000 + sim_i) = 0xFF;
    sim_i = 0;
  }  
  #else
  uart1_send(my_ch);
  #endif
  return (my_ch);
}
// Get a character
unsigned char UartGetc(void)
{
  //while ((SSE050_UART0->STATE & 2)==0); // Wait if Receive Holding register is empty
  return (SSE050_UART0->DATA);
}

void UartEndSimulation(void)
{
 // UartPutc((char) 0x4); // End of simulation
  *((volatile uint32_t *)ADDR_TC_WDATA) = 0xffff0000;
  while(1);
}

