/*!
    \file    systick.c
    \brief   the systick configuration file

*/

#include "lisoc_test.h"

volatile uint32_t SysTick1msCount;
uint32_t SysTick1msStart,SysTick1msEnd;

void delay_us(uint32_t count)
{
  uint32_t i;
  for (i = 0U; i < LOOP_CNT_PER_US * count; i ++) {
    __ISB();
  }
}

/*!
    \brief      delay a time in milliseconds
    \param[in]  count: count in milliseconds
    \param[out] none
    \retval     none
*/
void delay_ms(uint32_t count)
{
  uint32_t DelayMsTmoStamp;

  DelayMsTmoStamp = SysTick1msCount + count;

  while (IS_TIME_NOT_REACHED(DelayMsTmoStamp)) {
    /* Do nothing */
  }
}

