/*!
    \file    systick.h
    \brief   the header file of systick

*/

#ifndef SYS_TICK_H
#define SYS_TICK_H

/* Sys tick input clock characteristics */
#define SYS_NUM_TICKS_PER_MSEC          (LISOC_ARM_SYS_CLK / 1000U)

/* Number of instruction barriers per micro-sec (40M->4, 20M->2, 27M->2) */
#define LOOP_CNT_PER_US                 (LISOC_ARM_SYS_CLK / 10000000U)

/* Time-out checking utility macro */
#define IS_TIME_PASSED(stamp)           ((int32_t)(SysTick1msCount - (uint32_t)(stamp)) >= 0)
#define IS_TIME_NOT_REACHED(stamp)      ((int32_t)(SysTick1msCount - (uint32_t)(stamp)) < 0)

/* Global system tick count */
extern volatile uint32_t SysTick1msCount;
extern uint32_t SysTick1msStart,SysTick1msEnd;

/* Delay a time in milliseconds */
void delay_ms(uint32_t count);

/* Delay a time in microseconds */
void delay_us(uint32_t count);


#endif /* SYS_TICK_H */
