#include "lisoc_test.h"
#include "af_test.h"
#include "syscfg.h"
#include "i2c.h"
#include "rcc.h"
#include "gpio.h"

#define VCM_REVISION                    0x01
#define VCM_CONTROL                     0x02
#define VCM_CURRENT_MSB                 0x03
#define VCM_CURRENT_LSB                 0x04

#define REG_VCM_MODE                    0x06
#define REG_VCM_FREQ                    0x07

void af_fhd60_init(void)
{
  /* AF FHD60 */
  LISOC_AF->addr_0x04.V_P_AREA_SIZE = 160;
  LISOC_AF->addr_0x04.H_P_AREA_SIZE = 256;
  LISOC_AF->addr_0x08.V_OFFSET      = 60;
  LISOC_AF->addr_0x08.H_OFFSET      = 192;
  LISOC_AF->addr_0x0C.V_DIV         = 6;
  LISOC_AF->addr_0x0C.H_DIV         = 6;
  LISOC_AF->addr_0x10.SSB           = 10;

}

void af_uhd60_init(void)
{
  /* AF UHD60 */
  LISOC_AF->addr_0x04.V_P_AREA_SIZE = 324;
  LISOC_AF->addr_0x04.H_P_AREA_SIZE = 512;
  LISOC_AF->addr_0x08.V_OFFSET      = 108;
  LISOC_AF->addr_0x08.H_OFFSET      = 384;
  LISOC_AF->addr_0x0C.V_DIV         = 6;
  LISOC_AF->addr_0x0C.H_DIV         = 6;
  LISOC_AF->addr_0x10.SSB           = 12;

}

void bd63740_test()
{
  uint8_t i;
  LISOC_SYSCFG->AF_CCON0.pre_div = 1330; //27000/270 = 100khz
  LISOC_SYSCFG->AF_CCON0.mask0 = 0;
  LISOC_SYSCFG->AF_CCON0.mask1 = 0;
  LISOC_SYSCFG->AF_CCON0.mask2 = 0;
  LISOC_SYSCFG->AF_CCON0.mask3 = 0;
  LISOC_SYSCFG->AF_CCON0.mask4 = 0;
  LISOC_SYSCFG->AF_CCON0.EN = 1;


  //1/16 step
  LISOC_SYSCFG->AF_CCON1.mode2 = 1;
  LISOC_SYSCFG->AF_CCON1.mode1 = 1;
  LISOC_SYSCFG->AF_CCON1.mode0 = 1;
  LISOC_SYSCFG->AF_CCON1.enable = 1;
  LISOC_SYSCFG->AF_CCON1.CW = 1;

  gpioa_setPinDreict(PA15, GPIO_OUT);

  while(1){                           //Short circuit with DBG0
    if(i++ % 2 == 0)
      gpioa_out(PA15, GPIO_HIGH);
    else
      gpioa_out(PA15, GPIO_LOW);

    printf("af_count:%d\n",LISOC_SYSCFG->AF_COUNT.af_count);
    delay_ms(1000);
  }

}

void drv201_test()
{
  uint16_t vcm_val;
  uint8_t temp;

  /* Set PB10 PB11 as I2C2 respectively */
  SYSC_GPIOB_AF_SET(GPIO_AF_1, PB10AF | PB11AF);
  i2c_Disable(LISOC_I2C2);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C2, FREQ_400K, 0xE);
  i2c_Enable(LISOC_I2C2);
  i2c_vcm_write(LISOC_I2C2, VCM_CURRENT_MSB, 0);
  delay_ms(10);


  
  i2c_Disable(LISOC_I2C2);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C2, FREQ_400K, 0xE);
  i2c_Enable(LISOC_I2C2);

  i2c_vcm_write(LISOC_I2C2, VCM_CURRENT_MSB, 258);
  i2c_vcm_read(LISOC_I2C2, VCM_CURRENT_MSB, &vcm_val);

  printf("vcm_val:%x\n",vcm_val);


  while(1);
}
void drv2001_test()
{
  uint8_t rdata,i;

  /* Set PB10 PB11 as I2C2 respectively */
  SYSC_GPIOB_AF_SET(GPIO_AF_1, PB10AF | PB11AF);

  i2c_Disable(LISOC_I2C2);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C2, FREQ_100K, 0xe);
  i2c_Enable(LISOC_I2C2);



  i2c_reg8_write(LISOC_I2C2, VCM_CONTROL, 0x1);
  delay_ms(10);
  i2c_reg8_write(LISOC_I2C2, REG_VCM_MODE, 0x03);
  i2c_reg8_write(LISOC_I2C2, REG_VCM_FREQ, 0xAF);
  i2c_reg8_write(LISOC_I2C2, VCM_CONTROL, 0x2);
  printf("drv201 init \n");

  while(1){
    i2c_Disable(LISOC_I2C2);  //IC_ENABLE to 0
    i2c_Config(LISOC_I2C2, FREQ_400K, i%128);
    i2c_Enable(LISOC_I2C2);

    i2c_reg8_write(LISOC_I2C2, VCM_CURRENT_MSB, i % 4);
    i++;
    delay_ms(100);
    printf("drv201 set %d \n",i);

  }
}

void af_test(void)
{
  printf("af test start\n");

  af_uhd60_init();
}

