#include "lisoc_test.h"
#include "i2c_test.h"
#include "syscfg.h"
#include "i2c.h"

void i2c0_2_test(uint8_t speed)
{
  int temp;
  #if 1
  debug("i2c0 test start\n");

  i2c_Disable(LISOC_I2C0);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C0, speed, INA226_ADDR);
  // Write to IC_ENABLE to enable DW_apb_i2c
  i2c_Enable(LISOC_I2C0);
  i2c_Write(LISOC_I2C0, ID_REG);

  temp = i2c_Read(LISOC_I2C0);
  if(temp == 0x22)
    debug("i2c0 test pass\n");
  else
    debug("i2c0 test fail %x\n" ,temp);
#endif
#if 1

  debug("i2c1 test start\n");
  SYSC_GPIOB_AF_SET(GPIO_AF_1, PB6AF | PB7AF);

  i2c_Disable(LISOC_I2C1);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C1, speed, INA226_ADDR);
  // Write to IC_ENABLE to enable DW_apb_i2c
  i2c_Enable(LISOC_I2C1);
  i2c_Write(LISOC_I2C1, ID_REG);

  temp = i2c_Read(LISOC_I2C1);
  if(temp == 0x22)
    debug("i2c1 test pass\n");
  else
    debug("i2c1 test fail %x\n" ,temp);

#endif
  debug("i2c2 test start\n");
  /* Set PB10 PB11 as I2C2 respectively */
  SYSC_GPIOB_AF_SET(GPIO_AF_1, PB10AF | PB11AF);

  i2c_Disable(LISOC_I2C2);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C2, speed, INA226_ADDR);
  // Write to IC_ENABLE to enable DW_apb_i2c
  i2c_Enable(LISOC_I2C2);
  i2c_Write(LISOC_I2C2, ID_REG);

	temp = i2c_Read(LISOC_I2C2);
  if(temp == 0x22)
    debug("i2c2 test pass\n");
  else
    debug("i2c2 test fail %x\n" ,temp);

}


/*!
    \brief      i2c test
    \param[in]  none
    \param[out] none
    \retval     none
*/
void i2c0_test(uint8_t speed)
{
  int temp;
  debug("i2c0 test start\n");

  i2c_Disable(LISOC_I2C0);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C0, speed, INA226_ADDR);
  // Write to IC_ENABLE to enable DW_apb_i2c
  i2c_Enable(LISOC_I2C0);
  i2c_Write(LISOC_I2C0, ID_REG);

  temp = i2c_Read(LISOC_I2C0);
  if(temp == INA226_ID)
    debug("i2c0 test pass\n");
  else
    debug("i2c0 test fail %x\n" ,temp);
}

/*!
    \brief      i2c test
    \param[in]  none
    \param[out] none
    \retval     none
*/
void i2c1_config(uint8_t speed)
{

  //debug("i2c1 test start\n");

  /* Set PB6 PB7 as I2C1 respectively */
  SYSC_GPIOB_AF_SET(GPIO_AF_1, PB6AF | PB7AF);
  i2c_Disable(LISOC_I2C1);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C1, speed, INA226_ADDR);
  // Write to IC_ENABLE to enable DW_apb_i2c
  i2c_Enable(LISOC_I2C1);
  #if 0
  i2c_Write(LISOC_I2C1, ID_REG);

  if(i2c_Read(LISOC_I2C1) == INA226_ID)
    debug("i2c1 test pass\n");
  else
    debug("i2c1 test fail\n");
  #endif

}

/*!
    \brief      i2c test
    \param[in]  none
    \param[out] none
    \retval     none
*/
void i2c2_config(uint8_t speed)
{
#if 0
  debug("i2c2 test start\n");

  /* Set PB10 PB11 as I2C2 respectively */
  SYSC_GPIOB_AF_SET(GPIO_AF_1, PB10AF | PB11AF);
  i2c_Disable(LISOC_I2C2);  //IC_ENABLE to 0
  i2c_Config(LISOC_I2C2, speed, INA226_ADDR);
  // Write to IC_ENABLE to enable DW_apb_i2c
  i2c_Enable(LISOC_I2C2);
  i2c_Write(LISOC_I2C2, ID_REG);

  if(i2c_Read(LISOC_I2C2) == INA226_ID)
    debug("i2c2 test pass\n");
  else
    debug("i2c2 test fail\n");
#else
  /* Set PB10 PB11 as I2C2 respectively */
  SYSC_GPIOB_AF_SET(GPIO_AF_1, PB10AF | PB11AF);

  i2c_Disable(LISOC_I2C2);  //IC_ENABLE to 0
  //    wdata = wdata |(1<<6) | (1<<5) (1<<1)|1;
  //I2C0_CON = 0x61 | (speed << 1);  //IC_CON to xxx
  LISOC_I2C2->IC_CON_W = 0;
  LISOC_I2C2->IC_CON.MASTER_MODE = 0;
  LISOC_I2C2->IC_CON.SPEED = 1;
  LISOC_I2C2->IC_CON.IC_RESTART_EN = 1;
  LISOC_I2C2->IC_CON.IC_SLAVE_DISABLE = 0;

  //I2C0_TAR = 0x45;  //TAR to 0x45
  LISOC_I2C2->IC_SAR.IC_SAR = 0x45;

  // Write to IC_SS_HCNT to set HIGH period of SCL
  //I2C0_SS_SCL_HCNT = 0x190;
  LISOC_I2C2->IC_SS_SCL_HCNT_W = 0x190;

  // Write to IC_SS_LCNT to set LOW period of SCL
  //I2C0_SS_SCL_LCNT = 0x1D6;
  LISOC_I2C2->IC_SS_SCL_LCNT_W = 0x1D6;

  // Write to IC_INTR_MASK to disable all interrupts
  //I2C0_INTR_MASK = 0x0;
  LISOC_I2C2->IC_INTR_MASK_W = 0x20;

  // Write to IC_RX_TL to set Rx FIFO threshold leve
  //I2C0_RX_TL = 0x3;
  LISOC_I2C2->IC_RX_TL_W = 0;

  // Write to IC_TX_TL to set Tx FIFO threshold level
  //I2C0_TX_TL = 0x3;
  LISOC_I2C2->IC_TX_TL_W = 0x3;

  i2c_Enable(LISOC_I2C2);
  NVIC_ClearPendingIRQ(I2C2_IRQn);
  NVIC_EnableIRQ(I2C2_IRQn); 

#endif
}

/*!
    \brief      i2c test
    \param[in]  none
    \param[out] none
    \retval     none
*/
void i2c_test(void)
{
  //uint8_t rdata;
  #ifdef CFG_FPGA
  i2c0_2_test(FREQ_100K);
  #else
  i2c1_config(SPEED_STAND);
  i2c2_config(SPEED_STAND);

  if(i2c_Read(LISOC_I2C1) == 0X5A)
    debug("i2c2_3 test                                OK.\n");
  else
    debug("i2c2_3 test                                NG.\n");

  //debug("i2c23 test fail\n");
  NVIC_DisableIRQ(I2C2_IRQn); 
  #endif
}



