#include "lisoc_test.h"
#include "tpgen_test.h"

void tpgen_fhd60_init()
{
  LISOC_TPGEN->addr_0x00.FRMV_SIZE_CCHG   = 1125;
  LISOC_TPGEN->addr_0x00.FRMH_SIZE_CCHG   = 2400;
  LISOC_TPGEN->addr_0x04.V_OFFSET_CCHG    = 27;
  LISOC_TPGEN->addr_0x04.H_OFFSET_CCHG    = 0;
  LISOC_TPGEN->addr_0x08.V_OFFSET2_CCHG   = 2;
  LISOC_TPGEN->addr_0x0C.TPV_SIZE_CCHG    = 1088;
  LISOC_TPGEN->addr_0x0C.TPH_SIZE_CCHG    = 966;
  LISOC_TPGEN->addr_0x10.GSV_SIZE_CCHG    = 806;
  LISOC_TPGEN->addr_0x10.GSH_SIZE_CCHG    = 75;
  LISOC_TPGEN->addr_0x14.GSV_START_CCHG   = 141;
  LISOC_TPGEN->addr_0x14.GSH_START_CCHG   = 70;
  LISOC_TPGEN->addr_0x18.CG_R_E_CCHG      = 4095;
  LISOC_TPGEN->addr_0x18.CG_R_S_CCHG      = 0;
  LISOC_TPGEN->addr_0x1C.CG_G_E_CCHG      = 4095;
  LISOC_TPGEN->addr_0x1C.CG_G_S_CCHG      = 0;
  LISOC_TPGEN->addr_0x20.CG_B_E_CCHG      = 4095;
  LISOC_TPGEN->addr_0x20.CG_B_S_CCHG      = 0;
  LISOC_TPGEN->addr_0x24.PH_CCHG          = 3; //2bit 0~3
  LISOC_TPGEN->addr_0x24.PT_CCHG          = 3; //2bit 0~3
  LISOC_TPGEN->addr_0x28.ENABLE_CCHG      = 1;

  LISOC_TPGEN->addr_0x30.FRMV_SIZE_ISP    = 1125;
  LISOC_TPGEN->addr_0x30.FRMH_SIZE_ISP    = 2200;
  LISOC_TPGEN->addr_0x34.V_OFFSET_ISP     = 27;
  LISOC_TPGEN->addr_0x34.H_OFFSET_ISP     = 0;
  LISOC_TPGEN->addr_0x38.V_OFFSET2_ISP    = 2;
  LISOC_TPGEN->addr_0x3C.TPV_SIZE_ISP     = 1088;
  LISOC_TPGEN->addr_0x3C.TPH_SIZE_ISP     = 966;
  LISOC_TPGEN->addr_0x40.GSV_SIZE_ISP     = 806;
  LISOC_TPGEN->addr_0x40.GSH_SIZE_ISP     = 75;
  LISOC_TPGEN->addr_0x44.GSV_START_ISP    = 141;
  LISOC_TPGEN->addr_0x44.GSH_START_ISP    = 70;
  #if  0
  LISOC_TPGEN->addr_0x48.CG_R_E_ISP       = 2048;
  LISOC_TPGEN->addr_0x48.CG_R_S_ISP       = 4095;
  LISOC_TPGEN->addr_0x4C.CG_G_E_ISP       = 4095;
  LISOC_TPGEN->addr_0x4C.CG_G_S_ISP       = 2048;
  LISOC_TPGEN->addr_0x50.CG_B_E_ISP       = 4095;
  LISOC_TPGEN->addr_0x50.CG_B_S_ISP       = 0;
  #endif
  LISOC_TPGEN->addr_0x48.CG_R_E_ISP       = 4095;
  LISOC_TPGEN->addr_0x48.CG_R_S_ISP       = 0;
  LISOC_TPGEN->addr_0x4C.CG_G_E_ISP       = 4095;
  LISOC_TPGEN->addr_0x4C.CG_G_S_ISP       = 0;
  LISOC_TPGEN->addr_0x50.CG_B_E_ISP       = 4095;
  LISOC_TPGEN->addr_0x50.CG_B_S_ISP       = 0;

  LISOC_TPGEN->addr_0x54.PH_ISP           = 3;
  LISOC_TPGEN->addr_0x54.PT_ISP           = 2;
  LISOC_TPGEN->addr_0x58.ENABLE_ISP       = 1;

  LISOC_TPGEN->addr_0x60.FRMV_SIZE_LISR   = 1125;
  LISOC_TPGEN->addr_0x60.FRMH_SIZE_LISR   = 2200;
  LISOC_TPGEN->addr_0x64.VSW_LISR         = 5;
  LISOC_TPGEN->addr_0x64.HSW_LISR         = 22;
  LISOC_TPGEN->addr_0x68.VFRBLK_LISR      = 41;
  LISOC_TPGEN->addr_0x68.HFRBLK_LISR      = 96;
  LISOC_TPGEN->addr_0x6C.TPV_SIZE_LISR    = 1080;
  LISOC_TPGEN->addr_0x6C.TPH_SIZE_LISR    = 960;
  LISOC_TPGEN->addr_0x70.GSV_SIZE_LISR    = 800;
  LISOC_TPGEN->addr_0x70.GSH_SIZE_LISR    = 74;
  LISOC_TPGEN->addr_0x74.GSV_START_LISR   = 140;
  LISOC_TPGEN->addr_0x74.GSH_START_LISR   = 70;
  LISOC_TPGEN->addr_0x78.CG_R_E_LISR      = 4095;
  LISOC_TPGEN->addr_0x78.CG_R_S_LISR      = 0;
  LISOC_TPGEN->addr_0x7C.CG_G_E_LISR      = 4095;
  LISOC_TPGEN->addr_0x7C.CG_G_S_LISR      = 0;
  LISOC_TPGEN->addr_0x80.CG_B_E_LISR      = 4095;
  LISOC_TPGEN->addr_0x80.CG_B_S_LISR      = 0;
  LISOC_TPGEN->addr_0x84.PH_LISR          = 3;
  LISOC_TPGEN->addr_0x84.PT_LISR          = 2;
  LISOC_TPGEN->addr_0x88.ENABLE_LISR      = 1;
#if 0
  LISOC_TPGEN->addr_0x90.FRMV_SIZE_MIPITX = 1125;
  LISOC_TPGEN->addr_0x90.FRMH_SIZE_MIPITX = 2200;
  LISOC_TPGEN->addr_0x94.V_OFFSET_MIPITX  = 1;
  LISOC_TPGEN->addr_0x94.H_OFFSET_MIPITX  = 0;
  LISOC_TPGEN->addr_0x98.V_OFFSET2_MIPITX = 0;
  LISOC_TPGEN->addr_0x9C.TPV_SIZE_MIPITX  = 1080;
  LISOC_TPGEN->addr_0x9C.TPH_SIZE_MIPITX  = 960;
  LISOC_TPGEN->addr_0xA0.GSV_SIZE_MIPITX  = 800;
  LISOC_TPGEN->addr_0xA0.GSH_SIZE_MIPITX  = 74;
  LISOC_TPGEN->addr_0xA4.GSV_START_MIPITX = 140;
  LISOC_TPGEN->addr_0xA4.GSH_START_MIPITX = 70;
  LISOC_TPGEN->addr_0xA8.CG_R_E_MIPITX    = 4095;
  LISOC_TPGEN->addr_0xA8.CG_R_S_MIPITX    = 0;
  LISOC_TPGEN->addr_0xAC.CG_G_E_MIPITX    = 4095;
  LISOC_TPGEN->addr_0xAC.CG_G_S_MIPITX    = 0;
  LISOC_TPGEN->addr_0xB0.CG_B_E_MIPITX    = 2048;
  LISOC_TPGEN->addr_0xB0.CG_B_S_MIPITX    = 2048;
  LISOC_TPGEN->addr_0xB4.PH_MIPITX        = 0;
  LISOC_TPGEN->addr_0xB4.PT_MIPITX        = 0;
  LISOC_TPGEN->addr_0xB8.RGB_MIPITX       = 0;
  LISOC_TPGEN->addr_0xB8.ENABLE_MIPITX    = 1;
#endif
}

void tpgen_uhd60_init()
{
  LISOC_TPGEN->addr_0x00.FRMV_SIZE_CCHG   = 2250;
  LISOC_TPGEN->addr_0x00.FRMH_SIZE_CCHG   = 2400;
  LISOC_TPGEN->addr_0x04.V_OFFSET_CCHG    = 51;
  LISOC_TPGEN->addr_0x04.H_OFFSET_CCHG    = 0;
  LISOC_TPGEN->addr_0x08.V_OFFSET2_CCHG   = 3;
  LISOC_TPGEN->addr_0x0C.TPV_SIZE_CCHG    = 2176;
  LISOC_TPGEN->addr_0x0C.TPH_SIZE_CCHG    = 1932;
  LISOC_TPGEN->addr_0x10.GSV_SIZE_CCHG    = 1612;
  LISOC_TPGEN->addr_0x10.GSH_SIZE_CCHG    = 150;
  LISOC_TPGEN->addr_0x14.GSV_START_CCHG   = 282;
  LISOC_TPGEN->addr_0x14.GSH_START_CCHG   = 141;
  LISOC_TPGEN->addr_0x18.CG_R_E_CCHG      = 4095;
  LISOC_TPGEN->addr_0x18.CG_R_S_CCHG      = 0;
  LISOC_TPGEN->addr_0x1C.CG_G_E_CCHG      = 4095;
  LISOC_TPGEN->addr_0x1C.CG_G_S_CCHG      = 0;
  LISOC_TPGEN->addr_0x20.CG_B_E_CCHG      = 4095;
  LISOC_TPGEN->addr_0x20.CG_B_S_CCHG      = 0;
  LISOC_TPGEN->addr_0x24.PH_CCHG          = 0;
  LISOC_TPGEN->addr_0x24.PT_CCHG          = 0;
  LISOC_TPGEN->addr_0x28.ENABLE_CCHG      = 1;

  LISOC_TPGEN->addr_0x30.FRMV_SIZE_ISP    = 2250;
  LISOC_TPGEN->addr_0x30.FRMH_SIZE_ISP    = 2200;
  LISOC_TPGEN->addr_0x34.V_OFFSET_ISP     = 51;
  LISOC_TPGEN->addr_0x34.H_OFFSET_ISP     = 0;
  LISOC_TPGEN->addr_0x38.V_OFFSET2_ISP    = 3;
  LISOC_TPGEN->addr_0x3C.TPV_SIZE_ISP     = 2176;
  LISOC_TPGEN->addr_0x3C.TPH_SIZE_ISP     = 1932;
  LISOC_TPGEN->addr_0x40.GSV_SIZE_ISP     = 1612;
  LISOC_TPGEN->addr_0x40.GSH_SIZE_ISP     = 150;
  LISOC_TPGEN->addr_0x44.GSV_START_ISP    = 282;
  LISOC_TPGEN->addr_0x44.GSH_START_ISP    = 141;
  LISOC_TPGEN->addr_0x48.CG_R_E_ISP       = 2048;
  LISOC_TPGEN->addr_0x48.CG_R_S_ISP       = 4095;
  LISOC_TPGEN->addr_0x4C.CG_G_E_ISP       = 4095;
  LISOC_TPGEN->addr_0x4C.CG_G_S_ISP       = 2048;
  LISOC_TPGEN->addr_0x50.CG_B_E_ISP       = 4095;
  LISOC_TPGEN->addr_0x50.CG_B_S_ISP       = 0;
  LISOC_TPGEN->addr_0x54.PH_ISP           = 0;
  LISOC_TPGEN->addr_0x54.PT_ISP           = 3;
  LISOC_TPGEN->addr_0x58.ENABLE_ISP       = 1;

  LISOC_TPGEN->addr_0x60.FRMV_SIZE_LISR   = 2250;
  LISOC_TPGEN->addr_0x60.FRMH_SIZE_LISR   = 2200;
  LISOC_TPGEN->addr_0x64.VSW_LISR         = 5;
  LISOC_TPGEN->addr_0x64.HSW_LISR         = 22;
  LISOC_TPGEN->addr_0x68.VFRBLK_LISR      = 41;
  LISOC_TPGEN->addr_0x68.HFRBLK_LISR      = 96;
  LISOC_TPGEN->addr_0x6C.TPV_SIZE_LISR    = 2160;
  LISOC_TPGEN->addr_0x6C.TPH_SIZE_LISR    = 1920;
  LISOC_TPGEN->addr_0x70.GSV_SIZE_LISR    = 1600;
  LISOC_TPGEN->addr_0x70.GSH_SIZE_LISR    = 149;
  LISOC_TPGEN->addr_0x74.GSV_START_LISR   = 280;
  LISOC_TPGEN->addr_0x74.GSH_START_LISR   = 140;
  LISOC_TPGEN->addr_0x78.CG_R_E_LISR      = 4095;
  LISOC_TPGEN->addr_0x78.CG_R_S_LISR      = 0;
  LISOC_TPGEN->addr_0x7C.CG_G_E_LISR      = 4095;
  LISOC_TPGEN->addr_0x7C.CG_G_S_LISR      = 0;
  LISOC_TPGEN->addr_0x80.CG_B_E_LISR      = 4095;
  LISOC_TPGEN->addr_0x80.CG_B_S_LISR      = 0;
  LISOC_TPGEN->addr_0x84.PH_LISR          = 0;
  LISOC_TPGEN->addr_0x84.PT_LISR          = 2;
  LISOC_TPGEN->addr_0x88.ENABLE_LISR      = 1;
#if 0
  LISOC_TPGEN->addr_0x90.FRMV_SIZE_MIPITX = 2250;
  LISOC_TPGEN->addr_0x90.FRMH_SIZE_MIPITX = 2400;
  LISOC_TPGEN->addr_0x94.V_OFFSET_MIPITX  = 1;
  LISOC_TPGEN->addr_0x94.H_OFFSET_MIPITX  = 0;
  LISOC_TPGEN->addr_0x98.V_OFFSET2_MIPITX = 0;
  LISOC_TPGEN->addr_0x9C.TPV_SIZE_MIPITX  = 2160;
  LISOC_TPGEN->addr_0x9C.TPH_SIZE_MIPITX  = 1920;
  LISOC_TPGEN->addr_0xA0.GSV_SIZE_MIPITX  = 1600;
  LISOC_TPGEN->addr_0xA0.GSH_SIZE_MIPITX  = 149;
  LISOC_TPGEN->addr_0xA4.GSV_START_MIPITX = 280;
  LISOC_TPGEN->addr_0xA4.GSH_START_MIPITX = 140;
  LISOC_TPGEN->addr_0xA8.CG_R_E_MIPITX    = 4095;
  LISOC_TPGEN->addr_0xA8.CG_R_S_MIPITX    = 0;
  LISOC_TPGEN->addr_0xAC.CG_G_E_MIPITX    = 4095;
  LISOC_TPGEN->addr_0xAC.CG_G_S_MIPITX    = 0;
  LISOC_TPGEN->addr_0xB0.CG_B_E_MIPITX    = 4095;
  LISOC_TPGEN->addr_0xB0.CG_B_S_MIPITX    = 0;
  LISOC_TPGEN->addr_0xB4.PH_MIPITX        = 3;
  LISOC_TPGEN->addr_0xB4.PT_MIPITX        = 3;
  LISOC_TPGEN->addr_0xB8.RGB_MIPITX       = 0;
  LISOC_TPGEN->addr_0xB8.ENABLE_MIPITX    = 1;
#endif
}


void tpgen_test(TPGEN_Formatn_Type TPGEN_Formatn,TPGEN_SELn_Type TPGEN_SELn)
{
  printf("tpgen test start.\n");
  printf("TPGEN_Formatn:%d,TPGEN_SELn:%d.\n",TPGEN_Formatn,TPGEN_SELn);

  //Regs of SYSCFG
  LISOC_SYSCFG->SOC_CCON1.tpgen_sel = TPGEN_SELn;  //1:cchg 2:isp 4:lisr 8:mtx

  //Regs of TPGEN
  switch(TPGEN_Formatn)
  {
    case TPGEN_FHD60n:
      tpgen_fhd60_init();
      break;

    case TPGEN_UHD60n:
      tpgen_uhd60_init();
      break;

    default:
      break;
  }

}

